<!DOCTYPE html>

<html lang="br">
<!-- begin::Head -->

<head>
	<meta charset="utf-8" />

	<title><?php echo e($title); ?></title>
	<meta name="description" content="Updates and statistics">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="Cache-Control" content="no-cache">
	<!--begin::Fonts -->
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700|Roboto:300,400,500,600,700">

	<link href="/metronic/css/fullcalendar.bundle.css" rel="stylesheet" type="text/css" />
	<!-- <link href="/metronic/css/uppy.bundle.css" rel="stylesheet" type="text/css" /> -->
	<link href="/metronic/css/wizard.css" rel="stylesheet" type="text/css" />

	<link href="/css/style.css" rel="stylesheet" type="text/css" />

	<!--end::Page Vendors Styles -->

	<?php if($tema == 2): ?>
	<link href="/css/escuro.css" rel="stylesheet" type="text/css" />
	<?php endif; ?>

	<!--begin::Global Theme Styles(used by all pages) -->
	<link href="/metronic/css/plugins.bundle.css" rel="stylesheet" type="text/css" />
	<link href="/metronic/css/prismjs.bundle.css" rel="stylesheet" type="text/css" />
	<link href="/metronic/css/style.bundle.css" rel="stylesheet" type="text/css" />

	<link href="/metronic/css/pricing.css" rel="stylesheet" type="text/css" />
	<!--end::Global Theme Styles -->

	<!--begin::Layout Skins(used by all pages) -->

	<link href="/metronic/css/light.css" rel="stylesheet" type="text/css" />
	<link href="/metronic/css/light-menu.css" rel="stylesheet" type="text/css" />
	<link href="/metronic/css/dark-brand.css" rel="stylesheet" type="text/css" />
	<link href="/metronic/css/dark-aside.css" rel="stylesheet" type="text/css" />

	<link rel="stylesheet" href="https://maxst.icons8.com/vue-static/landings/line-awesome/line-awesome/1.3.0/css/line-awesome.min.css">

	<link rel="stylesheet" type="text/css" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

	<script>
		(function(h, o, t, j, a, r) {
			h.hj = h.hj || function() {
				(h.hj.q = h.hj.q || []).push(arguments)
			};
			h._hjSettings = {
				hjid: 1070954,
				hjsv: 6
			};
			a = o.getElementsByTagName('head')[0];
			r = o.createElement('script');
			r.async = 1;
			r.src = t + h._hjSettings.hjid + j + h._hjSettings.hjsv;
			a.appendChild(r);
		})(window, document, 'https://static.hotjar.com/c/hotjar-', '.js?sv=');
	</script>
	<!-- Global site tag (gtag.js) - Google Analytics -->
	<script async="async" src="https://www.googletagmanager.com/gtag/js?id=UA-37564768-1"></script>
	<script>
		window.dataLayer = window.dataLayer || [];

		function gtag() {
			dataLayer.push(arguments);
		}
		gtag('js', new Date());
		gtag('config', 'UA-37564768-1');
	</script>


	<style type="text/css">
		.select2-selection__arrow:before {
			content: "";
			position: absolute;
			right: 7px;
			top: 42%;
			border-top: 5px solid #888;
			border-left: 4px solid transparent;
			border-right: 4px solid transparent;
		}
		.no-padding{
			padding-left: 0 !important;
			padding-right: 0 !important;
		}
		.ativo{
			background-color: #55C6BD;
			color: #fff;
		}
		.desativo{
			background-color: #EBEDF3;
			color: #000;
		}
		.img-prod{
			/*height: 100px;*/
			margin-top: 10px;

		}
		@media  only screen and (max-width: 1000px) {
			#div-categorias{
				
			}
			#div-categorias > .card-body{
				height: inherit;
			}
		}
		@media  only screen and (min-width: 1001px) and (max-width: 3000px){
			#div-categorias{
				display: inline
			}
		}
		#atalho_add:hover{
			cursor: pointer;
		}

		.money-cel{
			width: 120px;
			height: 50px;
		}

		.money-moeda{
			width: 80px;
		}

		#focus-codigo:hover{
			cursor: pointer
		}

		.search-prod{
			position: absolute;
			top: 0;
			margin-top: 40px;
			left: 10;
			width: 100%;
			max-height: 200px;
			overflow: auto;
			z-index: 9999;
			border: 1px solid #eeeeee;
			border-radius: 4px;
			background-color: #fff;
			box-shadow: 0px 1px 6px 1px rgba(0, 0, 0, 0.4);
		}

		.search-prod label:hover{
			cursor: pointer;
		}

		.search-prod label{
			margin-left: 10px;
			width: 100%;
			margin-top: 7px;
			font-size: 14px;
		}

		.lbl-prod{
			color: #000 !important;
		}

	</style>
	<style type="text/css">
		.select2-selection__arroww:before {
			content: "";
			position: absolute;
			right: 7px;
			top: 42%;
			border-top: 5px solid #888;
			border-left: 4px solid transparent;
			border-right: 4px solid transparent;
		}

		.qrcode{
			display: block;
			margin-left: auto;
			margin-right: auto;
			width: 50%;
		}

		.icon-trash:hover{
			cursor: pointer;
		}

		.select2-results__option { 
			font-size: 20px !important;
		}
	</style>
</head>


<!-- end::Head -->

<!-- begin::Body -->

<body id="kt_body" class="header-fixed header-mobile-fixed subheader-enabled subheader-fixed aside-enabled aside-fixed aside-minimize-hoverable page-loading">


	<input type="hidden" id="categorias" value="<?php echo e(json_encode($categorias)); ?>" name="">
	<input type="hidden" id="clientes" value="<?php echo e(json_encode($clientes)); ?>" name="">
	<input type="hidden" id="agendamento_id" value="<?php echo e($agendamento_id ?? 0); ?>" name="">

	<input type="hidden" id="_token" value="<?php echo e(csrf_token()); ?>">

	<input type="hidden" id="valor_entrega" <?php if(isset($valor_entrega)): ?> value="<?php echo e($valor_entrega); ?>" <?php else: ?> value='0' <?php endif; ?>>

	<?php if(isset($itens)): ?>
	<input type="hidden" id="itens_pedido" value="<?php echo e(json_encode($itens)); ?>">
	<input type="hidden" id="valor_total" <?php if(isset($valor_total)): ?> value="<?php echo e($valor_total); ?>" <?php else: ?> value='0' <?php endif; ?>>
	<input type="hidden" id="delivery_id" <?php if(isset($delivery_id)): ?> value="<?php echo e($delivery_id); ?>" <?php else: ?> value='0' <?php endif; ?>>
	<input type="hidden" id="bairro" <?php if(isset($bairro)): ?> value="<?php echo e($bairro); ?>" <?php else: ?> value='0' <?php endif; ?>>

	<input type="hidden" id="codigo_comanda_hidden" <?php if(isset($cod_comanda)): ?> value="<?php echo e($cod_comanda); ?>" <?php else: ?> value='0' <?php endif; ?> name="">
	<?php endif; ?>

	<?php if(isset($venda)): ?>
	<input type="hidden" id="venda" value="<?php echo e($venda); ?>">
	<?php endif; ?>

	<input type="hidden" id="PDV_VALOR_RECEBIDO" <?php if(isset($atalhos)): ?> value="<?php echo e($atalhos->valor_recebido_automatico); ?>" <?php else: ?> value='0' <?php endif; ?>>
	<input type="hidden" id="ATALHOS" value="<?php echo e(json_encode($atalhos)); ?>">

	<?php if(isset($config)): ?>
	<input type="hidden" id="senha_alterar_preco" value="<?php echo e(($config->senha_alterar_preco)? 'true': ''); ?>">
	<?php endif; ?>

	<?php if(isset($vendedores)): ?>
	<input type="hidden" id="vendedores" value="<?php echo e(json_encode($vendedores)); ?>">
	<input type="hidden" id="acessores" value="<?php echo e(json_encode($acessores)); ?>">
	<?php endif; ?>

	<?php
	$caixa_tipos_pagamento = App\Models\ConfigCaixa::getTiposPagamento();
	$caixa_tipo_pagamento_padrao = App\Models\ConfigCaixa::getTipoPagamentoPadrao();
	?>

	<div class="card card-custom gutter-b example example-compact">
		<div class="col-lg-12">
			<div class="container">

				<div class="row mt-5">
					<div class="col-lg-1 col-md-12">
						<div style="display: flex;align-items: center;height: 100%;">
							<h4 class="mb-0">
								<strong id="timer">00:00:00</strong>
							</h4>
						</div>
					</div>
					<div class="col-lg-9 col-md-7 mt-2 mb-2" style="display: flex;flex-wrap: wrap;align-items: center;gap: 6px;">
						<?php if(isset($is_troca)): ?>
						<button class="btn text-dark mx-1" style="min-width: 150px;border-radius: 0;border: 1px solid #8950FC;">
							REALIZANDO TROCA
						</button>
						<?php elseif(isset($venda) && (json_decode($venda)->prevenda_nivel == 2)): ?>
						<button class="btn text-dark mx-1" style="min-width: 150px;border-radius: 0;border: 1px solid #8950FC;">
							FINALIZANDO PRÉ-VENDA
						</button>
						<?php elseif(isset($venda)): ?>
						<button class="btn text-dark mx-1" style="min-width: 150px;border-radius: 0;border: 1px solid #8950FC;">
							EDITANDO VENDA
						</button>
						<?php endif; ?>

						<?php if(isset($venda)): ?>
						<div class="btn btn-dark mx-1" style="background: #000;min-width: 150px;border-radius: 0;">
							<i class="las la-user-tie"></i>
							<?php
							$vendedor_nome = 'Não Informado';
							foreach($vendedores as $v)
							if($v->id == json_decode($venda)->usuario_id){
								$vendedor_nome = $v->funcionario->nome;
							}
							?>

							<?php echo e($vendedor_nome); ?>


						</div>

						<input type="hidden" value="<?php echo e(json_decode($venda)->usuario_id); ?>" id="vendedor_pre_venda">
						<?php else: ?>
						<div class="btn btn-dark mx-1" style="background: #000;min-width: 150px;border-radius: 0;"  data-toggle="modal" data-target="#selecionar_vendedor_modal" aria-haspopup="true" aria-expanded="true">
							<i class="las la-user-tie"></i> <span id="btn_informar_vendedor"> Informar Vendedor</span>
						</div>

						<?php if(sizeof($acessores) > 0): ?>
						<div class="btn btn-warning mx-1" style="min-width: 150px;border-radius: 0;"  data-toggle="modal" data-target="#selecionar_assessor_modal" aria-haspopup="true" aria-expanded="true">
							<i class="las la-user"></i> <span id="btn_informar_assessor"> Informar Assessor</span>
						</div>
						<?php endif; ?>

						<?php endif; ?>

						<?php if(isset($preVenda)): ?>
						<a href="/frenteCaixa/prevenda" class="btn btn-success mx-1" style="min-width: 150px;border-radius: 0;">
							<i class="la la-shopping-basket"></i> Nova Pré-venda
						</a>

						<a href="#" class="btn btn-secondary mx-1"  style="min-width: 150px;border-radius: 0;" data-toggle="modal" data-target="#prevenda_rascunhos_lista" aria-haspopup="true" aria-expanded="true">
							<i class="las la-th-list"></i> Lista de rascunhos
						</a>
						<?php else: ?>
						<?php if(!isset($venda)): ?>
						<div class="btn btn-success mx-1" id="open_prevenda_lista" style="min-width: 150px;border-radius: 0;" data-toggle="modal" data-target="#lista_prevenda_nivel2">
							<i class="la la-shopping-basket"></i> Lista de Pré-vendas
						</div>
						<?php endif; ?>

						<a href="/frenteCaixa/list" class="btn btn-dark mx-1" style="background:#353269;min-width: 150px;border-radius: 0;">
							<i class="las la-th-list"></i> Lista de Vendas
						</a>

						<?php if(!isset($venda)): ?>
						
						<a class="btn btn-primary mx-1" style="min-width: 150px;border-radius: 0;" href="/frenteCaixa/troca">
							<i class="las la-sync"></i> Lista de Trocas
						</a>
						<?php endif; ?>
						<?php endif; ?>
					</div>
					<div class="col-lg-2 col-md-4">

						<div class="dropdown dropdown-inline show" data-toggle="tooltip" title="" data-placement="left" data-original-title="Ações">

							<a <?php if(isset($preVenda) && $preVenda): ?> href="/frenteCaixa/list" <?php else: ?> href="/frenteCaixa/list" <?php endif; ?> class="btn btn-light-danger" style="border-radius: 0;">
								<i class="la la-angle-double-left"></i>

								Sair
								<!--end::Svg Icon-->
							</a>

							<?php if(!isset($preVenda)): ?>
							<a href="#" class="btn btn-light-info" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true" style="border-radius: 0;">
								Ações
								<i class="la la-angle-down"></i>
								<!--end::Svg Icon-->

							</a>
							<div class="dropdown-menu dropdown-menu-md dropdown-menu-right p-0 m-0 " style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(-211px, 39px, 0px);" x-placement="bottom-end">
								<!--begin::Navigation-->
								<ul class="navi navi-hover">
									<li class="navi-header font-weight-bold py-4">
										<span class="font-size-lg">Selecione:</span>
									</li>
									<li class="navi-separator mb-3 opacity-70"></li>


									<li class="navi-item">
										<a href="/frenteCaixa/devolucao" class="navi-link">
											<span class="navi-text">
												<span class="label label-xl label-inline label-light-danger">Devolução</span>
											</span>
										</a>
									</li>

									<li class="navi-item">
										<a data-toggle="modal" href="#!" data-target="#modal2" class="navi-link">
											<span class="navi-text">
												<span class="label label-xl label-inline label-light-dark">Sangria</span>
											</span>
										</a>
									</li>

									<li class="navi-item">
										<a data-toggle="modal" href="#!" data-target="#modal-supri" class="navi-link">
											<span class="navi-text">
												<span class="label label-xl label-inline label-light-warning">Suprimento de Caixa</span>
											</span>
										</a>
									</li>

									<li class="navi-item">
										<a data-toggle="modal" href="#!" data-target="#modal-comanda" class="navi-link">
											<span class="navi-text">
												<span class="label label-xl label-inline label-light-success">Apontar Comanda</span>
											</span>
										</a>
									</li>

									<li class="navi-item">
										<a href="/frenteCaixa/fechar" class="navi-link">
											<span class="navi-text">
												<span class="label label-xl label-inline label-light-danger">
													Fechar Caixa
												</span>
											</span>
										</a>
									</li>

									<li class="navi-item">
										<a href="/frenteCaixa/config" class="navi-link">
											<span class="navi-text">
												<span class="label label-xl label-inline label-light-dark">
													Configuração
												</span>
											</span>
										</a>
									</li>

									<li class="navi-item">
										<a data-toggle="modal" href="#!" data-target="#modal-rascunhos" class="navi-link">
											<span class="navi-text">
												<span class="label label-xl label-inline label-light-warning">
													Rascunhos
												</span>
											</span>
										</a>
									</li>

									<li class="navi-item">
										<a data-toggle="modal" href="#!" data-toggle="modal" data-target="#modal3" onclick="fluxoDiario()" class="navi-link">
											<span class="navi-text">
												<span class="label label-xl label-inline label-light-primary">
													Fluxo Diário
												</span>
											</span>
										</a>
									</li>


									<li class="navi-item">
										<a href="/frenteCaixa/list" class="navi-link">
											<span class="navi-text">
												<span class="label label-xl label-inline label-light-info">
													Sair
												</span>
											</span>
										</a>
									</li>
								</ul>

							</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>


			<hr>
			<div class="row">

				<div class="col-sm-12 col-lg-9 col-md-12 col-12">
					<div class="card card-custom gutter-b example example-compact">
						<div class="card-header">
							<div class="row" style="margin-top: 10px;width:100%">
								<div class="col-12">
									<div class="pr-2" id="focus-codigo">
										<button class="btn p-1 pl-2 barcode-btnbarcode-btn">
											<li class="la la-barcode" style="font-size: 2rem;color: #000;"></li>
										</button>

										<input class="mousetrap" type="" autofocus id="codBarras" name="">

										<span id="mousetrapTitle"><span>CLIQUE AQUI PARA ATIVAR O LEITOR</span> <i class="las la-sort-down" style="margin-top: 4px;"></i></span>
									</div>
								</div>
							</div>

							<div class="row align-items-center" style="margin-top: 10px;width:100%">
								<div class="form-group validated col-sm-6 col-lg-6 col-12 col-sm-12 add-prod">
									<label>Produto</label>
									<div class="input-group">

										<div class="input-group-prepend">
											<span class="input-group-text" id="focus-codigo">
												<li class="la la-search"></li>
											</span>
										</div>

										<!-- <input placeholder="Digite para buscar o produto" type="search" id="produto-search" class="form-control">
										<div class="search-prod" style="display: none">
										</div> -->

										<select class="form-control select2 produto-search select-search" style="width: 90%" id="kt_select2_1" name="produto-search">
											<option value="">Digite para buscar o produto</option>
										</select>

									</div>
								</div>

								<div class="form-group validated col-sm-2 col-lg-2 col-5 col-sm-5 add-prod">
									<div class="">
										<label>Valor</label>
										<input id="valor_item" placeholder="Valor" type="text" class="form-control" name="valor" value="<?php echo e(number_format(0, $casasDecimais, ',', '.')); ?>">
									</div>
								</div>

								<div class="form-group validated col-sm-2 col-lg-2 col-5 col-sm-5 add-prod">
									<div class="">
										<label>Quantidade</label>
										<input id="quantidade" placeholder="QTD" type="text" class="form-control" name="quantidade" value="1">

									</div>
								</div>

								<div class="form-group validated col-sm-2 col-lg-2 col-6 col-sm-6 add-prod">
									<button style="margin-top: 18px;" id="adicionar-item" type="submit" class="btn btn-success">Adicionar</button>
								</div>
							</div>
						</div>
						<div class="card-body" style="height: 445px;">

							<div class="col-xl-12">
								<div class="row">
									<div class="col-xl-12">
										<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded" >

											<table class="datatable-table" style="max-width: 100%; overflow: scroll; max-height: 420px;">
												<thead class="datatable-head">
													<tr class="datatable-row" style="left: 0px;">
														<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 50px;"></span></th>
														<th data-field="Country" class="datatable-cell datatable-cell-sort"><span style="width: 50px;">ID</span></th>
														<th data-field="ShipDate" class="datatable-cell datatable-cell-sort"><span style="width: 200px;">PRODUTO</span></th>
														<th data-field="CompanyName" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">QTD</span></th>
														<th data-field="CompanyName" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">VALOR</span></th>
														<th data-field="CompanyName" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">SUBTOTAL</span></th>
														<th data-field="CompanyName" class="datatable-cell datatable-cell-sort"><span style="width: 30px;">#</span></th>
														<?php if(isset($is_troca)): ?>
														<th data-field="ShipDate" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">Remover</span></th>
														<?php endif; ?>
													</tr>
												</thead>
												<tbody class="datatable-body" id="body">


												</tbody>

											</table>

										</div>
									</div>
								</div>

							</div>
						</div>

					</div>

					<div class="card card-custom gutter-b example example-compact" style="margin-top: -20px; height: auto;">
						<div class="card-body">
							<div class="row align-items-center">

								<div class="col-sm-3 col-lg-3 col-6" <?php if(isset($is_troca)): ?> style="display:none" <?php endif; ?>>
									<label>Desconto: R$ <strong id="valor_desconto">0,00</strong></label>
									<button onclick="setaDesconto()" style="margin-left: 4px; margin-top: -10px;" class="btn btn-link-primary">
										<i class="la la-edit"></i>
									</button>
								</div>
								<div class="col-sm-3 col-lg-3 col-6" <?php if(isset($is_troca)): ?> style="display:none" <?php endif; ?>>

									<label>Acrescimo: R$ <strong id="valor_acrescimo">0,00</strong></label>
									<button onclick="setaAcresicmo()" style="margin-left: 4px; margin-top: -10px;" class="btn btn-link-primary">
										<i class="la la-edit"></i>
									</button>
								</div>
								<div class="col-sm-2 col-lg-2 col-3" <?php if(isset($is_troca)): ?> style="display:none" <?php endif; ?>>
									<label>Lista de Preços</label>
								</div>

								<div class="col-sm-4 col-lg-4 col-6" style="margin-top: -8px;  <?php if(isset($is_troca)): ?> display:none; <?php endif; ?>">
									<?php if(isset($listaPreco)): ?>

									<select class="custom-select form-control" id="lista_id" name="lista_id">

										<option value="0">Padrão</option>
										<?php $__currentLoopData = $listaPreco; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e($l->id); ?>"><?php echo e($l->nome); ?> - <?php echo e($l->percentual_alteracao); ?>%
										</option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>

									<?php else: ?>


									<select class="custom-select form-control" id="lista_id" name="lista_id">

										<option value="0">Padrão</option>
									</select>


									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="col-sm-3 col-lg-3 col-md-12 col-12" id="div-categorias">
					<div class="card card-custom gutter-b example example-compact">
						<div class="card-header">
							<div class="form-group validated col-12" style="margin-top: 15px;">
								<button title="Informar Cliente" id="click-client" class="btn btn-danger btn-lg"  <?php if(isset($is_troca)): ?> style="display:none" <?php endif; ?>>
									<i class="la la-user"></i>
								</button>
								<button title="Pagamento Múltiplo" id="click-multi" class="btn btn-info btn-lg" <?php if(isset($is_troca) || isset($preVenda)): ?> style="display:none;" <?php endif; ?>>
									<i class="la la-list"></i>
								</button>
								<button title="Observação" onclick="setaObservacao()" class="btn btn-primary btn-lg">
									<i class="la la-marker"></i>
								</button>

								<?php if(isset($is_troca) && json_decode($venda)->cliente): ?>
								<div class="row">
									<div class="col-12 mt-5">
										<h4><i class="la la-user text-dark"></i> <?php echo e(json_decode($venda)->cliente->razao_social); ?></h4>
									</div>
								</div>
								<?php endif; ?>
							</div>
						</div>

						<div class="card-body pt-3 px-2" style="overflow-y: auto;">
							<div class="rounded py-5 mb-10 px-1" style="background:#F3F6F9;">
								<div class="col-12 px-10">
									<span style="color:#868686;font-size: 1.2rem;font-weight:800;">TOTAL R$:</span>
									<br/>
									<span id="total-venda" style="color:#274f51;font-size: 3.5rem;font-weight:400;">0</span>
									<?php if(isset($is_troca)): ?>
									<br>
									<span>Total restante: <strong class="text-danger" id="total-restante">R$ 0,00</strong></span>
									<?php endif; ?>
								</div>
							</div>

							<div class="form-group validated col-12 px-10" style="margin-top: 5px;">
								<div class="">
									<select class="custom-select form-control" id="tipo-pagamento" name="tipo-pagamento" <?php if(isset($is_troca) || isset($preVenda)): ?> style="display:none" <?php endif; ?>>
										<option value="--">Selecione o Tipo de pagamento</option>
										<?php $__currentLoopData = $tiposPagamento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

										<?php if(sizeof($caixa_tipos_pagamento) > 0): ?>
										<?php if(in_array($key, $caixa_tipos_pagamento)): ?>
										<option <?php if($caixa_tipo_pagamento_padrao == $key): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($key); ?> - <?php echo e($t); ?></option>
										<?php endif; ?>
										<?php else: ?>
										<option <?php if($caixa_tipo_pagamento_padrao == $key): ?> selected <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($key); ?> - <?php echo e($t); ?></option>
										<?php endif; ?>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
							</div>
							<div class="form-group validated col-sm-8 px-10" style="margin-top: 15px;">
								<div class="">
									<input type="text" placeholder="Valor recebido" id="valor_recebido" name="valor_recebido" class="form-control money" value="" <?php if(isset($is_troca) || isset($preVenda)): ?> style="display:none" <?php endif; ?>>
								</div>
							</div>
							<div class="form-group validated col-12 px-10">
								<span style="font-size: 20px; padding: 25px; width: 100% <?php if(isset($preVenda)): ?> ;display:none; <?php endif; ?>" class="label label-xl label-inline label-light-info">Troco
									<strong style="margin-left: 5px;" id="valor-troco"> R$ 0,00</strong>
								</span>
							</div>

							<div class="form-group validated col-12 px-10">
								<?php if(isset($is_troca)): ?>
								<button id="finalizar-troca" class="btn btn-success btn-lg w-100">
									<i class="la la-check"></i>
									Finalizar Troca
								</button>
								<?php endif; ?>

								<?php if(isset($preVenda)): ?>
								<button id="enviar-prevenda" class="btn btn-success btn-lg w-100">
									<i class="la la-paper-plane"></i>
									Enviar para o caixa
								</button>
								<button id="rascunho-prevenda" class="btn btn-secondary btn-lg w-100 mt-5">
									<i class="la la-sticky-note"></i>
									Manter em rascunhos
								</button>
								<?php else: ?>
								<button id="finalizar-venda" class="btn btn-success btn-lg w-100 spinner-white spinner-right" disabled <?php if(isset($is_troca)): ?> style="display:none;" <?php endif; ?>>
									<i class="la la-check"></i>
									Finalizar
									<!-- <strong id="total-venda">R$ 0,00</strong> -->
								</button>
								<button id="finalizar-rascunho" onclick="salvarRascuho()" class="btn btn-warning btn-lg mt-1 w-100" disabled  <?php if(isset($is_troca)): ?> style="display:none" <?php endif; ?>>
									<i class="la la-check"></i>
									Salvar rascunho
								</button> 
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>


		<!-- Modals -->
		<input type="hidden" id="_token" value="<?php echo e(csrf_token()); ?>" name="">

		<div class="modal fade" id="modal1" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-sm" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">É necessário abrir o caixa com um valor</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="form-group validated col-sm-12 col-lg-12">
								<label class="col-form-label" id="">Valor</label>
								<div class="">
									<input type="text" id="valor" name="valor" class="form-control money" value="">
								</div>
							</div>
						</div>

					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-light-danger font-weight-bold" data-dismiss="modal">Fechar</button>
						<button type="button" onclick="abrirCaixa()" class="btn btn-light-success font-weight-bold">Abrir</button>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="modal-pix" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Pagamento PIX</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="col-lg-12">
								<img src="" class="qrcode">
							</div>
						</div>

					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-light-danger font-weight-bold" data-dismiss="modal">Fechar</button>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="modal-barcode" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-sm" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Digite o código de barras</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="form-group validated col-12">
								<label class="col-form-label" id="">Código de barras</label>
								<div class="">
									<input type="text" id="barcode" name="barcode" class="form-control" value="">
								</div>
							</div>
						</div>

					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-light-danger font-weight-bold" data-dismiss="modal">Fechar</button>
						<button type="button" onclick="buscarProdutoCodigoBarras()" class="btn btn-light-success font-weight-bold btn-barcode-buscar">Buscar</button>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="modal-pag-mult" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-xl" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">PAGAMENTO MULTIPLO R$ <strong class="text-info" id="v-multi"></strong></h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="col-12">
								<h6>Adicione as linhas de pagamento</h6>
							</div>
							<div class="form-group validated col-sm-6 col-lg-3">
								<select class="custom-select form-control" id="tipo_pagamento" name="tipo_pagamento">
									<option value="">Tipo de pagamento</option>
									<?php $__currentLoopData = App\Models\VendaCaixa::tiposPagamento(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($key); ?>"><?php echo e($t); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
							<div class="form-group validated col-sm-6 col-lg-2">
								<input type="text" placeholder="Valor" id="valor_pagamento" name="valor_pagamento" class="form-control money" value="">
							</div>
							<div class="form-group validated col-sm-6 col-lg-4">
								<input type="text" placeholder="Observação/Descrição" id="observacao_pagamento" name="observacao_pagamento" class="form-control" value="">
							</div>
							<div class="form-group validated col-sm-6 col-lg-2">
								<input type="text" placeholder="Vencimento" id="vencimento_pagamento" name="vencimento_pagamento" class="form-control date-input kt_datepicker_3" value="">
							</div>
							<div class="form-group validated col-sm-6 col-lg-1">
								<button id="btnAddPag" onclick="addPag()" class="btn btn-success">
									<i class="la la-plus"></i>
								</button>
							</div>
						</div>
						<hr>
						<div class="row">
							<div class="col-12">
								<h6>Pagamentos adicionados</h6>
							</div>

							<div class="col-12">
								<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded" >

									<table class="datatable-table" style="max-width: 100%; overflow: scroll; max-height: 420px;">
										<thead class="datatable-head">
											<tr class="datatable-row" style="left: 0px;">
												<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">TIPO DO PAGAMENTO</span></th>
												<th data-field="Country" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">VENCIMENTO</span></th>
												<th data-field="Country" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">VALOR</span></th>
												<th data-field="ShipDate" class="datatable-cell datatable-cell-sort"><span style="width: 200px;">OBSERVAÇÃO</span></th>
												<th data-field="ShipDate" class="datatable-cell datatable-cell-sort"><span style="width: 60px;">AÇÕES</span></th>
												
											</tr>
										</thead>
										<tbody class="datatable-body" id="tbl_pag">

										</tbody>

									</table>

								</div>
							</div>
							
						</div>

						<div class="row">
							<div class="col-sm-6 col-lg-6">
								<br>
								<h4 class="">Valor restante 
									<strong id="vl_restante" class="text-danger"></strong>
								</h4>
							</div>
						</div>

					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-light-danger font-weight-bold" data-dismiss="modal">Fechar</button>
						<button type="button" id="btn-ok-multi" class="btn btn-light-success font-weight-bold" disabled="true">OK</button>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="modal-venda" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">FINALIZAR VENDA</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="form-group validated col-sm-4 col-lg-4 col-12 <?php if($certificado == null): ?> disabled <?php endif; ?>">
								<button <?php if($certificado == null): ?> disabled <?php endif; ?> id="btn_verifica_cliente" class="btn btn-success" onclick="verificaCliente()" style="height: 50px; width: 100%">

									CUPOM FISCAL
									<?php if($certificado == null): ?>
									<br>
									<b class="text-danger">Sem certificado</b>
									<?php endif; ?>

									<?php if($atalhos != null && $atalhos->finalizar_fiscal != ""): ?>
									<br>
									<b class="text-white"><?php echo e($atalhos->finalizar_fiscal); ?></b>
									<?php endif; ?>
								</button>
							</div>

							<div class="form-group validated col-sm-4 col-lg-4 col-12">
								<button class="btn btn-info" id="btn_nao_fiscal" onclick="finalizarVenda('nao_fiscal')" style="height: 50px; width: 100%">
									CUPOM NÃO FISCAL
									<?php if($atalhos != null && $atalhos->finalizar_nao_fiscal != ""): ?>
									<br>
									<b class="text-white"><?php echo e($atalhos->finalizar_nao_fiscal); ?></b>
									<?php endif; ?>
								</button>
							</div>

							<div class="form-group validated col-sm-4 col-lg-4 col-12">
								<button class="btn btn-warning disabled" id="conta_credito-btn" onclick="finalizarVenda('credito')" style="height: 50px; width: 100%">
									CONTA CRÉDITO
								</button>
							</div>


						</div>


					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="modal-emitir-cupom-troca" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">EMITIR CUPOM</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="form-group validated col-md-6 col-12 <?php if($certificado == null): ?> disabled <?php endif; ?>">
								<button <?php if($certificado == null): ?> disabled <?php endif; ?> id="btn-finalizarTrocaFiscal" class="btn btn-success" onclick="finalizarTrocaFiscal()" style="height: 50px; width: 100%">

									CUPOM FISCAL
									<?php if($certificado == null): ?>
									<br>
									<b class="text-danger">Sem certificado</b>
									<?php endif; ?>

									<?php if($atalhos != null && $atalhos->finalizar_fiscal != ""): ?>
									<br>
									<b class="text-white"><?php echo e($atalhos->finalizar_fiscal); ?></b>
									<?php endif; ?>
								</button>
							</div>

							<div class="form-group validated col-md-6 col-12">
								<button class="btn btn-info" id="btn_nao_fiscal" onclick="finalizarVenda('nao_fiscal')" style="height: 50px; width: 100%">
									CUPOM NÃO FISCAL
									<?php if($atalhos != null && $atalhos->finalizar_nao_fiscal != ""): ?>
									<br>
									<b class="text-white"><?php echo e($atalhos->finalizar_nao_fiscal); ?></b>
									<?php endif; ?>
								</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="modal-cpf-nota" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-md" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">CPF/CNPJ NA NOTA?</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<input type="hidden" id="nome" name="nome" class="form-control money" value="">
					<div class="modal-body">
						<div class="row">
							<div class="form-group validated col-sm-4 col-lg-4 col-12">
								<label class="col-form-label">TIPO</label>
								<select class="custom-select" id="select-doc">
									<option selected value="CPF">CPF</option>
									<option value="CNPJ">CNPJ</option>
								</select>
							</div>
							<div class="form-group validated col-sm-8 col-lg-8 col-12">
								<label class="col-form-label" id="tipo-doc">CPF</label>
								<input type="text" placeholder="CPF" id="cpf" name="cpf" class="form-control pula" value="">
							</div>
						</div>

						<div class="row">
							<div class="form-group validated col-12">
								<label class="col-form-label">Nome (opcional)</label>
								<input type="text" placeholder="Nome" id="nome-cpf" name="nome" class="form-control pula" value="">
							</div>
						</div>

					</div>
					<div class="modal-footer">
						<button style="width: 100%" id="btn-cpf" type="button" onPress="finalizarVenda('fiscal')" onclick="finalizarVenda('fiscal')" class="btn btn-success font-weight-bold spinner-white spinner-right pula">EMITIR</button>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="modal-cliente" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">SELECIONAR CLIENTE</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<input type="hidden" id="nome" name="nome" class="form-control money" value="">
					<div class="modal-body">
						<div class="row">
							<div class="form-group validated col-sm-12 col-lg-12 col-12">
								<label class="col-form-label" id="">Cliente</label><br>
								<select class="form-control select2" style="width: 100%" id="kt_select2_3" name="cliente">
									<option value="null">Selecione o cliente</option>
									<?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($c->id); ?>"><?php echo e($c->id); ?> - <?php echo e($c->razao_social); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>

					</div>
					<div class="modal-footer">
						<button type="button" onclick="novoClienteModal()" class="btn btn-light-primary mr-auto">Adicionar novo cliente</button>
						<button type="button" class="btn btn-light-danger font-weight-bold" data-dismiss="modal">Fechar</button>
						<button type="button" onclick="selecionarCliente()" class="btn btn-light-success font-weight-bold">OK</button>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="prevenda_rascunhos_lista" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="sprevenda_rascunhos_lista" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Rascunhos de Pré-venda</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="col-sm-12 col-lg-12 col-12 d-flex" style="flex-direction: column;gap: 4px;max-height: 500px;overflow-y: scroll;">
								<?php if(isset($preVendaRascunhos) && count($preVendaRascunhos) > 0): ?>
								<?php $__currentLoopData = $preVendaRascunhos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<div class="row">
									<a style="width: 85% !important;" href="/frenteCaixa/prevenda/edit/<?php echo e($v->id); ?>" class="bg-secondary">
										<span class="btn text-left">
											<?php echo e($v->vendedor()); ?>

										</span>
										<span class="btn text-left">
											#<?php echo e($v->id); ?> - <?php echo e($v->observacao); ?> - <?php echo e($v->cliente->razao_social ?? ''); ?> - <?php echo e(\Carbon\Carbon::parse($v->updated_at)->format('d/m/Y H:i:s')); ?>

										</span>
									</a>
									<a style="width: 12% !important;" class="btn btn-danger ml-1" title="REMOVER RASCUNHO" onclick='swal("Atenção!", "Deseja remover este registro?", "warning").then((sim) => {if(sim){ location.href="/frenteCaixa/deleteRascunhoPreVenda/<?php echo e($v->id); ?>" }else{return false} })'>
										<i class="la la-trash"></i>
									</a>
								</div>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<?php else: ?>
								<p class="p-3">Sem rascunhos de pré-venda.</p>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="selecionar_vendedor_modal" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="selecionar_vendedor_modal" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Selecione o vendedor</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="col-12 d-flex">
								<select class="form-control mb-5" id="select-vendedor" style="width: 100%" name="Vendedor" tabindex="-1" aria-hidden="true">
									<option value="" data-select2-id="5854">Selecione o vendedor</option>
									<?php $__currentLoopData = $vendedores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($v->id); ?>" <?php if(get_id_user() == $v->id): ?> selected="true" <?php endif; ?>><?php echo e($v->funcionario->nome); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>
					</div>
					<div class="modal-footer py-2">
						<div class="btn btn-success" data-dismiss="modal" aria-label="Close">OK</div>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="selecionar_assessor_modal" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="selecionar_assessor_modal" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Selecione o assessor</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="col-12 d-flex">
								<select class="form-control mb-5" id="select-assessor" style="width: 100%" name="assessor" tabindex="-1" aria-hidden="true">
									<option value="">Selecione o assessor</option>
									<?php $__currentLoopData = $acessores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($v->id); ?>"><?php echo e($v->razao_social); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>
					</div>
					<div class="modal-footer py-2">
						<div class="btn btn-success" onclick="selectAssessor()" data-dismiss="modal" aria-label="Close">OK</div>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="lista_prevenda_nivel2" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="lista_prevenda_nivel2" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Pré-vendas</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="col-sm-12 col-lg-12 col-12 d-flex" style="flex-direction: column;gap: 4px;max-height: 500px;overflow-y: scroll;">
								<div class="" id="lista_prevenda_container" style="min-height: 50px;">
									<div class="bg-secondary">
										<span class="btn text-left">

										</span>
										<span class="btn text-left">

										</span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="modal2" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-sm" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">SANGRIA DE CAIXA</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="form-group validated col-sm-12 col-lg-12 col-12">
								<label class="col-form-label" id="">Valor</label>
								<input type="text" placeholder="Valor" id="valor_sangria" name="valor_sangria" class="form-control" value="">
							</div>
						</div>

					</div>
					<div class="modal-footer">
						<button style="width: 100%" type="button" onclick="sangriaCaixa()" class="btn btn-success font-weight-bold">OK</button>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="modal-supri" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">SUPRIMENTO DE CAIXA</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="form-group validated col-sm-6 col-lg-6 col-6">
								<label class="col-form-label" id="">Valor</label>
								<input type="text" placeholder="Valor" id="valor_suprimento" name="valor_sangria" class="form-control money" value="">
							</div>
						</div>

						<div class="row">
							<div class="form-group validated col-sm-12 col-lg-12 col-12">
								<label class="col-form-label" id="">Observação</label>
								<input type="text" placeholder="Observação" id="obs_suprimento" name="obs" class="form-control" value="">
							</div>
						</div>

					</div>
					<div class="modal-footer">
						<button style="width: 100%" type="button" onclick="suprimentoCaixa()" class="btn btn-success font-weight-bold">OK</button>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="modal-rascunhos" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-xl" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">ULTIMOS RASCUNHOS</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<?php if(sizeof($rascunhos) > 0): ?>
						<div class="col-xl-12">
							<p class="text-info">*Ultimos 20 rascunhos</p>
							<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

								<table class="datatable-table" style="max-width: 100%; overflow: scroll">
									<thead class="datatable-head">
										<tr class="datatable-row" style="left: 0px;">

											<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">Cliente</span></th>
											<th data-field="Country" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">Data</span></th>
											<th data-field="Country" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Valor</span></th>
											<th data-field="CompanyName" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Ações</span></th>
										</tr>
									</thead>
									<tbody class="datatable-body">
										<?php $__currentLoopData = $rascunhos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr class="datatable-row">
											<td class="datatable-cell"><span class="codigo" style="width: 150px;"><?php echo e($v->cliente->razao_social ?? 'NAO IDENTIFCADO'); ?></span>
											</td>
											<td class="datatable-cell"><span class="codigo" style="width: 150px;"><?php echo e(\Carbon\Carbon::parse($v->created_at)->format('d/m/Y H:i:s')); ?></span>
											</td>
											<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e(number_format($v->valor_total, $casasDecimais, ',', '.')); ?></span>
											</td>
											<td class="datatable-cell">
												<a title="EDITAR RASCUNHO" href="/frenteCaixa/edit/<?php echo e($v->id); ?>" class="btn btn-warning">
													<i class="la la-edit"></i>
												</a>
												<a title="REMOVER RASCUNHO" onclick='swal("Atenção!", "Deseja editar este registro?", "warning").then((sim) => {if(sim){ location.href="/frenteCaixa/deleteRascunho/<?php echo e($v->id); ?>" }else{return false} })' href="#!" class="btn btn-danger">
													<i class="la la-trash"></i>
												</a>
											</td>

										</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</tbody>
								</table>
							</div>
						</div>
						<?php else: ?>
						<p>Nenhum rascunho encontrado</p>
						<?php endif; ?>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-light-danger font-weight-bold" data-dismiss="modal">Fechar</button>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="modal3" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">FLUXO DIÁRIO</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>

					<div class="modal-body">

						<div class="row" style="height: 350px; overflow-y: auto;">
							<div class="col-sm-12 col-lg-12 col-12">
								<h5>Abertura de Caixa:</h5>
								<div id="fluxo_abertura_caixa"></div>
							</div>

							<div class="col-sm-12 col-lg-12 col-12">
								<h5>Sangrias:</h5>
								<div id="fluxo_sangrias"></div>
							</div>

							<div class="col-sm-12 col-lg-12 col-12">
								<h5>Suprimentos:</h5>
								<div id="fluxo_suprimentos"></div>
							</div>

							<div class="col-sm-12 col-lg-12 col-12">
								<h5>Vendas:</h5>
								<div id="fluxo_vendas"></div>
							</div>

							<div class="col-sm-12 col-lg-12 col-12">
								<h5>Total em caixa:
									<strong id="total_caixa" class="text-success"></strong></h5>
								</div>
							</div>
						</div>


					</div>

				</div>
			</div>
		</div>

		<div class="modal fade" id="modal4" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">SUGESTÃO DE TROCO</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>

					<div class="modal-body">
						<h2>Valor do troco: <strong id="valor_troco" class="text-danger">0,00</strong></h2>

						<div class="row" style="height: 460px; overflow-y: auto;">
							<div class="col-sm-12 col-lg-12 col-12">

								<div class="row 50_reais" style="display: none">
									<div class="col-sm-3 col-lg-3 col-3">
										<img class="money-cel" src="/imgs/50_reais.jpeg">
									</div>
									<div class="col-sm-3 col-lg-3 col-3">
										<h4 id="qtd_50_reais"></h4>
									</div>
								</div>
								<div class="row 20_reais" style="display: none">
									<div class="col-sm-3 col-lg-3 col-3">
										<img class="money-cel" src="/imgs/20_reais.jpeg">
									</div>
									<div class="col-sm-3 col-lg-3 col-3">
										<h4 id="qtd_20_reais"></h4>
									</div>
								</div>

								<div class="row 10_reais" style="display: none">
									<div class="col-sm-3 col-lg-3 col-3">
										<img class="money-cel" src="/imgs/10_reais.jpeg">
									</div>
									<div class="col-sm-3 col-lg-3 col-3">
										<h4 id="qtd_10_reais"></h4>
									</div>
								</div>

								<div class="row 5_reais" style="display: none">
									<div class="col-sm-3 col-lg-3 col-3">
										<img class="money-cel" src="/imgs/5_reais.jpeg">
									</div>
									<div class="col-sm-3 col-lg-3 col-3">
										<h4 id="qtd_5_reais"></h4>
									</div>
								</div>

								<div class="row 2_reais" style="display: none">

									<div class="col-sm-3 col-lg-3 col-3">
										<img class="money-cel" src="/imgs/2_reais.jpeg">
									</div>
									<div class="col-sm-3 col-lg-3 col-3">
										<h4 id="qtd_2_reais"></h4>
									</div>
								</div>

								<div class="row 1_real" style="display: none">
									<div class="col-sm-3 col-lg-3 col-3">
										<img class="money-moeda" src="/imgs/1_real.png">
									</div>
									<div class="col-sm-3 col-lg-3 col-3">
										<h4 id="qtd_1_real"></h4>
									</div>
								</div>

								<div class="row 50_centavo" style="display: none">
									<div class="col-sm-3 col-lg-3 col-3">
										<img class="money-moeda" src="/imgs/50_centavo.png">
									</div>
									<div class="col-sm-3 col-lg-3 col-3">
										<h4 id="qtd_50_centavos"></h4>
									</div>
								</div>

								<div class="row 25_centavo" style="display: none">
									<div class="col-sm-3 col-lg-3 col-3">
										<img class="money-moeda" src="/imgs/25_centavo.png">
									</div>
									<div class="col-sm-3 col-lg-3 col-3">
										<h4 id="qtd_25_centavos"></h4>
									</div>
								</div>

								<div class="row 10_centavo" style="display: none">
									<div class="col-sm-3 col-lg-3 col-3">
										<img class="money-moeda" src="/imgs/10_centavo.png">
									</div>
									<div class="col-sm-3 col-lg-3 col-3">
										<h4 id="qtd_10_centavos"></h4>
									</div>
								</div>


								<div class="row 5_centavo" style="display: none">
									<div class="col-sm-3 col-lg-3 col-3">
										<img class="money-moeda" src="/imgs/5_centavo.png">
									</div>
									<div class="col-sm-3 col-lg-3 col-3">
										<h4 id="qtd_5_centavos"></h4>
									</div>
								</div>
							</div>
						</div>


					</div>

				</div>
			</div>
		</div>

		<div id="modal4" class="modal">
			<div class="modal-content">
				<div class="row">
					<h4>Valor do troco: <strong id="valor_troco" class="orange-text">0,00</strong></h4>

					<h5>Sugestão:</h5>
					<div class="row 50_reais" style="display: none">
						<div class="col s3">
							<img class="money-cel" src="/imgs/50_reais.jpeg">
						</div>
						<div class="col s3">
							<h4 id="qtd_50_reais"></h4>
						</div>
					</div>
					<div class="row 20_reais" style="display: none">
						<div class="col s3">
							<img class="money-cel" src="/imgs/20_reais.jpeg">
						</div>
						<div class="col s3">
							<h4 id="qtd_20_reais"></h4>
						</div>
					</div>

					<div class="row 10_reais" style="display: none">
						<div class="col s3">
							<img class="money-cel" src="/imgs/10_reais.jpeg">
						</div>
						<div class="col s3">
							<h4 id="qtd_10_reais"></h4>
						</div>
					</div>

					<div class="row 5_reais" style="display: none">
						<div class="col s3">
							<img class="money-cel" src="/imgs/5_reais.jpeg">
						</div>
						<div class="col s3">
							<h4 id="qtd_5_reais"></h4>
						</div>
					</div>

					<div class="row 2_reais" style="display: none">
						<div class="col s3">
							<img class="money-cel" src="/imgs/2_reais.jpeg">
						</div>
						<div class="col s3">
							<h4 id="qtd_2_reais"></h4>
						</div>
					</div>

					<div class="row 1_real" style="display: none">
						<div class="col s3">
							<img class="money-moeda" src="/imgs/1_real.png">
						</div>
						<div class="col s3">
							<h4 id="qtd_1_real"></h4>
						</div>
					</div>

					<div class="row 50_centavo" style="display: none">
						<div class="col s3">
							<img class="money-moeda" src="/imgs/50_centavo.png">
						</div>
						<div class="col s3">
							<h4 id="qtd_50_centavos"></h4>
						</div>
					</div>

					<div class="row 25_centavo" style="display: none">
						<div class="col s3">
							<img class="money-moeda" src="/imgs/25_centavo.png">
						</div>
						<div class="col s3">
							<h4 id="qtd_25_centavos"></h4>
						</div>
					</div>

					<div class="row 10_centavo" style="display: none">
						<div class="col s3">
							<img class="money-moeda" src="/imgs/10_centavo.png">
						</div>
						<div class="col s3">
							<h4 id="qtd_10_centavos"></h4>
						</div>
					</div>


					<div class="row 5_centavo" style="display: none">
						<div class="col s3">
							<img class="money-moeda" src="/imgs/5_centavo.png">
						</div>
						<div class="col s3">
							<h4 id="qtd_5_centavos"></h4>
						</div>
					</div>

				</div>
			</div>
			<div class="modal-footer">
				<div class="modal-footer">
					<a href="#!" class="modal-action modal-close waves-effect waves-green btn-flat">Fechar</a>
				</div>

			</div>
		</div>

		<div class="modal fade" id="modal-cartao" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">INFORME OS DADOS DO CARTÃO</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="form-group validated col-sm-3 col-lg-3 col-6">
								<label class="col-form-label">Bandeira</label>
								<select class="custom-select" id="bandeira_cartao">
									<option value="">--</option>
									<?php $__currentLoopData = App\Models\VendaCaixa::bandeiras(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($key); ?>"><?php echo e($b); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
							<div class="form-group validated col-sm-4 col-lg-4 col-6">
								<label class="col-form-label">Código autorização(opcional)</label>
								<input type="text" placeholder="Código autorização" id="cAut_cartao" class="form-control" value="">
							</div>

							<div class="form-group validated col-sm-4 col-lg-5 col-12">
								<label class="col-form-label">CNPJ(opcional)</label>
								<input type="text" placeholder="CNPJ" id="cnpj_cartao" data-mask="00.000.000/0000-00" name="cnpj_cartao" class="form-control" value="">
							</div>
						</div>

					</div>
					<div class="modal-footer">
						<button style="width: 100%" type="button" data-dismiss="modal" class="btn btn-success font-weight-bold">Salvar</button>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="modal-pag-outros" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">INFORME A DESCRIÇAO DO TIPO DE PAGAMENTO OUTROS</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">


							<div class="form-group validated col-12">
								<label class="col-form-label">Descrição</label>
								<input type="text" placeholder="Descrição" id="descricao_pag_outros" name="descricao_pag_outros" class="form-control" value="">
							</div>
						</div>

					</div>
					<div class="modal-footer">
						<button style="width: 100%" type="button" data-dismiss="modal" class="btn btn-success font-weight-bold">Salvar</button>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="modal-comanda" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-sm" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">INFORME O CÓDIGO DA COMANDA</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="form-group validated col-sm-12 col-lg-12 col-12">
								<label class="col-form-label" id="">Código da comanda</label>
								<input type="text" placeholder="Comanda" id="cod-comanda" name="cod-comanda" class="form-control" value="">
							</div>
						</div>

					</div>
					<div class="modal-footer">
						<button style="width: 100%" type="button" onclick="apontarComanda()" class="btn btn-success font-weight-bold spinner-white spinner-right btn-apontar">APONTAR</button>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="modal-grade" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-md" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">Grade</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body grade-prod">

					</div>
				</div>
			</div>
		</div>


		<div class="modal fade" id="modal-obs" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">OBSERVAÇÃO</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="form-group validated col-sm-12 col-lg-12 col-12">
								<label class="col-form-label" id="">Observação</label>
								<input type="text" placeholder="Observação" id="obs" class="form-control" <?php if(isset($observacao)): ?> value="<?php echo e($observacao); ?>" <?php endif; ?>>
							</div>
						</div>

					</div>
					<div class="modal-footer">
						<button style="width: 100%" type="button" onclick="apontarObs()" class="btn btn-success font-weight-bold">OK</button>
					</div>
				</div>
			</div>
		</div>

		

		<div class="modal fade" id="add_cliente_modal" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
			<div class="modal-dialog modal-xl" role="document">
				<div class="modal-content">
					<div class="modal-header">
						<h5 class="modal-title">ADICIONAR NOVO CLIENTE</h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							x
						</button>
					</div>
					<div class="modal-body">
						<div class="row">
							<form method="post" id="new_client_form">

								<?php echo csrf_field(); ?>
								<div class="row">
									<div class="col-xl-12">
										<div class="kt-section kt-section--first">
											<div class="kt-section__body">

												<div class="row">
													<div class="form-group col-sm-12 col-lg-12">
														<label>Pessoa:</label>
														<div class="radio-inline">


															<label class="radio radio-success">
																<input value="p_fisica" name="group1" type="radio" id="pessoaFisica" <?php if(isset($cliente)): ?> <?php if(strlen($cliente->cpf_cnpj)
																< 15): ?> checked <?php endif; ?> <?php endif; ?> <?php if(old('group1') == 'p_fisica'): ?> checked <?php endif; ?>/>
																<span></span>
																FISICA
															</label>
															<label class="radio radio-success">
																<input value="p_juridica" name="group1" type="radio" id="pessoaJuridica" <?php if(isset($cliente)): ?> <?php if(strlen($cliente->cpf_cnpj) > 15): ?> checked <?php endif; ?> <?php endif; ?> <?php if(old('group1') == 'p_juridica'): ?> checked <?php endif; ?>/>
																<span></span>
																JURIDICA
															</label>

															<label class="radio radio-success">
																<input value="p_ext" name="group1" type="radio" id="pessoaExt" <?php if(isset($cliente)): ?> <?php if($cliente->cpf_cnpj == '00.000.000/0000-00'): ?> checked <?php endif; ?> <?php endif; ?> <?php if(old('group1') == 'p_ext'): ?> checked <?php endif; ?>/>
																<span></span>
																EXTERIOR
															</label>
														</div>

													</div>
												</div>

												<div class="row">
													<div class="form-group validated col-sm-3 col-lg-4">
														<label class="col-form-label" id="lbl_cpf_cnpj">CPF</label>
														<div class="">
															<input type="text" id="cpf_cnpj" class="form-control <?php if($errors->has('cpf_cnpj')): ?> is-invalid <?php endif; ?>" name="cpf_cnpj" value="<?php echo e(isset($cliente) ? $cliente->cpf_cnpj : old('cpf_cnpj')); ?>">
															<?php if($errors->has('cpf_cnpj')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('cpf_cnpj')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>
													<div class="form-group validated col-lg-2 col-md-2 col-sm-6">
														<label class="col-form-label">UF</label>

														<select class="custom-select form-control" id="sigla_uf" name="sigla_uf">
															<?php $__currentLoopData = $estados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<option <?php if(isset($cliente)): ?> <?php if($cliente->cidade->uf == $c): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($c); ?>"
																<?php if(old('sigla_uf') == $c): ?>
																selected
																<?php endif; ?>>
																<?php echo e($c); ?>

															</option>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														</select>

													</div>
													<div class="form-group validated col-lg-2 col-md-2 col-sm-6">
														<br><br>
														<a type="button" id="btn-consulta-cadastro" onclick="consultaCadastro()" class="btn btn-success spinner-white spinner-right">
															<span>
																<i class="fa fa-search"></i>
															</span>
														</a>
													</div>

												</div>

												<div class="row">
													<div class="form-group validated col-sm-10 col-lg-6">
														<label class="col-form-label">Razao Social/Nome</label>
														<div class="">
															<input id="razao_social" type="text" class="form-control <?php if($errors->has('razao_social')): ?> is-invalid <?php endif; ?>" name="razao_social" value="<?php echo e(isset($cliente) ? $cliente->razao_social : old('razao_social')); ?>">
															<?php if($errors->has('razao_social')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('razao_social')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-10 col-lg-6">
														<label class="col-form-label">Nome Fantasia</label>
														<div class="">
															<input id="nome_fantasia" type="text" class="form-control <?php if($errors->has('nome_fantasia')): ?> is-invalid <?php endif; ?>" name="nome_fantasia" value="<?php echo e(isset($cliente) ? $cliente->nome_fantasia : old('nome_fantasia')); ?>">
															<?php if($errors->has('nome_fantasia')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('nome_fantasia')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>
												</div>


												<div class="row">

													<div class="form-group validated col-sm-3 col-lg-4">
														<label class="col-form-label" id="lbl_ie_rg">IE/RG</label>
														<div class="">
															<input type="text" id="ie_rg" class="form-control <?php if($errors->has('ie_rg')): ?> is-invalid <?php endif; ?>" name="ie_rg" value="<?php echo e(isset($cliente) ? $cliente->ie_rg : old('ie_rg')); ?>">
															<?php if($errors->has('ie_rg')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('ie_rg')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>
													<div class="form-group validated col-lg-3 col-md-3 col-sm-10">
														<label class="col-form-label">Consumidor Final</label>

														<select class="custom-select form-control" id="consumidor_final" name="consumidor_final">
															<option value=""></option>
															<option <?php if(isset($cliente) && $cliente->consumidor_final == 1): ?> selected <?php endif; ?> value="1" <?php if(old('consumidor_final') == 1): ?> selected <?php endif; ?> selected>SIM</option>
															<option <?php if(isset($cliente) && $cliente->consumidor_final == 0): ?> selected <?php endif; ?> value="0" <?php if(old('consumidor_final') == 0): ?> <?php endif; ?>>NAO</option>
														</select>
														<?php if($errors->has('consumidor_final')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('consumidor_final')); ?>

														</div>
														<?php endif; ?>

													</div>

													<div class="form-group validated col-lg-3 col-md-3 col-sm-10">
														<label class="col-form-label">Contribuinte</label>

														<select class="custom-select form-control" id="contribuinte" name="contribuinte">
															<option value=""></option>
															<option <?php if(isset($cliente) && $cliente->contribuinte == 1): ?> selected <?php endif; ?> value="1" <?php if(old('contribuinte') == 1): ?> selected <?php endif; ?> selected>SIM</option>
															<option <?php if(isset($cliente) && $cliente->contribuinte == 0): ?> selected <?php endif; ?> value="0" <?php if(old('contribuinte') == 0): ?> <?php endif; ?>>NAO</option>
														</select>
														<?php if($errors->has('contribuinte')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('contribuinte')); ?>

														</div>
														<?php endif; ?>

													</div>

													<div class="form-group validated col-sm-3 col-lg-4">
														<label class="col-form-label" id="lbl_ie_rg">Limite de Venda</label>
														<div class="">
															<input type="text" id="limite_venda" class="form-control <?php if($errors->has('limite_venda')): ?> is-invalid <?php endif; ?> money" name="limite_venda" value="<?php echo e(isset($cliente) ? $cliente->limite_venda : old('limite_venda')); ?>">
															<?php if($errors->has('limite_venda')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('limite_venda')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-3 col-lg-3">
														<label class="col-form-label" id="lbl_ie_rg">Data de Aniversário</label>
														<div class="">
															<input type="text" id="data_aniversario" class="form-control <?php if($errors->has('data_aniversario')): ?> is-invalid <?php endif; ?>" data-mask="00/00" data-mask-reverse="true" name="data_aniversario" value="<?php echo e(isset($cliente) ? $cliente->data_aniversario : old('data_aniversario')); ?>">
															<?php if($errors->has('data_aniversario')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('data_aniversario')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

												</div>
												<hr>
												<h5>Endereço de Faturamento</h5>
												<div class="row">
													<div class="form-group validated col-sm-8 col-lg-8">
														<label class="col-form-label">Rua</label>
														<div class="">
															<input id="rua" type="text" class="form-control <?php if($errors->has('rua')): ?> is-invalid <?php endif; ?>" name="rua" value="<?php echo e(isset($cliente) ? $cliente->rua : old('rua')); ?>">
															<?php if($errors->has('rua')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('rua')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-2 col-lg-2">
														<label class="col-form-label">Número</label>
														<div class="">
															<input id="numero" type="text" class="form-control <?php if($errors->has('numero')): ?> is-invalid <?php endif; ?>" name="numero" value="<?php echo e(isset($cliente) ? $cliente->numero : old('numero')); ?>">
															<?php if($errors->has('numero')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('numero')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>
												</div>
												<div class="row">
													<div class="form-group validated col-sm-8 col-lg-10">
														<label class="col-form-label">Complemento</label>
														<div class="">
															<input id="complemento" type="text" class="form-control <?php if($errors->has('complemento')): ?> is-invalid <?php endif; ?>" name="complemento" value="<?php echo e(isset($cliente) ? $cliente->complemento : old('complemento')); ?>">
															<?php if($errors->has('complemento')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('complemento')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>
												</div>
												<div class="row">
													<div class="form-group validated col-sm-8 col-lg-5">
														<label class="col-form-label">Bairro</label>
														<div class="">
															<input id="bairro" type="text" class="form-control <?php if($errors->has('bairro')): ?> is-invalid <?php endif; ?>" name="bairro" value="<?php echo e(isset($cliente) ? $cliente->bairro : old('bairro')); ?>">
															<?php if($errors->has('bairro')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('bairro')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-8 col-lg-3">
														<label class="col-form-label">CEP</label>
														<div class="">
															<input id="cep" type="text" class="form-control <?php if($errors->has('cep')): ?> is-invalid <?php endif; ?>" name="cep" value="<?php echo e(isset($cliente) ? $cliente->cep : old('cep')); ?>">
															<?php if($errors->has('cep')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('cep')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-8 col-lg-4">
														<label class="col-form-label">Email</label>
														<div class="">
															<input id="email" type="text" class="form-control <?php if($errors->has('email')): ?> is-invalid <?php endif; ?>" name="email" value="<?php echo e(isset($cliente) ? $cliente->email : old('email')); ?>">
															<?php if($errors->has('email')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('email')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

												</div>

												<div class="row">


													<div class="form-group validated col-lg-5 col-md-5 col-sm-10">
														<label class="col-form-label text-left col-12 col-sm-12">Cidade</label>
														<select class="form-control select2" id="kt_select2_4" name="cidade">
															<?php $__currentLoopData = $cidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<option value="<?php echo e($c->id); ?>" <?php if(isset($cliente)): ?> <?php if($c->id == $cliente->cidade_id): ?> selected <?php endif; ?> <?php endif; ?>
																<?php if(old('cidade') == $c->id): ?>
																selected
																<?php endif; ?>
																>
																<?php echo e($c->nome); ?> (<?php echo e($c->uf); ?>)
															</option>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														</select>
														<?php if($errors->has('cidade')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('cidade')); ?>

														</div>
														<?php endif; ?>
													</div>

													<div class="form-group validated col-lg-3 col-md-3 col-sm-6">
														<label class="col-form-label text-left col-12">Pais</label>
														<select class="form-control select2" id="kt_select2_5" name="cod_pais">
															<?php $__currentLoopData = $pais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<option value="<?php echo e($p->codigo); ?>" <?php if(isset($cliente)): ?> <?php if($p->codigo == $cliente->cod_pais): ?> selected <?php endif; ?> <?php else: ?> <?php if($p->codigo == 1058): ?> selected <?php endif; ?> <?php endif; ?> ><?php echo e($p->codigo); ?> -  (<?php echo e($p->nome); ?>)</option>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														</select>
														<?php if($errors->has('cod_pais')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('cod_pais')); ?>

														</div>
														<?php endif; ?>
													</div>

													<div class="form-group validated col-sm-8 col-lg-4">
														<label class="col-form-label">ID estrangeiro (Opcional)</label>
														<div class="">
															<input id="id_estrangeiro" type="text" class="form-control <?php if($errors->has('id_estrangeiro')): ?> is-invalid <?php endif; ?>" name="id_estrangeiro" value="<?php echo e(isset($cliente) ? $cliente->id_estrangeiro : old('id_estrangeiro')); ?>">
															<?php if($errors->has('id_estrangeiro')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('id_estrangeiro')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>
												</div>

												<div class="row">
													<div class="form-group validated col-sm-8 col-lg-3">
														<label class="col-form-label">Telefone (Opcional)</label>
														<div class="">
															<input id="telefone" type="text" class="form-control <?php if($errors->has('telefone')): ?> is-invalid <?php endif; ?>" name="telefone" value="<?php echo e(isset($cliente) ? $cliente->telefone : old('telefone')); ?>">
															<?php if($errors->has('telefone')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('telefone')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-8 col-lg-3">
														<label class="col-form-label">Celular (Opcional)</label>
														<div class="">
															<input id="celular" type="text" class="form-control <?php if($errors->has('celular')): ?> is-invalid <?php endif; ?>" name="celular" value="<?php echo e(isset($cliente) ? $cliente->celular : old('celular')); ?>">
															<?php if($errors->has('celular')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('celular')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-8 col-lg-3">
														<label class="col-form-label">Grupo (Opcional)</label>
														<div class="">

															<select class="custom-select form-control" name="grupo_id">
																<option value="0">--</option>
																<?php $__currentLoopData = $grupos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $g): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																<option <?php if(isset($cliente)): ?> <?php if($cliente->grupo_id == $g->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($g->id); ?>"
																	<?php if(old('grupo_id') == $g->id): ?>
																	selected
																	<?php endif; ?>>
																	<?php echo e($g->nome); ?>

																</option>
																<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
															</select>
														</div>
													</div>

													<div class="form-group validated col-sm-8 col-lg-3">
														<label class="col-form-label">Assessor (Opcional)</label>
														<div class="">

															<select class="custom-select form-control" name="acessor_id">
																<option value="0">--</option>
																<?php $__currentLoopData = $acessores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																<option <?php if(isset($cliente)): ?> <?php if($cliente->acessor_id == $a->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($a->id); ?>"
																	<?php if(old('acessor_id') == $a->id): ?>
																	selected
																	<?php endif; ?>>
																	<?php echo e($a->razao_social); ?>

																</option>
																<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
															</select>
														</div>
													</div>
												</div>

												<div class="row">
													<div class="form-group validated col-sm-3 col-lg-3">
														<label class="col-form-label">Dados do Contador</label>
														<div class="col-12">
															<span class="switch switch-outline switch-info">
																<label>
																	<input value="true" <?php if(isset($cliente) && $cliente->contador_nome != ""): ?> checked <?php endif; ?> <?php if(old('info_contador')): ?> checked <?php endif; ?> type="checkbox" name="info_contador" id="info_contador">
																	<span></span>
																</label>
															</span>
														</div>
													</div>

													<div class="form-group validated col-sm-5 col-lg-4 ct">
														<label class="col-form-label">Nome</label>
														<div class="">
															<input id="contador_nome" type="text" class="form-control <?php if($errors->has('contador_nome')): ?> is-invalid <?php endif; ?>" name="contador_nome" value="<?php echo e(isset($cliente) ? $cliente->contador_nome : old('contador_nome')); ?>">
															<?php if($errors->has('contador_nome')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('contador_nome')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-4 col-lg-3 ct">
														<label class="col-form-label">Telefone</label>
														<div class="">
															<input id="contador_telefone" type="text" class="form-control <?php if($errors->has('contador_telefone')): ?> is-invalid <?php endif; ?> telefone" name="contador_telefone" value="<?php echo e(isset($cliente) ? $cliente->contador_telefone : old('contador_telefone')); ?>">
															<?php if($errors->has('contador_telefone')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('contador_telefone')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-5 col-lg-4 ct">
														<label class="col-form-label">Email</label>
														<div class="">
															<input id="contador_email" type="email" class="form-control <?php if($errors->has('contador_email')): ?> is-invalid <?php endif; ?>" name="contador_email" value="<?php echo e(isset($cliente) ? $cliente->contador_email : old('contador_email')); ?>">
															<?php if($errors->has('contador_email')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('contador_email')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>
												</div>

												<div class="row">
													<div class="form-group validated col-sm-8 col-lg-8 col-12">
														<label class="col-form-label">Observação</label>
														<div class="">
															<input id="observacao" type="text" class="form-control <?php if($errors->has('observacao')): ?> is-invalid <?php endif; ?>" name="observacao" value="<?php echo e(isset($cliente) ? $cliente->observacao : old('observacao')); ?>">
															<?php if($errors->has('observacao')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('observacao')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-4 col-lg-4 col-12">
														<label class="col-form-label">Vendedor/Funcionário</label>
														<div class="">
															<select class="custom-select form-control" name="funcionario_id">
																<option value="0">--</option>
																<?php $__currentLoopData = $funcionarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																<option <?php if(isset($cliente)): ?> <?php if($cliente->funcionario_id == $f->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($f->id); ?>"
																	<?php if(old('funcionario_id') == $f->id): ?>
																	selected
																	<?php endif; ?>>
																	<?php echo e($f->nome); ?>

																</option>
																<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
															</select>
															<?php if($errors->has('funcionario_id')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('funcionario_id')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>
												</div>

												<hr>
												<h5>Endereço de Cobrança (Opcional)</h5>
												<div class="row">
													<div class="form-group validated col-sm-8 col-lg-8">
														<label class="col-form-label">Rua</label>
														<div class="">
															<input id="rua_cobranca" type="text" class="form-control <?php if($errors->has('rua_cobranca')): ?> is-invalid <?php endif; ?>" name="rua_cobranca" value="<?php echo e(isset($cliente) ? $cliente->rua_cobranca : old('rua_cobranca')); ?>">
															<?php if($errors->has('rua_cobranca')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('rua_cobranca')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-2 col-lg-2">
														<label class="col-form-label">Número</label>
														<div class="">
															<input id="numero_cobranca" type="text" class="form-control <?php if($errors->has('numero_cobranca')): ?> is-invalid <?php endif; ?>" name="numero_cobranca" value="<?php echo e(isset($cliente) ? $cliente->numero_cobranca : old('numero_cobranca')); ?>">
															<?php if($errors->has('numero_cobranca')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('numero_cobranca')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

												</div>
												<div class="row">
													<div class="form-group validated col-sm-8 col-lg-5">
														<label class="col-form-label">Bairro</label>
														<div class="">
															<input id="bairro_cobranca" type="text" class="form-control <?php if($errors->has('bairro_cobranca')): ?> is-invalid <?php endif; ?>" name="bairro_cobranca" value="<?php echo e(isset($cliente) ? $cliente->bairro_cobranca : old('bairro_cobranca')); ?>">
															<?php if($errors->has('bairro_cobranca')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('bairro_cobranca')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-8 col-lg-3">
														<label class="col-form-label">CEP</label>
														<div class="">
															<input id="cep_cobranca" type="text" class="form-control <?php if($errors->has('cep_cobranca')): ?> is-invalid <?php endif; ?>" name="cep_cobranca" value="<?php echo e(isset($cliente) ? $cliente->cep_cobranca : old('cep_cobranca')); ?>">
															<?php if($errors->has('cep_cobranca')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('cep_cobranca')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>
												</div>

												<div class="row">
													<div class="form-group validated col-lg-6 col-md-6 col-sm-10">
														<label class="col-form-label text-left col-lg-4 col-sm-12">Cidade</label>

														<select class="form-control select2" id="kt_select2_2" name="cidade_cobranca">
															<option value="-">--</option>
															<?php $__currentLoopData = $cidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<option value="<?php echo e($c->id); ?>" <?php if(isset($cliente)): ?> <?php if($c->id == $cliente->cidade_cobranca_id): ?>selected
																<?php endif; ?>
																<?php endif; ?> >
																<?php echo e($c->nome); ?> (<?php echo e($c->uf); ?>)
															</option>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														</select>
														<?php if($errors->has('cidade_cobranca_id')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('cidade_cobranca_id')); ?>

														</div>
														<?php endif; ?>
													</div>
												</div>

											</div>

										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="modal-footer">
							<button type="button" class="btn btn-light-danger font-weight-bold" data-dismiss="modal">Fechar</button>
							<button type="button" id="salvar_novo_cliente" onclick="addNovoCliente()" class="btn btn-success">Salvar <span class="m-3"></span></button>
						</div>
					</div>
				</div>
			</div>
		</div>


		<script>
			var KTAppSettings = {
				"breakpoints": {
					"sm": 576,
					"md": 768,
					"lg": 992,
					"xl": 1200,
					"xxl": 1400
				},
				"colors": {
					"theme": {
						"base": {
							"white": "#ffffff",
							"primary": "#3699FF",
							"secondary": "#E5EAEE",
							"success": "#1BC5BD",
							"info": "#8950FC",
							"warning": "#FFA800",
							"danger": "#F64E60",
							"light": "#E4E6EF",
							"dark": "#181C32"
						},
						"light": {
							"white": "#ffffff",
							"primary": "#E1F0FF",
							"secondary": "#EBEDF3",
							"success": "#C9F7F5",
							"info": "#EEE5FF",
							"warning": "#FFF4DE",
							"danger": "#FFE2E5",
							"light": "#F3F6F9",
							"dark": "#D6D6E0"
						},
						"inverse": {
							"white": "#ffffff",
							"primary": "#ffffff",
							"secondary": "#3F4254",
							"success": "#ffffff",
							"info": "#ffffff",
							"warning": "#ffffff",
							"danger": "#ffffff",
							"light": "#464E5F",
							"dark": "#ffffff"
						}
					},
					"gray": {
						"gray-100": "#F3F6F9",
						"gray-200": "#EBEDF3",
						"gray-300": "#E4E6EF",
						"gray-400": "#D1D3E0",
						"gray-500": "#B5B5C3",
						"gray-600": "#7E8299",
						"gray-700": "#5E6278",
						"gray-800": "#3F4254",
						"gray-900": "#181C32"
					}
				},
				"font-family": "Poppins"
			};
		</script>

		<!-- end::Global Config -->
		<!--begin::Global Theme Bundle(used by all pages) -->
		<script src="/metronic/js/plugins.bundle.js" type="text/javascript"></script>
		<script src="/metronic/js/prismjs.bundle.js" type="text/javascript"></script>
		<script src="/metronic/js/scripts.bundle.js" type="text/javascript"></script>
		<script src="/metronic/js/wizard.js" type="text/javascript"></script>

		<script src="/metronic/js/fullcalendar.bundle.js" type="text/javascript"></script>
		<script type="text/javascript" src="/js/jquery.mask.min.js"></script>
		<script type="text/javascript" src="/js/mascaras.js"></script>
		<script src="/metronic/js/select2.js" type="text/javascript"></script>
		<!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/limonte-sweetalert2/7.2.0/sweetalert2.all.min.js"></script> -->
		<script src="/js/sweetalert.min.js"></script>

		<script type="text/javascript">
			function audioSuccess(){
				console.clear()
				<?php if($alerta_sonoro != ""): ?>
				var audio = new Audio('audio/<?php echo e($alerta_sonoro); ?>');
				audio.addEventListener('canplaythrough', function() {
					audio.play();
				});
				<?php endif; ?>
			}
		</script>

		<?php $path = getenv('PATH_URL') . "/"; ?>
		<script type="text/javascript">
			var casas_decimais = 2;
			var casas_decimais_qtd = 2;
			casas_decimais = <?php echo e($casasDecimais); ?>

			casas_decimais_qtd = <?php echo e($casasDecimaisQtd); ?>

			let prot = window.location.protocol;
			let host = window.location.host;
			const path = prot + "//" + host + "/";

			const is_troca = <?php if(isset($is_troca)): ?> true <?php else: ?> false <?php endif; ?>;
			const is_preVenda = <?php if(isset($preVenda)): ?> true <?php else: ?> false <?php endif; ?>;
		</script>

		<script type="text/javascript" src="/js/mousetrap.js"></script>

		<script>

			jQuery(document).ready(function() {
				KTSelect2.init();
				$('.select2-selection__arrow').addClass('select2-selection__arroww')

				$('.select2-selection__arrow').removeClass('select2-selection__arrow')
				var KTBootstrapDatepicker = function() {

					var arrows;
					if (KTUtil.isRTL()) {
						arrows = {
							leftArrow: '<i class="la la-angle-right"></i>',
							rightArrow: '<i class="la la-angle-left"></i>'
						}
					} else {
						arrows = {
							leftArrow: '<i class="la la-angle-left"></i>',
							rightArrow: '<i class="la la-angle-right"></i>'
						}
					}

					// Private functions
					var demos = function() {

						// minimum setup
						$('#kt_datepicker_1').datepicker({
							rtl: KTUtil.isRTL(),
							todayHighlight: true,
							orientation: "bottom left",
							templates: arrows
						});

						// minimum setup for modal demo
						$('#kt_datepicker_1_modal').datepicker({
							rtl: KTUtil.isRTL(),
							todayHighlight: true,
							orientation: "bottom left",
							templates: arrows
						});

						// input group layout
						$('#kt_datepicker_2').datepicker({
							rtl: KTUtil.isRTL(),
							todayHighlight: true,
							orientation: "bottom left",
							templates: arrows
						});

						// input group layout for modal demo
						$('#kt_datepicker_2_modal').datepicker({
							rtl: KTUtil.isRTL(),
							todayHighlight: true,

							orientation: "bottom left",
							templates: arrows
						});

						// enable clear button
						$('#kt_datepicker_3, #kt_datepicker_3_validate').datepicker({
							rtl: KTUtil.isRTL(),
							todayBtn: "linked",
							clearBtn: false,
							format: 'dd/mm/yyyy',
							todayHighlight: false,
							templates: arrows
						});

						// enable clear button for modal demo
						$('#kt_datepicker_3_modal').datepicker({
							rtl: KTUtil.isRTL(),
							todayBtn: "linked",
							clearBtn: false,
							format: 'dd/mm/yyyy',
							todayHighlight: false,
							templates: arrows
						});

						// orientation
						$('#kt_datepicker_4_1').datepicker({
							rtl: KTUtil.isRTL(),
							orientation: "top left",
							todayHighlight: true,
							templates: arrows
						});

						$('#kt_datepicker_4_2').datepicker({
							rtl: KTUtil.isRTL(),
							orientation: "top right",
							todayHighlight: true,
							templates: arrows
						});

						$('#kt_datepicker_4_3').datepicker({
							rtl: KTUtil.isRTL(),
							orientation: "bottom left",
							todayHighlight: true,
							templates: arrows
						});


					}

					return {

						init: function() {
							demos();
						}
					};
				}();

				KTBootstrapDatepicker.init({
					format: 'dd/mm/yyyy'
				});

			});

			setInterval(() => {
				let hora = formatar(new Date())
				$('#timer').html(hora)
			}, 1000)

			const formatar = (data) => {
				const hora = data.getHours() < 10 ? '0'+data.getHours() : data.getHours();
				const min = data.getMinutes() < 10 ? '0'+data.getMinutes() : data.getMinutes();
				const seg = data.getSeconds() < 10 ? '0'+data.getSeconds() : data.getSeconds();

				return `${hora}:${min}:${seg}`;
			};

		</script>

		
		<script src="/js/pessoaFisicaOuJuridica.js" type="text/javascript"></script>
		<script src="/js/alert.js" type="text/javascript"></script>
		<script type="text/javascript" src="/js/frenteCaixa2.js"></script>
		
	</body>


	</html>
<?php /**PATH /home2/impa8969/sistema.enixsoft.online/resources/views/frontBox/main3.blade.php ENDPATH**/ ?>