<?php $__env->startSection('content'); ?>
<div class="card card-custom gutter-b">
	<div class="card-body">
		<div class="" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">
			<input type="hidden" id="_token" value="<?php echo e(csrf_token()); ?>">

			<a href="/alertas/create" class="btn btn-success">
				<i class="la la-plus"></i>
				Novo Alerta
			</a>

			<h4 class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight mt-2">
				Alertas para empresas
			</h4>

			<div class="col-xl-12 <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">

				<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

					<table class="datatable-table" style="max-width: 100%; overflow: scroll">
						<thead class="datatable-head">
							<tr class="datatable-row" style="left: 0px;">
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 70px;">ID</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Titulo</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Status</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Prioridade</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">Data de Cadastro</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">Ações</span></th>
							</tr>
						</thead>

						<tbody class="datatable-body">
							<?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

							<tr class="datatable-row">
								<td class="datatable-cell">
									<span class="codigo" style="width: 70px;">
										<?php echo e($item->id); ?>

									</span>
								</td>
								
								<td class="datatable-cell">
									<span class="codigo" style="width: 100px;">
										<?php echo e($item->titulo); ?>

									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 100px;">
										<?php if($item->status): ?>
										<span class="label label-xl label-inline label-light-success">Ativo</span>
										<?php else: ?>
										<span class="label label-xl label-inline label-light-danger">Desativado</span>
										<?php endif; ?>
									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 100px;">
										<?php echo e(strtoupper($item->prioridade)); ?>

									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 120px;">
										<?php echo e(\Carbon\Carbon::parse($item->created_at)->format('d/m/Y H:i')); ?>

									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 150px;">
										<form action="<?php echo e(route('alerta.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
											<?php echo method_field('delete'); ?>
											<?php echo csrf_field(); ?>
											<a href="/alertas/edit/<?php echo e($item->id); ?>" class="btn btn-sm btn-warning">
												<i class="la la-edit"></i>
											</a>
											<?php if(!$item->status): ?>

											<button class="btn btn-sm btn-danger btn-delete">
												<i class="la la-trash"></i>
											</button>

											<?php endif; ?>
											<?php if(sizeof($item->views) > 0): ?>
											<a href="/alertas/list/<?php echo e($item->id); ?>" class="btn btn-sm btn-info">
												<i class="la la-list"></i>
											</a>
											<?php endif; ?>
										</form>
										
									</span>
								</td>
							</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>	

<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/impa8969/sistema.enixsoft.online/resources/views/alertas/index.blade.php ENDPATH**/ ?>