<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Cidade;
use App\Models\CidadeDelivery;
use App\Models\Pais;
class CidadeSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
    	foreach($this->getCidades() as $c){
    		Cidade::create([
    			'id' => $c['id'],
    			'nome'=> $c['nome'],
    			'uf' => $c['uf'],
    			'codigo' => $c['codigo']
    		]);
    	}

        foreach($this->getPaises() as $p){
            Pais::create([
                'nome'=> $p['nome'],
                'codigo' => $p['codigo']
            ]);
        }

        CidadeDelivery::create([
            'nome' => 'Jaguariaíva',
            'cep' => '84200-000',
            'uf' => 'PR'
        ]);
    }

    private function getPaises(){
        return [
            ['codigo' => '0132', 'nome' => "Afeganistão"],   
            ['codigo' => '7560', 'nome' => "África do Sul"],     
            ['codigo' => '0175', 'nome' => "Albânia, República da"],     
            ['codigo' => '0230', 'nome' => "Alemanha"],
            ['codigo' => '0370', 'nome' => "Andorra Sim"],
            ['codigo' => '0400', 'nome' => "Angola"],
            ['codigo' => '0418', 'nome' => "Anguilla Sim"],
            ['codigo' => '0434', 'nome' => "Antigua e Barbuda Sim"],
            ['codigo' => '0477', 'nome' => "Antilhas Holandesas Sim"],
            ['codigo' => '0531', 'nome' => "Arábia Saudita"], 
            ['codigo' => '0590', 'nome' => "Argélia"],
            ['codigo' => '0639', 'nome' => "Argentina"],     
            ['codigo' => '0647', 'nome' => "Armênia, República da"],     
            ['codigo' => '0655', 'nome' => "Aruba"],     
            ['codigo' => '0698', 'nome' => "Austrália"],     
            ['codigo' => '0728', 'nome' => "Áustria"],   
            ['codigo' => '0736', 'nome' => "Azerbaijão, República do"],  
            ['codigo' => '0779', 'nome' => "Bahamas, Ilhas Sim"],
            ['codigo' => '0809', 'nome' => "Bahrein, Ilhas Sim"],
            ['codigo' => '0817', 'nome' => "Bangladesh"],    
            ['codigo' => '0833', 'nome' => "Barbados Sim"],
            ['codigo' => '0850', 'nome' => "Belarus"],   
            ['codigo' => '0876', 'nome' => "Bélgica"],   
            ['codigo' => '0884', 'nome' => "Belize Sim"],
            ['codigo' => '2291', 'nome' => "Benin"],     
            ['codigo' => '0906', 'nome' => "    Bermudas Sim"],
            ['codigo' => '0973', 'nome' => "Bolívia"],   
            ['codigo' => '0981', 'nome' => "Bósnia-Herzegovina"],    
            ['codigo' => '1015', 'nome' => "Botsuana"],  
            ['codigo' => '1058', 'nome' => "Brasil"],    
            ['codigo' => '1082', 'nome' => "Brunei"],    
            ['codigo' => '1112', 'nome' => "Bulgária, República da"],    
            ['codigo' => '0310', 'nome' => "Burkina Faso"],  
            ['codigo' => '1155', 'nome' => "Burundi"],   
            ['codigo' => '1198', 'nome' => "Butão"],     
            ['codigo' => '1279', 'nome' => "Cabo Verde, República de"],  
            ['codigo' => '1457', 'nome' => "Camarões"],  
            ['codigo' => '1414', 'nome' => "Camboja"],   
            ['codigo' => '1490', 'nome' => "Canadá"],    
            ['codigo' => '1504', 'nome' => "Canal, Ilhas do (Jersey e Guernsey) Sim"],
            ['codigo' => '1511', 'nome' => "Canárias, Ilhas"],   
            ['codigo' => '1546', 'nome' => "Catar"],     
            ['codigo' => '1376', 'nome' => "Cayman, Ilhas Sim"],
            ['codigo' => '1538', 'nome' => "Cazaquistão, República do"],     
            ['codigo' => '7889', 'nome' => "Chade"],     
            ['codigo' => '1589', 'nome' => "Chile"],     
            ['codigo' => '1600', 'nome' => "China, República Popular da"],   
            ['codigo' => '1635', 'nome' => "Chipre Sim"],
            ['codigo' => '5118', 'nome' => "Christmas, Ilha (Navidad)"],     
            ['codigo' => '7412', 'nome' => "Cingapura"],     
            ['codigo' => '1651', 'nome' => "Cocos (Keeling), Ilhas"],    
            ['codigo' => '1694', 'nome' => "Colômbia"],  
            ['codigo' => '1732', 'nome' => "Comores, Ilhas"],    
            ['codigo' => '8885', 'nome' => "Congo, República Democrática do"],   
            ['codigo' => '1775', 'nome' => "Congo, República do"],   
            ['codigo' => '1830', 'nome' => "Cook, Ilhas Sim"],
            ['codigo' => '1872', 'nome' => "Coréia, Rep. Pop. Democrática da"],  
            ['codigo' => '1902', 'nome' => "Coréia, República da"],  
            ['codigo' => '1937', 'nome' => "Costa do Marfim"],   
            ['codigo' => '1961', 'nome' => "Costa Rica  Sim"],
            ['codigo' => '1988', 'nome' => "Coveite"],   
            ['codigo' => '1953', 'nome' => "Croácia, República da"],     
            ['codigo' => '1996', 'nome' => "Cuba"],  
            ['codigo' => '2321', 'nome' => "Dinamarca"],     
            ['codigo' => '7838', 'nome' => "Djibuti Sim"],
            ['codigo' => '2356', 'nome' => "Dominica, Ilha Sim"],
            ['codigo' => '2402', 'nome' => "Egito"],     
            ['codigo' => '6874', 'nome' => "El Salvador"],   
            ['codigo' => '2445', 'nome' => "Emirados Árabes Unidos"],    
            ['codigo' => '2399', 'nome' => "Equador"],   
            ['codigo' => '2437', 'nome' => "Eritréia"],  
            ['codigo' => '6289', 'nome' => "Escócia"], 
            ['codigo' => '2470', 'nome' => "Eslovaca, República"],   
            ['codigo' => '2461', 'nome' => "Eslovênia, República da"],   
            ['codigo' => '2453', 'nome' => "Espanha"],   
            ['codigo' => '2496', 'nome' => "Estados Unidos"],    
            ['codigo' => '2518', 'nome' => "Estônia, República da"],     
            ['codigo' => '2534', 'nome' => "Etiópia"], 
            ['codigo' => '2550', 'nome' => "Falkland (Ilhas Malvinas)"],     
            ['codigo' => '2593', 'nome' => "Feroe, Ilhas"],  
            ['codigo' => '8702', 'nome' => "Fiji"],  
            ['codigo' => '2674', 'nome' => "Filipinas"],     
            ['codigo' => '2712', 'nome' => "Finlândia"],     
            ['codigo' => '1619', 'nome' => "Formosa (Taiwan)"],  
            ['codigo' => '2755', 'nome' => "França"],    
            ['codigo' => '2810', 'nome' => "Gabão"],     
            ['codigo' => '6289', 'nome' => "Gales, País de"],    
            ['codigo' => '2852', 'nome' => "Gâmbia"],    
            ['codigo' => '2895', 'nome' => "Gana"],  
            ['codigo' => '2917', 'nome' => "Geórgia, República da"],     
            ['codigo' => '2933', 'nome' => "Gibraltar Sim"],
            ['codigo' => '6289', 'nome' => "Grã-Bretanha"],  
            ['codigo' => '2976', 'nome' => "Granada Sim"],
            ['codigo' => '3018', 'nome' => "Grécia"],    
            ['codigo' => '3050', 'nome' => "Groenlândia"],   
            ['codigo' => '3093', 'nome' => "Guadalupe"],     
            ['codigo' => '3131', 'nome' => "Guam"],  
            ['codigo' => '3174', 'nome' => "Guatemala"],     
            ['codigo' => '3379', 'nome' => "Guiana"],    
            ['codigo' => '3255', 'nome' => "Guiana Francesa"],   
            ['codigo' => '3298', 'nome' => "Guiné"],     
            ['codigo' => '3344', 'nome' => "Guiné-Bissau"],  
            ['codigo' => '3310', 'nome' => "Guiné-Equatorial"],  
            ['codigo' => '3417', 'nome' => "Haiti"],     
            ['codigo' => '5738', 'nome' => "Holanda (Países Baixos)"], 
            ['codigo' => '3450', 'nome' => "Honduras"],  
            ['codigo' => '3514', 'nome' => "Hong Kong, Região Adm. Especial"], 
            ['codigo' => '3557', 'nome' => "Hungria, República da"],     
            ['codigo' => '3573', 'nome' => "Iêmen"],     
            ['codigo' => '3611', 'nome' => "Índia"],     
            ['codigo' => '3654', 'nome' => "Indonésia"],     
            ['codigo' => '6289', 'nome' => "Inglaterra"],    
            ['codigo' => '3727', 'nome' => "Irã, República Islâmica do"],    
            ['codigo' => '3697', 'nome' => "Iraque"],    
            ['codigo' => '3751', 'nome' => "Irlanda"],   
            ['codigo' => '6289', 'nome' => "Irlanda do Norte"],  
            ['codigo' => '3794', 'nome' => "Islândia"],  
            ['codigo' => '3832', 'nome' => "Israel"],    
            ['codigo' => '3867', 'nome' => "Itália"],    
            ['codigo' => '3883', 'nome' => "Iugoslávia, República Fed. da"],
            ['codigo' => '3913', 'nome' => "Jamaica"],   
            ['codigo' => '3999', 'nome' => "Japão"],     
            ['codigo' => '3964', 'nome' => "Johnston, Ilhas"], 
            ['codigo' => '4030', 'nome' => "Jordânia"],  
            ['codigo' => '4111', 'nome' => "Kiribati"],  
            ['codigo' => '4200', 'nome' => "Laos, Rep. Pop. Democrática do"],    
            ['codigo' => '4235', 'nome' => "Lebuan Sim"],
            ['codigo' => '4260', 'nome' => "Lesoto"],    
            ['codigo' => '4278', 'nome' => "Letônia, República da"],     
            ['codigo' => '4316', 'nome' => "Líbano"],    
            ['codigo' => '4340', 'nome' => "Libéria Sim"],
            ['codigo' => '4383', 'nome' => "Líbia"], 
            ['codigo' => '4405', 'nome' => "Liechtenstein Sim"],
            ['codigo' => '4421', 'nome' => "Lituânia, República da"],    
            ['codigo' => '4456', 'nome' => "Luxemburgo"],    
            ['codigo' => '4472', 'nome' => "Macau"],     
            ['codigo' => '4499', 'nome' => "Macedônia"],     
            ['codigo' => '4502', 'nome' => "Madagascar"],    
            ['codigo' => '4525', 'nome' => "Madeira, Ilha da Sim"],
            ['codigo' => '4553', 'nome' => "Malásia"], 
            ['codigo' => '4588', 'nome' => "Malavi"],    
            ['codigo' => '4618', 'nome' => "Maldivas"],  
            ['codigo' => '4642', 'nome' => "Máli"],  
            ['codigo' => '4677', 'nome' => "Malta Sim"],
            ['codigo' => '3595', 'nome' => "Man, Ilhas Sim"],
            ['codigo' => '4723', 'nome' => "Marianas do Norte"],     
            ['codigo' => '4740', 'nome' => "Marrocos"],  
            ['codigo' => '4766', 'nome' => "Marshall, Ilhas Sim"],
            ['codigo' => '4774', 'nome' => "Martinica"],     
            ['codigo' => '4855', 'nome' => "Maurício Sim"],
            ['codigo' => '4880', 'nome' => "Mauritânia"],    
            ['codigo' => '4936', 'nome' => "México"],    
            ['codigo' => '0930', 'nome' => "Mianmar (Birmânia)"],    
            ['codigo' => '4995', 'nome' => "Micronésia"],    
            ['codigo' => '4901', 'nome' => "Midway, Ilhas"],     
            ['codigo' => '5053', 'nome' => "Moçambique"],    
            ['codigo' => '4944', 'nome' => "Moldávia, República da"],    
            ['codigo' => '4952', 'nome' => "Mônaco Sim"],
            ['codigo' => '4979', 'nome' => "Mongólia"],  
            ['codigo' => '5010', 'nome' => "Montserrat, Ilhas Sim"],
            ['codigo' => '5070', 'nome' => "Namíbia"],   
            ['codigo' => '5088', 'nome' => "Nauru Sim"],
            ['codigo' => '5177', 'nome' => "Nepal"],     
            ['codigo' => '5215', 'nome' => "Nicarágua"],     
            ['codigo' => '5258', 'nome' => "Niger"],     
            ['codigo' => '5282', 'nome' => "Nigéria"],   
            ['codigo' => '5312', 'nome' => "Niue, Ilha Sim"],
            ['codigo' => '5355', 'nome' => "Norfolk, Ilha"],     
            ['codigo' => '5380', 'nome' => "Noruega"],   
            ['codigo' => '5428', 'nome' => "Nova Caledônia"],    
            ['codigo' => '5487', 'nome' => "Nova Zelândia"],     
            ['codigo' => '5568', 'nome' => "Omã"],   
            ['codigo' => '5738', 'nome' => "Países Baixos (Holanda)"],   
            ['codigo' => '5754', 'nome' => "Palau"],     
            ['codigo' => '5800', 'nome' => "Panamá Sim"],
            ['codigo' => '5452', 'nome' => "Papua Nova Guiné"],  
            ['codigo' => '5762', 'nome' => "Paquistão"],     
            ['codigo' => '5860', 'nome' => "Paraguai"],  
            ['codigo' => '5894', 'nome' => "Peru"],  
            ['codigo' => '5932', 'nome' => "Pitcairn, Ilha"],    
            ['codigo' => '5991', 'nome' => "Polinésia Francesa"],    
            ['codigo' => '6033', 'nome' => "Polônia, República da"],     
            ['codigo' => '6114', 'nome' => "Porto Rico"],    
            ['codigo' => '6076', 'nome' => "Portugal"],  
            ['codigo' => '6238', 'nome' => "Quênia"],    
            ['codigo' => '6254', 'nome' => "Quirguiz, República"],   
            ['codigo' => '6289', 'nome' => "Reino Unido"],   
            ['codigo' => '6408', 'nome' => "República Centro-Africana"],     
            ['codigo' => '6475', 'nome' => "República Dominicana"],  
            ['codigo' => '6602', 'nome' => "Reunião, Ilha"],     
            ['codigo' => '6700', 'nome' => "Romênia"],   
            ['codigo' => '6750', 'nome' => "Ruanda"],    
            ['codigo' => '6769', 'nome' => "Rússia"],    
            ['codigo' => '6858', 'nome' => "Saara Ocidental"],   
            ['codigo' => '6777', 'nome' => "Salomão, Ilhas"],    
            ['codigo' => '6904', 'nome' => "Samoa Sim"],
            ['codigo' => '6912', 'nome' => "Samoa Americana"],   
            ['codigo' => '6971', 'nome' => "San Marino Sim"],
            ['codigo' => '7102', 'nome' => "Santa Helena"],  
            ['codigo' => '7153', 'nome' => "Santa Lúcia Sim"],
            ['codigo' => '6955', 'nome' => "São Cristóvão e Neves Sim"],
            ['codigo' => '7005', 'nome' => "São Pedro e Miquelon"],  
            ['codigo' => '7200', 'nome' => "São Tomé e Príncipe, Ilhas"],    
            ['codigo' => '7056', 'nome' => "São Vicente e Granadinas Sim"],
            ['codigo' => '7285', 'nome' => "Senegal"],   
            ['codigo' => '7358', 'nome' => "Serra Leoa"],    
            ['codigo' => '7315', 'nome' => "Seychelles Sim"],
            ['codigo' => '7447', 'nome' => "Síria, República Árabe da"],     
            ['codigo' => '7480', 'nome' => "Somália"],   
            ['codigo' => '7501', 'nome' => "Sri Lanka"],     
            ['codigo' => '7544', 'nome' => "Suazilândia"],   
            ['codigo' => '7595', 'nome' => "Sudão"],     
            ['codigo' => '7641', 'nome' => "Suécia"],    
            ['codigo' => '7676', 'nome' => "Suíça"],     
            ['codigo' => '7706', 'nome' => "Suriname"],  
            ['codigo' => '7722', 'nome' => "Tadjiquistão"],  
            ['codigo' => '7765', 'nome' => "Tailândia"],     
            ['codigo' => '7803', 'nome' => "Tanzânia, República Unida da"],  
            ['codigo' => '7919', 'nome' => "Tcheca, República"],     
            ['codigo' => '7820', 'nome' => "Território Britânico Oc. Índico "], 
            ['codigo' => '7951', 'nome' => "Timor Leste"],     
            ['codigo' => '8001', 'nome' => "Togo"],  
            ['codigo' => '8109', 'nome' => "Tonga Sim"],
            ['codigo' => '8052', 'nome' => "Toquelau, Ilhas"],   
            ['codigo' => '8150', 'nome' => "Trinidad e Tobago"],     
            ['codigo' => '8206', 'nome' => "Tunísia"],   
            ['codigo' => '8230', 'nome' => "Turcas e Caicos, Ilhas Sim"],
            ['codigo' => '8249', 'nome' => "Turcomenistão, República do"],   
            ['codigo' => '8273', 'nome' => "Turquia"],   
            ['codigo' => '8281', 'nome' => "Tuvalu"],    
            ['codigo' => '8311', 'nome' => "Ucrânia"],   
            ['codigo' => '8338', 'nome' => "Uganda"],    
            ['codigo' => '8451', 'nome' => "Uruguai"],   
            ['codigo' => '8478', 'nome' => "Uzbequistão, República do"],     
            ['codigo' => '5517', 'nome' => "Vanuatu Sim"],
            ['codigo' => '8486', 'nome' => "Vaticano, Estado da Cidade do"],     
            ['codigo' => '8508', 'nome' => "Venezuela"],     
            ['codigo' => '8583', 'nome' => "Vietnã"],    
            ['codigo' => '8630', 'nome' => "Virgens, Ilhas (Britânicas) Sim"],
            ['codigo' => '8664', 'nome' => "Virgens, Ilhas (E.U.A.) Sim"],
            ['codigo' => '8737', 'nome' => "Wake, Ilha"],    
            ['codigo' => '8753', 'nome' => "Wallis e Futuna, Ilhas"],    
            ['codigo' => '8907', 'nome' => "Zâmbia"],    
            ['codigo' => '6653', 'nome' => "Zimbábue"],  
            ['codigo' => '8958', 'nome' => "Zona do Canal do Panamá"]   
        ];
    }

    private function getCidades(){
    	return [
    		['id' => 1, 'nome' => "Alta Floresta D'Oeste", 'uf' => "RO", 'codigo' => 1100015],
    		['id' => 2, 'nome' => "Ariquemes", 'uf' => "RO", 'codigo' => 1100023],
    		['id' => 3, 'nome' => "Cabixi", 'uf' => "RO", 'codigo' => 1100031],
    		['id' => 4, 'nome' => "Cacoal", 'uf' => "RO", 'codigo' => 1100049],
    		['id' => 5, 'nome' => "Cerejeiras", 'uf' => "RO", 'codigo' => 1100056],
    		['id' => 6, 'nome' => "Colorado do Oeste", 'uf' => "RO", 'codigo' => 1100064],
    		['id' => 7, 'nome' => "Corumbiara", 'uf' => "RO", 'codigo' => 1100072],
    		['id' => 8, 'nome' => "Costa Marques", 'uf' => "RO", 'codigo' => 1100080],
    		['id' => 9, 'nome' => "Espigão D'Oeste", 'uf' => "RO", 'codigo' => 1100098],
    		['id' => 10, 'nome' => "Guajará-Mirim", 'uf' => "RO", 'codigo' => 1100106],
    		['id' => 11, 'nome' => "Jaru", 'uf' => "RO", 'codigo' => 1100114],
    		['id' => 12, 'nome' => "Ji-Paraná", 'uf' => "RO", 'codigo' => 1100122],
    		['id' => 13, 'nome' => "Machadinho D'Oeste", 'uf' => "RO", 'codigo' => 1100130],
    		['id' => 14, 'nome' => "Nova Brasilândia D'Oeste", 'uf' => "RO", 'codigo' => 1100148],
    		['id' => 15, 'nome' => "Ouro Preto do Oeste", 'uf' => "RO", 'codigo' => 1100155],
    		['id' => 16, 'nome' => "Pimenta Bueno", 'uf' => "RO", 'codigo' => 1100189],
    		['id' => 17, 'nome' => "Porto Velho", 'uf' => "RO", 'codigo' => 1100205],
    		['id' => 18, 'nome' => "Presidente Médici", 'uf' => "RO", 'codigo' => 1100254],
    		['id' => 19, 'nome' => "Rio Crespo", 'uf' => "RO", 'codigo' => 1100262],
    		['id' => 20, 'nome' => "Rolim de Moura", 'uf' => "RO", 'codigo' => 1100288],
    		['id' => 21, 'nome' => "Santa Luzia D'Oeste", 'uf' => "RO", 'codigo' => 1100296],
    		['id' => 22, 'nome' => "Vilhena", 'uf' => "RO", 'codigo' => 1100304],
    		['id' => 23, 'nome' => "São Miguel do Guaporé", 'uf' => "RO", 'codigo' => 1100320],
    		['id' => 24, 'nome' => "Nova Mamoré", 'uf' => "RO", 'codigo' => 1100338],
    		['id' => 25, 'nome' => "Alvorada D'Oeste", 'uf' => "RO", 'codigo' => 1100346],
    		['id' => 26, 'nome' => "Alto Alegre dos Parecis", 'uf' => "RO", 'codigo' => 1100379],
    		['id' => 27, 'nome' => "Alto Paraíso", 'uf' => "RO", 'codigo' => 1100403],
    		['id' => 28, 'nome' => "Buritis", 'uf' => "RO", 'codigo' => 1100452],
    		['id' => 29, 'nome' => "Novo Horizonte do Oeste", 'uf' => "RO", 'codigo' => 1100502],
    		['id' => 30, 'nome' => "Cacaulândia", 'uf' => "RO", 'codigo' => 1100601],
    		['id' => 31, 'nome' => "Campo Novo de Rondônia", 'uf' => "RO", 'codigo' => 1100700],
    		['id' => 32, 'nome' => "Candeias do Jamari", 'uf' => "RO", 'codigo' => 1100809],
    		['id' => 33, 'nome' => "Castanheiras", 'uf' => "RO", 'codigo' => 1100908],
    		['id' => 34, 'nome' => "Chupinguaia", 'uf' => "RO", 'codigo' => 1100924],
    		['id' => 35, 'nome' => "Cujubim", 'uf' => "RO", 'codigo' => 1100940],
    		['id' => 36, 'nome' => "Governador Jorge Teixeira", 'uf' => "RO", 'codigo' => 1101005],
    		['id' => 37, 'nome' => "Itapuã do Oeste", 'uf' => "RO", 'codigo' => 1101104],
    		['id' => 38, 'nome' => "Ministro Andreazza", 'uf' => "RO", 'codigo' => 1101203],
    		['id' => 39, 'nome' => "Mirante da Serra", 'uf' => "RO", 'codigo' => 1101302],
    		['id' => 40, 'nome' => "Monte Negro", 'uf' => "RO", 'codigo' => 1101401],
    		['id' => 41, 'nome' => "Nova União", 'uf' => "RO", 'codigo' => 1101435],
    		['id' => 42, 'nome' => "Parecis", 'uf' => "RO", 'codigo' => 1101450],
    		['id' => 43, 'nome' => "Pimenteiras do Oeste", 'uf' => "RO", 'codigo' => 1101468],
    		['id' => 44, 'nome' => "Primavera de Rondônia", 'uf' => "RO", 'codigo' => 1101476],
    		['id' => 45, 'nome' => "São Felipe D'Oeste", 'uf' => "RO", 'codigo' => 1101484],
    		['id' => 46, 'nome' => "São Francisco do Guaporé", 'uf' => "RO", 'codigo' => 1101492],
    		['id' => 47, 'nome' => "Seringueiras", 'uf' => "RO", 'codigo' => 1101500],
    		['id' => 48, 'nome' => "Teixeirópolis", 'uf' => "RO", 'codigo' => 1101559],
    		['id' => 49, 'nome' => "Theobroma", 'uf' => "RO", 'codigo' => 1101609],
    		['id' => 50, 'nome' => "Urupá", 'uf' => "RO", 'codigo' => 1101708],
    		['id' => 51, 'nome' => "Vale do Anari", 'uf' => "RO", 'codigo' => 1101757],
    		['id' => 52, 'nome' => "Vale do Paraíso", 'uf' => "RO", 'codigo' => 1101807],
    		['id' => 53, 'nome' => "Acrelândia", 'uf' => "AC", 'codigo' => 1200013],
    		['id' => 54, 'nome' => "Assis Brasil", 'uf' => "AC", 'codigo' => 1200054],
    		['id' => 55, 'nome' => "Brasiléia", 'uf' => "AC", 'codigo' => 1200104],
    		['id' => 56, 'nome' => "Bujari", 'uf' => "AC", 'codigo' => 1200138],
    		['id' => 57, 'nome' => "Capixaba", 'uf' => "AC", 'codigo' => 1200179],
    		['id' => 58, 'nome' => "Cruzeiro do Sul", 'uf' => "AC", 'codigo' => 1200203],
    		['id' => 59, 'nome' => "Epitaciolândia", 'uf' => "AC", 'codigo' => 1200252],
    		['id' => 60, 'nome' => "Feijó", 'uf' => "AC", 'codigo' => 1200302],
    		['id' => 61, 'nome' => "Jordão", 'uf' => "AC", 'codigo' => 1200328],
    		['id' => 62, 'nome' => "Mâncio Lima", 'uf' => "AC", 'codigo' => 1200336],
    		['id' => 63, 'nome' => "Manoel Urbano", 'uf' => "AC", 'codigo' => 1200344],
    		['id' => 64, 'nome' => "Marechal Thaumaturgo", 'uf' => "AC", 'codigo' => 1200351],
    		['id' => 65, 'nome' => "Plácido de Castro", 'uf' => "AC", 'codigo' => 1200385],
    		['id' => 66, 'nome' => "Porto Walter", 'uf' => "AC", 'codigo' => 1200393],
    		['id' => 67, 'nome' => "Rio Branco", 'uf' => "AC", 'codigo' => 1200401],
    		['id' => 68, 'nome' => "Rodrigues Alves", 'uf' => "AC", 'codigo' => 1200427],
    		['id' => 69, 'nome' => "Santa Rosa do Purus", 'uf' => "AC", 'codigo' => 1200435],
    		['id' => 70, 'nome' => "Senador Guiomard", 'uf' => "AC", 'codigo' => 1200450],
    		['id' => 71, 'nome' => "Sena Madureira", 'uf' => "AC", 'codigo' => 1200500],
    		['id' => 72, 'nome' => "Tarauacá", 'uf' => "AC", 'codigo' => 1200609],
    		['id' => 73, 'nome' => "Xapuri", 'uf' => "AC", 'codigo' => 1200708],
    		['id' => 74, 'nome' => "Porto Acre", 'uf' => "AC", 'codigo' => 1200807],
    		['id' => 75, 'nome' => "Alvarães", 'uf' => "AM", 'codigo' => 1300029],
    		['id' => 76, 'nome' => "Amaturá", 'uf' => "AM", 'codigo' => 1300060],
    		['id' => 77, 'nome' => "Anamã", 'uf' => "AM", 'codigo' => 1300086],
    		['id' => 78, 'nome' => "Anori", 'uf' => "AM", 'codigo' => 1300102],
    		['id' => 79, 'nome' => "Apuí", 'uf' => "AM", 'codigo' => 1300144],
    		['id' => 80, 'nome' => "Atalaia do Norte", 'uf' => "AM", 'codigo' => 1300201],
    		['id' => 81, 'nome' => "Autazes", 'uf' => "AM", 'codigo' => 1300300],
    		['id' => 82, 'nome' => "Barcelos", 'uf' => "AM", 'codigo' => 1300409],
    		['id' => 83, 'nome' => "Barreirinha", 'uf' => "AM", 'codigo' => 1300508],
    		['id' => 84, 'nome' => "Benjamin Constant", 'uf' => "AM", 'codigo' => 1300607],
    		['id' => 85, 'nome' => "Beruri", 'uf' => "AM", 'codigo' => 1300631],
    		['id' => 86, 'nome' => "Boa Vista do Ramos", 'uf' => "AM", 'codigo' => 1300680],
    		['id' => 87, 'nome' => "Boca do Acre", 'uf' => "AM", 'codigo' => 1300706],
    		['id' => 88, 'nome' => "Borba", 'uf' => "AM", 'codigo' => 1300805],
    		['id' => 89, 'nome' => "Caapiranga", 'uf' => "AM", 'codigo' => 1300839],
    		['id' => 90, 'nome' => "Canutama", 'uf' => "AM", 'codigo' => 1300904],
    		['id' => 91, 'nome' => "Carauari", 'uf' => "AM", 'codigo' => 1301001],
    		['id' => 92, 'nome' => "Careiro", 'uf' => "AM", 'codigo' => 1301100],
    		['id' => 93, 'nome' => "Careiro da Várzea", 'uf' => "AM", 'codigo' => 1301159],
    		['id' => 94, 'nome' => "Coari", 'uf' => "AM", 'codigo' => 1301209],
    		['id' => 95, 'nome' => "Codajás", 'uf' => "AM", 'codigo' => 1301308],
    		['id' => 96, 'nome' => "Eirunepé", 'uf' => "AM", 'codigo' => 1301407],
    		['id' => 97, 'nome' => "Envira", 'uf' => "AM", 'codigo' => 1301506],
    		['id' => 98, 'nome' => "Fonte Boa", 'uf' => "AM", 'codigo' => 1301605],
    		['id' => 99, 'nome' => "Guajará", 'uf' => "AM", 'codigo' => 1301654],
    		['id' => 100, 'nome' => "Humaitá", 'uf' => "AM", 'codigo' => 1301704],
    		['id' => 101, 'nome' => "Ipixuna", 'uf' => "AM", 'codigo' => 1301803],
    		['id' => 102, 'nome' => "Iranduba", 'uf' => "AM", 'codigo' => 1301852],
    		['id' => 103, 'nome' => "Itacoatiara", 'uf' => "AM", 'codigo' => 1301902],
    		['id' => 104, 'nome' => "Itamarati", 'uf' => "AM", 'codigo' => 1301951],
    		['id' => 105, 'nome' => "Itapiranga", 'uf' => "AM", 'codigo' => 1302009],
    		['id' => 106, 'nome' => "Japurá", 'uf' => "AM", 'codigo' => 1302108],
    		['id' => 107, 'nome' => "Juruá", 'uf' => "AM", 'codigo' => 1302207],
    		['id' => 108, 'nome' => "Jutaí", 'uf' => "AM", 'codigo' => 1302306],
    		['id' => 109, 'nome' => "Lábrea", 'uf' => "AM", 'codigo' => 1302405],
    		['id' => 110, 'nome' => "Manacapuru", 'uf' => "AM", 'codigo' => 1302504],
    		['id' => 111, 'nome' => "Manaquiri", 'uf' => "AM", 'codigo' => 1302553],
    		['id' => 112, 'nome' => "Manaus", 'uf' => "AM", 'codigo' => 1302603],
    		['id' => 113, 'nome' => "Manicoré", 'uf' => "AM", 'codigo' => 1302702],
    		['id' => 114, 'nome' => "Maraã", 'uf' => "AM", 'codigo' => 1302801],
    		['id' => 115, 'nome' => "Maués", 'uf' => "AM", 'codigo' => 1302900],
    		['id' => 116, 'nome' => "Nhamundá", 'uf' => "AM", 'codigo' => 1303007],
    		['id' => 117, 'nome' => "Nova Olinda do Norte", 'uf' => "AM", 'codigo' => 1303106],
    		['id' => 118, 'nome' => "Novo Airão", 'uf' => "AM", 'codigo' => 1303205],
    		['id' => 119, 'nome' => "Novo Aripuanã", 'uf' => "AM", 'codigo' => 1303304],
    		['id' => 120, 'nome' => "Parintins", 'uf' => "AM", 'codigo' => 1303403],
    		['id' => 121, 'nome' => "Pauini", 'uf' => "AM", 'codigo' => 1303502],
    		['id' => 122, 'nome' => "Presidente Figueiredo", 'uf' => "AM", 'codigo' => 1303536],
    		['id' => 123, 'nome' => "Rio Preto da Eva", 'uf' => "AM", 'codigo' => 1303569],
    		['id' => 124, 'nome' => "Santa Isabel do Rio Negro", 'uf' => "AM", 'codigo' => 1303601],
    		['id' => 125, 'nome' => "Santo Antônio do Içá", 'uf' => "AM", 'codigo' => 1303700],
    		['id' => 126, 'nome' => "São Gabriel da Cachoeira", 'uf' => "AM", 'codigo' => 1303809],
    		['id' => 127, 'nome' => "São Paulo de Olivença", 'uf' => "AM", 'codigo' => 1303908],
    		['id' => 128, 'nome' => "São Sebastião do Uatumã", 'uf' => "AM", 'codigo' => 1303957],
    		['id' => 129, 'nome' => "Silves", 'uf' => "AM", 'codigo' => 1304005],
    		['id' => 130, 'nome' => "Tabatinga", 'uf' => "AM", 'codigo' => 1304062],
    		['id' => 131, 'nome' => "Tapauá", 'uf' => "AM", 'codigo' => 1304104],
    		['id' => 132, 'nome' => "Tefé", 'uf' => "AM", 'codigo' => 1304203],
    		['id' => 133, 'nome' => "Tonantins", 'uf' => "AM", 'codigo' => 1304237],
    		['id' => 134, 'nome' => "Uarini", 'uf' => "AM", 'codigo' => 1304260],
    		['id' => 135, 'nome' => "Urucará", 'uf' => "AM", 'codigo' => 1304302],
    		['id' => 136, 'nome' => "Urucurituba", 'uf' => "AM", 'codigo' => 1304401],
    		['id' => 137, 'nome' => "Amajari", 'uf' => "RR", 'codigo' => 1400027],
    		['id' => 138, 'nome' => "Alto Alegre", 'uf' => "RR", 'codigo' => 1400050],
    		['id' => 139, 'nome' => "Boa Vista", 'uf' => "RR", 'codigo' => 1400100],
    		['id' => 140, 'nome' => "Bonfim", 'uf' => "RR", 'codigo' => 1400159],
    		['id' => 141, 'nome' => "Cantá", 'uf' => "RR", 'codigo' => 1400175],
    		['id' => 142, 'nome' => "Caracaraí", 'uf' => "RR", 'codigo' => 1400209],
    		['id' => 143, 'nome' => "Caroebe", 'uf' => "RR", 'codigo' => 1400233],
    		['id' => 144, 'nome' => "Iracema", 'uf' => "RR", 'codigo' => 1400282],
    		['id' => 145, 'nome' => "Mucajaí", 'uf' => "RR", 'codigo' => 1400308],
    		['id' => 146, 'nome' => "Normandia", 'uf' => "RR", 'codigo' => 1400407],
    		['id' => 147, 'nome' => "Pacaraima", 'uf' => "RR", 'codigo' => 1400456],
    		['id' => 148, 'nome' => "Rorainópolis", 'uf' => "RR", 'codigo' => 1400472],
    		['id' => 149, 'nome' => "São João da Baliza", 'uf' => "RR", 'codigo' => 1400506],
    		['id' => 150, 'nome' => "São Luiz", 'uf' => "RR", 'codigo' => 1400605],
    		['id' => 151, 'nome' => "Uiramutã", 'uf' => "RR", 'codigo' => 1400704],
    		['id' => 152, 'nome' => "Abaetetuba", 'uf' => "PA", 'codigo' => 1500107],
    		['id' => 153, 'nome' => "Abel Figueiredo", 'uf' => "PA", 'codigo' => 1500131],
    		['id' => 154, 'nome' => "Acará", 'uf' => "PA", 'codigo' => 1500206],
    		['id' => 155, 'nome' => "Afuá", 'uf' => "PA", 'codigo' => 1500305],
    		['id' => 156, 'nome' => "Água Azul do Norte", 'uf' => "PA", 'codigo' => 1500347],
    		['id' => 157, 'nome' => "Alenquer", 'uf' => "PA", 'codigo' => 1500404],
    		['id' => 158, 'nome' => "Almeirim", 'uf' => "PA", 'codigo' => 1500503],
    		['id' => 159, 'nome' => "Altamira", 'uf' => "PA", 'codigo' => 1500602],
    		['id' => 160, 'nome' => "Anajás", 'uf' => "PA", 'codigo' => 1500701],
    		['id' => 161, 'nome' => "Ananindeua", 'uf' => "PA", 'codigo' => 1500800],
    		['id' => 162, 'nome' => "Anapu", 'uf' => "PA", 'codigo' => 1500859],
    		['id' => 163, 'nome' => "Augusto Corrêa", 'uf' => "PA", 'codigo' => 1500909],
    		['id' => 164, 'nome' => "Aurora do Pará", 'uf' => "PA", 'codigo' => 1500958],
    		['id' => 165, 'nome' => "Aveiro", 'uf' => "PA", 'codigo' => 1501006],
    		['id' => 166, 'nome' => "Bagre", 'uf' => "PA", 'codigo' => 1501105],
    		['id' => 167, 'nome' => "Baião", 'uf' => "PA", 'codigo' => 1501204],
    		['id' => 168, 'nome' => "Bannach", 'uf' => "PA", 'codigo' => 1501253],
    		['id' => 169, 'nome' => "Barcarena", 'uf' => "PA", 'codigo' => 1501303],
    		['id' => 170, 'nome' => "Belém", 'uf' => "PA", 'codigo' => 1501402],
    		['id' => 171, 'nome' => "Belterra", 'uf' => "PA", 'codigo' => 1501451],
    		['id' => 172, 'nome' => "Benevides", 'uf' => "PA", 'codigo' => 1501501],
    		['id' => 173, 'nome' => "Bom Jesus do Tocantins", 'uf' => "PA", 'codigo' => 1501576],
    		['id' => 174, 'nome' => "Bonito", 'uf' => "PA", 'codigo' => 1501600],
    		['id' => 175, 'nome' => "Bragança", 'uf' => "PA", 'codigo' => 1501709],
    		['id' => 176, 'nome' => "Brasil Novo", 'uf' => "PA", 'codigo' => 1501725],
    		['id' => 177, 'nome' => "Brejo Grande do Araguaia", 'uf' => "PA", 'codigo' => 1501758],
    		['id' => 178, 'nome' => "Breu Branco", 'uf' => "PA", 'codigo' => 1501782],
    		['id' => 179, 'nome' => "Breves", 'uf' => "PA", 'codigo' => 1501808],
    		['id' => 180, 'nome' => "Bujaru", 'uf' => "PA", 'codigo' => 1501907],
    		['id' => 181, 'nome' => "Cachoeira do Piriá", 'uf' => "PA", 'codigo' => 1501956],
    		['id' => 182, 'nome' => "Cachoeira do Arari", 'uf' => "PA", 'codigo' => 1502004],
    		['id' => 183, 'nome' => "Cametá", 'uf' => "PA", 'codigo' => 1502103],
    		['id' => 184, 'nome' => "Canaã dos Carajás", 'uf' => "PA", 'codigo' => 1502152],
    		['id' => 185, 'nome' => "Capanema", 'uf' => "PA", 'codigo' => 1502202],
    		['id' => 186, 'nome' => "Capitão Poço", 'uf' => "PA", 'codigo' => 1502301],
    		['id' => 187, 'nome' => "Castanhal", 'uf' => "PA", 'codigo' => 1502400],
    		['id' => 188, 'nome' => "Chaves", 'uf' => "PA", 'codigo' => 1502509],
    		['id' => 189, 'nome' => "Colares", 'uf' => "PA", 'codigo' => 1502608],
    		['id' => 190, 'nome' => "Conceição do Araguaia", 'uf' => "PA", 'codigo' => 1502707],
    		['id' => 191, 'nome' => "Concórdia do Pará", 'uf' => "PA", 'codigo' => 1502756],
    		['id' => 192, 'nome' => "Cumaru do Norte", 'uf' => "PA", 'codigo' => 1502764],
    		['id' => 193, 'nome' => "Curionópolis", 'uf' => "PA", 'codigo' => 1502772],
    		['id' => 194, 'nome' => "Curralinho", 'uf' => "PA", 'codigo' => 1502806],
    		['id' => 195, 'nome' => "Curuá", 'uf' => "PA", 'codigo' => 1502855],
    		['id' => 196, 'nome' => "Curuçá", 'uf' => "PA", 'codigo' => 1502905],
    		['id' => 197, 'nome' => "Dom Eliseu", 'uf' => "PA", 'codigo' => 1502939],
    		['id' => 198, 'nome' => "Eldorado dos Carajás", 'uf' => "PA", 'codigo' => 1502954],
    		['id' => 199, 'nome' => "Faro", 'uf' => "PA", 'codigo' => 1503002],
    		['id' => 200, 'nome' => "Floresta do Araguaia", 'uf' => "PA", 'codigo' => 1503044],
    		['id' => 201, 'nome' => "Garrafão do Norte", 'uf' => "PA", 'codigo' => 1503077],
    		['id' => 202, 'nome' => "Goianésia do Pará", 'uf' => "PA", 'codigo' => 1503093],
    		['id' => 203, 'nome' => "Gurupá", 'uf' => "PA", 'codigo' => 1503101],
    		['id' => 204, 'nome' => "Igarapé-Açu", 'uf' => "PA", 'codigo' => 1503200],
    		['id' => 205, 'nome' => "Igarapé-Miri", 'uf' => "PA", 'codigo' => 1503309],
    		['id' => 206, 'nome' => "Inhangapi", 'uf' => "PA", 'codigo' => 1503408],
    		['id' => 207, 'nome' => "Ipixuna do Pará", 'uf' => "PA", 'codigo' => 1503457],
    		['id' => 208, 'nome' => "Irituia", 'uf' => "PA", 'codigo' => 1503507],
    		['id' => 209, 'nome' => "Itaituba", 'uf' => "PA", 'codigo' => 1503606],
    		['id' => 210, 'nome' => "Itupiranga", 'uf' => "PA", 'codigo' => 1503705],
    		['id' => 211, 'nome' => "Jacareacanga", 'uf' => "PA", 'codigo' => 1503754],
    		['id' => 212, 'nome' => "Jacundá", 'uf' => "PA", 'codigo' => 1503804],
    		['id' => 213, 'nome' => "Juruti", 'uf' => "PA", 'codigo' => 1503903],
    		['id' => 214, 'nome' => "Limoeiro do Ajuru", 'uf' => "PA", 'codigo' => 1504000],
    		['id' => 215, 'nome' => "Mãe do Rio", 'uf' => "PA", 'codigo' => 1504059],
    		['id' => 216, 'nome' => "Magalhães Barata", 'uf' => "PA", 'codigo' => 1504109],
    		['id' => 217, 'nome' => "Marabá", 'uf' => "PA", 'codigo' => 1504208],
    		['id' => 218, 'nome' => "Maracanã", 'uf' => "PA", 'codigo' => 1504307],
    		['id' => 219, 'nome' => "Marapanim", 'uf' => "PA", 'codigo' => 1504406],
    		['id' => 220, 'nome' => "Marituba", 'uf' => "PA", 'codigo' => 1504422],
    		['id' => 221, 'nome' => "Medicilândia", 'uf' => "PA", 'codigo' => 1504455],
    		['id' => 222, 'nome' => "Melgaço", 'uf' => "PA", 'codigo' => 1504505],
    		['id' => 223, 'nome' => "Mocajuba", 'uf' => "PA", 'codigo' => 1504604],
    		['id' => 224, 'nome' => "Moju", 'uf' => "PA", 'codigo' => 1504703],
    		['id' => 225, 'nome' => "Mojuí dos Campos", 'uf' => "PA", 'codigo' => 1504752],
    		['id' => 226, 'nome' => "Monte Alegre", 'uf' => "PA", 'codigo' => 1504802],
    		['id' => 227, 'nome' => "Muaná", 'uf' => "PA", 'codigo' => 1504901],
    		['id' => 228, 'nome' => "Nova Esperança do Piriá", 'uf' => "PA", 'codigo' => 1504950],
    		['id' => 229, 'nome' => "Nova Ipixuna", 'uf' => "PA", 'codigo' => 1504976],
    		['id' => 230, 'nome' => "Nova Timboteua", 'uf' => "PA", 'codigo' => 1505007],
    		['id' => 231, 'nome' => "Novo Progresso", 'uf' => "PA", 'codigo' => 1505031],
    		['id' => 232, 'nome' => "Novo Repartimento", 'uf' => "PA", 'codigo' => 1505064],
    		['id' => 233, 'nome' => "Óbidos", 'uf' => "PA", 'codigo' => 1505106],
    		['id' => 234, 'nome' => "Oeiras do Pará", 'uf' => "PA", 'codigo' => 1505205],
    		['id' => 235, 'nome' => "Oriximiná", 'uf' => "PA", 'codigo' => 1505304],
    		['id' => 236, 'nome' => "Ourém", 'uf' => "PA", 'codigo' => 1505403],
    		['id' => 237, 'nome' => "Ourilândia do Norte", 'uf' => "PA", 'codigo' => 1505437],
    		['id' => 238, 'nome' => "Pacajá", 'uf' => "PA", 'codigo' => 1505486],
    		['id' => 239, 'nome' => "Palestina do Pará", 'uf' => "PA", 'codigo' => 1505494],
    		['id' => 240, 'nome' => "Paragominas", 'uf' => "PA", 'codigo' => 1505502],
    		['id' => 241, 'nome' => "Parauapebas", 'uf' => "PA", 'codigo' => 1505536],
    		['id' => 242, 'nome' => "Pau D'Arco", 'uf' => "PA", 'codigo' => 1505551],
    		['id' => 243, 'nome' => "Peixe-Boi", 'uf' => "PA", 'codigo' => 1505601],
    		['id' => 244, 'nome' => "Piçarra", 'uf' => "PA", 'codigo' => 1505635],
    		['id' => 245, 'nome' => "Placas", 'uf' => "PA", 'codigo' => 1505650],
    		['id' => 246, 'nome' => "Ponta de Pedras", 'uf' => "PA", 'codigo' => 1505700],
    		['id' => 247, 'nome' => "Portel", 'uf' => "PA", 'codigo' => 1505809],
    		['id' => 248, 'nome' => "Porto de Moz", 'uf' => "PA", 'codigo' => 1505908],
    		['id' => 249, 'nome' => "Prainha", 'uf' => "PA", 'codigo' => 1506005],
    		['id' => 250, 'nome' => "Primavera", 'uf' => "PA", 'codigo' => 1506104],
    		['id' => 251, 'nome' => "Quatipuru", 'uf' => "PA", 'codigo' => 1506112],
    		['id' => 252, 'nome' => "Redenção", 'uf' => "PA", 'codigo' => 1506138],
    		['id' => 253, 'nome' => "Rio Maria", 'uf' => "PA", 'codigo' => 1506161],
    		['id' => 254, 'nome' => "Rondon do Pará", 'uf' => "PA", 'codigo' => 1506187],
    		['id' => 255, 'nome' => "Rurópolis", 'uf' => "PA", 'codigo' => 1506195],
    		['id' => 256, 'nome' => "Salinópolis", 'uf' => "PA", 'codigo' => 1506203],
    		['id' => 257, 'nome' => "Salvaterra", 'uf' => "PA", 'codigo' => 1506302],
    		['id' => 258, 'nome' => "Santa Bárbara do Pará", 'uf' => "PA", 'codigo' => 1506351],
    		['id' => 259, 'nome' => "Santa Cruz do Arari", 'uf' => "PA", 'codigo' => 1506401],
    		['id' => 260, 'nome' => "Santa Isabel do Pará", 'uf' => "PA", 'codigo' => 1506500],
    		['id' => 261, 'nome' => "Santa Luzia do Pará", 'uf' => "PA", 'codigo' => 1506559],
    		['id' => 262, 'nome' => "Santa Maria das Barreiras", 'uf' => "PA", 'codigo' => 1506583],
    		['id' => 263, 'nome' => "Santa Maria do Pará", 'uf' => "PA", 'codigo' => 1506609],
    		['id' => 264, 'nome' => "Santana do Araguaia", 'uf' => "PA", 'codigo' => 1506708],
    		['id' => 265, 'nome' => "Santarém", 'uf' => "PA", 'codigo' => 1506807],
    		['id' => 266, 'nome' => "Santarém Novo", 'uf' => "PA", 'codigo' => 1506906],
    		['id' => 267, 'nome' => "Santo Antônio do Tauá", 'uf' => "PA", 'codigo' => 1507003],
    		['id' => 268, 'nome' => "São Caetano de Odivelas", 'uf' => "PA", 'codigo' => 1507102],
    		['id' => 269, 'nome' => "São Domingos do Araguaia", 'uf' => "PA", 'codigo' => 1507151],
    		['id' => 270, 'nome' => "São Domingos do Capim", 'uf' => "PA", 'codigo' => 1507201],
    		['id' => 271, 'nome' => "São Félix do Xingu", 'uf' => "PA", 'codigo' => 1507300],
    		['id' => 272, 'nome' => "São Francisco do Pará", 'uf' => "PA", 'codigo' => 1507409],
    		['id' => 273, 'nome' => "São Geraldo do Araguaia", 'uf' => "PA", 'codigo' => 1507458],
    		['id' => 274, 'nome' => "São João da Ponta", 'uf' => "PA", 'codigo' => 1507466],
    		['id' => 275, 'nome' => "São João de Pirabas", 'uf' => "PA", 'codigo' => 1507474],
    		['id' => 276, 'nome' => "São João do Araguaia", 'uf' => "PA", 'codigo' => 1507508],
    		['id' => 277, 'nome' => "São Miguel do Guamá", 'uf' => "PA", 'codigo' => 1507607],
    		['id' => 278, 'nome' => "São Sebastião da Boa Vista", 'uf' => "PA", 'codigo' => 1507706],
    		['id' => 279, 'nome' => "Sapucaia", 'uf' => "PA", 'codigo' => 1507755],
    		['id' => 280, 'nome' => "Senador José Porfírio", 'uf' => "PA", 'codigo' => 1507805],
    		['id' => 281, 'nome' => "Soure", 'uf' => "PA", 'codigo' => 1507904],
    		['id' => 282, 'nome' => "Tailândia", 'uf' => "PA", 'codigo' => 1507953],
    		['id' => 283, 'nome' => "Terra Alta", 'uf' => "PA", 'codigo' => 1507961],
    		['id' => 284, 'nome' => "Terra Santa", 'uf' => "PA", 'codigo' => 1507979],
    		['id' => 285, 'nome' => "Tomé-Açu", 'uf' => "PA", 'codigo' => 1508001],
    		['id' => 286, 'nome' => "Tracuateua", 'uf' => "PA", 'codigo' => 1508035],
    		['id' => 287, 'nome' => "Trairão", 'uf' => "PA", 'codigo' => 1508050],
    		['id' => 288, 'nome' => "Tucumã", 'uf' => "PA", 'codigo' => 1508084],
    		['id' => 289, 'nome' => "Tucuruí", 'uf' => "PA", 'codigo' => 1508100],
    		['id' => 290, 'nome' => "Ulianópolis", 'uf' => "PA", 'codigo' => 1508126],
    		['id' => 291, 'nome' => "Uruará", 'uf' => "PA", 'codigo' => 1508159],
    		['id' => 292, 'nome' => "Vigia", 'uf' => "PA", 'codigo' => 1508209],
    		['id' => 293, 'nome' => "Viseu", 'uf' => "PA", 'codigo' => 1508308],
    		['id' => 294, 'nome' => "Vitória do Xingu", 'uf' => "PA", 'codigo' => 1508357],
    		['id' => 295, 'nome' => "Xinguara", 'uf' => "PA", 'codigo' => 1508407],
    		['id' => 296, 'nome' => "Serra do Navio", 'uf' => "AP", 'codigo' => 1600055],
    		['id' => 297, 'nome' => "Amapá", 'uf' => "AP", 'codigo' => 1600105],
    		['id' => 298, 'nome' => "Pedra Branca do Amapari", 'uf' => "AP", 'codigo' => 1600154],
    		['id' => 299, 'nome' => "Calçoene", 'uf' => "AP", 'codigo' => 1600204],
    		['id' => 300, 'nome' => "Cutias", 'uf' => "AP", 'codigo' => 1600212],
    		['id' => 301, 'nome' => "Ferreira Gomes", 'uf' => "AP", 'codigo' => 1600238],
    		['id' => 302, 'nome' => "Itaubal", 'uf' => "AP", 'codigo' => 1600253],
    		['id' => 303, 'nome' => "Laranjal do Jari", 'uf' => "AP", 'codigo' => 1600279],
    		['id' => 304, 'nome' => "Macapá", 'uf' => "AP", 'codigo' => 1600303],
    		['id' => 305, 'nome' => "Mazagão", 'uf' => "AP", 'codigo' => 1600402],
    		['id' => 306, 'nome' => "Oiapoque", 'uf' => "AP", 'codigo' => 1600501],
    		['id' => 307, 'nome' => "Porto Grande", 'uf' => "AP", 'codigo' => 1600535],
    		['id' => 308, 'nome' => "Pracuúba", 'uf' => "AP", 'codigo' => 1600550],
    		['id' => 309, 'nome' => "Santana", 'uf' => "AP", 'codigo' => 1600600],
    		['id' => 310, 'nome' => "Tartarugalzinho", 'uf' => "AP", 'codigo' => 1600709],
    		['id' => 311, 'nome' => "Vitória do Jari", 'uf' => "AP", 'codigo' => 1600808],
    		['id' => 312, 'nome' => "Abreulândia", 'uf' => "TO", 'codigo' => 1700251],
    		['id' => 313, 'nome' => "Aguiarnópolis", 'uf' => "TO", 'codigo' => 1700301],
    		['id' => 314, 'nome' => "Aliança do Tocantins", 'uf' => "TO", 'codigo' => 1700350],
    		['id' => 315, 'nome' => "Almas", 'uf' => "TO", 'codigo' => 1700400],
    		['id' => 316, 'nome' => "Alvorada", 'uf' => "TO", 'codigo' => 1700707],
    		['id' => 317, 'nome' => "Ananás", 'uf' => "TO", 'codigo' => 1701002],
    		['id' => 318, 'nome' => "Angico", 'uf' => "TO", 'codigo' => 1701051],
    		['id' => 319, 'nome' => "Aparecida do Rio Negro", 'uf' => "TO", 'codigo' => 1701101],
    		['id' => 320, 'nome' => "Aragominas", 'uf' => "TO", 'codigo' => 1701309],
    		['id' => 321, 'nome' => "Araguacema", 'uf' => "TO", 'codigo' => 1701903],
    		['id' => 322, 'nome' => "Araguaçu", 'uf' => "TO", 'codigo' => 1702000],
    		['id' => 323, 'nome' => "Araguaína", 'uf' => "TO", 'codigo' => 1702109],
    		['id' => 324, 'nome' => "Araguanã", 'uf' => "TO", 'codigo' => 1702158],
    		['id' => 325, 'nome' => "Araguatins", 'uf' => "TO", 'codigo' => 1702208],
    		['id' => 326, 'nome' => "Arapoema", 'uf' => "TO", 'codigo' => 1702307],
    		['id' => 327, 'nome' => "Arraias", 'uf' => "TO", 'codigo' => 1702406],
    		['id' => 328, 'nome' => "Augustinópolis", 'uf' => "TO", 'codigo' => 1702554],
    		['id' => 329, 'nome' => "Aurora do Tocantins", 'uf' => "TO", 'codigo' => 1702703],
    		['id' => 330, 'nome' => "Axixá do Tocantins", 'uf' => "TO", 'codigo' => 1702901],
    		['id' => 331, 'nome' => "Babaçulândia", 'uf' => "TO", 'codigo' => 1703008],
    		['id' => 332, 'nome' => "Bandeirantes do Tocantins", 'uf' => "TO", 'codigo' => 1703057],
    		['id' => 333, 'nome' => "Barra do Ouro", 'uf' => "TO", 'codigo' => 1703073],
    		['id' => 334, 'nome' => "Barrolândia", 'uf' => "TO", 'codigo' => 1703107],
    		['id' => 335, 'nome' => "Bernardo Sayão", 'uf' => "TO", 'codigo' => 1703206],
    		['id' => 336, 'nome' => "Bom Jesus do Tocantins", 'uf' => "TO", 'codigo' => 1703305],
    		['id' => 337, 'nome' => "Brasilândia do Tocantins", 'uf' => "TO", 'codigo' => 1703602],
    		['id' => 338, 'nome' => "Brejinho de Nazaré", 'uf' => "TO", 'codigo' => 1703701],
    		['id' => 339, 'nome' => "Buriti do Tocantins", 'uf' => "TO", 'codigo' => 1703800],
    		['id' => 340, 'nome' => "Cachoeirinha", 'uf' => "TO", 'codigo' => 1703826],
    		['id' => 341, 'nome' => "Campos Lindos", 'uf' => "TO", 'codigo' => 1703842],
    		['id' => 342, 'nome' => "Cariri do Tocantins", 'uf' => "TO", 'codigo' => 1703867],
    		['id' => 343, 'nome' => "Carmolândia", 'uf' => "TO", 'codigo' => 1703883],
    		['id' => 344, 'nome' => "Carrasco Bonito", 'uf' => "TO", 'codigo' => 1703891],
    		['id' => 345, 'nome' => "Caseara", 'uf' => "TO", 'codigo' => 1703909],
    		['id' => 346, 'nome' => "Centenário", 'uf' => "TO", 'codigo' => 1704105],
    		['id' => 347, 'nome' => "Chapada de Areia", 'uf' => "TO", 'codigo' => 1704600],
    		['id' => 348, 'nome' => "Chapada da Natividade", 'uf' => "TO", 'codigo' => 1705102],
    		['id' => 349, 'nome' => "Colinas do Tocantins", 'uf' => "TO", 'codigo' => 1705508],
    		['id' => 350, 'nome' => "Combinado", 'uf' => "TO", 'codigo' => 1705557],
    		['id' => 351, 'nome' => "Conceição do Tocantins", 'uf' => "TO", 'codigo' => 1705607],
    		['id' => 352, 'nome' => "Couto Magalhães", 'uf' => "TO", 'codigo' => 1706001],
    		['id' => 353, 'nome' => "Cristalândia", 'uf' => "TO", 'codigo' => 1706100],
    		['id' => 354, 'nome' => "Crixás do Tocantins", 'uf' => "TO", 'codigo' => 1706258],
    		['id' => 355, 'nome' => "Darcinópolis", 'uf' => "TO", 'codigo' => 1706506],
    		['id' => 356, 'nome' => "Dianópolis", 'uf' => "TO", 'codigo' => 1707009],
    		['id' => 357, 'nome' => "Divinópolis do Tocantins", 'uf' => "TO", 'codigo' => 1707108],
    		['id' => 358, 'nome' => "Dois Irmãos do Tocantins", 'uf' => "TO", 'codigo' => 1707207],
    		['id' => 359, 'nome' => "Dueré", 'uf' => "TO", 'codigo' => 1707306],
    		['id' => 360, 'nome' => "Esperantina", 'uf' => "TO", 'codigo' => 1707405],
    		['id' => 361, 'nome' => "Fátima", 'uf' => "TO", 'codigo' => 1707553],
    		['id' => 362, 'nome' => "Figueirópolis", 'uf' => "TO", 'codigo' => 1707652],
    		['id' => 363, 'nome' => "Filadélfia", 'uf' => "TO", 'codigo' => 1707702],
    		['id' => 364, 'nome' => "Formoso do Araguaia", 'uf' => "TO", 'codigo' => 1708205],
    		['id' => 365, 'nome' => "Fortaleza do Tabocão", 'uf' => "TO", 'codigo' => 1708254],
    		['id' => 366, 'nome' => "Goianorte", 'uf' => "TO", 'codigo' => 1708304],
    		['id' => 367, 'nome' => "Goiatins", 'uf' => "TO", 'codigo' => 1709005],
    		['id' => 368, 'nome' => "Guaraí", 'uf' => "TO", 'codigo' => 1709302],
    		['id' => 369, 'nome' => "Gurupi", 'uf' => "TO", 'codigo' => 1709500],
    		['id' => 370, 'nome' => "Ipueiras", 'uf' => "TO", 'codigo' => 1709807],
    		['id' => 371, 'nome' => "Itacajá", 'uf' => "TO", 'codigo' => 1710508],
    		['id' => 372, 'nome' => "Itaguatins", 'uf' => "TO", 'codigo' => 1710706],
    		['id' => 373, 'nome' => "Itapiratins", 'uf' => "TO", 'codigo' => 1710904],
    		['id' => 374, 'nome' => "Itaporã do Tocantins", 'uf' => "TO", 'codigo' => 1711100],
    		['id' => 375, 'nome' => "Jaú do Tocantins", 'uf' => "TO", 'codigo' => 1711506],
    		['id' => 376, 'nome' => "Juarina", 'uf' => "TO", 'codigo' => 1711803],
    		['id' => 377, 'nome' => "Lagoa da Confusão", 'uf' => "TO", 'codigo' => 1711902],
    		['id' => 378, 'nome' => "Lagoa do Tocantins", 'uf' => "TO", 'codigo' => 1711951],
    		['id' => 379, 'nome' => "Lajeado", 'uf' => "TO", 'codigo' => 1712009],
    		['id' => 380, 'nome' => "Lavandeira", 'uf' => "TO", 'codigo' => 1712157],
    		['id' => 381, 'nome' => "Lizarda", 'uf' => "TO", 'codigo' => 1712405],
    		['id' => 382, 'nome' => "Luzinópolis", 'uf' => "TO", 'codigo' => 1712454],
    		['id' => 383, 'nome' => "Marianópolis do Tocantins", 'uf' => "TO", 'codigo' => 1712504],
    		['id' => 384, 'nome' => "Mateiros", 'uf' => "TO", 'codigo' => 1712702],
    		['id' => 385, 'nome' => "Maurilândia do Tocantins", 'uf' => "TO", 'codigo' => 1712801],
    		['id' => 386, 'nome' => "Miracema do Tocantins", 'uf' => "TO", 'codigo' => 1713205],
    		['id' => 387, 'nome' => "Miranorte", 'uf' => "TO", 'codigo' => 1713304],
    		['id' => 388, 'nome' => "Monte do Carmo", 'uf' => "TO", 'codigo' => 1713601],
    		['id' => 389, 'nome' => "Monte Santo do Tocantins", 'uf' => "TO", 'codigo' => 1713700],
    		['id' => 390, 'nome' => "Palmeiras do Tocantins", 'uf' => "TO", 'codigo' => 1713809],
    		['id' => 391, 'nome' => "Muricilândia", 'uf' => "TO", 'codigo' => 1713957],
    		['id' => 392, 'nome' => "Natividade", 'uf' => "TO", 'codigo' => 1714203],
    		['id' => 393, 'nome' => "Nazaré", 'uf' => "TO", 'codigo' => 1714302],
    		['id' => 394, 'nome' => "Nova Olinda", 'uf' => "TO", 'codigo' => 1714880],
    		['id' => 395, 'nome' => "Nova Rosalândia", 'uf' => "TO", 'codigo' => 1715002],
    		['id' => 396, 'nome' => "Novo Acordo", 'uf' => "TO", 'codigo' => 1715101],
    		['id' => 397, 'nome' => "Novo Alegre", 'uf' => "TO", 'codigo' => 1715150],
    		['id' => 398, 'nome' => "Novo Jardim", 'uf' => "TO", 'codigo' => 1715259],
    		['id' => 399, 'nome' => "Oliveira de Fátima", 'uf' => "TO", 'codigo' => 1715507],
    		['id' => 400, 'nome' => "Palmeirante", 'uf' => "TO", 'codigo' => 1715705],
    		['id' => 401, 'nome' => "Palmeirópolis", 'uf' => "TO", 'codigo' => 1715754],
    		['id' => 402, 'nome' => "Paraíso do Tocantins", 'uf' => "TO", 'codigo' => 1716109],
    		['id' => 403, 'nome' => "Paranã", 'uf' => "TO", 'codigo' => 1716208],
    		['id' => 404, 'nome' => "Pau D'Arco", 'uf' => "TO", 'codigo' => 1716307],
    		['id' => 405, 'nome' => "Pedro Afonso", 'uf' => "TO", 'codigo' => 1716505],
    		['id' => 406, 'nome' => "Peixe", 'uf' => "TO", 'codigo' => 1716604],
    		['id' => 407, 'nome' => "Pequizeiro", 'uf' => "TO", 'codigo' => 1716653],
    		['id' => 408, 'nome' => "Colméia", 'uf' => "TO", 'codigo' => 1716703],
    		['id' => 409, 'nome' => "Pindorama do Tocantins", 'uf' => "TO", 'codigo' => 1717008],
    		['id' => 410, 'nome' => "Piraquê", 'uf' => "TO", 'codigo' => 1717206],
    		['id' => 411, 'nome' => "Pium", 'uf' => "TO", 'codigo' => 1717503],
    		['id' => 412, 'nome' => "Ponte Alta do Bom Jesus", 'uf' => "TO", 'codigo' => 1717800],
    		['id' => 413, 'nome' => "Ponte Alta do Tocantins", 'uf' => "TO", 'codigo' => 1717909],
    		['id' => 414, 'nome' => "Porto Alegre do Tocantins", 'uf' => "TO", 'codigo' => 1718006],
    		['id' => 415, 'nome' => "Porto Nacional", 'uf' => "TO", 'codigo' => 1718204],
    		['id' => 416, 'nome' => "Praia Norte", 'uf' => "TO", 'codigo' => 1718303],
    		['id' => 417, 'nome' => "Presidente Kennedy", 'uf' => "TO", 'codigo' => 1718402],
    		['id' => 418, 'nome' => "Pugmil", 'uf' => "TO", 'codigo' => 1718451],
    		['id' => 419, 'nome' => "Recursolândia", 'uf' => "TO", 'codigo' => 1718501],
    		['id' => 420, 'nome' => "Riachinho", 'uf' => "TO", 'codigo' => 1718550],
    		['id' => 421, 'nome' => "Rio da Conceição", 'uf' => "TO", 'codigo' => 1718659],
    		['id' => 422, 'nome' => "Rio dos Bois", 'uf' => "TO", 'codigo' => 1718709],
    		['id' => 423, 'nome' => "Rio Sono", 'uf' => "TO", 'codigo' => 1718758],
    		['id' => 424, 'nome' => "Sampaio", 'uf' => "TO", 'codigo' => 1718808],
    		['id' => 425, 'nome' => "Sandolândia", 'uf' => "TO", 'codigo' => 1718840],
    		['id' => 426, 'nome' => "Santa Fé do Araguaia", 'uf' => "TO", 'codigo' => 1718865],
    		['id' => 427, 'nome' => "Santa Maria do Tocantins", 'uf' => "TO", 'codigo' => 1718881],
    		['id' => 428, 'nome' => "Santa Rita do Tocantins", 'uf' => "TO", 'codigo' => 1718899],
    		['id' => 429, 'nome' => "Santa Rosa do Tocantins", 'uf' => "TO", 'codigo' => 1718907],
    		['id' => 430, 'nome' => "Santa Tereza do Tocantins", 'uf' => "TO", 'codigo' => 1719004],
    		['id' => 431, 'nome' => "Santa Terezinha do Tocantins", 'uf' => "TO", 'codigo' => 1720002],
    		['id' => 432, 'nome' => "São Bento do Tocantins", 'uf' => "TO", 'codigo' => 1720101],
    		['id' => 433, 'nome' => "São Félix do Tocantins", 'uf' => "TO", 'codigo' => 1720150],
    		['id' => 434, 'nome' => "São Miguel do Tocantins", 'uf' => "TO", 'codigo' => 1720200],
    		['id' => 435, 'nome' => "São Salvador do Tocantins", 'uf' => "TO", 'codigo' => 1720259],
    		['id' => 436, 'nome' => "São Sebastião do Tocantins", 'uf' => "TO", 'codigo' => 1720309],
    		['id' => 437, 'nome' => "São Valério", 'uf' => "TO", 'codigo' => 1720499],
    		['id' => 438, 'nome' => "Silvanópolis", 'uf' => "TO", 'codigo' => 1720655],
    		['id' => 439, 'nome' => "Sítio Novo do Tocantins", 'uf' => "TO", 'codigo' => 1720804],
    		['id' => 440, 'nome' => "Sucupira", 'uf' => "TO", 'codigo' => 1720853],
    		['id' => 441, 'nome' => "Taguatinga", 'uf' => "TO", 'codigo' => 1720903],
    		['id' => 442, 'nome' => "Taipas do Tocantins", 'uf' => "TO", 'codigo' => 1720937],
    		['id' => 443, 'nome' => "Talismã", 'uf' => "TO", 'codigo' => 1720978],
    		['id' => 444, 'nome' => "Palmas", 'uf' => "TO", 'codigo' => 1721000],
    		['id' => 445, 'nome' => "Tocantínia", 'uf' => "TO", 'codigo' => 1721109],
    		['id' => 446, 'nome' => "Tocantinópolis", 'uf' => "TO", 'codigo' => 1721208],
    		['id' => 447, 'nome' => "Tupirama", 'uf' => "TO", 'codigo' => 1721257],
    		['id' => 448, 'nome' => "Tupiratins", 'uf' => "TO", 'codigo' => 1721307],
    		['id' => 449, 'nome' => "Wanderlândia", 'uf' => "TO", 'codigo' => 1722081],
    		['id' => 450, 'nome' => "Xambioá", 'uf' => "TO", 'codigo' => 1722107],
    		['id' => 451, 'nome' => "Açailândia", 'uf' => "MA", 'codigo' => 2100055],
    		['id' => 452, 'nome' => "Afonso Cunha", 'uf' => "MA", 'codigo' => 2100105],
    		['id' => 453, 'nome' => "Água Doce do Maranhão", 'uf' => "MA", 'codigo' => 2100154],
    		['id' => 454, 'nome' => "Alcântara", 'uf' => "MA", 'codigo' => 2100204],
    		['id' => 455, 'nome' => "Aldeias Altas", 'uf' => "MA", 'codigo' => 2100303],
    		['id' => 456, 'nome' => "Altamira do Maranhão", 'uf' => "MA", 'codigo' => 2100402],
    		['id' => 457, 'nome' => "Alto Alegre do Maranhão", 'uf' => "MA", 'codigo' => 2100436],
    		['id' => 458, 'nome' => "Alto Alegre do Pindaré", 'uf' => "MA", 'codigo' => 2100477],
    		['id' => 459, 'nome' => "Alto Parnaíba", 'uf' => "MA", 'codigo' => 2100501],
    		['id' => 460, 'nome' => "Amapá do Maranhão", 'uf' => "MA", 'codigo' => 2100550],
    		['id' => 461, 'nome' => "Amarante do Maranhão", 'uf' => "MA", 'codigo' => 2100600],
    		['id' => 462, 'nome' => "Anajatuba", 'uf' => "MA", 'codigo' => 2100709],
    		['id' => 463, 'nome' => "Anapurus", 'uf' => "MA", 'codigo' => 2100808],
    		['id' => 464, 'nome' => "Apicum-Açu", 'uf' => "MA", 'codigo' => 2100832],
    		['id' => 465, 'nome' => "Araguanã", 'uf' => "MA", 'codigo' => 2100873],
    		['id' => 466, 'nome' => "Araioses", 'uf' => "MA", 'codigo' => 2100907],
    		['id' => 467, 'nome' => "Arame", 'uf' => "MA", 'codigo' => 2100956],
    		['id' => 468, 'nome' => "Arari", 'uf' => "MA", 'codigo' => 2101004],
    		['id' => 469, 'nome' => "Axixá", 'uf' => "MA", 'codigo' => 2101103],
    		['id' => 470, 'nome' => "Bacabal", 'uf' => "MA", 'codigo' => 2101202],
    		['id' => 471, 'nome' => "Bacabeira", 'uf' => "MA", 'codigo' => 2101251],
    		['id' => 472, 'nome' => "Bacuri", 'uf' => "MA", 'codigo' => 2101301],
    		['id' => 473, 'nome' => "Bacurituba", 'uf' => "MA", 'codigo' => 2101350],
    		['id' => 474, 'nome' => "Balsas", 'uf' => "MA", 'codigo' => 2101400],
    		['id' => 475, 'nome' => "Barão de Grajaú", 'uf' => "MA", 'codigo' => 2101509],
    		['id' => 476, 'nome' => "Barra do Corda", 'uf' => "MA", 'codigo' => 2101608],
    		['id' => 477, 'nome' => "Barreirinhas", 'uf' => "MA", 'codigo' => 2101707],
    		['id' => 478, 'nome' => "Belágua", 'uf' => "MA", 'codigo' => 2101731],
    		['id' => 479, 'nome' => "Bela Vista do Maranhão", 'uf' => "MA", 'codigo' => 2101772],
    		['id' => 480, 'nome' => "Benedito Leite", 'uf' => "MA", 'codigo' => 2101806],
    		['id' => 481, 'nome' => "Bequimão", 'uf' => "MA", 'codigo' => 2101905],
    		['id' => 482, 'nome' => "Bernardo do Mearim", 'uf' => "MA", 'codigo' => 2101939],
    		['id' => 483, 'nome' => "Boa Vista do Gurupi", 'uf' => "MA", 'codigo' => 2101970],
    		['id' => 484, 'nome' => "Bom Jardim", 'uf' => "MA", 'codigo' => 2102002],
    		['id' => 485, 'nome' => "Bom Jesus das Selvas", 'uf' => "MA", 'codigo' => 2102036],
    		['id' => 486, 'nome' => "Bom Lugar", 'uf' => "MA", 'codigo' => 2102077],
    		['id' => 487, 'nome' => "Brejo", 'uf' => "MA", 'codigo' => 2102101],
    		['id' => 488, 'nome' => "Brejo de Areia", 'uf' => "MA", 'codigo' => 2102150],
    		['id' => 489, 'nome' => "Buriti", 'uf' => "MA", 'codigo' => 2102200],
    		['id' => 490, 'nome' => "Buriti Bravo", 'uf' => "MA", 'codigo' => 2102309],
    		['id' => 491, 'nome' => "Buriticupu", 'uf' => "MA", 'codigo' => 2102325],
    		['id' => 492, 'nome' => "Buritirana", 'uf' => "MA", 'codigo' => 2102358],
    		['id' => 493, 'nome' => "Cachoeira Grande", 'uf' => "MA", 'codigo' => 2102374],
    		['id' => 494, 'nome' => "Cajapió", 'uf' => "MA", 'codigo' => 2102408],
    		['id' => 495, 'nome' => "Cajari", 'uf' => "MA", 'codigo' => 2102507],
    		['id' => 496, 'nome' => "Campestre do Maranhão", 'uf' => "MA", 'codigo' => 2102556],
    		['id' => 497, 'nome' => "Cândido Mendes", 'uf' => "MA", 'codigo' => 2102606],
    		['id' => 498, 'nome' => "Cantanhede", 'uf' => "MA", 'codigo' => 2102705],
    		['id' => 499, 'nome' => "Capinzal do Norte", 'uf' => "MA", 'codigo' => 2102754],
    		['id' => 500, 'nome' => "Carolina", 'uf' => "MA", 'codigo' => 2102804],
    		['id' => 501, 'nome' => "Carutapera", 'uf' => "MA", 'codigo' => 2102903],
    		['id' => 502, 'nome' => "Caxias", 'uf' => "MA", 'codigo' => 2103000],
    		['id' => 503, 'nome' => "Cedral", 'uf' => "MA", 'codigo' => 2103109],
    		['id' => 504, 'nome' => "Central do Maranhão", 'uf' => "MA", 'codigo' => 2103125],
    		['id' => 505, 'nome' => "Centro do Guilherme", 'uf' => "MA", 'codigo' => 2103158],
    		['id' => 506, 'nome' => "Centro Novo do Maranhão", 'uf' => "MA", 'codigo' => 2103174],
    		['id' => 507, 'nome' => "Chapadinha", 'uf' => "MA", 'codigo' => 2103208],
    		['id' => 508, 'nome' => "Cidelândia", 'uf' => "MA", 'codigo' => 2103257],
    		['id' => 509, 'nome' => "Codó", 'uf' => "MA", 'codigo' => 2103307],
    		['id' => 510, 'nome' => "Coelho Neto", 'uf' => "MA", 'codigo' => 2103406],
    		['id' => 511, 'nome' => "Colinas", 'uf' => "MA", 'codigo' => 2103505],
    		['id' => 512, 'nome' => "Conceição do Lago-Açu", 'uf' => "MA", 'codigo' => 2103554],
    		['id' => 513, 'nome' => "Coroatá", 'uf' => "MA", 'codigo' => 2103604],
    		['id' => 514, 'nome' => "Cururupu", 'uf' => "MA", 'codigo' => 2103703],
    		['id' => 515, 'nome' => "Davinópolis", 'uf' => "MA", 'codigo' => 2103752],
    		['id' => 516, 'nome' => "Dom Pedro", 'uf' => "MA", 'codigo' => 2103802],
    		['id' => 517, 'nome' => "Duque Bacelar", 'uf' => "MA", 'codigo' => 2103901],
    		['id' => 518, 'nome' => "Esperantinópolis", 'uf' => "MA", 'codigo' => 2104008],
    		['id' => 519, 'nome' => "Estreito", 'uf' => "MA", 'codigo' => 2104057],
    		['id' => 520, 'nome' => "Feira Nova do Maranhão", 'uf' => "MA", 'codigo' => 2104073],
    		['id' => 521, 'nome' => "Fernando Falcão", 'uf' => "MA", 'codigo' => 2104081],
    		['id' => 522, 'nome' => "Formosa da Serra Negra", 'uf' => "MA", 'codigo' => 2104099],
    		['id' => 523, 'nome' => "Fortaleza dos Nogueiras", 'uf' => "MA", 'codigo' => 2104107],
    		['id' => 524, 'nome' => "Fortuna", 'uf' => "MA", 'codigo' => 2104206],
    		['id' => 525, 'nome' => "Godofredo Viana", 'uf' => "MA", 'codigo' => 2104305],
    		['id' => 526, 'nome' => "Gonçalves Dias", 'uf' => "MA", 'codigo' => 2104404],
    		['id' => 527, 'nome' => "Governador Archer", 'uf' => "MA", 'codigo' => 2104503],
    		['id' => 528, 'nome' => "Governador Edison Lobão", 'uf' => "MA", 'codigo' => 2104552],
    		['id' => 529, 'nome' => "Governador Eugênio Barros", 'uf' => "MA", 'codigo' => 2104602],
    		['id' => 530, 'nome' => "Governador Luiz Rocha", 'uf' => "MA", 'codigo' => 2104628],
    		['id' => 531, 'nome' => "Governador Newton Bello", 'uf' => "MA", 'codigo' => 2104651],
    		['id' => 532, 'nome' => "Governador Nunes Freire", 'uf' => "MA", 'codigo' => 2104677],
    		['id' => 533, 'nome' => "Graça Aranha", 'uf' => "MA", 'codigo' => 2104701],
    		['id' => 534, 'nome' => "Grajaú", 'uf' => "MA", 'codigo' => 2104800],
    		['id' => 535, 'nome' => "Guimarães", 'uf' => "MA", 'codigo' => 2104909],
    		['id' => 536, 'nome' => "Humberto de Campos", 'uf' => "MA", 'codigo' => 2105005],
    		['id' => 537, 'nome' => "Icatu", 'uf' => "MA", 'codigo' => 2105104],
    		['id' => 538, 'nome' => "Igarapé do Meio", 'uf' => "MA", 'codigo' => 2105153],
    		['id' => 539, 'nome' => "Igarapé Grande", 'uf' => "MA", 'codigo' => 2105203],
    		['id' => 540, 'nome' => "Imperatriz", 'uf' => "MA", 'codigo' => 2105302],
    		['id' => 541, 'nome' => "Itaipava do Grajaú", 'uf' => "MA", 'codigo' => 2105351],
    		['id' => 542, 'nome' => "Itapecuru Mirim", 'uf' => "MA", 'codigo' => 2105401],
    		['id' => 543, 'nome' => "Itinga do Maranhão", 'uf' => "MA", 'codigo' => 2105427],
    		['id' => 544, 'nome' => "Jatobá", 'uf' => "MA", 'codigo' => 2105450],
    		['id' => 545, 'nome' => "Jenipapo dos Vieiras", 'uf' => "MA", 'codigo' => 2105476],
    		['id' => 546, 'nome' => "João Lisboa", 'uf' => "MA", 'codigo' => 2105500],
    		['id' => 547, 'nome' => "Joselândia", 'uf' => "MA", 'codigo' => 2105609],
    		['id' => 548, 'nome' => "Junco do Maranhão", 'uf' => "MA", 'codigo' => 2105658],
    		['id' => 549, 'nome' => "Lago da Pedra", 'uf' => "MA", 'codigo' => 2105708],
    		['id' => 550, 'nome' => "Lago do Junco", 'uf' => "MA", 'codigo' => 2105807],
    		['id' => 551, 'nome' => "Lago Verde", 'uf' => "MA", 'codigo' => 2105906],
    		['id' => 552, 'nome' => "Lagoa do Mato", 'uf' => "MA", 'codigo' => 2105922],
    		['id' => 553, 'nome' => "Lago dos Rodrigues", 'uf' => "MA", 'codigo' => 2105948],
    		['id' => 554, 'nome' => "Lagoa Grande do Maranhão", 'uf' => "MA", 'codigo' => 2105963],
    		['id' => 555, 'nome' => "Lajeado Novo", 'uf' => "MA", 'codigo' => 2105989],
    		['id' => 556, 'nome' => "Lima Campos", 'uf' => "MA", 'codigo' => 2106003],
    		['id' => 557, 'nome' => "Loreto", 'uf' => "MA", 'codigo' => 2106102],
    		['id' => 558, 'nome' => "Luís Domingues", 'uf' => "MA", 'codigo' => 2106201],
    		['id' => 559, 'nome' => "Magalhães de Almeida", 'uf' => "MA", 'codigo' => 2106300],
    		['id' => 560, 'nome' => "Maracaçumé", 'uf' => "MA", 'codigo' => 2106326],
    		['id' => 561, 'nome' => "Marajá do Sena", 'uf' => "MA", 'codigo' => 2106359],
    		['id' => 562, 'nome' => "Maranhãozinho", 'uf' => "MA", 'codigo' => 2106375],
    		['id' => 563, 'nome' => "Mata Roma", 'uf' => "MA", 'codigo' => 2106409],
    		['id' => 564, 'nome' => "Matinha", 'uf' => "MA", 'codigo' => 2106508],
    		['id' => 565, 'nome' => "Matões", 'uf' => "MA", 'codigo' => 2106607],
    		['id' => 566, 'nome' => "Matões do Norte", 'uf' => "MA", 'codigo' => 2106631],
    		['id' => 567, 'nome' => "Milagres do Maranhão", 'uf' => "MA", 'codigo' => 2106672],
    		['id' => 568, 'nome' => "Mirador", 'uf' => "MA", 'codigo' => 2106706],
    		['id' => 569, 'nome' => "Miranda do Norte", 'uf' => "MA", 'codigo' => 2106755],
    		['id' => 570, 'nome' => "Mirinzal", 'uf' => "MA", 'codigo' => 2106805],
    		['id' => 571, 'nome' => "Monção", 'uf' => "MA", 'codigo' => 2106904],
    		['id' => 572, 'nome' => "Montes Altos", 'uf' => "MA", 'codigo' => 2107001],
    		['id' => 573, 'nome' => "Morros", 'uf' => "MA", 'codigo' => 2107100],
    		['id' => 574, 'nome' => "Nina Rodrigues", 'uf' => "MA", 'codigo' => 2107209],
    		['id' => 575, 'nome' => "Nova Colinas", 'uf' => "MA", 'codigo' => 2107258],
    		['id' => 576, 'nome' => "Nova Iorque", 'uf' => "MA", 'codigo' => 2107308],
    		['id' => 577, 'nome' => "Nova Olinda do Maranhão", 'uf' => "MA", 'codigo' => 2107357],
    		['id' => 578, 'nome' => "Olho D'Água das Cunhãs", 'uf' => "MA", 'codigo' => 2107407],
    		['id' => 579, 'nome' => "Olinda Nova do Maranhão", 'uf' => "MA", 'codigo' => 2107456],
    		['id' => 580, 'nome' => "Paço do Lumiar", 'uf' => "MA", 'codigo' => 2107506],
    		['id' => 581, 'nome' => "Palmeirândia", 'uf' => "MA", 'codigo' => 2107605],
    		['id' => 582, 'nome' => "Paraibano", 'uf' => "MA", 'codigo' => 2107704],
    		['id' => 583, 'nome' => "Parnarama", 'uf' => "MA", 'codigo' => 2107803],
    		['id' => 584, 'nome' => "Passagem Franca", 'uf' => "MA", 'codigo' => 2107902],
    		['id' => 585, 'nome' => "Pastos Bons", 'uf' => "MA", 'codigo' => 2108009],
    		['id' => 586, 'nome' => "Paulino Neves", 'uf' => "MA", 'codigo' => 2108058],
    		['id' => 587, 'nome' => "Paulo Ramos", 'uf' => "MA", 'codigo' => 2108108],
    		['id' => 588, 'nome' => "Pedreiras", 'uf' => "MA", 'codigo' => 2108207],
    		['id' => 589, 'nome' => "Pedro do Rosário", 'uf' => "MA", 'codigo' => 2108256],
    		['id' => 590, 'nome' => "Penalva", 'uf' => "MA", 'codigo' => 2108306],
    		['id' => 591, 'nome' => "Peri Mirim", 'uf' => "MA", 'codigo' => 2108405],
    		['id' => 592, 'nome' => "Peritoró", 'uf' => "MA", 'codigo' => 2108454],
    		['id' => 593, 'nome' => "Pindaré-Mirim", 'uf' => "MA", 'codigo' => 2108504],
    		['id' => 594, 'nome' => "Pinheiro", 'uf' => "MA", 'codigo' => 2108603],
    		['id' => 595, 'nome' => "Pio XII", 'uf' => "MA", 'codigo' => 2108702],
    		['id' => 596, 'nome' => "Pirapemas", 'uf' => "MA", 'codigo' => 2108801],
    		['id' => 597, 'nome' => "Poção de Pedras", 'uf' => "MA", 'codigo' => 2108900],
    		['id' => 598, 'nome' => "Porto Franco", 'uf' => "MA", 'codigo' => 2109007],
    		['id' => 599, 'nome' => "Porto Rico do Maranhão", 'uf' => "MA", 'codigo' => 2109056],
    		['id' => 600, 'nome' => "Presidente Dutra", 'uf' => "MA", 'codigo' => 2109106],
    		['id' => 601, 'nome' => "Presidente Juscelino", 'uf' => "MA", 'codigo' => 2109205],
    		['id' => 602, 'nome' => "Presidente Médici", 'uf' => "MA", 'codigo' => 2109239],
    		['id' => 603, 'nome' => "Presidente Sarney", 'uf' => "MA", 'codigo' => 2109270],
    		['id' => 604, 'nome' => "Presidente Vargas", 'uf' => "MA", 'codigo' => 2109304],
    		['id' => 605, 'nome' => "Primeira Cruz", 'uf' => "MA", 'codigo' => 2109403],
    		['id' => 606, 'nome' => "Raposa", 'uf' => "MA", 'codigo' => 2109452],
    		['id' => 607, 'nome' => "Riachão", 'uf' => "MA", 'codigo' => 2109502],
    		['id' => 608, 'nome' => "Ribamar Fiquene", 'uf' => "MA", 'codigo' => 2109551],
    		['id' => 609, 'nome' => "Rosário", 'uf' => "MA", 'codigo' => 2109601],
    		['id' => 610, 'nome' => "Sambaíba", 'uf' => "MA", 'codigo' => 2109700],
    		['id' => 611, 'nome' => "Santa Filomena do Maranhão", 'uf' => "MA", 'codigo' => 2109759],
    		['id' => 612, 'nome' => "Santa Helena", 'uf' => "MA", 'codigo' => 2109809],
    		['id' => 613, 'nome' => "Santa Inês", 'uf' => "MA", 'codigo' => 2109908],
    		['id' => 614, 'nome' => "Santa Luzia", 'uf' => "MA", 'codigo' => 2110005],
    		['id' => 615, 'nome' => "Santa Luzia do Paruá", 'uf' => "MA", 'codigo' => 2110039],
    		['id' => 616, 'nome' => "Santa Quitéria do Maranhão", 'uf' => "MA", 'codigo' => 2110104],
    		['id' => 617, 'nome' => "Santa Rita", 'uf' => "MA", 'codigo' => 2110203],
    		['id' => 618, 'nome' => "Santana do Maranhão", 'uf' => "MA", 'codigo' => 2110237],
    		['id' => 619, 'nome' => "Santo Amaro do Maranhão", 'uf' => "MA", 'codigo' => 2110278],
    		['id' => 620, 'nome' => "Santo Antônio dos Lopes", 'uf' => "MA", 'codigo' => 2110302],
    		['id' => 621, 'nome' => "São Benedito do Rio Preto", 'uf' => "MA", 'codigo' => 2110401],
    		['id' => 622, 'nome' => "São Bento", 'uf' => "MA", 'codigo' => 2110500],
    		['id' => 623, 'nome' => "São Bernardo", 'uf' => "MA", 'codigo' => 2110609],
    		['id' => 624, 'nome' => "São Domingos do Azeitão", 'uf' => "MA", 'codigo' => 2110658],
    		['id' => 625, 'nome' => "São Domingos do Maranhão", 'uf' => "MA", 'codigo' => 2110708],
    		['id' => 626, 'nome' => "São Félix de Balsas", 'uf' => "MA", 'codigo' => 2110807],
    		['id' => 627, 'nome' => "São Francisco do Brejão", 'uf' => "MA", 'codigo' => 2110856],
    		['id' => 628, 'nome' => "São Francisco do Maranhão", 'uf' => "MA", 'codigo' => 2110906],
    		['id' => 629, 'nome' => "São João Batista", 'uf' => "MA", 'codigo' => 2111003],
    		['id' => 630, 'nome' => "São João do Carú", 'uf' => "MA", 'codigo' => 2111029],
    		['id' => 631, 'nome' => "São João do Paraíso", 'uf' => "MA", 'codigo' => 2111052],
    		['id' => 632, 'nome' => "São João do Soter", 'uf' => "MA", 'codigo' => 2111078],
    		['id' => 633, 'nome' => "São João dos Patos", 'uf' => "MA", 'codigo' => 2111102],
    		['id' => 634, 'nome' => "São José de Ribamar", 'uf' => "MA", 'codigo' => 2111201],
    		['id' => 635, 'nome' => "São José dos Basílios", 'uf' => "MA", 'codigo' => 2111250],
    		['id' => 636, 'nome' => "São Luís", 'uf' => "MA", 'codigo' => 2111300],
    		['id' => 637, 'nome' => "São Luís Gonzaga do Maranhão", 'uf' => "MA", 'codigo' => 2111409],
    		['id' => 638, 'nome' => "São Mateus do Maranhão", 'uf' => "MA", 'codigo' => 2111508],
    		['id' => 639, 'nome' => "São Pedro da Água Branca", 'uf' => "MA", 'codigo' => 2111532],
    		['id' => 640, 'nome' => "São Pedro dos Crentes", 'uf' => "MA", 'codigo' => 2111573],
    		['id' => 641, 'nome' => "São Raimundo das Mangabeiras", 'uf' => "MA", 'codigo' => 2111607],
    		['id' => 642, 'nome' => "São Raimundo do Doca Bezerra", 'uf' => "MA", 'codigo' => 2111631],
    		['id' => 643, 'nome' => "São Roberto", 'uf' => "MA", 'codigo' => 2111672],
    		['id' => 644, 'nome' => "São Vicente Ferrer", 'uf' => "MA", 'codigo' => 2111706],
    		['id' => 645, 'nome' => "Satubinha", 'uf' => "MA", 'codigo' => 2111722],
    		['id' => 646, 'nome' => "Senador Alexandre Costa", 'uf' => "MA", 'codigo' => 2111748],
    		['id' => 647, 'nome' => "Senador La Rocque", 'uf' => "MA", 'codigo' => 2111763],
    		['id' => 648, 'nome' => "Serrano do Maranhão", 'uf' => "MA", 'codigo' => 2111789],
    		['id' => 649, 'nome' => "Sítio Novo", 'uf' => "MA", 'codigo' => 2111805],
    		['id' => 650, 'nome' => "Sucupira do Norte", 'uf' => "MA", 'codigo' => 2111904],
    		['id' => 651, 'nome' => "Sucupira do Riachão", 'uf' => "MA", 'codigo' => 2111953],
    		['id' => 652, 'nome' => "Tasso Fragoso", 'uf' => "MA", 'codigo' => 2112001],
    		['id' => 653, 'nome' => "Timbiras", 'uf' => "MA", 'codigo' => 2112100],
    		['id' => 654, 'nome' => "Timon", 'uf' => "MA", 'codigo' => 2112209],
    		['id' => 655, 'nome' => "Trizidela do Vale", 'uf' => "MA", 'codigo' => 2112233],
    		['id' => 656, 'nome' => "Tufilândia", 'uf' => "MA", 'codigo' => 2112274],
    		['id' => 657, 'nome' => "Tuntum", 'uf' => "MA", 'codigo' => 2112308],
    		['id' => 658, 'nome' => "Turiaçu", 'uf' => "MA", 'codigo' => 2112407],
    		['id' => 659, 'nome' => "Turilândia", 'uf' => "MA", 'codigo' => 2112456],
    		['id' => 660, 'nome' => "Tutóia", 'uf' => "MA", 'codigo' => 2112506],
    		['id' => 661, 'nome' => "Urbano Santos", 'uf' => "MA", 'codigo' => 2112605],
    		['id' => 662, 'nome' => "Vargem Grande", 'uf' => "MA", 'codigo' => 2112704],
    		['id' => 663, 'nome' => "Viana", 'uf' => "MA", 'codigo' => 2112803],
    		['id' => 664, 'nome' => "Vila Nova dos Martírios", 'uf' => "MA", 'codigo' => 2112852],
    		['id' => 665, 'nome' => "Vitória do Mearim", 'uf' => "MA", 'codigo' => 2112902],
    		['id' => 666, 'nome' => "Vitorino Freire", 'uf' => "MA", 'codigo' => 2113009],
    		['id' => 667, 'nome' => "Zé Doca", 'uf' => "MA", 'codigo' => 2114007],
    		['id' => 668, 'nome' => "Acauã", 'uf' => "PI", 'codigo' => 2200053],
    		['id' => 669, 'nome' => "Agricolândia", 'uf' => "PI", 'codigo' => 2200103],
    		['id' => 670, 'nome' => "Água Branca", 'uf' => "PI", 'codigo' => 2200202],
    		['id' => 671, 'nome' => "Alagoinha do Piauí", 'uf' => "PI", 'codigo' => 2200251],
    		['id' => 672, 'nome' => "Alegrete do Piauí", 'uf' => "PI", 'codigo' => 2200277],
    		['id' => 673, 'nome' => "Alto Longá", 'uf' => "PI", 'codigo' => 2200301],
    		['id' => 674, 'nome' => "Altos", 'uf' => "PI", 'codigo' => 2200400],
    		['id' => 675, 'nome' => "Alvorada do Gurguéia", 'uf' => "PI", 'codigo' => 2200459],
    		['id' => 676, 'nome' => "Amarante", 'uf' => "PI", 'codigo' => 2200509],
    		['id' => 677, 'nome' => "Angical do Piauí", 'uf' => "PI", 'codigo' => 2200608],
    		['id' => 678, 'nome' => "Anísio de Abreu", 'uf' => "PI", 'codigo' => 2200707],
    		['id' => 679, 'nome' => "Antônio Almeida", 'uf' => "PI", 'codigo' => 2200806],
    		['id' => 680, 'nome' => "Aroazes", 'uf' => "PI", 'codigo' => 2200905],
    		['id' => 681, 'nome' => "Aroeiras do Itaim", 'uf' => "PI", 'codigo' => 2200954],
    		['id' => 682, 'nome' => "Arraial", 'uf' => "PI", 'codigo' => 2201002],
    		['id' => 683, 'nome' => "Assunção do Piauí", 'uf' => "PI", 'codigo' => 2201051],
    		['id' => 684, 'nome' => "Avelino Lopes", 'uf' => "PI", 'codigo' => 2201101],
    		['id' => 685, 'nome' => "Baixa Grande do Ribeiro", 'uf' => "PI", 'codigo' => 2201150],
    		['id' => 686, 'nome' => "Barra D'Alcântara", 'uf' => "PI", 'codigo' => 2201176],
    		['id' => 687, 'nome' => "Barras", 'uf' => "PI", 'codigo' => 2201200],
    		['id' => 688, 'nome' => "Barreiras do Piauí", 'uf' => "PI", 'codigo' => 2201309],
    		['id' => 689, 'nome' => "Barro Duro", 'uf' => "PI", 'codigo' => 2201408],
    		['id' => 690, 'nome' => "Batalha", 'uf' => "PI", 'codigo' => 2201507],
    		['id' => 691, 'nome' => "Bela Vista do Piauí", 'uf' => "PI", 'codigo' => 2201556],
    		['id' => 692, 'nome' => "Belém do Piauí", 'uf' => "PI", 'codigo' => 2201572],
    		['id' => 693, 'nome' => "Beneditinos", 'uf' => "PI", 'codigo' => 2201606],
    		['id' => 694, 'nome' => "Bertolínia", 'uf' => "PI", 'codigo' => 2201705],
    		['id' => 695, 'nome' => "Betânia do Piauí", 'uf' => "PI", 'codigo' => 2201739],
    		['id' => 696, 'nome' => "Boa Hora", 'uf' => "PI", 'codigo' => 2201770],
    		['id' => 697, 'nome' => "Bocaina", 'uf' => "PI", 'codigo' => 2201804],
    		['id' => 698, 'nome' => "Bom Jesus", 'uf' => "PI", 'codigo' => 2201903],
    		['id' => 699, 'nome' => "Bom Princípio do Piauí", 'uf' => "PI", 'codigo' => 2201919],
    		['id' => 700, 'nome' => "Bonfim do Piauí", 'uf' => "PI", 'codigo' => 2201929],
    		['id' => 701, 'nome' => "Boqueirão do Piauí", 'uf' => "PI", 'codigo' => 2201945],
    		['id' => 702, 'nome' => "Brasileira", 'uf' => "PI", 'codigo' => 2201960],
    		['id' => 703, 'nome' => "Brejo do Piauí", 'uf' => "PI", 'codigo' => 2201988],
    		['id' => 704, 'nome' => "Buriti dos Lopes", 'uf' => "PI", 'codigo' => 2202000],
    		['id' => 705, 'nome' => "Buriti dos Montes", 'uf' => "PI", 'codigo' => 2202026],
    		['id' => 706, 'nome' => "Cabeceiras do Piauí", 'uf' => "PI", 'codigo' => 2202059],
    		['id' => 707, 'nome' => "Cajazeiras do Piauí", 'uf' => "PI", 'codigo' => 2202075],
    		['id' => 708, 'nome' => "Cajueiro da Praia", 'uf' => "PI", 'codigo' => 2202083],
    		['id' => 709, 'nome' => "Caldeirão Grande do Piauí", 'uf' => "PI", 'codigo' => 2202091],
    		['id' => 710, 'nome' => "Campinas do Piauí", 'uf' => "PI", 'codigo' => 2202109],
    		['id' => 711, 'nome' => "Campo Alegre do Fidalgo", 'uf' => "PI", 'codigo' => 2202117],
    		['id' => 712, 'nome' => "Campo Grande do Piauí", 'uf' => "PI", 'codigo' => 2202133],
    		['id' => 713, 'nome' => "Campo Largo do Piauí", 'uf' => "PI", 'codigo' => 2202174],
    		['id' => 714, 'nome' => "Campo Maior", 'uf' => "PI", 'codigo' => 2202208],
    		['id' => 715, 'nome' => "Canavieira", 'uf' => "PI", 'codigo' => 2202251],
    		['id' => 716, 'nome' => "Canto do Buriti", 'uf' => "PI", 'codigo' => 2202307],
    		['id' => 717, 'nome' => "Capitão de Campos", 'uf' => "PI", 'codigo' => 2202406],
    		['id' => 718, 'nome' => "Capitão Gervásio Oliveira", 'uf' => "PI", 'codigo' => 2202455],
    		['id' => 719, 'nome' => "Caracol", 'uf' => "PI", 'codigo' => 2202505],
    		['id' => 720, 'nome' => "Caraúbas do Piauí", 'uf' => "PI", 'codigo' => 2202539],
    		['id' => 721, 'nome' => "Caridade do Piauí", 'uf' => "PI", 'codigo' => 2202554],
    		['id' => 722, 'nome' => "Castelo do Piauí", 'uf' => "PI", 'codigo' => 2202604],
    		['id' => 723, 'nome' => "Caxingó", 'uf' => "PI", 'codigo' => 2202653],
    		['id' => 724, 'nome' => "Cocal", 'uf' => "PI", 'codigo' => 2202703],
    		['id' => 725, 'nome' => "Cocal de Telha", 'uf' => "PI", 'codigo' => 2202711],
    		['id' => 726, 'nome' => "Cocal dos Alves", 'uf' => "PI", 'codigo' => 2202729],
    		['id' => 727, 'nome' => "Coivaras", 'uf' => "PI", 'codigo' => 2202737],
    		['id' => 728, 'nome' => "Colônia do Gurguéia", 'uf' => "PI", 'codigo' => 2202752],
    		['id' => 729, 'nome' => "Colônia do Piauí", 'uf' => "PI", 'codigo' => 2202778],
    		['id' => 730, 'nome' => "Conceição do Canindé", 'uf' => "PI", 'codigo' => 2202802],
    		['id' => 731, 'nome' => "Coronel José Dias", 'uf' => "PI", 'codigo' => 2202851],
    		['id' => 732, 'nome' => "Corrente", 'uf' => "PI", 'codigo' => 2202901],
    		['id' => 733, 'nome' => "Cristalândia do Piauí", 'uf' => "PI", 'codigo' => 2203008],
    		['id' => 734, 'nome' => "Cristino Castro", 'uf' => "PI", 'codigo' => 2203107],
    		['id' => 735, 'nome' => "Curimatá", 'uf' => "PI", 'codigo' => 2203206],
    		['id' => 736, 'nome' => "Currais", 'uf' => "PI", 'codigo' => 2203230],
    		['id' => 737, 'nome' => "Curralinhos", 'uf' => "PI", 'codigo' => 2203255],
    		['id' => 738, 'nome' => "Curral Novo do Piauí", 'uf' => "PI", 'codigo' => 2203271],
    		['id' => 739, 'nome' => "Demerval Lobão", 'uf' => "PI", 'codigo' => 2203305],
    		['id' => 740, 'nome' => "Dirceu Arcoverde", 'uf' => "PI", 'codigo' => 2203354],
    		['id' => 741, 'nome' => "Dom Expedito Lopes", 'uf' => "PI", 'codigo' => 2203404],
    		['id' => 742, 'nome' => "Domingos Mourão", 'uf' => "PI", 'codigo' => 2203420],
    		['id' => 743, 'nome' => "Dom Inocêncio", 'uf' => "PI", 'codigo' => 2203453],
    		['id' => 744, 'nome' => "Elesbão Veloso", 'uf' => "PI", 'codigo' => 2203503],
    		['id' => 745, 'nome' => "Eliseu Martins", 'uf' => "PI", 'codigo' => 2203602],
    		['id' => 746, 'nome' => "Esperantina", 'uf' => "PI", 'codigo' => 2203701],
    		['id' => 747, 'nome' => "Fartura do Piauí", 'uf' => "PI", 'codigo' => 2203750],
    		['id' => 748, 'nome' => "Flores do Piauí", 'uf' => "PI", 'codigo' => 2203800],
    		['id' => 749, 'nome' => "Floresta do Piauí", 'uf' => "PI", 'codigo' => 2203859],
    		['id' => 750, 'nome' => "Floriano", 'uf' => "PI", 'codigo' => 2203909],
    		['id' => 751, 'nome' => "Francinópolis", 'uf' => "PI", 'codigo' => 2204006],
    		['id' => 752, 'nome' => "Francisco Ayres", 'uf' => "PI", 'codigo' => 2204105],
    		['id' => 753, 'nome' => "Francisco Macedo", 'uf' => "PI", 'codigo' => 2204154],
    		['id' => 754, 'nome' => "Francisco Santos", 'uf' => "PI", 'codigo' => 2204204],
    		['id' => 755, 'nome' => "Fronteiras", 'uf' => "PI", 'codigo' => 2204303],
    		['id' => 756, 'nome' => "Geminiano", 'uf' => "PI", 'codigo' => 2204352],
    		['id' => 757, 'nome' => "Gilbués", 'uf' => "PI", 'codigo' => 2204402],
    		['id' => 758, 'nome' => "Guadalupe", 'uf' => "PI", 'codigo' => 2204501],
    		['id' => 759, 'nome' => "Guaribas", 'uf' => "PI", 'codigo' => 2204550],
    		['id' => 760, 'nome' => "Hugo Napoleão", 'uf' => "PI", 'codigo' => 2204600],
    		['id' => 761, 'nome' => "Ilha Grande", 'uf' => "PI", 'codigo' => 2204659],
    		['id' => 762, 'nome' => "Inhuma", 'uf' => "PI", 'codigo' => 2204709],
    		['id' => 763, 'nome' => "Ipiranga do Piauí", 'uf' => "PI", 'codigo' => 2204808],
    		['id' => 764, 'nome' => "Isaías Coelho", 'uf' => "PI", 'codigo' => 2204907],
    		['id' => 765, 'nome' => "Itainópolis", 'uf' => "PI", 'codigo' => 2205003],
    		['id' => 766, 'nome' => "Itaueira", 'uf' => "PI", 'codigo' => 2205102],
    		['id' => 767, 'nome' => "Jacobina do Piauí", 'uf' => "PI", 'codigo' => 2205151],
    		['id' => 768, 'nome' => "Jaicós", 'uf' => "PI", 'codigo' => 2205201],
    		['id' => 769, 'nome' => "Jardim do Mulato", 'uf' => "PI", 'codigo' => 2205250],
    		['id' => 770, 'nome' => "Jatobá do Piauí", 'uf' => "PI", 'codigo' => 2205276],
    		['id' => 771, 'nome' => "Jerumenha", 'uf' => "PI", 'codigo' => 2205300],
    		['id' => 772, 'nome' => "João Costa", 'uf' => "PI", 'codigo' => 2205359],
    		['id' => 773, 'nome' => "Joaquim Pires", 'uf' => "PI", 'codigo' => 2205409],
    		['id' => 774, 'nome' => "Joca Marques", 'uf' => "PI", 'codigo' => 2205458],
    		['id' => 775, 'nome' => "José de Freitas", 'uf' => "PI", 'codigo' => 2205508],
    		['id' => 776, 'nome' => "Juazeiro do Piauí", 'uf' => "PI", 'codigo' => 2205516],
    		['id' => 777, 'nome' => "Júlio Borges", 'uf' => "PI", 'codigo' => 2205524],
    		['id' => 778, 'nome' => "Jurema", 'uf' => "PI", 'codigo' => 2205532],
    		['id' => 779, 'nome' => "Lagoinha do Piauí", 'uf' => "PI", 'codigo' => 2205540],
    		['id' => 780, 'nome' => "Lagoa Alegre", 'uf' => "PI", 'codigo' => 2205557],
    		['id' => 781, 'nome' => "Lagoa do Barro do Piauí", 'uf' => "PI", 'codigo' => 2205565],
    		['id' => 782, 'nome' => "Lagoa de São Francisco", 'uf' => "PI", 'codigo' => 2205573],
    		['id' => 783, 'nome' => "Lagoa do Piauí", 'uf' => "PI", 'codigo' => 2205581],
    		['id' => 784, 'nome' => "Lagoa do Sítio", 'uf' => "PI", 'codigo' => 2205599],
    		['id' => 785, 'nome' => "Landri Sales", 'uf' => "PI", 'codigo' => 2205607],
    		['id' => 786, 'nome' => "Luís Correia", 'uf' => "PI", 'codigo' => 2205706],
    		['id' => 787, 'nome' => "Luzilândia", 'uf' => "PI", 'codigo' => 2205805],
    		['id' => 788, 'nome' => "Madeiro", 'uf' => "PI", 'codigo' => 2205854],
    		['id' => 789, 'nome' => "Manoel Emídio", 'uf' => "PI", 'codigo' => 2205904],
    		['id' => 790, 'nome' => "Marcolândia", 'uf' => "PI", 'codigo' => 2205953],
    		['id' => 791, 'nome' => "Marcos Parente", 'uf' => "PI", 'codigo' => 2206001],
    		['id' => 792, 'nome' => "Massapê do Piauí", 'uf' => "PI", 'codigo' => 2206050],
    		['id' => 793, 'nome' => "Matias Olímpio", 'uf' => "PI", 'codigo' => 2206100],
    		['id' => 794, 'nome' => "Miguel Alves", 'uf' => "PI", 'codigo' => 2206209],
    		['id' => 795, 'nome' => "Miguel Leão", 'uf' => "PI", 'codigo' => 2206308],
    		['id' => 796, 'nome' => "Milton Brandão", 'uf' => "PI", 'codigo' => 2206357],
    		['id' => 797, 'nome' => "Monsenhor Gil", 'uf' => "PI", 'codigo' => 2206407],
    		['id' => 798, 'nome' => "Monsenhor Hipólito", 'uf' => "PI", 'codigo' => 2206506],
    		['id' => 799, 'nome' => "Monte Alegre do Piauí", 'uf' => "PI", 'codigo' => 2206605],
    		['id' => 800, 'nome' => "Morro Cabeça no Tempo", 'uf' => "PI", 'codigo' => 2206654],
    		['id' => 801, 'nome' => "Morro do Chapéu do Piauí", 'uf' => "PI", 'codigo' => 2206670],
    		['id' => 802, 'nome' => "Murici dos Portelas", 'uf' => "PI", 'codigo' => 2206696],
    		['id' => 803, 'nome' => "Nazaré do Piauí", 'uf' => "PI", 'codigo' => 2206704],
    		['id' => 804, 'nome' => "Nazária", 'uf' => "PI", 'codigo' => 2206720],
    		['id' => 805, 'nome' => "Nossa Senhora de Nazaré", 'uf' => "PI", 'codigo' => 2206753],
    		['id' => 806, 'nome' => "Nossa Senhora dos Remédios", 'uf' => "PI", 'codigo' => 2206803],
    		['id' => 807, 'nome' => "Novo Oriente do Piauí", 'uf' => "PI", 'codigo' => 2206902],
    		['id' => 808, 'nome' => "Novo Santo Antônio", 'uf' => "PI", 'codigo' => 2206951],
    		['id' => 809, 'nome' => "Oeiras", 'uf' => "PI", 'codigo' => 2207009],
    		['id' => 810, 'nome' => "Olho D'Água do Piauí", 'uf' => "PI", 'codigo' => 2207108],
    		['id' => 811, 'nome' => "Padre Marcos", 'uf' => "PI", 'codigo' => 2207207],
    		['id' => 812, 'nome' => "Paes Landim", 'uf' => "PI", 'codigo' => 2207306],
    		['id' => 813, 'nome' => "Pajeú do Piauí", 'uf' => "PI", 'codigo' => 2207355],
    		['id' => 814, 'nome' => "Palmeira do Piauí", 'uf' => "PI", 'codigo' => 2207405],
    		['id' => 815, 'nome' => "Palmeirais", 'uf' => "PI", 'codigo' => 2207504],
    		['id' => 816, 'nome' => "Paquetá", 'uf' => "PI", 'codigo' => 2207553],
    		['id' => 817, 'nome' => "Parnaguá", 'uf' => "PI", 'codigo' => 2207603],
    		['id' => 818, 'nome' => "Parnaíba", 'uf' => "PI", 'codigo' => 2207702],
    		['id' => 819, 'nome' => "Passagem Franca do Piauí", 'uf' => "PI", 'codigo' => 2207751],
    		['id' => 820, 'nome' => "Patos do Piauí", 'uf' => "PI", 'codigo' => 2207777],
    		['id' => 821, 'nome' => "Pau D'Arco do Piauí", 'uf' => "PI", 'codigo' => 2207793],
    		['id' => 822, 'nome' => "Paulistana", 'uf' => "PI", 'codigo' => 2207801],
    		['id' => 823, 'nome' => "Pavussu", 'uf' => "PI", 'codigo' => 2207850],
    		['id' => 824, 'nome' => "Pedro II", 'uf' => "PI", 'codigo' => 2207900],
    		['id' => 825, 'nome' => "Pedro Laurentino", 'uf' => "PI", 'codigo' => 2207934],
    		['id' => 826, 'nome' => "Nova Santa Rita", 'uf' => "PI", 'codigo' => 2207959],
    		['id' => 827, 'nome' => "Picos", 'uf' => "PI", 'codigo' => 2208007],
    		['id' => 828, 'nome' => "Pimenteiras", 'uf' => "PI", 'codigo' => 2208106],
    		['id' => 829, 'nome' => "Pio IX", 'uf' => "PI", 'codigo' => 2208205],
    		['id' => 830, 'nome' => "Piracuruca", 'uf' => "PI", 'codigo' => 2208304],
    		['id' => 831, 'nome' => "Piripiri", 'uf' => "PI", 'codigo' => 2208403],
    		['id' => 832, 'nome' => "Porto", 'uf' => "PI", 'codigo' => 2208502],
    		['id' => 833, 'nome' => "Porto Alegre do Piauí", 'uf' => "PI", 'codigo' => 2208551],
    		['id' => 834, 'nome' => "Prata do Piauí", 'uf' => "PI", 'codigo' => 2208601],
    		['id' => 835, 'nome' => "Queimada Nova", 'uf' => "PI", 'codigo' => 2208650],
    		['id' => 836, 'nome' => "Redenção do Gurguéia", 'uf' => "PI", 'codigo' => 2208700],
    		['id' => 837, 'nome' => "Regeneração", 'uf' => "PI", 'codigo' => 2208809],
    		['id' => 838, 'nome' => "Riacho Frio", 'uf' => "PI", 'codigo' => 2208858],
    		['id' => 839, 'nome' => "Ribeira do Piauí", 'uf' => "PI", 'codigo' => 2208874],
    		['id' => 840, 'nome' => "Ribeiro Gonçalves", 'uf' => "PI", 'codigo' => 2208908],
    		['id' => 841, 'nome' => "Rio Grande do Piauí", 'uf' => "PI", 'codigo' => 2209005],
    		['id' => 842, 'nome' => "Santa Cruz do Piauí", 'uf' => "PI", 'codigo' => 2209104],
    		['id' => 843, 'nome' => "Santa Cruz dos Milagres", 'uf' => "PI", 'codigo' => 2209153],
    		['id' => 844, 'nome' => "Santa Filomena", 'uf' => "PI", 'codigo' => 2209203],
    		['id' => 845, 'nome' => "Santa Luz", 'uf' => "PI", 'codigo' => 2209302],
    		['id' => 846, 'nome' => "Santana do Piauí", 'uf' => "PI", 'codigo' => 2209351],
    		['id' => 847, 'nome' => "Santa Rosa do Piauí", 'uf' => "PI", 'codigo' => 2209377],
    		['id' => 848, 'nome' => "Santo Antônio de Lisboa", 'uf' => "PI", 'codigo' => 2209401],
    		['id' => 849, 'nome' => "Santo Antônio dos Milagres", 'uf' => "PI", 'codigo' => 2209450],
    		['id' => 850, 'nome' => "Santo Inácio do Piauí", 'uf' => "PI", 'codigo' => 2209500],
    		['id' => 851, 'nome' => "São Braz do Piauí", 'uf' => "PI", 'codigo' => 2209559],
    		['id' => 852, 'nome' => "São Félix do Piauí", 'uf' => "PI", 'codigo' => 2209609],
    		['id' => 853, 'nome' => "São Francisco de Assis do Piauí", 'uf' => "PI", 'codigo' => 2209658],
    		['id' => 854, 'nome' => "São Francisco do Piauí", 'uf' => "PI", 'codigo' => 2209708],
    		['id' => 855, 'nome' => "São Gonçalo do Gurguéia", 'uf' => "PI", 'codigo' => 2209757],
    		['id' => 856, 'nome' => "São Gonçalo do Piauí", 'uf' => "PI", 'codigo' => 2209807],
    		['id' => 857, 'nome' => "São João da Canabrava", 'uf' => "PI", 'codigo' => 2209856],
    		['id' => 858, 'nome' => "São João da Fronteira", 'uf' => "PI", 'codigo' => 2209872],
    		['id' => 859, 'nome' => "São João da Serra", 'uf' => "PI", 'codigo' => 2209906],
    		['id' => 860, 'nome' => "São João da Varjota", 'uf' => "PI", 'codigo' => 2209955],
    		['id' => 861, 'nome' => "São João do Arraial", 'uf' => "PI", 'codigo' => 2209971],
    		['id' => 862, 'nome' => "São João do Piauí", 'uf' => "PI", 'codigo' => 2210003],
    		['id' => 863, 'nome' => "São José do Divino", 'uf' => "PI", 'codigo' => 2210052],
    		['id' => 864, 'nome' => "São José do Peixe", 'uf' => "PI", 'codigo' => 2210102],
    		['id' => 865, 'nome' => "São José do Piauí", 'uf' => "PI", 'codigo' => 2210201],
    		['id' => 866, 'nome' => "São Julião", 'uf' => "PI", 'codigo' => 2210300],
    		['id' => 867, 'nome' => "São Lourenço do Piauí", 'uf' => "PI", 'codigo' => 2210359],
    		['id' => 868, 'nome' => "São Luis do Piauí", 'uf' => "PI", 'codigo' => 2210375],
    		['id' => 869, 'nome' => "São Miguel da Baixa Grande", 'uf' => "PI", 'codigo' => 2210383],
    		['id' => 870, 'nome' => "São Miguel do Fidalgo", 'uf' => "PI", 'codigo' => 2210391],
    		['id' => 871, 'nome' => "São Miguel do Tapuio", 'uf' => "PI", 'codigo' => 2210409],
    		['id' => 872, 'nome' => "São Pedro do Piauí", 'uf' => "PI", 'codigo' => 2210508],
    		['id' => 873, 'nome' => "São Raimundo Nonato", 'uf' => "PI", 'codigo' => 2210607],
    		['id' => 874, 'nome' => "Sebastião Barros", 'uf' => "PI", 'codigo' => 2210623],
    		['id' => 875, 'nome' => "Sebastião Leal", 'uf' => "PI", 'codigo' => 2210631],
    		['id' => 876, 'nome' => "Sigefredo Pacheco", 'uf' => "PI", 'codigo' => 2210656],
    		['id' => 877, 'nome' => "Simões", 'uf' => "PI", 'codigo' => 2210706],
    		['id' => 878, 'nome' => "Simplício Mendes", 'uf' => "PI", 'codigo' => 2210805],
    		['id' => 879, 'nome' => "Socorro do Piauí", 'uf' => "PI", 'codigo' => 2210904],
    		['id' => 880, 'nome' => "Sussuapara", 'uf' => "PI", 'codigo' => 2210938],
    		['id' => 881, 'nome' => "Tamboril do Piauí", 'uf' => "PI", 'codigo' => 2210953],
    		['id' => 882, 'nome' => "Tanque do Piauí", 'uf' => "PI", 'codigo' => 2210979],
    		['id' => 883, 'nome' => "Teresina", 'uf' => "PI", 'codigo' => 2211001],
    		['id' => 884, 'nome' => "União", 'uf' => "PI", 'codigo' => 2211100],
    		['id' => 885, 'nome' => "Uruçuí", 'uf' => "PI", 'codigo' => 2211209],
    		['id' => 886, 'nome' => "Valença do Piauí", 'uf' => "PI", 'codigo' => 2211308],
    		['id' => 887, 'nome' => "Várzea Branca", 'uf' => "PI", 'codigo' => 2211357],
    		['id' => 888, 'nome' => "Várzea Grande", 'uf' => "PI", 'codigo' => 2211407],
    		['id' => 889, 'nome' => "Vera Mendes", 'uf' => "PI", 'codigo' => 2211506],
    		['id' => 890, 'nome' => "Vila Nova do Piauí", 'uf' => "PI", 'codigo' => 2211605],
    		['id' => 891, 'nome' => "Wall Ferraz", 'uf' => "PI", 'codigo' => 2211704],
    		['id' => 892, 'nome' => "Abaiara", 'uf' => "CE", 'codigo' => 2300101],
    		['id' => 893, 'nome' => "Acarape", 'uf' => "CE", 'codigo' => 2300150],
    		['id' => 894, 'nome' => "Acaraú", 'uf' => "CE", 'codigo' => 2300200],
    		['id' => 895, 'nome' => "Acopiara", 'uf' => "CE", 'codigo' => 2300309],
    		['id' => 896, 'nome' => "Aiuaba", 'uf' => "CE", 'codigo' => 2300408],
    		['id' => 897, 'nome' => "Alcântaras", 'uf' => "CE", 'codigo' => 2300507],
    		['id' => 898, 'nome' => "Altaneira", 'uf' => "CE", 'codigo' => 2300606],
    		['id' => 899, 'nome' => "Alto Santo", 'uf' => "CE", 'codigo' => 2300705],
    		['id' => 900, 'nome' => "Amontada", 'uf' => "CE", 'codigo' => 2300754],
    		['id' => 901, 'nome' => "Antonina do Norte", 'uf' => "CE", 'codigo' => 2300804],
    		['id' => 902, 'nome' => "Apuiarés", 'uf' => "CE", 'codigo' => 2300903],
    		['id' => 903, 'nome' => "Aquiraz", 'uf' => "CE", 'codigo' => 2301000],
    		['id' => 904, 'nome' => "Aracati", 'uf' => "CE", 'codigo' => 2301109],
    		['id' => 905, 'nome' => "Aracoiaba", 'uf' => "CE", 'codigo' => 2301208],
    		['id' => 906, 'nome' => "Ararendá", 'uf' => "CE", 'codigo' => 2301257],
    		['id' => 907, 'nome' => "Araripe", 'uf' => "CE", 'codigo' => 2301307],
    		['id' => 908, 'nome' => "Aratuba", 'uf' => "CE", 'codigo' => 2301406],
    		['id' => 909, 'nome' => "Arneiroz", 'uf' => "CE", 'codigo' => 2301505],
    		['id' => 910, 'nome' => "Assaré", 'uf' => "CE", 'codigo' => 2301604],
    		['id' => 911, 'nome' => "Aurora", 'uf' => "CE", 'codigo' => 2301703],
    		['id' => 912, 'nome' => "Baixio", 'uf' => "CE", 'codigo' => 2301802],
    		['id' => 913, 'nome' => "Banabuiú", 'uf' => "CE", 'codigo' => 2301851],
    		['id' => 914, 'nome' => "Barbalha", 'uf' => "CE", 'codigo' => 2301901],
    		['id' => 915, 'nome' => "Barreira", 'uf' => "CE", 'codigo' => 2301950],
    		['id' => 916, 'nome' => "Barro", 'uf' => "CE", 'codigo' => 2302008],
    		['id' => 917, 'nome' => "Barroquinha", 'uf' => "CE", 'codigo' => 2302057],
    		['id' => 918, 'nome' => "Baturité", 'uf' => "CE", 'codigo' => 2302107],
    		['id' => 919, 'nome' => "Beberibe", 'uf' => "CE", 'codigo' => 2302206],
    		['id' => 920, 'nome' => "Bela Cruz", 'uf' => "CE", 'codigo' => 2302305],
    		['id' => 921, 'nome' => "Boa Viagem", 'uf' => "CE", 'codigo' => 2302404],
    		['id' => 922, 'nome' => "Brejo Santo", 'uf' => "CE", 'codigo' => 2302503],
    		['id' => 923, 'nome' => "Camocim", 'uf' => "CE", 'codigo' => 2302602],
    		['id' => 924, 'nome' => "Campos Sales", 'uf' => "CE", 'codigo' => 2302701],
    		['id' => 925, 'nome' => "Canindé", 'uf' => "CE", 'codigo' => 2302800],
    		['id' => 926, 'nome' => "Capistrano", 'uf' => "CE", 'codigo' => 2302909],
    		['id' => 927, 'nome' => "Caridade", 'uf' => "CE", 'codigo' => 2303006],
    		['id' => 928, 'nome' => "Cariré", 'uf' => "CE", 'codigo' => 2303105],
    		['id' => 929, 'nome' => "Caririaçu", 'uf' => "CE", 'codigo' => 2303204],
    		['id' => 930, 'nome' => "Cariús", 'uf' => "CE", 'codigo' => 2303303],
    		['id' => 931, 'nome' => "Carnaubal", 'uf' => "CE", 'codigo' => 2303402],
    		['id' => 932, 'nome' => "Cascavel", 'uf' => "CE", 'codigo' => 2303501],
    		['id' => 933, 'nome' => "Catarina", 'uf' => "CE", 'codigo' => 2303600],
    		['id' => 934, 'nome' => "Catunda", 'uf' => "CE", 'codigo' => 2303659],
    		['id' => 935, 'nome' => "Caucaia", 'uf' => "CE", 'codigo' => 2303709],
    		['id' => 936, 'nome' => "Cedro", 'uf' => "CE", 'codigo' => 2303808],
    		['id' => 937, 'nome' => "Chaval", 'uf' => "CE", 'codigo' => 2303907],
    		['id' => 938, 'nome' => "Choró", 'uf' => "CE", 'codigo' => 2303931],
    		['id' => 939, 'nome' => "Chorozinho", 'uf' => "CE", 'codigo' => 2303956],
    		['id' => 940, 'nome' => "Coreaú", 'uf' => "CE", 'codigo' => 2304004],
    		['id' => 941, 'nome' => "Crateús", 'uf' => "CE", 'codigo' => 2304103],
    		['id' => 942, 'nome' => "Crato", 'uf' => "CE", 'codigo' => 2304202],
    		['id' => 943, 'nome' => "Croatá", 'uf' => "CE", 'codigo' => 2304236],
    		['id' => 944, 'nome' => "Cruz", 'uf' => "CE", 'codigo' => 2304251],
    		['id' => 945, 'nome' => "Deputado Irapuan Pinheiro", 'uf' => "CE", 'codigo' => 2304269],
    		['id' => 946, 'nome' => "Ererê", 'uf' => "CE", 'codigo' => 2304277],
    		['id' => 947, 'nome' => "Eusébio", 'uf' => "CE", 'codigo' => 2304285],
    		['id' => 948, 'nome' => "Farias Brito", 'uf' => "CE", 'codigo' => 2304301],
    		['id' => 949, 'nome' => "Forquilha", 'uf' => "CE", 'codigo' => 2304350],
    		['id' => 950, 'nome' => "Fortaleza", 'uf' => "CE", 'codigo' => 2304400],
    		['id' => 951, 'nome' => "Fortim", 'uf' => "CE", 'codigo' => 2304459],
    		['id' => 952, 'nome' => "Frecheirinha", 'uf' => "CE", 'codigo' => 2304509],
    		['id' => 953, 'nome' => "General Sampaio", 'uf' => "CE", 'codigo' => 2304608],
    		['id' => 954, 'nome' => "Graça", 'uf' => "CE", 'codigo' => 2304657],
    		['id' => 955, 'nome' => "Granja", 'uf' => "CE", 'codigo' => 2304707],
    		['id' => 956, 'nome' => "Granjeiro", 'uf' => "CE", 'codigo' => 2304806],
    		['id' => 957, 'nome' => "Groaíras", 'uf' => "CE", 'codigo' => 2304905],
    		['id' => 958, 'nome' => "Guaiúba", 'uf' => "CE", 'codigo' => 2304954],
    		['id' => 959, 'nome' => "Guaraciaba do Norte", 'uf' => "CE", 'codigo' => 2305001],
    		['id' => 960, 'nome' => "Guaramiranga", 'uf' => "CE", 'codigo' => 2305100],
    		['id' => 961, 'nome' => "Hidrolândia", 'uf' => "CE", 'codigo' => 2305209],
    		['id' => 962, 'nome' => "Horizonte", 'uf' => "CE", 'codigo' => 2305233],
    		['id' => 963, 'nome' => "Ibaretama", 'uf' => "CE", 'codigo' => 2305266],
    		['id' => 964, 'nome' => "Ibiapina", 'uf' => "CE", 'codigo' => 2305308],
    		['id' => 965, 'nome' => "Ibicuitinga", 'uf' => "CE", 'codigo' => 2305332],
    		['id' => 966, 'nome' => "Icapuí", 'uf' => "CE", 'codigo' => 2305357],
    		['id' => 967, 'nome' => "Icó", 'uf' => "CE", 'codigo' => 2305407],
    		['id' => 968, 'nome' => "Iguatu", 'uf' => "CE", 'codigo' => 2305506],
    		['id' => 969, 'nome' => "Independência", 'uf' => "CE", 'codigo' => 2305605],
    		['id' => 970, 'nome' => "Ipaporanga", 'uf' => "CE", 'codigo' => 2305654],
    		['id' => 971, 'nome' => "Ipaumirim", 'uf' => "CE", 'codigo' => 2305704],
    		['id' => 972, 'nome' => "Ipu", 'uf' => "CE", 'codigo' => 2305803],
    		['id' => 973, 'nome' => "Ipueiras", 'uf' => "CE", 'codigo' => 2305902],
    		['id' => 974, 'nome' => "Iracema", 'uf' => "CE", 'codigo' => 2306009],
    		['id' => 975, 'nome' => "Irauçuba", 'uf' => "CE", 'codigo' => 2306108],
    		['id' => 976, 'nome' => "Itaiçaba", 'uf' => "CE", 'codigo' => 2306207],
    		['id' => 977, 'nome' => "Itaitinga", 'uf' => "CE", 'codigo' => 2306256],
    		['id' => 978, 'nome' => "Itapagé", 'uf' => "CE", 'codigo' => 2306306],
    		['id' => 979, 'nome' => "Itapipoca", 'uf' => "CE", 'codigo' => 2306405],
    		['id' => 980, 'nome' => "Itapiúna", 'uf' => "CE", 'codigo' => 2306504],
    		['id' => 981, 'nome' => "Itarema", 'uf' => "CE", 'codigo' => 2306553],
    		['id' => 982, 'nome' => "Itatira", 'uf' => "CE", 'codigo' => 2306603],
    		['id' => 983, 'nome' => "Jaguaretama", 'uf' => "CE", 'codigo' => 2306702],
    		['id' => 984, 'nome' => "Jaguaribara", 'uf' => "CE", 'codigo' => 2306801],
    		['id' => 985, 'nome' => "Jaguaribe", 'uf' => "CE", 'codigo' => 2306900],
    		['id' => 986, 'nome' => "Jaguaruana", 'uf' => "CE", 'codigo' => 2307007],
    		['id' => 987, 'nome' => "Jardim", 'uf' => "CE", 'codigo' => 2307106],
    		['id' => 988, 'nome' => "Jati", 'uf' => "CE", 'codigo' => 2307205],
    		['id' => 989, 'nome' => "Jijoca de Jericoacoara", 'uf' => "CE", 'codigo' => 2307254],
    		['id' => 990, 'nome' => "Juazeiro do Norte", 'uf' => "CE", 'codigo' => 2307304],
    		['id' => 991, 'nome' => "Jucás", 'uf' => "CE", 'codigo' => 2307403],
    		['id' => 992, 'nome' => "Lavras da Mangabeira", 'uf' => "CE", 'codigo' => 2307502],
    		['id' => 993, 'nome' => "Limoeiro do Norte", 'uf' => "CE", 'codigo' => 2307601],
    		['id' => 994, 'nome' => "Madalena", 'uf' => "CE", 'codigo' => 2307635],
    		['id' => 995, 'nome' => "Maracanaú", 'uf' => "CE", 'codigo' => 2307650],
    		['id' => 996, 'nome' => "Maranguape", 'uf' => "CE", 'codigo' => 2307700],
    		['id' => 997, 'nome' => "Marco", 'uf' => "CE", 'codigo' => 2307809],
    		['id' => 998, 'nome' => "Martinópole", 'uf' => "CE", 'codigo' => 2307908],
    		['id' => 999, 'nome' => "Massapê", 'uf' => "CE", 'codigo' => 2308005],
    		['id' => 1000, 'nome' => "Mauriti", 'uf' => "CE", 'codigo' => 2308104],
    		['id' => 1001, 'nome' => "Meruoca", 'uf' => "CE", 'codigo' => 2308203],
    		['id' => 1002, 'nome' => "Milagres", 'uf' => "CE", 'codigo' => 2308302],
    		['id' => 1003, 'nome' => "Milhã", 'uf' => "CE", 'codigo' => 2308351],
    		['id' => 1004, 'nome' => "Miraíma", 'uf' => "CE", 'codigo' => 2308377],
    		['id' => 1005, 'nome' => "Missão Velha", 'uf' => "CE", 'codigo' => 2308401],
    		['id' => 1006, 'nome' => "Mombaça", 'uf' => "CE", 'codigo' => 2308500],
    		['id' => 1007, 'nome' => "Monsenhor Tabosa", 'uf' => "CE", 'codigo' => 2308609],
    		['id' => 1008, 'nome' => "Morada Nova", 'uf' => "CE", 'codigo' => 2308708],
    		['id' => 1009, 'nome' => "Moraújo", 'uf' => "CE", 'codigo' => 2308807],
    		['id' => 1010, 'nome' => "Morrinhos", 'uf' => "CE", 'codigo' => 2308906],
    		['id' => 1011, 'nome' => "Mucambo", 'uf' => "CE", 'codigo' => 2309003],
    		['id' => 1012, 'nome' => "Mulungu", 'uf' => "CE", 'codigo' => 2309102],
    		['id' => 1013, 'nome' => "Nova Olinda", 'uf' => "CE", 'codigo' => 2309201],
    		['id' => 1014, 'nome' => "Nova Russas", 'uf' => "CE", 'codigo' => 2309300],
    		['id' => 1015, 'nome' => "Novo Oriente", 'uf' => "CE", 'codigo' => 2309409],
    		['id' => 1016, 'nome' => "Ocara", 'uf' => "CE", 'codigo' => 2309458],
    		['id' => 1017, 'nome' => "Orós", 'uf' => "CE", 'codigo' => 2309508],
    		['id' => 1018, 'nome' => "Pacajus", 'uf' => "CE", 'codigo' => 2309607],
    		['id' => 1019, 'nome' => "Pacatuba", 'uf' => "CE", 'codigo' => 2309706],
    		['id' => 1020, 'nome' => "Pacoti", 'uf' => "CE", 'codigo' => 2309805],
    		['id' => 1021, 'nome' => "Pacujá", 'uf' => "CE", 'codigo' => 2309904],
    		['id' => 1022, 'nome' => "Palhano", 'uf' => "CE", 'codigo' => 2310001],
    		['id' => 1023, 'nome' => "Palmácia", 'uf' => "CE", 'codigo' => 2310100],
    		['id' => 1024, 'nome' => "Paracuru", 'uf' => "CE", 'codigo' => 2310209],
    		['id' => 1025, 'nome' => "Paraipaba", 'uf' => "CE", 'codigo' => 2310258],
    		['id' => 1026, 'nome' => "Parambu", 'uf' => "CE", 'codigo' => 2310308],
    		['id' => 1027, 'nome' => "Paramoti", 'uf' => "CE", 'codigo' => 2310407],
    		['id' => 1028, 'nome' => "Pedra Branca", 'uf' => "CE", 'codigo' => 2310506],
    		['id' => 1029, 'nome' => "Penaforte", 'uf' => "CE", 'codigo' => 2310605],
    		['id' => 1030, 'nome' => "Pentecoste", 'uf' => "CE", 'codigo' => 2310704],
    		['id' => 1031, 'nome' => "Pereiro", 'uf' => "CE", 'codigo' => 2310803],
    		['id' => 1032, 'nome' => "Pindoretama", 'uf' => "CE", 'codigo' => 2310852],
    		['id' => 1033, 'nome' => "Piquet Carneiro", 'uf' => "CE", 'codigo' => 2310902],
    		['id' => 1034, 'nome' => "Pires Ferreira", 'uf' => "CE", 'codigo' => 2310951],
    		['id' => 1035, 'nome' => "Poranga", 'uf' => "CE", 'codigo' => 2311009],
    		['id' => 1036, 'nome' => "Porteiras", 'uf' => "CE", 'codigo' => 2311108],
    		['id' => 1037, 'nome' => "Potengi", 'uf' => "CE", 'codigo' => 2311207],
    		['id' => 1038, 'nome' => "Potiretama", 'uf' => "CE", 'codigo' => 2311231],
    		['id' => 1039, 'nome' => "Quiterianópolis", 'uf' => "CE", 'codigo' => 2311264],
    		['id' => 1040, 'nome' => "Quixadá", 'uf' => "CE", 'codigo' => 2311306],
    		['id' => 1041, 'nome' => "Quixelô", 'uf' => "CE", 'codigo' => 2311355],
    		['id' => 1042, 'nome' => "Quixeramobim", 'uf' => "CE", 'codigo' => 2311405],
    		['id' => 1043, 'nome' => "Quixeré", 'uf' => "CE", 'codigo' => 2311504],
    		['id' => 1044, 'nome' => "Redenção", 'uf' => "CE", 'codigo' => 2311603],
    		['id' => 1045, 'nome' => "Reriutaba", 'uf' => "CE", 'codigo' => 2311702],
    		['id' => 1046, 'nome' => "Russas", 'uf' => "CE", 'codigo' => 2311801],
    		['id' => 1047, 'nome' => "Saboeiro", 'uf' => "CE", 'codigo' => 2311900],
    		['id' => 1048, 'nome' => "Salitre", 'uf' => "CE", 'codigo' => 2311959],
    		['id' => 1049, 'nome' => "Santana do Acaraú", 'uf' => "CE", 'codigo' => 2312007],
    		['id' => 1050, 'nome' => "Santana do Cariri", 'uf' => "CE", 'codigo' => 2312106],
    		['id' => 1051, 'nome' => "Santa Quitéria", 'uf' => "CE", 'codigo' => 2312205],
    		['id' => 1052, 'nome' => "São Benedito", 'uf' => "CE", 'codigo' => 2312304],
    		['id' => 1053, 'nome' => "São Gonçalo do Amarante", 'uf' => "CE", 'codigo' => 2312403],
    		['id' => 1054, 'nome' => "São João do Jaguaribe", 'uf' => "CE", 'codigo' => 2312502],
    		['id' => 1055, 'nome' => "São Luís do Curu", 'uf' => "CE", 'codigo' => 2312601],
    		['id' => 1056, 'nome' => "Senador Pompeu", 'uf' => "CE", 'codigo' => 2312700],
    		['id' => 1057, 'nome' => "Senador Sá", 'uf' => "CE", 'codigo' => 2312809],
    		['id' => 1058, 'nome' => "Sobral", 'uf' => "CE", 'codigo' => 2312908],
    		['id' => 1059, 'nome' => "Solonópole", 'uf' => "CE", 'codigo' => 2313005],
    		['id' => 1060, 'nome' => "Tabuleiro do Norte", 'uf' => "CE", 'codigo' => 2313104],
    		['id' => 1061, 'nome' => "Tamboril", 'uf' => "CE", 'codigo' => 2313203],
    		['id' => 1062, 'nome' => "Tarrafas", 'uf' => "CE", 'codigo' => 2313252],
    		['id' => 1063, 'nome' => "Tauá", 'uf' => "CE", 'codigo' => 2313302],
    		['id' => 1064, 'nome' => "Tejuçuoca", 'uf' => "CE", 'codigo' => 2313351],
    		['id' => 1065, 'nome' => "Tianguá", 'uf' => "CE", 'codigo' => 2313401],
    		['id' => 1066, 'nome' => "Trairi", 'uf' => "CE", 'codigo' => 2313500],
    		['id' => 1067, 'nome' => "Tururu", 'uf' => "CE", 'codigo' => 2313559],
    		['id' => 1068, 'nome' => "Ubajara", 'uf' => "CE", 'codigo' => 2313609],
    		['id' => 1069, 'nome' => "Umari", 'uf' => "CE", 'codigo' => 2313708],
    		['id' => 1070, 'nome' => "Umirim", 'uf' => "CE", 'codigo' => 2313757],
    		['id' => 1071, 'nome' => "Uruburetama", 'uf' => "CE", 'codigo' => 2313807],
    		['id' => 1072, 'nome' => "Uruoca", 'uf' => "CE", 'codigo' => 2313906],
    		['id' => 1073, 'nome' => "Varjota", 'uf' => "CE", 'codigo' => 2313955],
    		['id' => 1074, 'nome' => "Várzea Alegre", 'uf' => "CE", 'codigo' => 2314003],
    		['id' => 1075, 'nome' => "Viçosa do Ceará", 'uf' => "CE", 'codigo' => 2314102],
    		['id' => 1076, 'nome' => "Acari", 'uf' => "RN", 'codigo' => 2400109],
    		['id' => 1077, 'nome' => "Açu", 'uf' => "RN", 'codigo' => 2400208],
    		['id' => 1078, 'nome' => "Afonso Bezerra", 'uf' => "RN", 'codigo' => 2400307],
    		['id' => 1079, 'nome' => "Água Nova", 'uf' => "RN", 'codigo' => 2400406],
    		['id' => 1080, 'nome' => "Alexandria", 'uf' => "RN", 'codigo' => 2400505],
    		['id' => 1081, 'nome' => "Almino Afonso", 'uf' => "RN", 'codigo' => 2400604],
    		['id' => 1082, 'nome' => "Alto do Rodrigues", 'uf' => "RN", 'codigo' => 2400703],
    		['id' => 1083, 'nome' => "Angicos", 'uf' => "RN", 'codigo' => 2400802],
    		['id' => 1084, 'nome' => "Antônio Martins", 'uf' => "RN", 'codigo' => 2400901],
    		['id' => 1085, 'nome' => "Apodi", 'uf' => "RN", 'codigo' => 2401008],
    		['id' => 1086, 'nome' => "Areia Branca", 'uf' => "RN", 'codigo' => 2401107],
    		['id' => 1087, 'nome' => "Arês", 'uf' => "RN", 'codigo' => 2401206],
    		['id' => 1088, 'nome' => "Augusto Severo", 'uf' => "RN", 'codigo' => 2401305],
    		['id' => 1089, 'nome' => "Baía Formosa", 'uf' => "RN", 'codigo' => 2401404],
    		['id' => 1090, 'nome' => "Baraúna", 'uf' => "RN", 'codigo' => 2401453],
    		['id' => 1091, 'nome' => "Barcelona", 'uf' => "RN", 'codigo' => 2401503],
    		['id' => 1092, 'nome' => "Bento Fernandes", 'uf' => "RN", 'codigo' => 2401602],
    		['id' => 1093, 'nome' => "Bodó", 'uf' => "RN", 'codigo' => 2401651],
    		['id' => 1094, 'nome' => "Bom Jesus", 'uf' => "RN", 'codigo' => 2401701],
    		['id' => 1095, 'nome' => "Brejinho", 'uf' => "RN", 'codigo' => 2401800],
    		['id' => 1096, 'nome' => "Caiçara do Norte", 'uf' => "RN", 'codigo' => 2401859],
    		['id' => 1097, 'nome' => "Caiçara do Rio do Vento", 'uf' => "RN", 'codigo' => 2401909],
    		['id' => 1098, 'nome' => "Caicó", 'uf' => "RN", 'codigo' => 2402006],
    		['id' => 1099, 'nome' => "Campo Redondo", 'uf' => "RN", 'codigo' => 2402105],
    		['id' => 1100, 'nome' => "Canguaretama", 'uf' => "RN", 'codigo' => 2402204],
    		['id' => 1101, 'nome' => "Caraúbas", 'uf' => "RN", 'codigo' => 2402303],
    		['id' => 1102, 'nome' => "Carnaúba dos Dantas", 'uf' => "RN", 'codigo' => 2402402],
    		['id' => 1103, 'nome' => "Carnaubais", 'uf' => "RN", 'codigo' => 2402501],
    		['id' => 1104, 'nome' => "Ceará-Mirim", 'uf' => "RN", 'codigo' => 2402600],
    		['id' => 1105, 'nome' => "Cerro Corá", 'uf' => "RN", 'codigo' => 2402709],
    		['id' => 1106, 'nome' => "Coronel Ezequiel", 'uf' => "RN", 'codigo' => 2402808],
    		['id' => 1107, 'nome' => "Coronel João Pessoa", 'uf' => "RN", 'codigo' => 2402907],
    		['id' => 1108, 'nome' => "Cruzeta", 'uf' => "RN", 'codigo' => 2403004],
    		['id' => 1109, 'nome' => "Currais Novos", 'uf' => "RN", 'codigo' => 2403103],
    		['id' => 1110, 'nome' => "Doutor Severiano", 'uf' => "RN", 'codigo' => 2403202],
    		['id' => 1111, 'nome' => "Parnamirim", 'uf' => "RN", 'codigo' => 2403251],
    		['id' => 1112, 'nome' => "Encanto", 'uf' => "RN", 'codigo' => 2403301],
    		['id' => 1113, 'nome' => "Equador", 'uf' => "RN", 'codigo' => 2403400],
    		['id' => 1114, 'nome' => "Espírito Santo", 'uf' => "RN", 'codigo' => 2403509],
    		['id' => 1115, 'nome' => "Extremoz", 'uf' => "RN", 'codigo' => 2403608],
    		['id' => 1116, 'nome' => "Felipe Guerra", 'uf' => "RN", 'codigo' => 2403707],
    		['id' => 1117, 'nome' => "Fernando Pedroza", 'uf' => "RN", 'codigo' => 2403756],
    		['id' => 1118, 'nome' => "Florânia", 'uf' => "RN", 'codigo' => 2403806],
    		['id' => 1119, 'nome' => "Francisco Dantas", 'uf' => "RN", 'codigo' => 2403905],
    		['id' => 1120, 'nome' => "Frutuoso Gomes", 'uf' => "RN", 'codigo' => 2404002],
    		['id' => 1121, 'nome' => "Galinhos", 'uf' => "RN", 'codigo' => 2404101],
    		['id' => 1122, 'nome' => "Goianinha", 'uf' => "RN", 'codigo' => 2404200],
    		['id' => 1123, 'nome' => "Governador Dix-Sept Rosado", 'uf' => "RN", 'codigo' => 2404309],
    		['id' => 1124, 'nome' => "Grossos", 'uf' => "RN", 'codigo' => 2404408],
    		['id' => 1125, 'nome' => "Guamaré", 'uf' => "RN", 'codigo' => 2404507],
    		['id' => 1126, 'nome' => "Ielmo Marinho", 'uf' => "RN", 'codigo' => 2404606],
    		['id' => 1127, 'nome' => "Ipanguaçu", 'uf' => "RN", 'codigo' => 2404705],
    		['id' => 1128, 'nome' => "Ipueira", 'uf' => "RN", 'codigo' => 2404804],
    		['id' => 1129, 'nome' => "Itajá", 'uf' => "RN", 'codigo' => 2404853],
    		['id' => 1130, 'nome' => "Itaú", 'uf' => "RN", 'codigo' => 2404903],
    		['id' => 1131, 'nome' => "Jaçanã", 'uf' => "RN", 'codigo' => 2405009],
    		['id' => 1132, 'nome' => "Jandaíra", 'uf' => "RN", 'codigo' => 2405108],
    		['id' => 1133, 'nome' => "Janduís", 'uf' => "RN", 'codigo' => 2405207],
    		['id' => 1134, 'nome' => "Januário Cicco", 'uf' => "RN", 'codigo' => 2405306],
    		['id' => 1135, 'nome' => "Japi", 'uf' => "RN", 'codigo' => 2405405],
    		['id' => 1136, 'nome' => "Jardim de Angicos", 'uf' => "RN", 'codigo' => 2405504],
    		['id' => 1137, 'nome' => "Jardim de Piranhas", 'uf' => "RN", 'codigo' => 2405603],
    		['id' => 1138, 'nome' => "Jardim do Seridó", 'uf' => "RN", 'codigo' => 2405702],
    		['id' => 1139, 'nome' => "João Câmara", 'uf' => "RN", 'codigo' => 2405801],
    		['id' => 1140, 'nome' => "João Dias", 'uf' => "RN", 'codigo' => 2405900],
    		['id' => 1141, 'nome' => "José da Penha", 'uf' => "RN", 'codigo' => 2406007],
    		['id' => 1142, 'nome' => "Jucurutu", 'uf' => "RN", 'codigo' => 2406106],
    		['id' => 1143, 'nome' => "Jundiá", 'uf' => "RN", 'codigo' => 2406155],
    		['id' => 1144, 'nome' => "Lagoa D'Anta", 'uf' => "RN", 'codigo' => 2406205],
    		['id' => 1145, 'nome' => "Lagoa de Pedras", 'uf' => "RN", 'codigo' => 2406304],
    		['id' => 1146, 'nome' => "Lagoa de Velhos", 'uf' => "RN", 'codigo' => 2406403],
    		['id' => 1147, 'nome' => "Lagoa Nova", 'uf' => "RN", 'codigo' => 2406502],
    		['id' => 1148, 'nome' => "Lagoa Salgada", 'uf' => "RN", 'codigo' => 2406601],
    		['id' => 1149, 'nome' => "Lajes", 'uf' => "RN", 'codigo' => 2406700],
    		['id' => 1150, 'nome' => "Lajes Pintadas", 'uf' => "RN", 'codigo' => 2406809],
    		['id' => 1151, 'nome' => "Lucrécia", 'uf' => "RN", 'codigo' => 2406908],
    		['id' => 1152, 'nome' => "Luís Gomes", 'uf' => "RN", 'codigo' => 2407005],
    		['id' => 1153, 'nome' => "Macaíba", 'uf' => "RN", 'codigo' => 2407104],
    		['id' => 1154, 'nome' => "Macau", 'uf' => "RN", 'codigo' => 2407203],
    		['id' => 1155, 'nome' => "Major Sales", 'uf' => "RN", 'codigo' => 2407252],
    		['id' => 1156, 'nome' => "Marcelino Vieira", 'uf' => "RN", 'codigo' => 2407302],
    		['id' => 1157, 'nome' => "Martins", 'uf' => "RN", 'codigo' => 2407401],
    		['id' => 1158, 'nome' => "Maxaranguape", 'uf' => "RN", 'codigo' => 2407500],
    		['id' => 1159, 'nome' => "Messias Targino", 'uf' => "RN", 'codigo' => 2407609],
    		['id' => 1160, 'nome' => "Montanhas", 'uf' => "RN", 'codigo' => 2407708],
    		['id' => 1161, 'nome' => "Monte Alegre", 'uf' => "RN", 'codigo' => 2407807],
    		['id' => 1162, 'nome' => "Monte das Gameleiras", 'uf' => "RN", 'codigo' => 2407906],
    		['id' => 1163, 'nome' => "Mossoró", 'uf' => "RN", 'codigo' => 2408003],
    		['id' => 1164, 'nome' => "Natal", 'uf' => "RN", 'codigo' => 2408102],
    		['id' => 1165, 'nome' => "Nísia Floresta", 'uf' => "RN", 'codigo' => 2408201],
    		['id' => 1166, 'nome' => "Nova Cruz", 'uf' => "RN", 'codigo' => 2408300],
    		['id' => 1167, 'nome' => "Olho-D'Água do Borges", 'uf' => "RN", 'codigo' => 2408409],
    		['id' => 1168, 'nome' => "Ouro Branco", 'uf' => "RN", 'codigo' => 2408508],
    		['id' => 1169, 'nome' => "Paraná", 'uf' => "RN", 'codigo' => 2408607],
    		['id' => 1170, 'nome' => "Paraú", 'uf' => "RN", 'codigo' => 2408706],
    		['id' => 1171, 'nome' => "Parazinho", 'uf' => "RN", 'codigo' => 2408805],
    		['id' => 1172, 'nome' => "Parelhas", 'uf' => "RN", 'codigo' => 2408904],
    		['id' => 1173, 'nome' => "Rio do Fogo", 'uf' => "RN", 'codigo' => 2408953],
    		['id' => 1174, 'nome' => "Passa e Fica", 'uf' => "RN", 'codigo' => 2409100],
    		['id' => 1175, 'nome' => "Passagem", 'uf' => "RN", 'codigo' => 2409209],
    		['id' => 1176, 'nome' => "Patu", 'uf' => "RN", 'codigo' => 2409308],
    		['id' => 1177, 'nome' => "Santa Maria", 'uf' => "RN", 'codigo' => 2409332],
    		['id' => 1178, 'nome' => "Pau dos Ferros", 'uf' => "RN", 'codigo' => 2409407],
    		['id' => 1179, 'nome' => "Pedra Grande", 'uf' => "RN", 'codigo' => 2409506],
    		['id' => 1180, 'nome' => "Pedra Preta", 'uf' => "RN", 'codigo' => 2409605],
    		['id' => 1181, 'nome' => "Pedro Avelino", 'uf' => "RN", 'codigo' => 2409704],
    		['id' => 1182, 'nome' => "Pedro Velho", 'uf' => "RN", 'codigo' => 2409803],
    		['id' => 1183, 'nome' => "Pendências", 'uf' => "RN", 'codigo' => 2409902],
    		['id' => 1184, 'nome' => "Pilões", 'uf' => "RN", 'codigo' => 2410009],
    		['id' => 1185, 'nome' => "Poço Branco", 'uf' => "RN", 'codigo' => 2410108],
    		['id' => 1186, 'nome' => "Portalegre", 'uf' => "RN", 'codigo' => 2410207],
    		['id' => 1187, 'nome' => "Porto do Mangue", 'uf' => "RN", 'codigo' => 2410256],
    		['id' => 1188, 'nome' => "Presidente Juscelino", 'uf' => "RN", 'codigo' => 2410306],
    		['id' => 1189, 'nome' => "Pureza", 'uf' => "RN", 'codigo' => 2410405],
    		['id' => 1190, 'nome' => "Rafael Fernandes", 'uf' => "RN", 'codigo' => 2410504],
    		['id' => 1191, 'nome' => "Rafael Godeiro", 'uf' => "RN", 'codigo' => 2410603],
    		['id' => 1192, 'nome' => "Riacho da Cruz", 'uf' => "RN", 'codigo' => 2410702],
    		['id' => 1193, 'nome' => "Riacho de Santana", 'uf' => "RN", 'codigo' => 2410801],
    		['id' => 1194, 'nome' => "Riachuelo", 'uf' => "RN", 'codigo' => 2410900],
    		['id' => 1195, 'nome' => "Rodolfo Fernandes", 'uf' => "RN", 'codigo' => 2411007],
    		['id' => 1196, 'nome' => "Tibau", 'uf' => "RN", 'codigo' => 2411056],
    		['id' => 1197, 'nome' => "Ruy Barbosa", 'uf' => "RN", 'codigo' => 2411106],
    		['id' => 1198, 'nome' => "Santa Cruz", 'uf' => "RN", 'codigo' => 2411205],
    		['id' => 1199, 'nome' => "Santana do Matos", 'uf' => "RN", 'codigo' => 2411403],
    		['id' => 1200, 'nome' => "Santana do Seridó", 'uf' => "RN", 'codigo' => 2411429],
    		['id' => 1201, 'nome' => "Santo Antônio", 'uf' => "RN", 'codigo' => 2411502],
    		['id' => 1202, 'nome' => "São Bento do Norte", 'uf' => "RN", 'codigo' => 2411601],
    		['id' => 1203, 'nome' => "São Bento do Trairí", 'uf' => "RN", 'codigo' => 2411700],
    		['id' => 1204, 'nome' => "São Fernando", 'uf' => "RN", 'codigo' => 2411809],
    		['id' => 1205, 'nome' => "São Francisco do Oeste", 'uf' => "RN", 'codigo' => 2411908],
    		['id' => 1206, 'nome' => "São Gonçalo do Amarante", 'uf' => "RN", 'codigo' => 2412005],
    		['id' => 1207, 'nome' => "São João do Sabugi", 'uf' => "RN", 'codigo' => 2412104],
    		['id' => 1208, 'nome' => "São José de Mipibu", 'uf' => "RN", 'codigo' => 2412203],
    		['id' => 1209, 'nome' => "São José do Campestre", 'uf' => "RN", 'codigo' => 2412302],
    		['id' => 1210, 'nome' => "São José do Seridó", 'uf' => "RN", 'codigo' => 2412401],
    		['id' => 1211, 'nome' => "São Miguel", 'uf' => "RN", 'codigo' => 2412500],
    		['id' => 1212, 'nome' => "São Miguel do Gostoso", 'uf' => "RN", 'codigo' => 2412559],
    		['id' => 1213, 'nome' => "São Paulo do Potengi", 'uf' => "RN", 'codigo' => 2412609],
    		['id' => 1214, 'nome' => "São Pedro", 'uf' => "RN", 'codigo' => 2412708],
    		['id' => 1215, 'nome' => "São Rafael", 'uf' => "RN", 'codigo' => 2412807],
    		['id' => 1216, 'nome' => "São Tomé", 'uf' => "RN", 'codigo' => 2412906],
    		['id' => 1217, 'nome' => "São Vicente", 'uf' => "RN", 'codigo' => 2413003],
    		['id' => 1218, 'nome' => "Senador Elói de Souza", 'uf' => "RN", 'codigo' => 2413102],
    		['id' => 1219, 'nome' => "Senador Georgino Avelino", 'uf' => "RN", 'codigo' => 2413201],
    		['id' => 1220, 'nome' => "Serra de São Bento", 'uf' => "RN", 'codigo' => 2413300],
    		['id' => 1221, 'nome' => "Serra do Mel", 'uf' => "RN", 'codigo' => 2413359],
    		['id' => 1222, 'nome' => "Serra Negra do Norte", 'uf' => "RN", 'codigo' => 2413409],
    		['id' => 1223, 'nome' => "Serrinha", 'uf' => "RN", 'codigo' => 2413508],
    		['id' => 1224, 'nome' => "Serrinha dos Pintos", 'uf' => "RN", 'codigo' => 2413557],
    		['id' => 1225, 'nome' => "Severiano Melo", 'uf' => "RN", 'codigo' => 2413607],
    		['id' => 1226, 'nome' => "Sítio Novo", 'uf' => "RN", 'codigo' => 2413706],
    		['id' => 1227, 'nome' => "Taboleiro Grande", 'uf' => "RN", 'codigo' => 2413805],
    		['id' => 1228, 'nome' => "Taipu", 'uf' => "RN", 'codigo' => 2413904],
    		['id' => 1229, 'nome' => "Tangará", 'uf' => "RN", 'codigo' => 2414001],
    		['id' => 1230, 'nome' => "Tenente Ananias", 'uf' => "RN", 'codigo' => 2414100],
    		['id' => 1231, 'nome' => "Tenente Laurentino Cruz", 'uf' => "RN", 'codigo' => 2414159],
    		['id' => 1232, 'nome' => "Tibau do Sul", 'uf' => "RN", 'codigo' => 2414209],
    		['id' => 1233, 'nome' => "Timbaúba dos Batistas", 'uf' => "RN", 'codigo' => 2414308],
    		['id' => 1234, 'nome' => "Touros", 'uf' => "RN", 'codigo' => 2414407],
    		['id' => 1235, 'nome' => "Triunfo Potiguar", 'uf' => "RN", 'codigo' => 2414456],
    		['id' => 1236, 'nome' => "Umarizal", 'uf' => "RN", 'codigo' => 2414506],
    		['id' => 1237, 'nome' => "Upanema", 'uf' => "RN", 'codigo' => 2414605],
    		['id' => 1238, 'nome' => "Várzea", 'uf' => "RN", 'codigo' => 2414704],
    		['id' => 1239, 'nome' => "Venha-Ver", 'uf' => "RN", 'codigo' => 2414753],
    		['id' => 1240, 'nome' => "Vera Cruz", 'uf' => "RN", 'codigo' => 2414803],
    		['id' => 1241, 'nome' => "Viçosa", 'uf' => "RN", 'codigo' => 2414902],
    		['id' => 1242, 'nome' => "Vila Flor", 'uf' => "RN", 'codigo' => 2415008],
    		['id' => 1243, 'nome' => "Água Branca", 'uf' => "PB", 'codigo' => 2500106],
    		['id' => 1244, 'nome' => "Aguiar", 'uf' => "PB", 'codigo' => 2500205],
    		['id' => 1245, 'nome' => "Alagoa Grande", 'uf' => "PB", 'codigo' => 2500304],
    		['id' => 1246, 'nome' => "Alagoa Nova", 'uf' => "PB", 'codigo' => 2500403],
    		['id' => 1247, 'nome' => "Alagoinha", 'uf' => "PB", 'codigo' => 2500502],
    		['id' => 1248, 'nome' => "Alcantil", 'uf' => "PB", 'codigo' => 2500536],
    		['id' => 1249, 'nome' => "Algodão de Jandaíra", 'uf' => "PB", 'codigo' => 2500577],
    		['id' => 1250, 'nome' => "Alhandra", 'uf' => "PB", 'codigo' => 2500601],
    		['id' => 1251, 'nome' => "São João do Rio do Peixe", 'uf' => "PB", 'codigo' => 2500700],
    		['id' => 1252, 'nome' => "Amparo", 'uf' => "PB", 'codigo' => 2500734],
    		['id' => 1253, 'nome' => "Aparecida", 'uf' => "PB", 'codigo' => 2500775],
    		['id' => 1254, 'nome' => "Araçagi", 'uf' => "PB", 'codigo' => 2500809],
    		['id' => 1255, 'nome' => "Arara", 'uf' => "PB", 'codigo' => 2500908],
    		['id' => 1256, 'nome' => "Araruna", 'uf' => "PB", 'codigo' => 2501005],
    		['id' => 1257, 'nome' => "Areia", 'uf' => "PB", 'codigo' => 2501104],
    		['id' => 1258, 'nome' => "Areia de Baraúnas", 'uf' => "PB", 'codigo' => 2501153],
    		['id' => 1259, 'nome' => "Areial", 'uf' => "PB", 'codigo' => 2501203],
    		['id' => 1260, 'nome' => "Aroeiras", 'uf' => "PB", 'codigo' => 2501302],
    		['id' => 1261, 'nome' => "Assunção", 'uf' => "PB", 'codigo' => 2501351],
    		['id' => 1262, 'nome' => "Baía da Traição", 'uf' => "PB", 'codigo' => 2501401],
    		['id' => 1263, 'nome' => "Bananeiras", 'uf' => "PB", 'codigo' => 2501500],
    		['id' => 1264, 'nome' => "Baraúna", 'uf' => "PB", 'codigo' => 2501534],
    		['id' => 1265, 'nome' => "Barra de Santana", 'uf' => "PB", 'codigo' => 2501575],
    		['id' => 1266, 'nome' => "Barra de Santa Rosa", 'uf' => "PB", 'codigo' => 2501609],
    		['id' => 1267, 'nome' => "Barra de São Miguel", 'uf' => "PB", 'codigo' => 2501708],
    		['id' => 1268, 'nome' => "Bayeux", 'uf' => "PB", 'codigo' => 2501807],
    		['id' => 1269, 'nome' => "Belém", 'uf' => "PB", 'codigo' => 2501906],
    		['id' => 1270, 'nome' => "Belém do Brejo do Cruz", 'uf' => "PB", 'codigo' => 2502003],
    		['id' => 1271, 'nome' => "Bernardino Batista", 'uf' => "PB", 'codigo' => 2502052],
    		['id' => 1272, 'nome' => "Boa Ventura", 'uf' => "PB", 'codigo' => 2502102],
    		['id' => 1273, 'nome' => "Boa Vista", 'uf' => "PB", 'codigo' => 2502151],
    		['id' => 1274, 'nome' => "Bom Jesus", 'uf' => "PB", 'codigo' => 2502201],
    		['id' => 1275, 'nome' => "Bom Sucesso", 'uf' => "PB", 'codigo' => 2502300],
    		['id' => 1276, 'nome' => "Bonito de Santa Fé", 'uf' => "PB", 'codigo' => 2502409],
    		['id' => 1277, 'nome' => "Boqueirão", 'uf' => "PB", 'codigo' => 2502508],
    		['id' => 1278, 'nome' => "Igaracy", 'uf' => "PB", 'codigo' => 2502607],
    		['id' => 1279, 'nome' => "Borborema", 'uf' => "PB", 'codigo' => 2502706],
    		['id' => 1280, 'nome' => "Brejo do Cruz", 'uf' => "PB", 'codigo' => 2502805],
    		['id' => 1281, 'nome' => "Brejo dos Santos", 'uf' => "PB", 'codigo' => 2502904],
    		['id' => 1282, 'nome' => "Caaporã", 'uf' => "PB", 'codigo' => 2503001],
    		['id' => 1283, 'nome' => "Cabaceiras", 'uf' => "PB", 'codigo' => 2503100],
    		['id' => 1284, 'nome' => "Cabedelo", 'uf' => "PB", 'codigo' => 2503209],
    		['id' => 1285, 'nome' => "Cachoeira dos Índios", 'uf' => "PB", 'codigo' => 2503308],
    		['id' => 1286, 'nome' => "Cacimba de Areia", 'uf' => "PB", 'codigo' => 2503407],
    		['id' => 1287, 'nome' => "Cacimba de Dentro", 'uf' => "PB", 'codigo' => 2503506],
    		['id' => 1288, 'nome' => "Cacimbas", 'uf' => "PB", 'codigo' => 2503555],
    		['id' => 1289, 'nome' => "Caiçara", 'uf' => "PB", 'codigo' => 2503605],
    		['id' => 1290, 'nome' => "Cajazeiras", 'uf' => "PB", 'codigo' => 2503704],
    		['id' => 1291, 'nome' => "Cajazeirinhas", 'uf' => "PB", 'codigo' => 2503753],
    		['id' => 1292, 'nome' => "Caldas Brandão", 'uf' => "PB", 'codigo' => 2503803],
    		['id' => 1293, 'nome' => "Camalaú", 'uf' => "PB", 'codigo' => 2503902],
    		['id' => 1294, 'nome' => "Campina Grande", 'uf' => "PB", 'codigo' => 2504009],
    		['id' => 1295, 'nome' => "Capim", 'uf' => "PB", 'codigo' => 2504033],
    		['id' => 1296, 'nome' => "Caraúbas", 'uf' => "PB", 'codigo' => 2504074],
    		['id' => 1297, 'nome' => "Carrapateira", 'uf' => "PB", 'codigo' => 2504108],
    		['id' => 1298, 'nome' => "Casserengue", 'uf' => "PB", 'codigo' => 2504157],
    		['id' => 1299, 'nome' => "Catingueira", 'uf' => "PB", 'codigo' => 2504207],
    		['id' => 1300, 'nome' => "Catolé do Rocha", 'uf' => "PB", 'codigo' => 2504306],
    		['id' => 1301, 'nome' => "Caturité", 'uf' => "PB", 'codigo' => 2504355],
    		['id' => 1302, 'nome' => "Conceição", 'uf' => "PB", 'codigo' => 2504405],
    		['id' => 1303, 'nome' => "Condado", 'uf' => "PB", 'codigo' => 2504504],
    		['id' => 1304, 'nome' => "Conde", 'uf' => "PB", 'codigo' => 2504603],
    		['id' => 1305, 'nome' => "Congo", 'uf' => "PB", 'codigo' => 2504702],
    		['id' => 1306, 'nome' => "Coremas", 'uf' => "PB", 'codigo' => 2504801],
    		['id' => 1307, 'nome' => "Coxixola", 'uf' => "PB", 'codigo' => 2504850],
    		['id' => 1308, 'nome' => "Cruz do Espírito Santo", 'uf' => "PB", 'codigo' => 2504900],
    		['id' => 1309, 'nome' => "Cubati", 'uf' => "PB", 'codigo' => 2505006],
    		['id' => 1310, 'nome' => "Cuité", 'uf' => "PB", 'codigo' => 2505105],
    		['id' => 1311, 'nome' => "Cuitegi", 'uf' => "PB", 'codigo' => 2505204],
    		['id' => 1312, 'nome' => "Cuité de Mamanguape", 'uf' => "PB", 'codigo' => 2505238],
    		['id' => 1313, 'nome' => "Curral de Cima", 'uf' => "PB", 'codigo' => 2505279],
    		['id' => 1314, 'nome' => "Curral Velho", 'uf' => "PB", 'codigo' => 2505303],
    		['id' => 1315, 'nome' => "Damião", 'uf' => "PB", 'codigo' => 2505352],
    		['id' => 1316, 'nome' => "Desterro", 'uf' => "PB", 'codigo' => 2505402],
    		['id' => 1317, 'nome' => "Vista Serrana", 'uf' => "PB", 'codigo' => 2505501],
    		['id' => 1318, 'nome' => "Diamante", 'uf' => "PB", 'codigo' => 2505600],
    		['id' => 1319, 'nome' => "Dona Inês", 'uf' => "PB", 'codigo' => 2505709],
    		['id' => 1320, 'nome' => "Duas Estradas", 'uf' => "PB", 'codigo' => 2505808],
    		['id' => 1321, 'nome' => "Emas", 'uf' => "PB", 'codigo' => 2505907],
    		['id' => 1322, 'nome' => "Esperança", 'uf' => "PB", 'codigo' => 2506004],
    		['id' => 1323, 'nome' => "Fagundes", 'uf' => "PB", 'codigo' => 2506103],
    		['id' => 1324, 'nome' => "Frei Martinho", 'uf' => "PB", 'codigo' => 2506202],
    		['id' => 1325, 'nome' => "Gado Bravo", 'uf' => "PB", 'codigo' => 2506251],
    		['id' => 1326, 'nome' => "Guarabira", 'uf' => "PB", 'codigo' => 2506301],
    		['id' => 1327, 'nome' => "Gurinhém", 'uf' => "PB", 'codigo' => 2506400],
    		['id' => 1328, 'nome' => "Gurjão", 'uf' => "PB", 'codigo' => 2506509],
    		['id' => 1329, 'nome' => "Ibiara", 'uf' => "PB", 'codigo' => 2506608],
    		['id' => 1330, 'nome' => "Imaculada", 'uf' => "PB", 'codigo' => 2506707],
    		['id' => 1331, 'nome' => "Ingá", 'uf' => "PB", 'codigo' => 2506806],
    		['id' => 1332, 'nome' => "Itabaiana", 'uf' => "PB", 'codigo' => 2506905],
    		['id' => 1333, 'nome' => "Itaporanga", 'uf' => "PB", 'codigo' => 2507002],
    		['id' => 1334, 'nome' => "Itapororoca", 'uf' => "PB", 'codigo' => 2507101],
    		['id' => 1335, 'nome' => "Itatuba", 'uf' => "PB", 'codigo' => 2507200],
    		['id' => 1336, 'nome' => "Jacaraú", 'uf' => "PB", 'codigo' => 2507309],
    		['id' => 1337, 'nome' => "Jericó", 'uf' => "PB", 'codigo' => 2507408],
    		['id' => 1338, 'nome' => "João Pessoa", 'uf' => "PB", 'codigo' => 2507507],
    		['id' => 1339, 'nome' => "Juarez Távora", 'uf' => "PB", 'codigo' => 2507606],
    		['id' => 1340, 'nome' => "Juazeirinho", 'uf' => "PB", 'codigo' => 2507705],
    		['id' => 1341, 'nome' => "Junco do Seridó", 'uf' => "PB", 'codigo' => 2507804],
    		['id' => 1342, 'nome' => "Juripiranga", 'uf' => "PB", 'codigo' => 2507903],
    		['id' => 1343, 'nome' => "Juru", 'uf' => "PB", 'codigo' => 2508000],
    		['id' => 1344, 'nome' => "Lagoa", 'uf' => "PB", 'codigo' => 2508109],
    		['id' => 1345, 'nome' => "Lagoa de Dentro", 'uf' => "PB", 'codigo' => 2508208],
    		['id' => 1346, 'nome' => "Lagoa Seca", 'uf' => "PB", 'codigo' => 2508307],
    		['id' => 1347, 'nome' => "Lastro", 'uf' => "PB", 'codigo' => 2508406],
    		['id' => 1348, 'nome' => "Livramento", 'uf' => "PB", 'codigo' => 2508505],
    		['id' => 1349, 'nome' => "Logradouro", 'uf' => "PB", 'codigo' => 2508554],
    		['id' => 1350, 'nome' => "Lucena", 'uf' => "PB", 'codigo' => 2508604],
    		['id' => 1351, 'nome' => "Mãe D'Água", 'uf' => "PB", 'codigo' => 2508703],
    		['id' => 1352, 'nome' => "Malta", 'uf' => "PB", 'codigo' => 2508802],
    		['id' => 1353, 'nome' => "Mamanguape", 'uf' => "PB", 'codigo' => 2508901],
    		['id' => 1354, 'nome' => "Manaíra", 'uf' => "PB", 'codigo' => 2509008],
    		['id' => 1355, 'nome' => "Marcação", 'uf' => "PB", 'codigo' => 2509057],
    		['id' => 1356, 'nome' => "Mari", 'uf' => "PB", 'codigo' => 2509107],
    		['id' => 1357, 'nome' => "Marizópolis", 'uf' => "PB", 'codigo' => 2509156],
    		['id' => 1358, 'nome' => "Massaranduba", 'uf' => "PB", 'codigo' => 2509206],
    		['id' => 1359, 'nome' => "Mataraca", 'uf' => "PB", 'codigo' => 2509305],
    		['id' => 1360, 'nome' => "Matinhas", 'uf' => "PB", 'codigo' => 2509339],
    		['id' => 1361, 'nome' => "Mato Grosso", 'uf' => "PB", 'codigo' => 2509370],
    		['id' => 1362, 'nome' => "Maturéia", 'uf' => "PB", 'codigo' => 2509396],
    		['id' => 1363, 'nome' => "Mogeiro", 'uf' => "PB", 'codigo' => 2509404],
    		['id' => 1364, 'nome' => "Montadas", 'uf' => "PB", 'codigo' => 2509503],
    		['id' => 1365, 'nome' => "Monte Horebe", 'uf' => "PB", 'codigo' => 2509602],
    		['id' => 1366, 'nome' => "Monteiro", 'uf' => "PB", 'codigo' => 2509701],
    		['id' => 1367, 'nome' => "Mulungu", 'uf' => "PB", 'codigo' => 2509800],
    		['id' => 1368, 'nome' => "Natuba", 'uf' => "PB", 'codigo' => 2509909],
    		['id' => 1369, 'nome' => "Nazarezinho", 'uf' => "PB", 'codigo' => 2510006],
    		['id' => 1370, 'nome' => "Nova Floresta", 'uf' => "PB", 'codigo' => 2510105],
    		['id' => 1371, 'nome' => "Nova Olinda", 'uf' => "PB", 'codigo' => 2510204],
    		['id' => 1372, 'nome' => "Nova Palmeira", 'uf' => "PB", 'codigo' => 2510303],
    		['id' => 1373, 'nome' => "Olho D'Água", 'uf' => "PB", 'codigo' => 2510402],
    		['id' => 1374, 'nome' => "Olivedos", 'uf' => "PB", 'codigo' => 2510501],
    		['id' => 1375, 'nome' => "Ouro Velho", 'uf' => "PB", 'codigo' => 2510600],
    		['id' => 1376, 'nome' => "Parari", 'uf' => "PB", 'codigo' => 2510659],
    		['id' => 1377, 'nome' => "Passagem", 'uf' => "PB", 'codigo' => 2510709],
    		['id' => 1378, 'nome' => "Patos", 'uf' => "PB", 'codigo' => 2510808],
    		['id' => 1379, 'nome' => "Paulista", 'uf' => "PB", 'codigo' => 2510907],
    		['id' => 1380, 'nome' => "Pedra Branca", 'uf' => "PB", 'codigo' => 2511004],
    		['id' => 1381, 'nome' => "Pedra Lavrada", 'uf' => "PB", 'codigo' => 2511103],
    		['id' => 1382, 'nome' => "Pedras de Fogo", 'uf' => "PB", 'codigo' => 2511202],
    		['id' => 1383, 'nome' => "Piancó", 'uf' => "PB", 'codigo' => 2511301],
    		['id' => 1384, 'nome' => "Picuí", 'uf' => "PB", 'codigo' => 2511400],
    		['id' => 1385, 'nome' => "Pilar", 'uf' => "PB", 'codigo' => 2511509],
    		['id' => 1386, 'nome' => "Pilões", 'uf' => "PB", 'codigo' => 2511608],
    		['id' => 1387, 'nome' => "Pilõezinhos", 'uf' => "PB", 'codigo' => 2511707],
    		['id' => 1388, 'nome' => "Pirpirituba", 'uf' => "PB", 'codigo' => 2511806],
    		['id' => 1389, 'nome' => "Pitimbu", 'uf' => "PB", 'codigo' => 2511905],
    		['id' => 1390, 'nome' => "Pocinhos", 'uf' => "PB", 'codigo' => 2512002],
    		['id' => 1391, 'nome' => "Poço Dantas", 'uf' => "PB", 'codigo' => 2512036],
    		['id' => 1392, 'nome' => "Poço de José de Moura", 'uf' => "PB", 'codigo' => 2512077],
    		['id' => 1393, 'nome' => "Pombal", 'uf' => "PB", 'codigo' => 2512101],
    		['id' => 1394, 'nome' => "Prata", 'uf' => "PB", 'codigo' => 2512200],
    		['id' => 1395, 'nome' => "Princesa Isabel", 'uf' => "PB", 'codigo' => 2512309],
    		['id' => 1396, 'nome' => "Puxinanã", 'uf' => "PB", 'codigo' => 2512408],
    		['id' => 1397, 'nome' => "Queimadas", 'uf' => "PB", 'codigo' => 2512507],
    		['id' => 1398, 'nome' => "Quixabá", 'uf' => "PB", 'codigo' => 2512606],
    		['id' => 1399, 'nome' => "Remígio", 'uf' => "PB", 'codigo' => 2512705],
    		['id' => 1400, 'nome' => "Pedro Régis", 'uf' => "PB", 'codigo' => 2512721],
    		['id' => 1401, 'nome' => "Riachão", 'uf' => "PB", 'codigo' => 2512747],
    		['id' => 1402, 'nome' => "Riachão do Bacamarte", 'uf' => "PB", 'codigo' => 2512754],
    		['id' => 1403, 'nome' => "Riachão do Poço", 'uf' => "PB", 'codigo' => 2512762],
    		['id' => 1404, 'nome' => "Riacho de Santo Antônio", 'uf' => "PB", 'codigo' => 2512788],
    		['id' => 1405, 'nome' => "Riacho dos Cavalos", 'uf' => "PB", 'codigo' => 2512804],
    		['id' => 1406, 'nome' => "Rio Tinto", 'uf' => "PB", 'codigo' => 2512903],
    		['id' => 1407, 'nome' => "Salgadinho", 'uf' => "PB", 'codigo' => 2513000],
    		['id' => 1408, 'nome' => "Salgado de São Félix", 'uf' => "PB", 'codigo' => 2513109],
    		['id' => 1409, 'nome' => "Santa Cecília", 'uf' => "PB", 'codigo' => 2513158],
    		['id' => 1410, 'nome' => "Santa Cruz", 'uf' => "PB", 'codigo' => 2513208],
    		['id' => 1411, 'nome' => "Santa Helena", 'uf' => "PB", 'codigo' => 2513307],
    		['id' => 1412, 'nome' => "Santa Inês", 'uf' => "PB", 'codigo' => 2513356],
    		['id' => 1413, 'nome' => "Santa Luzia", 'uf' => "PB", 'codigo' => 2513406],
    		['id' => 1414, 'nome' => "Santana de Mangueira", 'uf' => "PB", 'codigo' => 2513505],
    		['id' => 1415, 'nome' => "Santana dos Garrotes", 'uf' => "PB", 'codigo' => 2513604],
    		['id' => 1416, 'nome' => "Joca Claudino", 'uf' => "PB", 'codigo' => 2513653],
    		['id' => 1417, 'nome' => "Santa Rita", 'uf' => "PB", 'codigo' => 2513703],
    		['id' => 1418, 'nome' => "Santa Teresinha", 'uf' => "PB", 'codigo' => 2513802],
    		['id' => 1419, 'nome' => "Santo André", 'uf' => "PB", 'codigo' => 2513851],
    		['id' => 1420, 'nome' => "São Bento", 'uf' => "PB", 'codigo' => 2513901],
    		['id' => 1421, 'nome' => "São Bentinho", 'uf' => "PB", 'codigo' => 2513927],
    		['id' => 1422, 'nome' => "São Domingos do Cariri", 'uf' => "PB", 'codigo' => 2513943],
    		['id' => 1423, 'nome' => "São Domingos", 'uf' => "PB", 'codigo' => 2513968],
    		['id' => 1424, 'nome' => "São Francisco", 'uf' => "PB", 'codigo' => 2513984],
    		['id' => 1425, 'nome' => "São João do Cariri", 'uf' => "PB", 'codigo' => 2514008],
    		['id' => 1426, 'nome' => "São João do Tigre", 'uf' => "PB", 'codigo' => 2514107],
    		['id' => 1427, 'nome' => "São José da Lagoa Tapada", 'uf' => "PB", 'codigo' => 2514206],
    		['id' => 1428, 'nome' => "São José de Caiana", 'uf' => "PB", 'codigo' => 2514305],
    		['id' => 1429, 'nome' => "São José de Espinharas", 'uf' => "PB", 'codigo' => 2514404],
    		['id' => 1430, 'nome' => "São José dos Ramos", 'uf' => "PB", 'codigo' => 2514453],
    		['id' => 1431, 'nome' => "São José de Piranhas", 'uf' => "PB", 'codigo' => 2514503],
    		['id' => 1432, 'nome' => "São José de Princesa", 'uf' => "PB", 'codigo' => 2514552],
    		['id' => 1433, 'nome' => "São José do Bonfim", 'uf' => "PB", 'codigo' => 2514602],
    		['id' => 1434, 'nome' => "São José do Brejo do Cruz", 'uf' => "PB", 'codigo' => 2514651],
    		['id' => 1435, 'nome' => "São José do Sabugi", 'uf' => "PB", 'codigo' => 2514701],
    		['id' => 1436, 'nome' => "São José dos Cordeiros", 'uf' => "PB", 'codigo' => 2514800],
    		['id' => 1437, 'nome' => "São Mamede", 'uf' => "PB", 'codigo' => 2514909],
    		['id' => 1438, 'nome' => "São Miguel de Taipu", 'uf' => "PB", 'codigo' => 2515005],
    		['id' => 1439, 'nome' => "São Sebastião de Lagoa de Roça", 'uf' => "PB", 'codigo' => 2515104],
    		['id' => 1440, 'nome' => "São Sebastião do Umbuzeiro", 'uf' => "PB", 'codigo' => 2515203],
    		['id' => 1441, 'nome' => "Sapé", 'uf' => "PB", 'codigo' => 2515302],
    		['id' => 1442, 'nome' => "São Vicente do Seridó", 'uf' => "PB", 'codigo' => 2515401],
    		['id' => 1443, 'nome' => "Serra Branca", 'uf' => "PB", 'codigo' => 2515500],
    		['id' => 1444, 'nome' => "Serra da Raiz", 'uf' => "PB", 'codigo' => 2515609],
    		['id' => 1445, 'nome' => "Serra Grande", 'uf' => "PB", 'codigo' => 2515708],
    		['id' => 1446, 'nome' => "Serra Redonda", 'uf' => "PB", 'codigo' => 2515807],
    		['id' => 1447, 'nome' => "Serraria", 'uf' => "PB", 'codigo' => 2515906],
    		['id' => 1448, 'nome' => "Sertãozinho", 'uf' => "PB", 'codigo' => 2515930],
    		['id' => 1449, 'nome' => "Sobrado", 'uf' => "PB", 'codigo' => 2515971],
    		['id' => 1450, 'nome' => "Solânea", 'uf' => "PB", 'codigo' => 2516003],
    		['id' => 1451, 'nome' => "Soledade", 'uf' => "PB", 'codigo' => 2516102],
    		['id' => 1452, 'nome' => "Sossêgo", 'uf' => "PB", 'codigo' => 2516151],
    		['id' => 1453, 'nome' => "Sousa", 'uf' => "PB", 'codigo' => 2516201],
    		['id' => 1454, 'nome' => "Sumé", 'uf' => "PB", 'codigo' => 2516300],
    		['id' => 1455, 'nome' => "Tacima", 'uf' => "PB", 'codigo' => 2516409],
    		['id' => 1456, 'nome' => "Taperoá", 'uf' => "PB", 'codigo' => 2516508],
    		['id' => 1457, 'nome' => "Tavares", 'uf' => "PB", 'codigo' => 2516607],
    		['id' => 1458, 'nome' => "Teixeira", 'uf' => "PB", 'codigo' => 2516706],
    		['id' => 1459, 'nome' => "Tenório", 'uf' => "PB", 'codigo' => 2516755],
    		['id' => 1460, 'nome' => "Triunfo", 'uf' => "PB", 'codigo' => 2516805],
    		['id' => 1461, 'nome' => "Uiraúna", 'uf' => "PB", 'codigo' => 2516904],
    		['id' => 1462, 'nome' => "Umbuzeiro", 'uf' => "PB", 'codigo' => 2517001],
    		['id' => 1463, 'nome' => "Várzea", 'uf' => "PB", 'codigo' => 2517100],
    		['id' => 1464, 'nome' => "Vieirópolis", 'uf' => "PB", 'codigo' => 2517209],
    		['id' => 1465, 'nome' => "Zabelê", 'uf' => "PB", 'codigo' => 2517407],
    		['id' => 1466, 'nome' => "Abreu e Lima", 'uf' => "PE", 'codigo' => 2600054],
    		['id' => 1467, 'nome' => "Afogados da Ingazeira", 'uf' => "PE", 'codigo' => 2600104],
    		['id' => 1468, 'nome' => "Afrânio", 'uf' => "PE", 'codigo' => 2600203],
    		['id' => 1469, 'nome' => "Agrestina", 'uf' => "PE", 'codigo' => 2600302],
    		['id' => 1470, 'nome' => "Água Preta", 'uf' => "PE", 'codigo' => 2600401],
    		['id' => 1471, 'nome' => "Águas Belas", 'uf' => "PE", 'codigo' => 2600500],
    		['id' => 1472, 'nome' => "Alagoinha", 'uf' => "PE", 'codigo' => 2600609],
    		['id' => 1473, 'nome' => "Aliança", 'uf' => "PE", 'codigo' => 2600708],
    		['id' => 1474, 'nome' => "Altinho", 'uf' => "PE", 'codigo' => 2600807],
    		['id' => 1475, 'nome' => "Amaraji", 'uf' => "PE", 'codigo' => 2600906],
    		['id' => 1476, 'nome' => "Angelim", 'uf' => "PE", 'codigo' => 2601003],
    		['id' => 1477, 'nome' => "Araçoiaba", 'uf' => "PE", 'codigo' => 2601052],
    		['id' => 1478, 'nome' => "Araripina", 'uf' => "PE", 'codigo' => 2601102],
    		['id' => 1479, 'nome' => "Arcoverde", 'uf' => "PE", 'codigo' => 2601201],
    		['id' => 1480, 'nome' => "Barra de Guabiraba", 'uf' => "PE", 'codigo' => 2601300],
    		['id' => 1481, 'nome' => "Barreiros", 'uf' => "PE", 'codigo' => 2601409],
    		['id' => 1482, 'nome' => "Belém de Maria", 'uf' => "PE", 'codigo' => 2601508],
    		['id' => 1483, 'nome' => "Belém do São Francisco", 'uf' => "PE", 'codigo' => 2601607],
    		['id' => 1484, 'nome' => "Belo Jardim", 'uf' => "PE", 'codigo' => 2601706],
    		['id' => 1485, 'nome' => "Betânia", 'uf' => "PE", 'codigo' => 2601805],
    		['id' => 1486, 'nome' => "Bezerros", 'uf' => "PE", 'codigo' => 2601904],
    		['id' => 1487, 'nome' => "Bodocó", 'uf' => "PE", 'codigo' => 2602001],
    		['id' => 1488, 'nome' => "Bom Conselho", 'uf' => "PE", 'codigo' => 2602100],
    		['id' => 1489, 'nome' => "Bom Jardim", 'uf' => "PE", 'codigo' => 2602209],
    		['id' => 1490, 'nome' => "Bonito", 'uf' => "PE", 'codigo' => 2602308],
    		['id' => 1491, 'nome' => "Brejão", 'uf' => "PE", 'codigo' => 2602407],
    		['id' => 1492, 'nome' => "Brejinho", 'uf' => "PE", 'codigo' => 2602506],
    		['id' => 1493, 'nome' => "Brejo da Madre de Deus", 'uf' => "PE", 'codigo' => 2602605],
    		['id' => 1494, 'nome' => "Buenos Aires", 'uf' => "PE", 'codigo' => 2602704],
    		['id' => 1495, 'nome' => "Buíque", 'uf' => "PE", 'codigo' => 2602803],
    		['id' => 1496, 'nome' => "Cabo de Santo Agostinho", 'uf' => "PE", 'codigo' => 2602902],
    		['id' => 1497, 'nome' => "Cabrobó", 'uf' => "PE", 'codigo' => 2603009],
    		['id' => 1498, 'nome' => "Cachoeirinha", 'uf' => "PE", 'codigo' => 2603108],
    		['id' => 1499, 'nome' => "Caetés", 'uf' => "PE", 'codigo' => 2603207],
    		['id' => 1500, 'nome' => "Calçado", 'uf' => "PE", 'codigo' => 2603306],
    		['id' => 1501, 'nome' => "Calumbi", 'uf' => "PE", 'codigo' => 2603405],
    		['id' => 1502, 'nome' => "Camaragibe", 'uf' => "PE", 'codigo' => 2603454],
    		['id' => 1503, 'nome' => "Camocim de São Félix", 'uf' => "PE", 'codigo' => 2603504],
    		['id' => 1504, 'nome' => "Camutanga", 'uf' => "PE", 'codigo' => 2603603],
    		['id' => 1505, 'nome' => "Canhotinho", 'uf' => "PE", 'codigo' => 2603702],
    		['id' => 1506, 'nome' => "Capoeiras", 'uf' => "PE", 'codigo' => 2603801],
    		['id' => 1507, 'nome' => "Carnaíba", 'uf' => "PE", 'codigo' => 2603900],
    		['id' => 1508, 'nome' => "Carnaubeira da Penha", 'uf' => "PE", 'codigo' => 2603926],
    		['id' => 1509, 'nome' => "Carpina", 'uf' => "PE", 'codigo' => 2604007],
    		['id' => 1510, 'nome' => "Caruaru", 'uf' => "PE", 'codigo' => 2604106],
    		['id' => 1511, 'nome' => "Casinhas", 'uf' => "PE", 'codigo' => 2604155],
    		['id' => 1512, 'nome' => "Catende", 'uf' => "PE", 'codigo' => 2604205],
    		['id' => 1513, 'nome' => "Cedro", 'uf' => "PE", 'codigo' => 2604304],
    		['id' => 1514, 'nome' => "Chã de Alegria", 'uf' => "PE", 'codigo' => 2604403],
    		['id' => 1515, 'nome' => "Chã Grande", 'uf' => "PE", 'codigo' => 2604502],
    		['id' => 1516, 'nome' => "Condado", 'uf' => "PE", 'codigo' => 2604601],
    		['id' => 1517, 'nome' => "Correntes", 'uf' => "PE", 'codigo' => 2604700],
    		['id' => 1518, 'nome' => "Cortês", 'uf' => "PE", 'codigo' => 2604809],
    		['id' => 1519, 'nome' => "Cumaru", 'uf' => "PE", 'codigo' => 2604908],
    		['id' => 1520, 'nome' => "Cupira", 'uf' => "PE", 'codigo' => 2605004],
    		['id' => 1521, 'nome' => "Custódia", 'uf' => "PE", 'codigo' => 2605103],
    		['id' => 1522, 'nome' => "Dormentes", 'uf' => "PE", 'codigo' => 2605152],
    		['id' => 1523, 'nome' => "Escada", 'uf' => "PE", 'codigo' => 2605202],
    		['id' => 1524, 'nome' => "Exu", 'uf' => "PE", 'codigo' => 2605301],
    		['id' => 1525, 'nome' => "Feira Nova", 'uf' => "PE", 'codigo' => 2605400],
    		['id' => 1526, 'nome' => "Fernando de Noronha", 'uf' => "PE", 'codigo' => 2605459],
    		['id' => 1527, 'nome' => "Ferreiros", 'uf' => "PE", 'codigo' => 2605509],
    		['id' => 1528, 'nome' => "Flores", 'uf' => "PE", 'codigo' => 2605608],
    		['id' => 1529, 'nome' => "Floresta", 'uf' => "PE", 'codigo' => 2605707],
    		['id' => 1530, 'nome' => "Frei Miguelinho", 'uf' => "PE", 'codigo' => 2605806],
    		['id' => 1531, 'nome' => "Gameleira", 'uf' => "PE", 'codigo' => 2605905],
    		['id' => 1532, 'nome' => "Garanhuns", 'uf' => "PE", 'codigo' => 2606002],
    		['id' => 1533, 'nome' => "Glória do Goitá", 'uf' => "PE", 'codigo' => 2606101],
    		['id' => 1534, 'nome' => "Goiana", 'uf' => "PE", 'codigo' => 2606200],
    		['id' => 1535, 'nome' => "Granito", 'uf' => "PE", 'codigo' => 2606309],
    		['id' => 1536, 'nome' => "Gravatá", 'uf' => "PE", 'codigo' => 2606408],
    		['id' => 1537, 'nome' => "Iati", 'uf' => "PE", 'codigo' => 2606507],
    		['id' => 1538, 'nome' => "Ibimirim", 'uf' => "PE", 'codigo' => 2606606],
    		['id' => 1539, 'nome' => "Ibirajuba", 'uf' => "PE", 'codigo' => 2606705],
    		['id' => 1540, 'nome' => "Igarassu", 'uf' => "PE", 'codigo' => 2606804],
    		['id' => 1541, 'nome' => "Iguaraci", 'uf' => "PE", 'codigo' => 2606903],
    		['id' => 1542, 'nome' => "Inajá", 'uf' => "PE", 'codigo' => 2607000],
    		['id' => 1543, 'nome' => "Ingazeira", 'uf' => "PE", 'codigo' => 2607109],
    		['id' => 1544, 'nome' => "Ipojuca", 'uf' => "PE", 'codigo' => 2607208],
    		['id' => 1545, 'nome' => "Ipubi", 'uf' => "PE", 'codigo' => 2607307],
    		['id' => 1546, 'nome' => "Itacuruba", 'uf' => "PE", 'codigo' => 2607406],
    		['id' => 1547, 'nome' => "Itaíba", 'uf' => "PE", 'codigo' => 2607505],
    		['id' => 1548, 'nome' => "Ilha de Itamaracá", 'uf' => "PE", 'codigo' => 2607604],
    		['id' => 1549, 'nome' => "Itambé", 'uf' => "PE", 'codigo' => 2607653],
    		['id' => 1550, 'nome' => "Itapetim", 'uf' => "PE", 'codigo' => 2607703],
    		['id' => 1551, 'nome' => "Itapissuma", 'uf' => "PE", 'codigo' => 2607752],
    		['id' => 1552, 'nome' => "Itaquitinga", 'uf' => "PE", 'codigo' => 2607802],
    		['id' => 1553, 'nome' => "Jaboatão dos Guararapes", 'uf' => "PE", 'codigo' => 2607901],
    		['id' => 1554, 'nome' => "Jaqueira", 'uf' => "PE", 'codigo' => 2607950],
    		['id' => 1555, 'nome' => "Jataúba", 'uf' => "PE", 'codigo' => 2608008],
    		['id' => 1556, 'nome' => "Jatobá", 'uf' => "PE", 'codigo' => 2608057],
    		['id' => 1557, 'nome' => "João Alfredo", 'uf' => "PE", 'codigo' => 2608107],
    		['id' => 1558, 'nome' => "Joaquim Nabuco", 'uf' => "PE", 'codigo' => 2608206],
    		['id' => 1559, 'nome' => "Jucati", 'uf' => "PE", 'codigo' => 2608255],
    		['id' => 1560, 'nome' => "Jupi", 'uf' => "PE", 'codigo' => 2608305],
    		['id' => 1561, 'nome' => "Jurema", 'uf' => "PE", 'codigo' => 2608404],
    		['id' => 1562, 'nome' => "Lagoa do Carro", 'uf' => "PE", 'codigo' => 2608453],
    		['id' => 1563, 'nome' => "Lagoa de Itaenga", 'uf' => "PE", 'codigo' => 2608503],
    		['id' => 1564, 'nome' => "Lagoa do Ouro", 'uf' => "PE", 'codigo' => 2608602],
    		['id' => 1565, 'nome' => "Lagoa dos Gatos", 'uf' => "PE", 'codigo' => 2608701],
    		['id' => 1566, 'nome' => "Lagoa Grande", 'uf' => "PE", 'codigo' => 2608750],
    		['id' => 1567, 'nome' => "Lajedo", 'uf' => "PE", 'codigo' => 2608800],
    		['id' => 1568, 'nome' => "Limoeiro", 'uf' => "PE", 'codigo' => 2608909],
    		['id' => 1569, 'nome' => "Macaparana", 'uf' => "PE", 'codigo' => 2609006],
    		['id' => 1570, 'nome' => "Machados", 'uf' => "PE", 'codigo' => 2609105],
    		['id' => 1571, 'nome' => "Manari", 'uf' => "PE", 'codigo' => 2609154],
    		['id' => 1572, 'nome' => "Maraial", 'uf' => "PE", 'codigo' => 2609204],
    		['id' => 1573, 'nome' => "Mirandiba", 'uf' => "PE", 'codigo' => 2609303],
    		['id' => 1574, 'nome' => "Moreno", 'uf' => "PE", 'codigo' => 2609402],
    		['id' => 1575, 'nome' => "Nazaré da Mata", 'uf' => "PE", 'codigo' => 2609501],
    		['id' => 1576, 'nome' => "Olinda", 'uf' => "PE", 'codigo' => 2609600],
    		['id' => 1577, 'nome' => "Orobó", 'uf' => "PE", 'codigo' => 2609709],
    		['id' => 1578, 'nome' => "Orocó", 'uf' => "PE", 'codigo' => 2609808],
    		['id' => 1579, 'nome' => "Ouricuri", 'uf' => "PE", 'codigo' => 2609907],
    		['id' => 1580, 'nome' => "Palmares", 'uf' => "PE", 'codigo' => 2610004],
    		['id' => 1581, 'nome' => "Palmeirina", 'uf' => "PE", 'codigo' => 2610103],
    		['id' => 1582, 'nome' => "Panelas", 'uf' => "PE", 'codigo' => 2610202],
    		['id' => 1583, 'nome' => "Paranatama", 'uf' => "PE", 'codigo' => 2610301],
    		['id' => 1584, 'nome' => "Parnamirim", 'uf' => "PE", 'codigo' => 2610400],
    		['id' => 1585, 'nome' => "Passira", 'uf' => "PE", 'codigo' => 2610509],
    		['id' => 1586, 'nome' => "Paudalho", 'uf' => "PE", 'codigo' => 2610608],
    		['id' => 1587, 'nome' => "Paulista", 'uf' => "PE", 'codigo' => 2610707],
    		['id' => 1588, 'nome' => "Pedra", 'uf' => "PE", 'codigo' => 2610806],
    		['id' => 1589, 'nome' => "Pesqueira", 'uf' => "PE", 'codigo' => 2610905],
    		['id' => 1590, 'nome' => "Petrolândia", 'uf' => "PE", 'codigo' => 2611002],
    		['id' => 1591, 'nome' => "Petrolina", 'uf' => "PE", 'codigo' => 2611101],
    		['id' => 1592, 'nome' => "Poção", 'uf' => "PE", 'codigo' => 2611200],
    		['id' => 1593, 'nome' => "Pombos", 'uf' => "PE", 'codigo' => 2611309],
    		['id' => 1594, 'nome' => "Primavera", 'uf' => "PE", 'codigo' => 2611408],
    		['id' => 1595, 'nome' => "Quipapá", 'uf' => "PE", 'codigo' => 2611507],
    		['id' => 1596, 'nome' => "Quixaba", 'uf' => "PE", 'codigo' => 2611533],
    		['id' => 1597, 'nome' => "Recife", 'uf' => "PE", 'codigo' => 2611606],
    		['id' => 1598, 'nome' => "Riacho das Almas", 'uf' => "PE", 'codigo' => 2611705],
    		['id' => 1599, 'nome' => "Ribeirão", 'uf' => "PE", 'codigo' => 2611804],
    		['id' => 1600, 'nome' => "Rio Formoso", 'uf' => "PE", 'codigo' => 2611903],
    		['id' => 1601, 'nome' => "Sairé", 'uf' => "PE", 'codigo' => 2612000],
    		['id' => 1602, 'nome' => "Salgadinho", 'uf' => "PE", 'codigo' => 2612109],
    		['id' => 1603, 'nome' => "Salgueiro", 'uf' => "PE", 'codigo' => 2612208],
    		['id' => 1604, 'nome' => "Saloá", 'uf' => "PE", 'codigo' => 2612307],
    		['id' => 1605, 'nome' => "Sanharó", 'uf' => "PE", 'codigo' => 2612406],
    		['id' => 1606, 'nome' => "Santa Cruz", 'uf' => "PE", 'codigo' => 2612455],
    		['id' => 1607, 'nome' => "Santa Cruz da Baixa Verde", 'uf' => "PE", 'codigo' => 2612471],
    		['id' => 1608, 'nome' => "Santa Cruz do Capibaribe", 'uf' => "PE", 'codigo' => 2612505],
    		['id' => 1609, 'nome' => "Santa Filomena", 'uf' => "PE", 'codigo' => 2612554],
    		['id' => 1610, 'nome' => "Santa Maria da Boa Vista", 'uf' => "PE", 'codigo' => 2612604],
    		['id' => 1611, 'nome' => "Santa Maria do Cambucá", 'uf' => "PE", 'codigo' => 2612703],
    		['id' => 1612, 'nome' => "Santa Terezinha", 'uf' => "PE", 'codigo' => 2612802],
    		['id' => 1613, 'nome' => "São Benedito do Sul", 'uf' => "PE", 'codigo' => 2612901],
    		['id' => 1614, 'nome' => "São Bento do Una", 'uf' => "PE", 'codigo' => 2613008],
    		['id' => 1615, 'nome' => "São Caitano", 'uf' => "PE", 'codigo' => 2613107],
    		['id' => 1616, 'nome' => "São João", 'uf' => "PE", 'codigo' => 2613206],
    		['id' => 1617, 'nome' => "São Joaquim do Monte", 'uf' => "PE", 'codigo' => 2613305],
    		['id' => 1618, 'nome' => "São José da Coroa Grande", 'uf' => "PE", 'codigo' => 2613404],
    		['id' => 1619, 'nome' => "São José do Belmonte", 'uf' => "PE", 'codigo' => 2613503],
    		['id' => 1620, 'nome' => "São José do Egito", 'uf' => "PE", 'codigo' => 2613602],
    		['id' => 1621, 'nome' => "São Lourenço da Mata", 'uf' => "PE", 'codigo' => 2613701],
    		['id' => 1622, 'nome' => "São Vicente Ferrer", 'uf' => "PE", 'codigo' => 2613800],
    		['id' => 1623, 'nome' => "Serra Talhada", 'uf' => "PE", 'codigo' => 2613909],
    		['id' => 1624, 'nome' => "Serrita", 'uf' => "PE", 'codigo' => 2614006],
    		['id' => 1625, 'nome' => "Sertânia", 'uf' => "PE", 'codigo' => 2614105],
    		['id' => 1626, 'nome' => "Sirinhaém", 'uf' => "PE", 'codigo' => 2614204],
    		['id' => 1627, 'nome' => "Moreilândia", 'uf' => "PE", 'codigo' => 2614303],
    		['id' => 1628, 'nome' => "Solidão", 'uf' => "PE", 'codigo' => 2614402],
    		['id' => 1629, 'nome' => "Surubim", 'uf' => "PE", 'codigo' => 2614501],
    		['id' => 1630, 'nome' => "Tabira", 'uf' => "PE", 'codigo' => 2614600],
    		['id' => 1631, 'nome' => "Tacaimbó", 'uf' => "PE", 'codigo' => 2614709],
    		['id' => 1632, 'nome' => "Tacaratu", 'uf' => "PE", 'codigo' => 2614808],
    		['id' => 1633, 'nome' => "Tamandaré", 'uf' => "PE", 'codigo' => 2614857],
    		['id' => 1634, 'nome' => "Taquaritinga do Norte", 'uf' => "PE", 'codigo' => 2615003],
    		['id' => 1635, 'nome' => "Terezinha", 'uf' => "PE", 'codigo' => 2615102],
    		['id' => 1636, 'nome' => "Terra Nova", 'uf' => "PE", 'codigo' => 2615201],
    		['id' => 1637, 'nome' => "Timbaúba", 'uf' => "PE", 'codigo' => 2615300],
    		['id' => 1638, 'nome' => "Toritama", 'uf' => "PE", 'codigo' => 2615409],
    		['id' => 1639, 'nome' => "Tracunhaém", 'uf' => "PE", 'codigo' => 2615508],
    		['id' => 1640, 'nome' => "Trindade", 'uf' => "PE", 'codigo' => 2615607],
    		['id' => 1641, 'nome' => "Triunfo", 'uf' => "PE", 'codigo' => 2615706],
    		['id' => 1642, 'nome' => "Tupanatinga", 'uf' => "PE", 'codigo' => 2615805],
    		['id' => 1643, 'nome' => "Tuparetama", 'uf' => "PE", 'codigo' => 2615904],
    		['id' => 1644, 'nome' => "Venturosa", 'uf' => "PE", 'codigo' => 2616001],
    		['id' => 1645, 'nome' => "Verdejante", 'uf' => "PE", 'codigo' => 2616100],
    		['id' => 1646, 'nome' => "Vertente do Lério", 'uf' => "PE", 'codigo' => 2616183],
    		['id' => 1647, 'nome' => "Vertentes", 'uf' => "PE", 'codigo' => 2616209],
    		['id' => 1648, 'nome' => "Vicência", 'uf' => "PE", 'codigo' => 2616308],
    		['id' => 1649, 'nome' => "Vitória de Santo Antão", 'uf' => "PE", 'codigo' => 2616407],
    		['id' => 1650, 'nome' => "Xexéu", 'uf' => "PE", 'codigo' => 2616506],
    		['id' => 1651, 'nome' => "Água Branca", 'uf' => "AL", 'codigo' => 2700102],
    		['id' => 1652, 'nome' => "Anadia", 'uf' => "AL", 'codigo' => 2700201],
    		['id' => 1653, 'nome' => "Arapiraca", 'uf' => "AL", 'codigo' => 2700300],
    		['id' => 1654, 'nome' => "Atalaia", 'uf' => "AL", 'codigo' => 2700409],
    		['id' => 1655, 'nome' => "Barra de Santo Antônio", 'uf' => "AL", 'codigo' => 2700508],
    		['id' => 1656, 'nome' => "Barra de São Miguel", 'uf' => "AL", 'codigo' => 2700607],
    		['id' => 1657, 'nome' => "Batalha", 'uf' => "AL", 'codigo' => 2700706],
    		['id' => 1658, 'nome' => "Belém", 'uf' => "AL", 'codigo' => 2700805],
    		['id' => 1659, 'nome' => "Belo Monte", 'uf' => "AL", 'codigo' => 2700904],
    		['id' => 1660, 'nome' => "Boca da Mata", 'uf' => "AL", 'codigo' => 2701001],
    		['id' => 1661, 'nome' => "Branquinha", 'uf' => "AL", 'codigo' => 2701100],
    		['id' => 1662, 'nome' => "Cacimbinhas", 'uf' => "AL", 'codigo' => 2701209],
    		['id' => 1663, 'nome' => "Cajueiro", 'uf' => "AL", 'codigo' => 2701308],
    		['id' => 1664, 'nome' => "Campestre", 'uf' => "AL", 'codigo' => 2701357],
    		['id' => 1665, 'nome' => "Campo Alegre", 'uf' => "AL", 'codigo' => 2701407],
    		['id' => 1666, 'nome' => "Campo Grande", 'uf' => "AL", 'codigo' => 2701506],
    		['id' => 1667, 'nome' => "Canapi", 'uf' => "AL", 'codigo' => 2701605],
    		['id' => 1668, 'nome' => "Capela", 'uf' => "AL", 'codigo' => 2701704],
    		['id' => 1669, 'nome' => "Carneiros", 'uf' => "AL", 'codigo' => 2701803],
    		['id' => 1670, 'nome' => "Chã Preta", 'uf' => "AL", 'codigo' => 2701902],
    		['id' => 1671, 'nome' => "Coité do Nóia", 'uf' => "AL", 'codigo' => 2702009],
    		['id' => 1672, 'nome' => "Colônia Leopoldina", 'uf' => "AL", 'codigo' => 2702108],
    		['id' => 1673, 'nome' => "Coqueiro Seco", 'uf' => "AL", 'codigo' => 2702207],
    		['id' => 1674, 'nome' => "Coruripe", 'uf' => "AL", 'codigo' => 2702306],
    		['id' => 1675, 'nome' => "Craíbas", 'uf' => "AL", 'codigo' => 2702355],
    		['id' => 1676, 'nome' => "Delmiro Gouveia", 'uf' => "AL", 'codigo' => 2702405],
    		['id' => 1677, 'nome' => "Dois Riachos", 'uf' => "AL", 'codigo' => 2702504],
    		['id' => 1678, 'nome' => "Estrela de Alagoas", 'uf' => "AL", 'codigo' => 2702553],
    		['id' => 1679, 'nome' => "Feira Grande", 'uf' => "AL", 'codigo' => 2702603],
    		['id' => 1680, 'nome' => "Feliz Deserto", 'uf' => "AL", 'codigo' => 2702702],
    		['id' => 1681, 'nome' => "Flexeiras", 'uf' => "AL", 'codigo' => 2702801],
    		['id' => 1682, 'nome' => "Girau do Ponciano", 'uf' => "AL", 'codigo' => 2702900],
    		['id' => 1683, 'nome' => "Ibateguara", 'uf' => "AL", 'codigo' => 2703007],
    		['id' => 1684, 'nome' => "Igaci", 'uf' => "AL", 'codigo' => 2703106],
    		['id' => 1685, 'nome' => "Igreja Nova", 'uf' => "AL", 'codigo' => 2703205],
    		['id' => 1686, 'nome' => "Inhapi", 'uf' => "AL", 'codigo' => 2703304],
    		['id' => 1687, 'nome' => "Jacaré dos Homens", 'uf' => "AL", 'codigo' => 2703403],
    		['id' => 1688, 'nome' => "Jacuípe", 'uf' => "AL", 'codigo' => 2703502],
    		['id' => 1689, 'nome' => "Japaratinga", 'uf' => "AL", 'codigo' => 2703601],
    		['id' => 1690, 'nome' => "Jaramataia", 'uf' => "AL", 'codigo' => 2703700],
    		['id' => 1691, 'nome' => "Jequiá da Praia", 'uf' => "AL", 'codigo' => 2703759],
    		['id' => 1692, 'nome' => "Joaquim Gomes", 'uf' => "AL", 'codigo' => 2703809],
    		['id' => 1693, 'nome' => "Jundiá", 'uf' => "AL", 'codigo' => 2703908],
    		['id' => 1694, 'nome' => "Junqueiro", 'uf' => "AL", 'codigo' => 2704005],
    		['id' => 1695, 'nome' => "Lagoa da Canoa", 'uf' => "AL", 'codigo' => 2704104],
    		['id' => 1696, 'nome' => "Limoeiro de Anadia", 'uf' => "AL", 'codigo' => 2704203],
    		['id' => 1697, 'nome' => "Maceió", 'uf' => "AL", 'codigo' => 2704302],
    		['id' => 1698, 'nome' => "Major Isidoro", 'uf' => "AL", 'codigo' => 2704401],
    		['id' => 1699, 'nome' => "Maragogi", 'uf' => "AL", 'codigo' => 2704500],
    		['id' => 1700, 'nome' => "Maravilha", 'uf' => "AL", 'codigo' => 2704609],
    		['id' => 1701, 'nome' => "Marechal Deodoro", 'uf' => "AL", 'codigo' => 2704708],
    		['id' => 1702, 'nome' => "Maribondo", 'uf' => "AL", 'codigo' => 2704807],
    		['id' => 1703, 'nome' => "Mar Vermelho", 'uf' => "AL", 'codigo' => 2704906],
    		['id' => 1704, 'nome' => "Mata Grande", 'uf' => "AL", 'codigo' => 2705002],
    		['id' => 1705, 'nome' => "Matriz de Camaragibe", 'uf' => "AL", 'codigo' => 2705101],
    		['id' => 1706, 'nome' => "Messias", 'uf' => "AL", 'codigo' => 2705200],
    		['id' => 1707, 'nome' => "Minador do Negrão", 'uf' => "AL", 'codigo' => 2705309],
    		['id' => 1708, 'nome' => "Monteirópolis", 'uf' => "AL", 'codigo' => 2705408],
    		['id' => 1709, 'nome' => "Murici", 'uf' => "AL", 'codigo' => 2705507],
    		['id' => 1710, 'nome' => "Novo Lino", 'uf' => "AL", 'codigo' => 2705606],
    		['id' => 1711, 'nome' => "Olho D'Água das Flores", 'uf' => "AL", 'codigo' => 2705705],
    		['id' => 1712, 'nome' => "Olho D'Água do Casado", 'uf' => "AL", 'codigo' => 2705804],
    		['id' => 1713, 'nome' => "Olho D'Água Grande", 'uf' => "AL", 'codigo' => 2705903],
    		['id' => 1714, 'nome' => "Olivença", 'uf' => "AL", 'codigo' => 2706000],
    		['id' => 1715, 'nome' => "Ouro Branco", 'uf' => "AL", 'codigo' => 2706109],
    		['id' => 1716, 'nome' => "Palestina", 'uf' => "AL", 'codigo' => 2706208],
    		['id' => 1717, 'nome' => "Palmeira dos Índios", 'uf' => "AL", 'codigo' => 2706307],
    		['id' => 1718, 'nome' => "Pão de Açúcar", 'uf' => "AL", 'codigo' => 2706406],
    		['id' => 1719, 'nome' => "Pariconha", 'uf' => "AL", 'codigo' => 2706422],
    		['id' => 1720, 'nome' => "Paripueira", 'uf' => "AL", 'codigo' => 2706448],
    		['id' => 1721, 'nome' => "Passo de Camaragibe", 'uf' => "AL", 'codigo' => 2706505],
    		['id' => 1722, 'nome' => "Paulo Jacinto", 'uf' => "AL", 'codigo' => 2706604],
    		['id' => 1723, 'nome' => "Penedo", 'uf' => "AL", 'codigo' => 2706703],
    		['id' => 1724, 'nome' => "Piaçabuçu", 'uf' => "AL", 'codigo' => 2706802],
    		['id' => 1725, 'nome' => "Pilar", 'uf' => "AL", 'codigo' => 2706901],
    		['id' => 1726, 'nome' => "Pindoba", 'uf' => "AL", 'codigo' => 2707008],
    		['id' => 1727, 'nome' => "Piranhas", 'uf' => "AL", 'codigo' => 2707107],
    		['id' => 1728, 'nome' => "Poço das Trincheiras", 'uf' => "AL", 'codigo' => 2707206],
    		['id' => 1729, 'nome' => "Porto Calvo", 'uf' => "AL", 'codigo' => 2707305],
    		['id' => 1730, 'nome' => "Porto de Pedras", 'uf' => "AL", 'codigo' => 2707404],
    		['id' => 1731, 'nome' => "Porto Real do Colégio", 'uf' => "AL", 'codigo' => 2707503],
    		['id' => 1732, 'nome' => "Quebrangulo", 'uf' => "AL", 'codigo' => 2707602],
    		['id' => 1733, 'nome' => "Rio Largo", 'uf' => "AL", 'codigo' => 2707701],
    		['id' => 1734, 'nome' => "Roteiro", 'uf' => "AL", 'codigo' => 2707800],
    		['id' => 1735, 'nome' => "Santa Luzia do Norte", 'uf' => "AL", 'codigo' => 2707909],
    		['id' => 1736, 'nome' => "Santana do Ipanema", 'uf' => "AL", 'codigo' => 2708006],
    		['id' => 1737, 'nome' => "Santana do Mundaú", 'uf' => "AL", 'codigo' => 2708105],
    		['id' => 1738, 'nome' => "São Brás", 'uf' => "AL", 'codigo' => 2708204],
    		['id' => 1739, 'nome' => "São José da Laje", 'uf' => "AL", 'codigo' => 2708303],
    		['id' => 1740, 'nome' => "São José da Tapera", 'uf' => "AL", 'codigo' => 2708402],
    		['id' => 1741, 'nome' => "São Luís do Quitunde", 'uf' => "AL", 'codigo' => 2708501],
    		['id' => 1742, 'nome' => "São Miguel dos Campos", 'uf' => "AL", 'codigo' => 2708600],
    		['id' => 1743, 'nome' => "São Miguel dos Milagres", 'uf' => "AL", 'codigo' => 2708709],
    		['id' => 1744, 'nome' => "São Sebastião", 'uf' => "AL", 'codigo' => 2708808],
    		['id' => 1745, 'nome' => "Satuba", 'uf' => "AL", 'codigo' => 2708907],
    		['id' => 1746, 'nome' => "Senador Rui Palmeira", 'uf' => "AL", 'codigo' => 2708956],
    		['id' => 1747, 'nome' => "Tanque D'Arca", 'uf' => "AL", 'codigo' => 2709004],
    		['id' => 1748, 'nome' => "Taquarana", 'uf' => "AL", 'codigo' => 2709103],
    		['id' => 1749, 'nome' => "Teotônio Vilela", 'uf' => "AL", 'codigo' => 2709152],
    		['id' => 1750, 'nome' => "Traipu", 'uf' => "AL", 'codigo' => 2709202],
    		['id' => 1751, 'nome' => "União dos Palmares", 'uf' => "AL", 'codigo' => 2709301],
    		['id' => 1752, 'nome' => "Viçosa", 'uf' => "AL", 'codigo' => 2709400],
    		['id' => 1753, 'nome' => "Amparo de São Francisco", 'uf' => "SE", 'codigo' => 2800100],
    		['id' => 1754, 'nome' => "Aquidabã", 'uf' => "SE", 'codigo' => 2800209],
    		['id' => 1755, 'nome' => "Aracaju", 'uf' => "SE", 'codigo' => 2800308],
    		['id' => 1756, 'nome' => "Arauá", 'uf' => "SE", 'codigo' => 2800407],
    		['id' => 1757, 'nome' => "Areia Branca", 'uf' => "SE", 'codigo' => 2800506],
    		['id' => 1758, 'nome' => "Barra dos Coqueiros", 'uf' => "SE", 'codigo' => 2800605],
    		['id' => 1759, 'nome' => "Boquim", 'uf' => "SE", 'codigo' => 2800670],
    		['id' => 1760, 'nome' => "Brejo Grande", 'uf' => "SE", 'codigo' => 2800704],
    		['id' => 1761, 'nome' => "Campo do Brito", 'uf' => "SE", 'codigo' => 2801009],
    		['id' => 1762, 'nome' => "Canhoba", 'uf' => "SE", 'codigo' => 2801108],
    		['id' => 1763, 'nome' => "Canindé de São Francisco", 'uf' => "SE", 'codigo' => 2801207],
    		['id' => 1764, 'nome' => "Capela", 'uf' => "SE", 'codigo' => 2801306],
    		['id' => 1765, 'nome' => "Carira", 'uf' => "SE", 'codigo' => 2801405],
    		['id' => 1766, 'nome' => "Carmópolis", 'uf' => "SE", 'codigo' => 2801504],
    		['id' => 1767, 'nome' => "Cedro de São João", 'uf' => "SE", 'codigo' => 2801603],
    		['id' => 1768, 'nome' => "Cristinápolis", 'uf' => "SE", 'codigo' => 2801702],
    		['id' => 1769, 'nome' => "Cumbe", 'uf' => "SE", 'codigo' => 2801900],
    		['id' => 1770, 'nome' => "Divina Pastora", 'uf' => "SE", 'codigo' => 2802007],
    		['id' => 1771, 'nome' => "Estância", 'uf' => "SE", 'codigo' => 2802106],
    		['id' => 1772, 'nome' => "Feira Nova", 'uf' => "SE", 'codigo' => 2802205],
    		['id' => 1773, 'nome' => "Frei Paulo", 'uf' => "SE", 'codigo' => 2802304],
    		['id' => 1774, 'nome' => "Gararu", 'uf' => "SE", 'codigo' => 2802403],
    		['id' => 1775, 'nome' => "General Maynard", 'uf' => "SE", 'codigo' => 2802502],
    		['id' => 1776, 'nome' => "Gracho Cardoso", 'uf' => "SE", 'codigo' => 2802601],
    		['id' => 1777, 'nome' => "Ilha das Flores", 'uf' => "SE", 'codigo' => 2802700],
    		['id' => 1778, 'nome' => "Indiaroba", 'uf' => "SE", 'codigo' => 2802809],
    		['id' => 1779, 'nome' => "Itabaiana", 'uf' => "SE", 'codigo' => 2802908],
    		['id' => 1780, 'nome' => "Itabaianinha", 'uf' => "SE", 'codigo' => 2803005],
    		['id' => 1781, 'nome' => "Itabi", 'uf' => "SE", 'codigo' => 2803104],
    		['id' => 1782, 'nome' => "Itaporanga D'Ajuda", 'uf' => "SE", 'codigo' => 2803203],
    		['id' => 1783, 'nome' => "Japaratuba", 'uf' => "SE", 'codigo' => 2803302],
    		['id' => 1784, 'nome' => "Japoatã", 'uf' => "SE", 'codigo' => 2803401],
    		['id' => 1785, 'nome' => "Lagarto", 'uf' => "SE", 'codigo' => 2803500],
    		['id' => 1786, 'nome' => "Laranjeiras", 'uf' => "SE", 'codigo' => 2803609],
    		['id' => 1787, 'nome' => "Macambira", 'uf' => "SE", 'codigo' => 2803708],
    		['id' => 1788, 'nome' => "Malhada dos Bois", 'uf' => "SE", 'codigo' => 2803807],
    		['id' => 1789, 'nome' => "Malhador", 'uf' => "SE", 'codigo' => 2803906],
    		['id' => 1790, 'nome' => "Maruim", 'uf' => "SE", 'codigo' => 2804003],
    		['id' => 1791, 'nome' => "Moita Bonita", 'uf' => "SE", 'codigo' => 2804102],
    		['id' => 1792, 'nome' => "Monte Alegre de Sergipe", 'uf' => "SE", 'codigo' => 2804201],
    		['id' => 1793, 'nome' => "Muribeca", 'uf' => "SE", 'codigo' => 2804300],
    		['id' => 1794, 'nome' => "Neópolis", 'uf' => "SE", 'codigo' => 2804409],
    		['id' => 1795, 'nome' => "Nossa Senhora Aparecida", 'uf' => "SE", 'codigo' => 2804458],
    		['id' => 1796, 'nome' => "Nossa Senhora da Glória", 'uf' => "SE", 'codigo' => 2804508],
    		['id' => 1797, 'nome' => "Nossa Senhora das Dores", 'uf' => "SE", 'codigo' => 2804607],
    		['id' => 1798, 'nome' => "Nossa Senhora de Lourdes", 'uf' => "SE", 'codigo' => 2804706],
    		['id' => 1799, 'nome' => "Nossa Senhora do Socorro", 'uf' => "SE", 'codigo' => 2804805],
    		['id' => 1800, 'nome' => "Pacatuba", 'uf' => "SE", 'codigo' => 2804904],
    		['id' => 1801, 'nome' => "Pedra Mole", 'uf' => "SE", 'codigo' => 2805000],
    		['id' => 1802, 'nome' => "Pedrinhas", 'uf' => "SE", 'codigo' => 2805109],
    		['id' => 1803, 'nome' => "Pinhão", 'uf' => "SE", 'codigo' => 2805208],
    		['id' => 1804, 'nome' => "Pirambu", 'uf' => "SE", 'codigo' => 2805307],
    		['id' => 1805, 'nome' => "Poço Redondo", 'uf' => "SE", 'codigo' => 2805406],
    		['id' => 1806, 'nome' => "Poço Verde", 'uf' => "SE", 'codigo' => 2805505],
    		['id' => 1807, 'nome' => "Porto da Folha", 'uf' => "SE", 'codigo' => 2805604],
    		['id' => 1808, 'nome' => "Propriá", 'uf' => "SE", 'codigo' => 2805703],
    		['id' => 1809, 'nome' => "Riachão do Dantas", 'uf' => "SE", 'codigo' => 2805802],
    		['id' => 1810, 'nome' => "Riachuelo", 'uf' => "SE", 'codigo' => 2805901],
    		['id' => 1811, 'nome' => "Ribeirópolis", 'uf' => "SE", 'codigo' => 2806008],
    		['id' => 1812, 'nome' => "Rosário do Catete", 'uf' => "SE", 'codigo' => 2806107],
    		['id' => 1813, 'nome' => "Salgado", 'uf' => "SE", 'codigo' => 2806206],
    		['id' => 1814, 'nome' => "Santa Luzia do Itanhy", 'uf' => "SE", 'codigo' => 2806305],
    		['id' => 1815, 'nome' => "Santana do São Francisco", 'uf' => "SE", 'codigo' => 2806404],
    		['id' => 1816, 'nome' => "Santa Rosa de Lima", 'uf' => "SE", 'codigo' => 2806503],
    		['id' => 1817, 'nome' => "Santo Amaro das Brotas", 'uf' => "SE", 'codigo' => 2806602],
    		['id' => 1818, 'nome' => "São Cristóvão", 'uf' => "SE", 'codigo' => 2806701],
    		['id' => 1819, 'nome' => "São Domingos", 'uf' => "SE", 'codigo' => 2806800],
    		['id' => 1820, 'nome' => "São Francisco", 'uf' => "SE", 'codigo' => 2806909],
    		['id' => 1821, 'nome' => "São Miguel do Aleixo", 'uf' => "SE", 'codigo' => 2807006],
    		['id' => 1822, 'nome' => "Simão Dias", 'uf' => "SE", 'codigo' => 2807105],
    		['id' => 1823, 'nome' => "Siriri", 'uf' => "SE", 'codigo' => 2807204],
    		['id' => 1824, 'nome' => "Telha", 'uf' => "SE", 'codigo' => 2807303],
    		['id' => 1825, 'nome' => "Tobias Barreto", 'uf' => "SE", 'codigo' => 2807402],
    		['id' => 1826, 'nome' => "Tomar do Geru", 'uf' => "SE", 'codigo' => 2807501],
    		['id' => 1827, 'nome' => "Umbaúba", 'uf' => "SE", 'codigo' => 2807600],
    		['id' => 1828, 'nome' => "Abaíra", 'uf' => "BA", 'codigo' => 2900108],
    		['id' => 1829, 'nome' => "Abaré", 'uf' => "BA", 'codigo' => 2900207],
    		['id' => 1830, 'nome' => "Acajutiba", 'uf' => "BA", 'codigo' => 2900306],
    		['id' => 1831, 'nome' => "Adustina", 'uf' => "BA", 'codigo' => 2900355],
    		['id' => 1832, 'nome' => "Água Fria", 'uf' => "BA", 'codigo' => 2900405],
    		['id' => 1833, 'nome' => "Érico Cardoso", 'uf' => "BA", 'codigo' => 2900504],
    		['id' => 1834, 'nome' => "Aiquara", 'uf' => "BA", 'codigo' => 2900603],
    		['id' => 1835, 'nome' => "Alagoinhas", 'uf' => "BA", 'codigo' => 2900702],
    		['id' => 1836, 'nome' => "Alcobaça", 'uf' => "BA", 'codigo' => 2900801],
    		['id' => 1837, 'nome' => "Almadina", 'uf' => "BA", 'codigo' => 2900900],
    		['id' => 1838, 'nome' => "Amargosa", 'uf' => "BA", 'codigo' => 2901007],
    		['id' => 1839, 'nome' => "Amélia Rodrigues", 'uf' => "BA", 'codigo' => 2901106],
    		['id' => 1840, 'nome' => "América Dourada", 'uf' => "BA", 'codigo' => 2901155],
    		['id' => 1841, 'nome' => "Anagé", 'uf' => "BA", 'codigo' => 2901205],
    		['id' => 1842, 'nome' => "Andaraí", 'uf' => "BA", 'codigo' => 2901304],
    		['id' => 1843, 'nome' => "Andorinha", 'uf' => "BA", 'codigo' => 2901353],
    		['id' => 1844, 'nome' => "Angical", 'uf' => "BA", 'codigo' => 2901403],
    		['id' => 1845, 'nome' => "Anguera", 'uf' => "BA", 'codigo' => 2901502],
    		['id' => 1846, 'nome' => "Antas", 'uf' => "BA", 'codigo' => 2901601],
    		['id' => 1847, 'nome' => "Antônio Cardoso", 'uf' => "BA", 'codigo' => 2901700],
    		['id' => 1848, 'nome' => "Antônio Gonçalves", 'uf' => "BA", 'codigo' => 2901809],
    		['id' => 1849, 'nome' => "Aporá", 'uf' => "BA", 'codigo' => 2901908],
    		['id' => 1850, 'nome' => "Apuarema", 'uf' => "BA", 'codigo' => 2901957],
    		['id' => 1851, 'nome' => "Aracatu", 'uf' => "BA", 'codigo' => 2902005],
    		['id' => 1852, 'nome' => "Araças", 'uf' => "BA", 'codigo' => 2902054],
    		['id' => 1853, 'nome' => "Araci", 'uf' => "BA", 'codigo' => 2902104],
    		['id' => 1854, 'nome' => "Aramari", 'uf' => "BA", 'codigo' => 2902203],
    		['id' => 1855, 'nome' => "Arataca", 'uf' => "BA", 'codigo' => 2902252],
    		['id' => 1856, 'nome' => "Aratuípe", 'uf' => "BA", 'codigo' => 2902302],
    		['id' => 1857, 'nome' => "Aurelino Leal", 'uf' => "BA", 'codigo' => 2902401],
    		['id' => 1858, 'nome' => "Baianópolis", 'uf' => "BA", 'codigo' => 2902500],
    		['id' => 1859, 'nome' => "Baixa Grande", 'uf' => "BA", 'codigo' => 2902609],
    		['id' => 1860, 'nome' => "Banzaê", 'uf' => "BA", 'codigo' => 2902658],
    		['id' => 1861, 'nome' => "Barra", 'uf' => "BA", 'codigo' => 2902708],
    		['id' => 1862, 'nome' => "Barra da Estiva", 'uf' => "BA", 'codigo' => 2902807],
    		['id' => 1863, 'nome' => "Barra do Choça", 'uf' => "BA", 'codigo' => 2902906],
    		['id' => 1864, 'nome' => "Barra do Mendes", 'uf' => "BA", 'codigo' => 2903003],
    		['id' => 1865, 'nome' => "Barra do Rocha", 'uf' => "BA", 'codigo' => 2903102],
    		['id' => 1866, 'nome' => "Barreiras", 'uf' => "BA", 'codigo' => 2903201],
    		['id' => 1867, 'nome' => "Barro Alto", 'uf' => "BA", 'codigo' => 2903235],
    		['id' => 1868, 'nome' => "Barrocas", 'uf' => "BA", 'codigo' => 2903276],
    		['id' => 1869, 'nome' => "Barro Preto", 'uf' => "BA", 'codigo' => 2903300],
    		['id' => 1870, 'nome' => "Belmonte", 'uf' => "BA", 'codigo' => 2903409],
    		['id' => 1871, 'nome' => "Belo Campo", 'uf' => "BA", 'codigo' => 2903508],
    		['id' => 1872, 'nome' => "Biritinga", 'uf' => "BA", 'codigo' => 2903607],
    		['id' => 1873, 'nome' => "Boa Nova", 'uf' => "BA", 'codigo' => 2903706],
    		['id' => 1874, 'nome' => "Boa Vista do Tupim", 'uf' => "BA", 'codigo' => 2903805],
    		['id' => 1875, 'nome' => "Bom Jesus da Lapa", 'uf' => "BA", 'codigo' => 2903904],
    		['id' => 1876, 'nome' => "Bom Jesus da Serra", 'uf' => "BA", 'codigo' => 2903953],
    		['id' => 1877, 'nome' => "Boninal", 'uf' => "BA", 'codigo' => 2904001],
    		['id' => 1878, 'nome' => "Bonito", 'uf' => "BA", 'codigo' => 2904050],
    		['id' => 1879, 'nome' => "Boquira", 'uf' => "BA", 'codigo' => 2904100],
    		['id' => 1880, 'nome' => "Botuporã", 'uf' => "BA", 'codigo' => 2904209],
    		['id' => 1881, 'nome' => "Brejões", 'uf' => "BA", 'codigo' => 2904308],
    		['id' => 1882, 'nome' => "Brejolândia", 'uf' => "BA", 'codigo' => 2904407],
    		['id' => 1883, 'nome' => "Brotas de Macaúbas", 'uf' => "BA", 'codigo' => 2904506],
    		['id' => 1884, 'nome' => "Brumado", 'uf' => "BA", 'codigo' => 2904605],
    		['id' => 1885, 'nome' => "Buerarema", 'uf' => "BA", 'codigo' => 2904704],
    		['id' => 1886, 'nome' => "Buritirama", 'uf' => "BA", 'codigo' => 2904753],
    		['id' => 1887, 'nome' => "Caatiba", 'uf' => "BA", 'codigo' => 2904803],
    		['id' => 1888, 'nome' => "Cabaceiras do Paraguaçu", 'uf' => "BA", 'codigo' => 2904852],
    		['id' => 1889, 'nome' => "Cachoeira", 'uf' => "BA", 'codigo' => 2904902],
    		['id' => 1890, 'nome' => "Caculé", 'uf' => "BA", 'codigo' => 2905008],
    		['id' => 1891, 'nome' => "Caém", 'uf' => "BA", 'codigo' => 2905107],
    		['id' => 1892, 'nome' => "Caetanos", 'uf' => "BA", 'codigo' => 2905156],
    		['id' => 1893, 'nome' => "Caetité", 'uf' => "BA", 'codigo' => 2905206],
    		['id' => 1894, 'nome' => "Cafarnaum", 'uf' => "BA", 'codigo' => 2905305],
    		['id' => 1895, 'nome' => "Cairu", 'uf' => "BA", 'codigo' => 2905404],
    		['id' => 1896, 'nome' => "Caldeirão Grande", 'uf' => "BA", 'codigo' => 2905503],
    		['id' => 1897, 'nome' => "Camacan", 'uf' => "BA", 'codigo' => 2905602],
    		['id' => 1898, 'nome' => "Camaçari", 'uf' => "BA", 'codigo' => 2905701],
    		['id' => 1899, 'nome' => "Camamu", 'uf' => "BA", 'codigo' => 2905800],
    		['id' => 1900, 'nome' => "Campo Alegre de Lourdes", 'uf' => "BA", 'codigo' => 2905909],
    		['id' => 1901, 'nome' => "Campo Formoso", 'uf' => "BA", 'codigo' => 2906006],
    		['id' => 1902, 'nome' => "Canápolis", 'uf' => "BA", 'codigo' => 2906105],
    		['id' => 1903, 'nome' => "Canarana", 'uf' => "BA", 'codigo' => 2906204],
    		['id' => 1904, 'nome' => "Canavieiras", 'uf' => "BA", 'codigo' => 2906303],
    		['id' => 1905, 'nome' => "Candeal", 'uf' => "BA", 'codigo' => 2906402],
    		['id' => 1906, 'nome' => "Candeias", 'uf' => "BA", 'codigo' => 2906501],
    		['id' => 1907, 'nome' => "Candiba", 'uf' => "BA", 'codigo' => 2906600],
    		['id' => 1908, 'nome' => "Cândido Sales", 'uf' => "BA", 'codigo' => 2906709],
    		['id' => 1909, 'nome' => "Cansanção", 'uf' => "BA", 'codigo' => 2906808],
    		['id' => 1910, 'nome' => "Canudos", 'uf' => "BA", 'codigo' => 2906824],
    		['id' => 1911, 'nome' => "Capela do Alto Alegre", 'uf' => "BA", 'codigo' => 2906857],
    		['id' => 1912, 'nome' => "Capim Grosso", 'uf' => "BA", 'codigo' => 2906873],
    		['id' => 1913, 'nome' => "Caraíbas", 'uf' => "BA", 'codigo' => 2906899],
    		['id' => 1914, 'nome' => "Caravelas", 'uf' => "BA", 'codigo' => 2906907],
    		['id' => 1915, 'nome' => "Cardeal da Silva", 'uf' => "BA", 'codigo' => 2907004],
    		['id' => 1916, 'nome' => "Carinhanha", 'uf' => "BA", 'codigo' => 2907103],
    		['id' => 1917, 'nome' => "Casa Nova", 'uf' => "BA", 'codigo' => 2907202],
    		['id' => 1918, 'nome' => "Castro Alves", 'uf' => "BA", 'codigo' => 2907301],
    		['id' => 1919, 'nome' => "Catolândia", 'uf' => "BA", 'codigo' => 2907400],
    		['id' => 1920, 'nome' => "Catu", 'uf' => "BA", 'codigo' => 2907509],
    		['id' => 1921, 'nome' => "Caturama", 'uf' => "BA", 'codigo' => 2907558],
    		['id' => 1922, 'nome' => "Central", 'uf' => "BA", 'codigo' => 2907608],
    		['id' => 1923, 'nome' => "Chorrochó", 'uf' => "BA", 'codigo' => 2907707],
    		['id' => 1924, 'nome' => "Cícero Dantas", 'uf' => "BA", 'codigo' => 2907806],
    		['id' => 1925, 'nome' => "Cipó", 'uf' => "BA", 'codigo' => 2907905],
    		['id' => 1926, 'nome' => "Coaraci", 'uf' => "BA", 'codigo' => 2908002],
    		['id' => 1927, 'nome' => "Cocos", 'uf' => "BA", 'codigo' => 2908101],
    		['id' => 1928, 'nome' => "Conceição da Feira", 'uf' => "BA", 'codigo' => 2908200],
    		['id' => 1929, 'nome' => "Conceição do Almeida", 'uf' => "BA", 'codigo' => 2908309],
    		['id' => 1930, 'nome' => "Conceição do Coité", 'uf' => "BA", 'codigo' => 2908408],
    		['id' => 1931, 'nome' => "Conceição do Jacuípe", 'uf' => "BA", 'codigo' => 2908507],
    		['id' => 1932, 'nome' => "Conde", 'uf' => "BA", 'codigo' => 2908606],
    		['id' => 1933, 'nome' => "Condeúba", 'uf' => "BA", 'codigo' => 2908705],
    		['id' => 1934, 'nome' => "Contendas do Sincorá", 'uf' => "BA", 'codigo' => 2908804],
    		['id' => 1935, 'nome' => "Coração de Maria", 'uf' => "BA", 'codigo' => 2908903],
    		['id' => 1936, 'nome' => "Cordeiros", 'uf' => "BA", 'codigo' => 2909000],
    		['id' => 1937, 'nome' => "Coribe", 'uf' => "BA", 'codigo' => 2909109],
    		['id' => 1938, 'nome' => "Coronel João Sá", 'uf' => "BA", 'codigo' => 2909208],
    		['id' => 1939, 'nome' => "Correntina", 'uf' => "BA", 'codigo' => 2909307],
    		['id' => 1940, 'nome' => "Cotegipe", 'uf' => "BA", 'codigo' => 2909406],
    		['id' => 1941, 'nome' => "Cravolândia", 'uf' => "BA", 'codigo' => 2909505],
    		['id' => 1942, 'nome' => "Crisópolis", 'uf' => "BA", 'codigo' => 2909604],
    		['id' => 1943, 'nome' => "Cristópolis", 'uf' => "BA", 'codigo' => 2909703],
    		['id' => 1944, 'nome' => "Cruz das Almas", 'uf' => "BA", 'codigo' => 2909802],
    		['id' => 1945, 'nome' => "Curaçá", 'uf' => "BA", 'codigo' => 2909901],
    		['id' => 1946, 'nome' => "Dário Meira", 'uf' => "BA", 'codigo' => 2910008],
    		['id' => 1947, 'nome' => "Dias D'Ávila", 'uf' => "BA", 'codigo' => 2910057],
    		['id' => 1948, 'nome' => "Dom Basílio", 'uf' => "BA", 'codigo' => 2910107],
    		['id' => 1949, 'nome' => "Dom Macedo Costa", 'uf' => "BA", 'codigo' => 2910206],
    		['id' => 1950, 'nome' => "Elísio Medrado", 'uf' => "BA", 'codigo' => 2910305],
    		['id' => 1951, 'nome' => "Encruzilhada", 'uf' => "BA", 'codigo' => 2910404],
    		['id' => 1952, 'nome' => "Entre Rios", 'uf' => "BA", 'codigo' => 2910503],
    		['id' => 1953, 'nome' => "Esplanada", 'uf' => "BA", 'codigo' => 2910602],
    		['id' => 1954, 'nome' => "Euclides da Cunha", 'uf' => "BA", 'codigo' => 2910701],
    		['id' => 1955, 'nome' => "Eunápolis", 'uf' => "BA", 'codigo' => 2910727],
    		['id' => 1956, 'nome' => "Fátima", 'uf' => "BA", 'codigo' => 2910750],
    		['id' => 1957, 'nome' => "Feira da Mata", 'uf' => "BA", 'codigo' => 2910776],
    		['id' => 1958, 'nome' => "Feira de Santana", 'uf' => "BA", 'codigo' => 2910800],
    		['id' => 1959, 'nome' => "Filadélfia", 'uf' => "BA", 'codigo' => 2910859],
    		['id' => 1960, 'nome' => "Firmino Alves", 'uf' => "BA", 'codigo' => 2910909],
    		['id' => 1961, 'nome' => "Floresta Azul", 'uf' => "BA", 'codigo' => 2911006],
    		['id' => 1962, 'nome' => "Formosa do Rio Preto", 'uf' => "BA", 'codigo' => 2911105],
    		['id' => 1963, 'nome' => "Gandu", 'uf' => "BA", 'codigo' => 2911204],
    		['id' => 1964, 'nome' => "Gavião", 'uf' => "BA", 'codigo' => 2911253],
    		['id' => 1965, 'nome' => "Gentio do Ouro", 'uf' => "BA", 'codigo' => 2911303],
    		['id' => 1966, 'nome' => "Glória", 'uf' => "BA", 'codigo' => 2911402],
    		['id' => 1967, 'nome' => "Gongogi", 'uf' => "BA", 'codigo' => 2911501],
    		['id' => 1968, 'nome' => "Governador Mangabeira", 'uf' => "BA", 'codigo' => 2911600],
    		['id' => 1969, 'nome' => "Guajeru", 'uf' => "BA", 'codigo' => 2911659],
    		['id' => 1970, 'nome' => "Guanambi", 'uf' => "BA", 'codigo' => 2911709],
    		['id' => 1971, 'nome' => "Guaratinga", 'uf' => "BA", 'codigo' => 2911808],
    		['id' => 1972, 'nome' => "Heliópolis", 'uf' => "BA", 'codigo' => 2911857],
    		['id' => 1973, 'nome' => "Iaçu", 'uf' => "BA", 'codigo' => 2911907],
    		['id' => 1974, 'nome' => "Ibiassucê", 'uf' => "BA", 'codigo' => 2912004],
    		['id' => 1975, 'nome' => "Ibicaraí", 'uf' => "BA", 'codigo' => 2912103],
    		['id' => 1976, 'nome' => "Ibicoara", 'uf' => "BA", 'codigo' => 2912202],
    		['id' => 1977, 'nome' => "Ibicuí", 'uf' => "BA", 'codigo' => 2912301],
    		['id' => 1978, 'nome' => "Ibipeba", 'uf' => "BA", 'codigo' => 2912400],
    		['id' => 1979, 'nome' => "Ibipitanga", 'uf' => "BA", 'codigo' => 2912509],
    		['id' => 1980, 'nome' => "Ibiquera", 'uf' => "BA", 'codigo' => 2912608],
    		['id' => 1981, 'nome' => "Ibirapitanga", 'uf' => "BA", 'codigo' => 2912707],
    		['id' => 1982, 'nome' => "Ibirapuã", 'uf' => "BA", 'codigo' => 2912806],
    		['id' => 1983, 'nome' => "Ibirataia", 'uf' => "BA", 'codigo' => 2912905],
    		['id' => 1984, 'nome' => "Ibitiara", 'uf' => "BA", 'codigo' => 2913002],
    		['id' => 1985, 'nome' => "Ibititá", 'uf' => "BA", 'codigo' => 2913101],
    		['id' => 1986, 'nome' => "Ibotirama", 'uf' => "BA", 'codigo' => 2913200],
    		['id' => 1987, 'nome' => "Ichu", 'uf' => "BA", 'codigo' => 2913309],
    		['id' => 1988, 'nome' => "Igaporã", 'uf' => "BA", 'codigo' => 2913408],
    		['id' => 1989, 'nome' => "Igrapiúna", 'uf' => "BA", 'codigo' => 2913457],
    		['id' => 1990, 'nome' => "Iguaí", 'uf' => "BA", 'codigo' => 2913507],
    		['id' => 1991, 'nome' => "Ilhéus", 'uf' => "BA", 'codigo' => 2913606],
    		['id' => 1992, 'nome' => "Inhambupe", 'uf' => "BA", 'codigo' => 2913705],
    		['id' => 1993, 'nome' => "Ipecaetá", 'uf' => "BA", 'codigo' => 2913804],
    		['id' => 1994, 'nome' => "Ipiaú", 'uf' => "BA", 'codigo' => 2913903],
    		['id' => 1995, 'nome' => "Ipirá", 'uf' => "BA", 'codigo' => 2914000],
    		['id' => 1996, 'nome' => "Ipupiara", 'uf' => "BA", 'codigo' => 2914109],
    		['id' => 1997, 'nome' => "Irajuba", 'uf' => "BA", 'codigo' => 2914208],
    		['id' => 1998, 'nome' => "Iramaia", 'uf' => "BA", 'codigo' => 2914307],
    		['id' => 1999, 'nome' => "Iraquara", 'uf' => "BA", 'codigo' => 2914406],
    		['id' => 2000, 'nome' => "Irará", 'uf' => "BA", 'codigo' => 2914505],
    		['id' => 2001, 'nome' => "Irecê", 'uf' => "BA", 'codigo' => 2914604],
    		['id' => 2002, 'nome' => "Itabela", 'uf' => "BA", 'codigo' => 2914653],
    		['id' => 2003, 'nome' => "Itaberaba", 'uf' => "BA", 'codigo' => 2914703],
    		['id' => 2004, 'nome' => "Itabuna", 'uf' => "BA", 'codigo' => 2914802],
    		['id' => 2005, 'nome' => "Itacaré", 'uf' => "BA", 'codigo' => 2914901],
    		['id' => 2006, 'nome' => "Itaeté", 'uf' => "BA", 'codigo' => 2915007],
    		['id' => 2007, 'nome' => "Itagi", 'uf' => "BA", 'codigo' => 2915106],
    		['id' => 2008, 'nome' => "Itagibá", 'uf' => "BA", 'codigo' => 2915205],
    		['id' => 2009, 'nome' => "Itagimirim", 'uf' => "BA", 'codigo' => 2915304],
    		['id' => 2010, 'nome' => "Itaguaçu da Bahia", 'uf' => "BA", 'codigo' => 2915353],
    		['id' => 2011, 'nome' => "Itaju do Colônia", 'uf' => "BA", 'codigo' => 2915403],
    		['id' => 2012, 'nome' => "Itajuípe", 'uf' => "BA", 'codigo' => 2915502],
    		['id' => 2013, 'nome' => "Itamaraju", 'uf' => "BA", 'codigo' => 2915601],
    		['id' => 2014, 'nome' => "Itamari", 'uf' => "BA", 'codigo' => 2915700],
    		['id' => 2015, 'nome' => "Itambé", 'uf' => "BA", 'codigo' => 2915809],
    		['id' => 2016, 'nome' => "Itanagra", 'uf' => "BA", 'codigo' => 2915908],
    		['id' => 2017, 'nome' => "Itanhém", 'uf' => "BA", 'codigo' => 2916005],
    		['id' => 2018, 'nome' => "Itaparica", 'uf' => "BA", 'codigo' => 2916104],
    		['id' => 2019, 'nome' => "Itapé", 'uf' => "BA", 'codigo' => 2916203],
    		['id' => 2020, 'nome' => "Itapebi", 'uf' => "BA", 'codigo' => 2916302],
    		['id' => 2021, 'nome' => "Itapetinga", 'uf' => "BA", 'codigo' => 2916401],
    		['id' => 2022, 'nome' => "Itapicuru", 'uf' => "BA", 'codigo' => 2916500],
    		['id' => 2023, 'nome' => "Itapitanga", 'uf' => "BA", 'codigo' => 2916609],
    		['id' => 2024, 'nome' => "Itaquara", 'uf' => "BA", 'codigo' => 2916708],
    		['id' => 2025, 'nome' => "Itarantim", 'uf' => "BA", 'codigo' => 2916807],
    		['id' => 2026, 'nome' => "Itatim", 'uf' => "BA", 'codigo' => 2916856],
    		['id' => 2027, 'nome' => "Itiruçu", 'uf' => "BA", 'codigo' => 2916906],
    		['id' => 2028, 'nome' => "Itiúba", 'uf' => "BA", 'codigo' => 2917003],
    		['id' => 2029, 'nome' => "Itororó", 'uf' => "BA", 'codigo' => 2917102],
    		['id' => 2030, 'nome' => "Ituaçu", 'uf' => "BA", 'codigo' => 2917201],
    		['id' => 2031, 'nome' => "Ituberá", 'uf' => "BA", 'codigo' => 2917300],
    		['id' => 2032, 'nome' => "Iuiú", 'uf' => "BA", 'codigo' => 2917334],
    		['id' => 2033, 'nome' => "Jaborandi", 'uf' => "BA", 'codigo' => 2917359],
    		['id' => 2034, 'nome' => "Jacaraci", 'uf' => "BA", 'codigo' => 2917409],
    		['id' => 2035, 'nome' => "Jacobina", 'uf' => "BA", 'codigo' => 2917508],
    		['id' => 2036, 'nome' => "Jaguaquara", 'uf' => "BA", 'codigo' => 2917607],
    		['id' => 2037, 'nome' => "Jaguarari", 'uf' => "BA", 'codigo' => 2917706],
    		['id' => 2038, 'nome' => "Jaguaripe", 'uf' => "BA", 'codigo' => 2917805],
    		['id' => 2039, 'nome' => "Jandaíra", 'uf' => "BA", 'codigo' => 2917904],
    		['id' => 2040, 'nome' => "Jequié", 'uf' => "BA", 'codigo' => 2918001],
    		['id' => 2041, 'nome' => "Jeremoabo", 'uf' => "BA", 'codigo' => 2918100],
    		['id' => 2042, 'nome' => "Jiquiriçá", 'uf' => "BA", 'codigo' => 2918209],
    		['id' => 2043, 'nome' => "Jitaúna", 'uf' => "BA", 'codigo' => 2918308],
    		['id' => 2044, 'nome' => "João Dourado", 'uf' => "BA", 'codigo' => 2918357],
    		['id' => 2045, 'nome' => "Juazeiro", 'uf' => "BA", 'codigo' => 2918407],
    		['id' => 2046, 'nome' => "Jucuruçu", 'uf' => "BA", 'codigo' => 2918456],
    		['id' => 2047, 'nome' => "Jussara", 'uf' => "BA", 'codigo' => 2918506],
    		['id' => 2048, 'nome' => "Jussari", 'uf' => "BA", 'codigo' => 2918555],
    		['id' => 2049, 'nome' => "Jussiape", 'uf' => "BA", 'codigo' => 2918605],
    		['id' => 2050, 'nome' => "Lafaiete Coutinho", 'uf' => "BA", 'codigo' => 2918704],
    		['id' => 2051, 'nome' => "Lagoa Real", 'uf' => "BA", 'codigo' => 2918753],
    		['id' => 2052, 'nome' => "Laje", 'uf' => "BA", 'codigo' => 2918803],
    		['id' => 2053, 'nome' => "Lajedão", 'uf' => "BA", 'codigo' => 2918902],
    		['id' => 2054, 'nome' => "Lajedinho", 'uf' => "BA", 'codigo' => 2919009],
    		['id' => 2055, 'nome' => "Lajedo do Tabocal", 'uf' => "BA", 'codigo' => 2919058],
    		['id' => 2056, 'nome' => "Lamarão", 'uf' => "BA", 'codigo' => 2919108],
    		['id' => 2057, 'nome' => "Lapão", 'uf' => "BA", 'codigo' => 2919157],
    		['id' => 2058, 'nome' => "Lauro de Freitas", 'uf' => "BA", 'codigo' => 2919207],
    		['id' => 2059, 'nome' => "Lençóis", 'uf' => "BA", 'codigo' => 2919306],
    		['id' => 2060, 'nome' => "Licínio de Almeida", 'uf' => "BA", 'codigo' => 2919405],
    		['id' => 2061, 'nome' => "Livramento de Nossa Senhora", 'uf' => "BA", 'codigo' => 2919504],
    		['id' => 2062, 'nome' => "Luís Eduardo Magalhães", 'uf' => "BA", 'codigo' => 2919553],
    		['id' => 2063, 'nome' => "Macajuba", 'uf' => "BA", 'codigo' => 2919603],
    		['id' => 2064, 'nome' => "Macarani", 'uf' => "BA", 'codigo' => 2919702],
    		['id' => 2065, 'nome' => "Macaúbas", 'uf' => "BA", 'codigo' => 2919801],
    		['id' => 2066, 'nome' => "Macururé", 'uf' => "BA", 'codigo' => 2919900],
    		['id' => 2067, 'nome' => "Madre de Deus", 'uf' => "BA", 'codigo' => 2919926],
    		['id' => 2068, 'nome' => "Maetinga", 'uf' => "BA", 'codigo' => 2919959],
    		['id' => 2069, 'nome' => "Maiquinique", 'uf' => "BA", 'codigo' => 2920007],
    		['id' => 2070, 'nome' => "Mairi", 'uf' => "BA", 'codigo' => 2920106],
    		['id' => 2071, 'nome' => "Malhada", 'uf' => "BA", 'codigo' => 2920205],
    		['id' => 2072, 'nome' => "Malhada de Pedras", 'uf' => "BA", 'codigo' => 2920304],
    		['id' => 2073, 'nome' => "Manoel Vitorino", 'uf' => "BA", 'codigo' => 2920403],
    		['id' => 2074, 'nome' => "Mansidão", 'uf' => "BA", 'codigo' => 2920452],
    		['id' => 2075, 'nome' => "Maracás", 'uf' => "BA", 'codigo' => 2920502],
    		['id' => 2076, 'nome' => "Maragogipe", 'uf' => "BA", 'codigo' => 2920601],
    		['id' => 2077, 'nome' => "Maraú", 'uf' => "BA", 'codigo' => 2920700],
    		['id' => 2078, 'nome' => "Marcionílio Souza", 'uf' => "BA", 'codigo' => 2920809],
    		['id' => 2079, 'nome' => "Mascote", 'uf' => "BA", 'codigo' => 2920908],
    		['id' => 2080, 'nome' => "Mata de São João", 'uf' => "BA", 'codigo' => 2921005],
    		['id' => 2081, 'nome' => "Matina", 'uf' => "BA", 'codigo' => 2921054],
    		['id' => 2082, 'nome' => "Medeiros Neto", 'uf' => "BA", 'codigo' => 2921104],
    		['id' => 2083, 'nome' => "Miguel Calmon", 'uf' => "BA", 'codigo' => 2921203],
    		['id' => 2084, 'nome' => "Milagres", 'uf' => "BA", 'codigo' => 2921302],
    		['id' => 2085, 'nome' => "Mirangaba", 'uf' => "BA", 'codigo' => 2921401],
    		['id' => 2086, 'nome' => "Mirante", 'uf' => "BA", 'codigo' => 2921450],
    		['id' => 2087, 'nome' => "Monte Santo", 'uf' => "BA", 'codigo' => 2921500],
    		['id' => 2088, 'nome' => "Morpará", 'uf' => "BA", 'codigo' => 2921609],
    		['id' => 2089, 'nome' => "Morro do Chapéu", 'uf' => "BA", 'codigo' => 2921708],
    		['id' => 2090, 'nome' => "Mortugaba", 'uf' => "BA", 'codigo' => 2921807],
    		['id' => 2091, 'nome' => "Mucugê", 'uf' => "BA", 'codigo' => 2921906],
    		['id' => 2092, 'nome' => "Mucuri", 'uf' => "BA", 'codigo' => 2922003],
    		['id' => 2093, 'nome' => "Mulungu do Morro", 'uf' => "BA", 'codigo' => 2922052],
    		['id' => 2094, 'nome' => "Mundo Novo", 'uf' => "BA", 'codigo' => 2922102],
    		['id' => 2095, 'nome' => "Muniz Ferreira", 'uf' => "BA", 'codigo' => 2922201],
    		['id' => 2096, 'nome' => "Muquém de São Francisco", 'uf' => "BA", 'codigo' => 2922250],
    		['id' => 2097, 'nome' => "Muritiba", 'uf' => "BA", 'codigo' => 2922300],
    		['id' => 2098, 'nome' => "Mutuípe", 'uf' => "BA", 'codigo' => 2922409],
    		['id' => 2099, 'nome' => "Nazaré", 'uf' => "BA", 'codigo' => 2922508],
    		['id' => 2100, 'nome' => "Nilo Peçanha", 'uf' => "BA", 'codigo' => 2922607],
    		['id' => 2101, 'nome' => "Nordestina", 'uf' => "BA", 'codigo' => 2922656],
    		['id' => 2102, 'nome' => "Nova Canaã", 'uf' => "BA", 'codigo' => 2922706],
    		['id' => 2103, 'nome' => "Nova Fátima", 'uf' => "BA", 'codigo' => 2922730],
    		['id' => 2104, 'nome' => "Nova Ibiá", 'uf' => "BA", 'codigo' => 2922755],
    		['id' => 2105, 'nome' => "Nova Itarana", 'uf' => "BA", 'codigo' => 2922805],
    		['id' => 2106, 'nome' => "Nova Redenção", 'uf' => "BA", 'codigo' => 2922854],
    		['id' => 2107, 'nome' => "Nova Soure", 'uf' => "BA", 'codigo' => 2922904],
    		['id' => 2108, 'nome' => "Nova Viçosa", 'uf' => "BA", 'codigo' => 2923001],
    		['id' => 2109, 'nome' => "Novo Horizonte", 'uf' => "BA", 'codigo' => 2923035],
    		['id' => 2110, 'nome' => "Novo Triunfo", 'uf' => "BA", 'codigo' => 2923050],
    		['id' => 2111, 'nome' => "Olindina", 'uf' => "BA", 'codigo' => 2923100],
    		['id' => 2112, 'nome' => "Oliveira dos Brejinhos", 'uf' => "BA", 'codigo' => 2923209],
    		['id' => 2113, 'nome' => "Ouriçangas", 'uf' => "BA", 'codigo' => 2923308],
    		['id' => 2114, 'nome' => "Ourolândia", 'uf' => "BA", 'codigo' => 2923357],
    		['id' => 2115, 'nome' => "Palmas de Monte Alto", 'uf' => "BA", 'codigo' => 2923407],
    		['id' => 2116, 'nome' => "Palmeiras", 'uf' => "BA", 'codigo' => 2923506],
    		['id' => 2117, 'nome' => "Paramirim", 'uf' => "BA", 'codigo' => 2923605],
    		['id' => 2118, 'nome' => "Paratinga", 'uf' => "BA", 'codigo' => 2923704],
    		['id' => 2119, 'nome' => "Paripiranga", 'uf' => "BA", 'codigo' => 2923803],
    		['id' => 2120, 'nome' => "Pau Brasil", 'uf' => "BA", 'codigo' => 2923902],
    		['id' => 2121, 'nome' => "Paulo Afonso", 'uf' => "BA", 'codigo' => 2924009],
    		['id' => 2122, 'nome' => "Pé de Serra", 'uf' => "BA", 'codigo' => 2924058],
    		['id' => 2123, 'nome' => "Pedrão", 'uf' => "BA", 'codigo' => 2924108],
    		['id' => 2124, 'nome' => "Pedro Alexandre", 'uf' => "BA", 'codigo' => 2924207],
    		['id' => 2125, 'nome' => "Piatã", 'uf' => "BA", 'codigo' => 2924306],
    		['id' => 2126, 'nome' => "Pilão Arcado", 'uf' => "BA", 'codigo' => 2924405],
    		['id' => 2127, 'nome' => "Pindaí", 'uf' => "BA", 'codigo' => 2924504],
    		['id' => 2128, 'nome' => "Pindobaçu", 'uf' => "BA", 'codigo' => 2924603],
    		['id' => 2129, 'nome' => "Pintadas", 'uf' => "BA", 'codigo' => 2924652],
    		['id' => 2130, 'nome' => "Piraí do Norte", 'uf' => "BA", 'codigo' => 2924678],
    		['id' => 2131, 'nome' => "Piripá", 'uf' => "BA", 'codigo' => 2924702],
    		['id' => 2132, 'nome' => "Piritiba", 'uf' => "BA", 'codigo' => 2924801],
    		['id' => 2133, 'nome' => "Planaltino", 'uf' => "BA", 'codigo' => 2924900],
    		['id' => 2134, 'nome' => "Planalto", 'uf' => "BA", 'codigo' => 2925006],
    		['id' => 2135, 'nome' => "Poções", 'uf' => "BA", 'codigo' => 2925105],
    		['id' => 2136, 'nome' => "Pojuca", 'uf' => "BA", 'codigo' => 2925204],
    		['id' => 2137, 'nome' => "Ponto Novo", 'uf' => "BA", 'codigo' => 2925253],
    		['id' => 2138, 'nome' => "Porto Seguro", 'uf' => "BA", 'codigo' => 2925303],
    		['id' => 2139, 'nome' => "Potiraguá", 'uf' => "BA", 'codigo' => 2925402],
    		['id' => 2140, 'nome' => "Prado", 'uf' => "BA", 'codigo' => 2925501],
    		['id' => 2141, 'nome' => "Presidente Dutra", 'uf' => "BA", 'codigo' => 2925600],
    		['id' => 2142, 'nome' => "Presidente Jânio Quadros", 'uf' => "BA", 'codigo' => 2925709],
    		['id' => 2143, 'nome' => "Presidente Tancredo Neves", 'uf' => "BA", 'codigo' => 2925758],
    		['id' => 2144, 'nome' => "Queimadas", 'uf' => "BA", 'codigo' => 2925808],
    		['id' => 2145, 'nome' => "Quijingue", 'uf' => "BA", 'codigo' => 2925907],
    		['id' => 2146, 'nome' => "Quixabeira", 'uf' => "BA", 'codigo' => 2925931],
    		['id' => 2147, 'nome' => "Rafael Jambeiro", 'uf' => "BA", 'codigo' => 2925956],
    		['id' => 2148, 'nome' => "Remanso", 'uf' => "BA", 'codigo' => 2926004],
    		['id' => 2149, 'nome' => "Retirolândia", 'uf' => "BA", 'codigo' => 2926103],
    		['id' => 2150, 'nome' => "Riachão das Neves", 'uf' => "BA", 'codigo' => 2926202],
    		['id' => 2151, 'nome' => "Riachão do Jacuípe", 'uf' => "BA", 'codigo' => 2926301],
    		['id' => 2152, 'nome' => "Riacho de Santana", 'uf' => "BA", 'codigo' => 2926400],
    		['id' => 2153, 'nome' => "Ribeira do Amparo", 'uf' => "BA", 'codigo' => 2926509],
    		['id' => 2154, 'nome' => "Ribeira do Pombal", 'uf' => "BA", 'codigo' => 2926608],
    		['id' => 2155, 'nome' => "Ribeirão do Largo", 'uf' => "BA", 'codigo' => 2926657],
    		['id' => 2156, 'nome' => "Rio de Contas", 'uf' => "BA", 'codigo' => 2926707],
    		['id' => 2157, 'nome' => "Rio do Antônio", 'uf' => "BA", 'codigo' => 2926806],
    		['id' => 2158, 'nome' => "Rio do Pires", 'uf' => "BA", 'codigo' => 2926905],
    		['id' => 2159, 'nome' => "Rio Real", 'uf' => "BA", 'codigo' => 2927002],
    		['id' => 2160, 'nome' => "Rodelas", 'uf' => "BA", 'codigo' => 2927101],
    		['id' => 2161, 'nome' => "Ruy Barbosa", 'uf' => "BA", 'codigo' => 2927200],
    		['id' => 2162, 'nome' => "Salinas da Margarida", 'uf' => "BA", 'codigo' => 2927309],
    		['id' => 2163, 'nome' => "Salvador", 'uf' => "BA", 'codigo' => 2927408],
    		['id' => 2164, 'nome' => "Santa Bárbara", 'uf' => "BA", 'codigo' => 2927507],
    		['id' => 2165, 'nome' => "Santa Brígida", 'uf' => "BA", 'codigo' => 2927606],
    		['id' => 2166, 'nome' => "Santa Cruz Cabrália", 'uf' => "BA", 'codigo' => 2927705],
    		['id' => 2167, 'nome' => "Santa Cruz da Vitória", 'uf' => "BA", 'codigo' => 2927804],
    		['id' => 2168, 'nome' => "Santa Inês", 'uf' => "BA", 'codigo' => 2927903],
    		['id' => 2169, 'nome' => "Santaluz", 'uf' => "BA", 'codigo' => 2928000],
    		['id' => 2170, 'nome' => "Santa Luzia", 'uf' => "BA", 'codigo' => 2928059],
    		['id' => 2171, 'nome' => "Santa Maria da Vitória", 'uf' => "BA", 'codigo' => 2928109],
    		['id' => 2172, 'nome' => "Santana", 'uf' => "BA", 'codigo' => 2928208],
    		['id' => 2173, 'nome' => "Santanópolis", 'uf' => "BA", 'codigo' => 2928307],
    		['id' => 2174, 'nome' => "Santa Rita de Cássia", 'uf' => "BA", 'codigo' => 2928406],
    		['id' => 2175, 'nome' => "Santa Teresinha", 'uf' => "BA", 'codigo' => 2928505],
    		['id' => 2176, 'nome' => "Santo Amaro", 'uf' => "BA", 'codigo' => 2928604],
    		['id' => 2177, 'nome' => "Santo Antônio de Jesus", 'uf' => "BA", 'codigo' => 2928703],
    		['id' => 2178, 'nome' => "Santo Estêvão", 'uf' => "BA", 'codigo' => 2928802],
    		['id' => 2179, 'nome' => "São Desidério", 'uf' => "BA", 'codigo' => 2928901],
    		['id' => 2180, 'nome' => "São Domingos", 'uf' => "BA", 'codigo' => 2928950],
    		['id' => 2181, 'nome' => "São Félix", 'uf' => "BA", 'codigo' => 2929008],
    		['id' => 2182, 'nome' => "São Félix do Coribe", 'uf' => "BA", 'codigo' => 2929057],
    		['id' => 2183, 'nome' => "São Felipe", 'uf' => "BA", 'codigo' => 2929107],
    		['id' => 2184, 'nome' => "São Francisco do Conde", 'uf' => "BA", 'codigo' => 2929206],
    		['id' => 2185, 'nome' => "São Gabriel", 'uf' => "BA", 'codigo' => 2929255],
    		['id' => 2186, 'nome' => "São Gonçalo dos Campos", 'uf' => "BA", 'codigo' => 2929305],
    		['id' => 2187, 'nome' => "São José da Vitória", 'uf' => "BA", 'codigo' => 2929354],
    		['id' => 2188, 'nome' => "São José do Jacuípe", 'uf' => "BA", 'codigo' => 2929370],
    		['id' => 2189, 'nome' => "São Miguel das Matas", 'uf' => "BA", 'codigo' => 2929404],
    		['id' => 2190, 'nome' => "São Sebastião do Passé", 'uf' => "BA", 'codigo' => 2929503],
    		['id' => 2191, 'nome' => "Sapeaçu", 'uf' => "BA", 'codigo' => 2929602],
    		['id' => 2192, 'nome' => "Sátiro Dias", 'uf' => "BA", 'codigo' => 2929701],
    		['id' => 2193, 'nome' => "Saubara", 'uf' => "BA", 'codigo' => 2929750],
    		['id' => 2194, 'nome' => "Saúde", 'uf' => "BA", 'codigo' => 2929800],
    		['id' => 2195, 'nome' => "Seabra", 'uf' => "BA", 'codigo' => 2929909],
    		['id' => 2196, 'nome' => "Sebastião Laranjeiras", 'uf' => "BA", 'codigo' => 2930006],
    		['id' => 2197, 'nome' => "Senhor do Bonfim", 'uf' => "BA", 'codigo' => 2930105],
    		['id' => 2198, 'nome' => "Serra do Ramalho", 'uf' => "BA", 'codigo' => 2930154],
    		['id' => 2199, 'nome' => "Sento Sé", 'uf' => "BA", 'codigo' => 2930204],
    		['id' => 2200, 'nome' => "Serra Dourada", 'uf' => "BA", 'codigo' => 2930303],
    		['id' => 2201, 'nome' => "Serra Preta", 'uf' => "BA", 'codigo' => 2930402],
    		['id' => 2202, 'nome' => "Serrinha", 'uf' => "BA", 'codigo' => 2930501],
    		['id' => 2203, 'nome' => "Serrolândia", 'uf' => "BA", 'codigo' => 2930600],
    		['id' => 2204, 'nome' => "Simões Filho", 'uf' => "BA", 'codigo' => 2930709],
    		['id' => 2205, 'nome' => "Sítio do Mato", 'uf' => "BA", 'codigo' => 2930758],
    		['id' => 2206, 'nome' => "Sítio do Quinto", 'uf' => "BA", 'codigo' => 2930766],
    		['id' => 2207, 'nome' => "Sobradinho", 'uf' => "BA", 'codigo' => 2930774],
    		['id' => 2208, 'nome' => "Souto Soares", 'uf' => "BA", 'codigo' => 2930808],
    		['id' => 2209, 'nome' => "Tabocas do Brejo Velho", 'uf' => "BA", 'codigo' => 2930907],
    		['id' => 2210, 'nome' => "Tanhaçu", 'uf' => "BA", 'codigo' => 2931004],
    		['id' => 2211, 'nome' => "Tanque Novo", 'uf' => "BA", 'codigo' => 2931053],
    		['id' => 2212, 'nome' => "Tanquinho", 'uf' => "BA", 'codigo' => 2931103],
    		['id' => 2213, 'nome' => "Taperoá", 'uf' => "BA", 'codigo' => 2931202],
    		['id' => 2214, 'nome' => "Tapiramutá", 'uf' => "BA", 'codigo' => 2931301],
    		['id' => 2215, 'nome' => "Teixeira de Freitas", 'uf' => "BA", 'codigo' => 2931350],
    		['id' => 2216, 'nome' => "Teodoro Sampaio", 'uf' => "BA", 'codigo' => 2931400],
    		['id' => 2217, 'nome' => "Teofilândia", 'uf' => "BA", 'codigo' => 2931509],
    		['id' => 2218, 'nome' => "Teolândia", 'uf' => "BA", 'codigo' => 2931608],
    		['id' => 2219, 'nome' => "Terra Nova", 'uf' => "BA", 'codigo' => 2931707],
    		['id' => 2220, 'nome' => "Tremedal", 'uf' => "BA", 'codigo' => 2931806],
    		['id' => 2221, 'nome' => "Tucano", 'uf' => "BA", 'codigo' => 2931905],
    		['id' => 2222, 'nome' => "Uauá", 'uf' => "BA", 'codigo' => 2932002],
    		['id' => 2223, 'nome' => "Ubaíra", 'uf' => "BA", 'codigo' => 2932101],
    		['id' => 2224, 'nome' => "Ubaitaba", 'uf' => "BA", 'codigo' => 2932200],
    		['id' => 2225, 'nome' => "Ubatã", 'uf' => "BA", 'codigo' => 2932309],
    		['id' => 2226, 'nome' => "Uibaí", 'uf' => "BA", 'codigo' => 2932408],
    		['id' => 2227, 'nome' => "Umburanas", 'uf' => "BA", 'codigo' => 2932457],
    		['id' => 2228, 'nome' => "Una", 'uf' => "BA", 'codigo' => 2932507],
    		['id' => 2229, 'nome' => "Urandi", 'uf' => "BA", 'codigo' => 2932606],
    		['id' => 2230, 'nome' => "Uruçuca", 'uf' => "BA", 'codigo' => 2932705],
    		['id' => 2231, 'nome' => "Utinga", 'uf' => "BA", 'codigo' => 2932804],
    		['id' => 2232, 'nome' => "Valença", 'uf' => "BA", 'codigo' => 2932903],
    		['id' => 2233, 'nome' => "Valente", 'uf' => "BA", 'codigo' => 2933000],
    		['id' => 2234, 'nome' => "Várzea da Roça", 'uf' => "BA", 'codigo' => 2933059],
    		['id' => 2235, 'nome' => "Várzea do Poço", 'uf' => "BA", 'codigo' => 2933109],
    		['id' => 2236, 'nome' => "Várzea Nova", 'uf' => "BA", 'codigo' => 2933158],
    		['id' => 2237, 'nome' => "Varzedo", 'uf' => "BA", 'codigo' => 2933174],
    		['id' => 2238, 'nome' => "Vera Cruz", 'uf' => "BA", 'codigo' => 2933208],
    		['id' => 2239, 'nome' => "Vereda", 'uf' => "BA", 'codigo' => 2933257],
    		['id' => 2240, 'nome' => "Vitória da Conquista", 'uf' => "BA", 'codigo' => 2933307],
    		['id' => 2241, 'nome' => "Wagner", 'uf' => "BA", 'codigo' => 2933406],
    		['id' => 2242, 'nome' => "Wanderley", 'uf' => "BA", 'codigo' => 2933455],
    		['id' => 2243, 'nome' => "Wenceslau Guimarães", 'uf' => "BA", 'codigo' => 2933505],
    		['id' => 2244, 'nome' => "Xique-Xique", 'uf' => "BA", 'codigo' => 2933604],
    		['id' => 2245, 'nome' => "Abadia dos Dourados", 'uf' => "MG", 'codigo' => 3100104],
    		['id' => 2246, 'nome' => "Abaeté", 'uf' => "MG", 'codigo' => 3100203],
    		['id' => 2247, 'nome' => "Abre Campo", 'uf' => "MG", 'codigo' => 3100302],
    		['id' => 2248, 'nome' => "Acaiaca", 'uf' => "MG", 'codigo' => 3100401],
    		['id' => 2249, 'nome' => "Açucena", 'uf' => "MG", 'codigo' => 3100500],
    		['id' => 2250, 'nome' => "Água Boa", 'uf' => "MG", 'codigo' => 3100609],
    		['id' => 2251, 'nome' => "Água Comprida", 'uf' => "MG", 'codigo' => 3100708],
    		['id' => 2252, 'nome' => "Aguanil", 'uf' => "MG", 'codigo' => 3100807],
    		['id' => 2253, 'nome' => "Águas Formosas", 'uf' => "MG", 'codigo' => 3100906],
    		['id' => 2254, 'nome' => "Águas Vermelhas", 'uf' => "MG", 'codigo' => 3101003],
    		['id' => 2255, 'nome' => "Aimorés", 'uf' => "MG", 'codigo' => 3101102],
    		['id' => 2256, 'nome' => "Aiuruoca", 'uf' => "MG", 'codigo' => 3101201],
    		['id' => 2257, 'nome' => "Alagoa", 'uf' => "MG", 'codigo' => 3101300],
    		['id' => 2258, 'nome' => "Albertina", 'uf' => "MG", 'codigo' => 3101409],
    		['id' => 2259, 'nome' => "Além Paraíba", 'uf' => "MG", 'codigo' => 3101508],
    		['id' => 2260, 'nome' => "Alfenas", 'uf' => "MG", 'codigo' => 3101607],
    		['id' => 2261, 'nome' => "Alfredo Vasconcelos", 'uf' => "MG", 'codigo' => 3101631],
    		['id' => 2262, 'nome' => "Almenara", 'uf' => "MG", 'codigo' => 3101706],
    		['id' => 2263, 'nome' => "Alpercata", 'uf' => "MG", 'codigo' => 3101805],
    		['id' => 2264, 'nome' => "Alpinópolis", 'uf' => "MG", 'codigo' => 3101904],
    		['id' => 2265, 'nome' => "Alterosa", 'uf' => "MG", 'codigo' => 3102001],
    		['id' => 2266, 'nome' => "Alto Caparaó", 'uf' => "MG", 'codigo' => 3102050],
    		['id' => 2267, 'nome' => "Alto Rio Doce", 'uf' => "MG", 'codigo' => 3102100],
    		['id' => 2268, 'nome' => "Alvarenga", 'uf' => "MG", 'codigo' => 3102209],
    		['id' => 2269, 'nome' => "Alvinópolis", 'uf' => "MG", 'codigo' => 3102308],
    		['id' => 2270, 'nome' => "Alvorada de Minas", 'uf' => "MG", 'codigo' => 3102407],
    		['id' => 2271, 'nome' => "Amparo do Serra", 'uf' => "MG", 'codigo' => 3102506],
    		['id' => 2272, 'nome' => "Andradas", 'uf' => "MG", 'codigo' => 3102605],
    		['id' => 2273, 'nome' => "Cachoeira de Pajeú", 'uf' => "MG", 'codigo' => 3102704],
    		['id' => 2274, 'nome' => "Andrelândia", 'uf' => "MG", 'codigo' => 3102803],
    		['id' => 2275, 'nome' => "Angelândia", 'uf' => "MG", 'codigo' => 3102852],
    		['id' => 2276, 'nome' => "Antônio Carlos", 'uf' => "MG", 'codigo' => 3102902],
    		['id' => 2277, 'nome' => "Antônio Dias", 'uf' => "MG", 'codigo' => 3103009],
    		['id' => 2278, 'nome' => "Antônio Prado de Minas", 'uf' => "MG", 'codigo' => 3103108],
    		['id' => 2279, 'nome' => "Araçaí", 'uf' => "MG", 'codigo' => 3103207],
    		['id' => 2280, 'nome' => "Aracitaba", 'uf' => "MG", 'codigo' => 3103306],
    		['id' => 2281, 'nome' => "Araçuaí", 'uf' => "MG", 'codigo' => 3103405],
    		['id' => 2282, 'nome' => "Araguari", 'uf' => "MG", 'codigo' => 3103504],
    		['id' => 2283, 'nome' => "Arantina", 'uf' => "MG", 'codigo' => 3103603],
    		['id' => 2284, 'nome' => "Araponga", 'uf' => "MG", 'codigo' => 3103702],
    		['id' => 2285, 'nome' => "Araporã", 'uf' => "MG", 'codigo' => 3103751],
    		['id' => 2286, 'nome' => "Arapuá", 'uf' => "MG", 'codigo' => 3103801],
    		['id' => 2287, 'nome' => "Araújos", 'uf' => "MG", 'codigo' => 3103900],
    		['id' => 2288, 'nome' => "Araxá", 'uf' => "MG", 'codigo' => 3104007],
    		['id' => 2289, 'nome' => "Arceburgo", 'uf' => "MG", 'codigo' => 3104106],
    		['id' => 2290, 'nome' => "Arcos", 'uf' => "MG", 'codigo' => 3104205],
    		['id' => 2291, 'nome' => "Areado", 'uf' => "MG", 'codigo' => 3104304],
    		['id' => 2292, 'nome' => "Argirita", 'uf' => "MG", 'codigo' => 3104403],
    		['id' => 2293, 'nome' => "Aricanduva", 'uf' => "MG", 'codigo' => 3104452],
    		['id' => 2294, 'nome' => "Arinos", 'uf' => "MG", 'codigo' => 3104502],
    		['id' => 2295, 'nome' => "Astolfo Dutra", 'uf' => "MG", 'codigo' => 3104601],
    		['id' => 2296, 'nome' => "Ataléia", 'uf' => "MG", 'codigo' => 3104700],
    		['id' => 2297, 'nome' => "Augusto de Lima", 'uf' => "MG", 'codigo' => 3104809],
    		['id' => 2298, 'nome' => "Baependi", 'uf' => "MG", 'codigo' => 3104908],
    		['id' => 2299, 'nome' => "Baldim", 'uf' => "MG", 'codigo' => 3105004],
    		['id' => 2300, 'nome' => "Bambuí", 'uf' => "MG", 'codigo' => 3105103],
    		['id' => 2301, 'nome' => "Bandeira", 'uf' => "MG", 'codigo' => 3105202],
    		['id' => 2302, 'nome' => "Bandeira do Sul", 'uf' => "MG", 'codigo' => 3105301],
    		['id' => 2303, 'nome' => "Barão de Cocais", 'uf' => "MG", 'codigo' => 3105400],
    		['id' => 2304, 'nome' => "Barão de Monte Alto", 'uf' => "MG", 'codigo' => 3105509],
    		['id' => 2305, 'nome' => "Barbacena", 'uf' => "MG", 'codigo' => 3105608],
    		['id' => 2306, 'nome' => "Barra Longa", 'uf' => "MG", 'codigo' => 3105707],
    		['id' => 2307, 'nome' => "Barroso", 'uf' => "MG", 'codigo' => 3105905],
    		['id' => 2308, 'nome' => "Bela Vista de Minas", 'uf' => "MG", 'codigo' => 3106002],
    		['id' => 2309, 'nome' => "Belmiro Braga", 'uf' => "MG", 'codigo' => 3106101],
    		['id' => 2310, 'nome' => "Belo Horizonte", 'uf' => "MG", 'codigo' => 3106200],
    		['id' => 2311, 'nome' => "Belo Oriente", 'uf' => "MG", 'codigo' => 3106309],
    		['id' => 2312, 'nome' => "Belo Vale", 'uf' => "MG", 'codigo' => 3106408],
    		['id' => 2313, 'nome' => "Berilo", 'uf' => "MG", 'codigo' => 3106507],
    		['id' => 2314, 'nome' => "Bertópolis", 'uf' => "MG", 'codigo' => 3106606],
    		['id' => 2315, 'nome' => "Berizal", 'uf' => "MG", 'codigo' => 3106655],
    		['id' => 2316, 'nome' => "Betim", 'uf' => "MG", 'codigo' => 3106705],
    		['id' => 2317, 'nome' => "Bias Fortes", 'uf' => "MG", 'codigo' => 3106804],
    		['id' => 2318, 'nome' => "Bicas", 'uf' => "MG", 'codigo' => 3106903],
    		['id' => 2319, 'nome' => "Biquinhas", 'uf' => "MG", 'codigo' => 3107000],
    		['id' => 2320, 'nome' => "Boa Esperança", 'uf' => "MG", 'codigo' => 3107109],
    		['id' => 2321, 'nome' => "Bocaina de Minas", 'uf' => "MG", 'codigo' => 3107208],
    		['id' => 2322, 'nome' => "Bocaiúva", 'uf' => "MG", 'codigo' => 3107307],
    		['id' => 2323, 'nome' => "Bom Despacho", 'uf' => "MG", 'codigo' => 3107406],
    		['id' => 2324, 'nome' => "Bom Jardim de Minas", 'uf' => "MG", 'codigo' => 3107505],
    		['id' => 2325, 'nome' => "Bom Jesus da Penha", 'uf' => "MG", 'codigo' => 3107604],
    		['id' => 2326, 'nome' => "Bom Jesus do Amparo", 'uf' => "MG", 'codigo' => 3107703],
    		['id' => 2327, 'nome' => "Bom Jesus do Galho", 'uf' => "MG", 'codigo' => 3107802],
    		['id' => 2328, 'nome' => "Bom Repouso", 'uf' => "MG", 'codigo' => 3107901],
    		['id' => 2329, 'nome' => "Bom Sucesso", 'uf' => "MG", 'codigo' => 3108008],
    		['id' => 2330, 'nome' => "Bonfim", 'uf' => "MG", 'codigo' => 3108107],
    		['id' => 2331, 'nome' => "Bonfinópolis de Minas", 'uf' => "MG", 'codigo' => 3108206],
    		['id' => 2332, 'nome' => "Bonito de Minas", 'uf' => "MG", 'codigo' => 3108255],
    		['id' => 2333, 'nome' => "Borda da Mata", 'uf' => "MG", 'codigo' => 3108305],
    		['id' => 2334, 'nome' => "Botelhos", 'uf' => "MG", 'codigo' => 3108404],
    		['id' => 2335, 'nome' => "Botumirim", 'uf' => "MG", 'codigo' => 3108503],
    		['id' => 2336, 'nome' => "Brasilândia de Minas", 'uf' => "MG", 'codigo' => 3108552],
    		['id' => 2337, 'nome' => "Brasília de Minas", 'uf' => "MG", 'codigo' => 3108602],
    		['id' => 2338, 'nome' => "Brás Pires", 'uf' => "MG", 'codigo' => 3108701],
    		['id' => 2339, 'nome' => "Braúnas", 'uf' => "MG", 'codigo' => 3108800],
    		['id' => 2340, 'nome' => "Brazópolis", 'uf' => "MG", 'codigo' => 3108909],
    		['id' => 2341, 'nome' => "Brumadinho", 'uf' => "MG", 'codigo' => 3109006],
    		['id' => 2342, 'nome' => "Bueno Brandão", 'uf' => "MG", 'codigo' => 3109105],
    		['id' => 2343, 'nome' => "Buenópolis", 'uf' => "MG", 'codigo' => 3109204],
    		['id' => 2344, 'nome' => "Bugre", 'uf' => "MG", 'codigo' => 3109253],
    		['id' => 2345, 'nome' => "Buritis", 'uf' => "MG", 'codigo' => 3109303],
    		['id' => 2346, 'nome' => "Buritizeiro", 'uf' => "MG", 'codigo' => 3109402],
    		['id' => 2347, 'nome' => "Cabeceira Grande", 'uf' => "MG", 'codigo' => 3109451],
    		['id' => 2348, 'nome' => "Cabo Verde", 'uf' => "MG", 'codigo' => 3109501],
    		['id' => 2349, 'nome' => "Cachoeira da Prata", 'uf' => "MG", 'codigo' => 3109600],
    		['id' => 2350, 'nome' => "Cachoeira de Minas", 'uf' => "MG", 'codigo' => 3109709],
    		['id' => 2351, 'nome' => "Cachoeira Dourada", 'uf' => "MG", 'codigo' => 3109808],
    		['id' => 2352, 'nome' => "Caetanópolis", 'uf' => "MG", 'codigo' => 3109907],
    		['id' => 2353, 'nome' => "Caeté", 'uf' => "MG", 'codigo' => 3110004],
    		['id' => 2354, 'nome' => "Caiana", 'uf' => "MG", 'codigo' => 3110103],
    		['id' => 2355, 'nome' => "Cajuri", 'uf' => "MG", 'codigo' => 3110202],
    		['id' => 2356, 'nome' => "Caldas", 'uf' => "MG", 'codigo' => 3110301],
    		['id' => 2357, 'nome' => "Camacho", 'uf' => "MG", 'codigo' => 3110400],
    		['id' => 2358, 'nome' => "Camanducaia", 'uf' => "MG", 'codigo' => 3110509],
    		['id' => 2359, 'nome' => "Cambuí", 'uf' => "MG", 'codigo' => 3110608],
    		['id' => 2360, 'nome' => "Cambuquira", 'uf' => "MG", 'codigo' => 3110707],
    		['id' => 2361, 'nome' => "Campanário", 'uf' => "MG", 'codigo' => 3110806],
    		['id' => 2362, 'nome' => "Campanha", 'uf' => "MG", 'codigo' => 3110905],
    		['id' => 2363, 'nome' => "Campestre", 'uf' => "MG", 'codigo' => 3111002],
    		['id' => 2364, 'nome' => "Campina Verde", 'uf' => "MG", 'codigo' => 3111101],
    		['id' => 2365, 'nome' => "Campo Azul", 'uf' => "MG", 'codigo' => 3111150],
    		['id' => 2366, 'nome' => "Campo Belo", 'uf' => "MG", 'codigo' => 3111200],
    		['id' => 2367, 'nome' => "Campo do Meio", 'uf' => "MG", 'codigo' => 3111309],
    		['id' => 2368, 'nome' => "Campo Florido", 'uf' => "MG", 'codigo' => 3111408],
    		['id' => 2369, 'nome' => "Campos Altos", 'uf' => "MG", 'codigo' => 3111507],
    		['id' => 2370, 'nome' => "Campos Gerais", 'uf' => "MG", 'codigo' => 3111606],
    		['id' => 2371, 'nome' => "Canaã", 'uf' => "MG", 'codigo' => 3111705],
    		['id' => 2372, 'nome' => "Canápolis", 'uf' => "MG", 'codigo' => 3111804],
    		['id' => 2373, 'nome' => "Cana Verde", 'uf' => "MG", 'codigo' => 3111903],
    		['id' => 2374, 'nome' => "Candeias", 'uf' => "MG", 'codigo' => 3112000],
    		['id' => 2375, 'nome' => "Cantagalo", 'uf' => "MG", 'codigo' => 3112059],
    		['id' => 2376, 'nome' => "Caparaó", 'uf' => "MG", 'codigo' => 3112109],
    		['id' => 2377, 'nome' => "Capela Nova", 'uf' => "MG", 'codigo' => 3112208],
    		['id' => 2378, 'nome' => "Capelinha", 'uf' => "MG", 'codigo' => 3112307],
    		['id' => 2379, 'nome' => "Capetinga", 'uf' => "MG", 'codigo' => 3112406],
    		['id' => 2380, 'nome' => "Capim Branco", 'uf' => "MG", 'codigo' => 3112505],
    		['id' => 2381, 'nome' => "Capinópolis", 'uf' => "MG", 'codigo' => 3112604],
    		['id' => 2382, 'nome' => "Capitão Andrade", 'uf' => "MG", 'codigo' => 3112653],
    		['id' => 2383, 'nome' => "Capitão Enéas", 'uf' => "MG", 'codigo' => 3112703],
    		['id' => 2384, 'nome' => "Capitólio", 'uf' => "MG", 'codigo' => 3112802],
    		['id' => 2385, 'nome' => "Caputira", 'uf' => "MG", 'codigo' => 3112901],
    		['id' => 2386, 'nome' => "Caraí", 'uf' => "MG", 'codigo' => 3113008],
    		['id' => 2387, 'nome' => "Caranaíba", 'uf' => "MG", 'codigo' => 3113107],
    		['id' => 2388, 'nome' => "Carandaí", 'uf' => "MG", 'codigo' => 3113206],
    		['id' => 2389, 'nome' => "Carangola", 'uf' => "MG", 'codigo' => 3113305],
    		['id' => 2390, 'nome' => "Caratinga", 'uf' => "MG", 'codigo' => 3113404],
    		['id' => 2391, 'nome' => "Carbonita", 'uf' => "MG", 'codigo' => 3113503],
    		['id' => 2392, 'nome' => "Careaçu", 'uf' => "MG", 'codigo' => 3113602],
    		['id' => 2393, 'nome' => "Carlos Chagas", 'uf' => "MG", 'codigo' => 3113701],
    		['id' => 2394, 'nome' => "Carmésia", 'uf' => "MG", 'codigo' => 3113800],
    		['id' => 2395, 'nome' => "Carmo da Cachoeira", 'uf' => "MG", 'codigo' => 3113909],
    		['id' => 2396, 'nome' => "Carmo da Mata", 'uf' => "MG", 'codigo' => 3114006],
    		['id' => 2397, 'nome' => "Carmo de Minas", 'uf' => "MG", 'codigo' => 3114105],
    		['id' => 2398, 'nome' => "Carmo do Cajuru", 'uf' => "MG", 'codigo' => 3114204],
    		['id' => 2399, 'nome' => "Carmo do Paranaíba", 'uf' => "MG", 'codigo' => 3114303],
    		['id' => 2400, 'nome' => "Carmo do Rio Claro", 'uf' => "MG", 'codigo' => 3114402],
    		['id' => 2401, 'nome' => "Carmópolis de Minas", 'uf' => "MG", 'codigo' => 3114501],
    		['id' => 2402, 'nome' => "Carneirinho", 'uf' => "MG", 'codigo' => 3114550],
    		['id' => 2403, 'nome' => "Carrancas", 'uf' => "MG", 'codigo' => 3114600],
    		['id' => 2404, 'nome' => "Carvalhópolis", 'uf' => "MG", 'codigo' => 3114709],
    		['id' => 2405, 'nome' => "Carvalhos", 'uf' => "MG", 'codigo' => 3114808],
    		['id' => 2406, 'nome' => "Casa Grande", 'uf' => "MG", 'codigo' => 3114907],
    		['id' => 2407, 'nome' => "Cascalho Rico", 'uf' => "MG", 'codigo' => 3115003],
    		['id' => 2408, 'nome' => "Cássia", 'uf' => "MG", 'codigo' => 3115102],
    		['id' => 2409, 'nome' => "Conceição da Barra de Minas", 'uf' => "MG", 'codigo' => 3115201],
    		['id' => 2410, 'nome' => "Cataguases", 'uf' => "MG", 'codigo' => 3115300],
    		['id' => 2411, 'nome' => "Catas Altas", 'uf' => "MG", 'codigo' => 3115359],
    		['id' => 2412, 'nome' => "Catas Altas da Noruega", 'uf' => "MG", 'codigo' => 3115409],
    		['id' => 2413, 'nome' => "Catuji", 'uf' => "MG", 'codigo' => 3115458],
    		['id' => 2414, 'nome' => "Catuti", 'uf' => "MG", 'codigo' => 3115474],
    		['id' => 2415, 'nome' => "Caxambu", 'uf' => "MG", 'codigo' => 3115508],
    		['id' => 2416, 'nome' => "Cedro do Abaeté", 'uf' => "MG", 'codigo' => 3115607],
    		['id' => 2417, 'nome' => "Central de Minas", 'uf' => "MG", 'codigo' => 3115706],
    		['id' => 2418, 'nome' => "Centralina", 'uf' => "MG", 'codigo' => 3115805],
    		['id' => 2419, 'nome' => "Chácara", 'uf' => "MG", 'codigo' => 3115904],
    		['id' => 2420, 'nome' => "Chalé", 'uf' => "MG", 'codigo' => 3116001],
    		['id' => 2421, 'nome' => "Chapada do Norte", 'uf' => "MG", 'codigo' => 3116100],
    		['id' => 2422, 'nome' => "Chapada Gaúcha", 'uf' => "MG", 'codigo' => 3116159],
    		['id' => 2423, 'nome' => "Chiador", 'uf' => "MG", 'codigo' => 3116209],
    		['id' => 2424, 'nome' => "Cipotânea", 'uf' => "MG", 'codigo' => 3116308],
    		['id' => 2425, 'nome' => "Claraval", 'uf' => "MG", 'codigo' => 3116407],
    		['id' => 2426, 'nome' => "Claro dos Poções", 'uf' => "MG", 'codigo' => 3116506],
    		['id' => 2427, 'nome' => "Cláudio", 'uf' => "MG", 'codigo' => 3116605],
    		['id' => 2428, 'nome' => "Coimbra", 'uf' => "MG", 'codigo' => 3116704],
    		['id' => 2429, 'nome' => "Coluna", 'uf' => "MG", 'codigo' => 3116803],
    		['id' => 2430, 'nome' => "Comendador Gomes", 'uf' => "MG", 'codigo' => 3116902],
    		['id' => 2431, 'nome' => "Comercinho", 'uf' => "MG", 'codigo' => 3117009],
    		['id' => 2432, 'nome' => "Conceição da Aparecida", 'uf' => "MG", 'codigo' => 3117108],
    		['id' => 2433, 'nome' => "Conceição das Pedras", 'uf' => "MG", 'codigo' => 3117207],
    		['id' => 2434, 'nome' => "Conceição das Alagoas", 'uf' => "MG", 'codigo' => 3117306],
    		['id' => 2435, 'nome' => "Conceição de Ipanema", 'uf' => "MG", 'codigo' => 3117405],
    		['id' => 2436, 'nome' => "Conceição do Mato Dentro", 'uf' => "MG", 'codigo' => 3117504],
    		['id' => 2437, 'nome' => "Conceição do Pará", 'uf' => "MG", 'codigo' => 3117603],
    		['id' => 2438, 'nome' => "Conceição do Rio Verde", 'uf' => "MG", 'codigo' => 3117702],
    		['id' => 2439, 'nome' => "Conceição dos Ouros", 'uf' => "MG", 'codigo' => 3117801],
    		['id' => 2440, 'nome' => "Cônego Marinho", 'uf' => "MG", 'codigo' => 3117836],
    		['id' => 2441, 'nome' => "Confins", 'uf' => "MG", 'codigo' => 3117876],
    		['id' => 2442, 'nome' => "Congonhal", 'uf' => "MG", 'codigo' => 3117900],
    		['id' => 2443, 'nome' => "Congonhas", 'uf' => "MG", 'codigo' => 3118007],
    		['id' => 2444, 'nome' => "Congonhas do Norte", 'uf' => "MG", 'codigo' => 3118106],
    		['id' => 2445, 'nome' => "Conquista", 'uf' => "MG", 'codigo' => 3118205],
    		['id' => 2446, 'nome' => "Conselheiro Lafaiete", 'uf' => "MG", 'codigo' => 3118304],
    		['id' => 2447, 'nome' => "Conselheiro Pena", 'uf' => "MG", 'codigo' => 3118403],
    		['id' => 2448, 'nome' => "Consolação", 'uf' => "MG", 'codigo' => 3118502],
    		['id' => 2449, 'nome' => "Contagem", 'uf' => "MG", 'codigo' => 3118601],
    		['id' => 2450, 'nome' => "Coqueiral", 'uf' => "MG", 'codigo' => 3118700],
    		['id' => 2451, 'nome' => "Coração de Jesus", 'uf' => "MG", 'codigo' => 3118809],
    		['id' => 2452, 'nome' => "Cordisburgo", 'uf' => "MG", 'codigo' => 3118908],
    		['id' => 2453, 'nome' => "Cordislândia", 'uf' => "MG", 'codigo' => 3119005],
    		['id' => 2454, 'nome' => "Corinto", 'uf' => "MG", 'codigo' => 3119104],
    		['id' => 2455, 'nome' => "Coroaci", 'uf' => "MG", 'codigo' => 3119203],
    		['id' => 2456, 'nome' => "Coromandel", 'uf' => "MG", 'codigo' => 3119302],
    		['id' => 2457, 'nome' => "Coronel Fabriciano", 'uf' => "MG", 'codigo' => 3119401],
    		['id' => 2458, 'nome' => "Coronel Murta", 'uf' => "MG", 'codigo' => 3119500],
    		['id' => 2459, 'nome' => "Coronel Pacheco", 'uf' => "MG", 'codigo' => 3119609],
    		['id' => 2460, 'nome' => "Coronel Xavier Chaves", 'uf' => "MG", 'codigo' => 3119708],
    		['id' => 2461, 'nome' => "Córrego Danta", 'uf' => "MG", 'codigo' => 3119807],
    		['id' => 2462, 'nome' => "Córrego do Bom Jesus", 'uf' => "MG", 'codigo' => 3119906],
    		['id' => 2463, 'nome' => "Córrego Fundo", 'uf' => "MG", 'codigo' => 3119955],
    		['id' => 2464, 'nome' => "Córrego Novo", 'uf' => "MG", 'codigo' => 3120003],
    		['id' => 2465, 'nome' => "Couto de Magalhães de Minas", 'uf' => "MG", 'codigo' => 3120102],
    		['id' => 2466, 'nome' => "Crisólita", 'uf' => "MG", 'codigo' => 3120151],
    		['id' => 2467, 'nome' => "Cristais", 'uf' => "MG", 'codigo' => 3120201],
    		['id' => 2468, 'nome' => "Cristália", 'uf' => "MG", 'codigo' => 3120300],
    		['id' => 2469, 'nome' => "Cristiano Otoni", 'uf' => "MG", 'codigo' => 3120409],
    		['id' => 2470, 'nome' => "Cristina", 'uf' => "MG", 'codigo' => 3120508],
    		['id' => 2471, 'nome' => "Crucilândia", 'uf' => "MG", 'codigo' => 3120607],
    		['id' => 2472, 'nome' => "Cruzeiro da Fortaleza", 'uf' => "MG", 'codigo' => 3120706],
    		['id' => 2473, 'nome' => "Cruzília", 'uf' => "MG", 'codigo' => 3120805],
    		['id' => 2474, 'nome' => "Cuparaque", 'uf' => "MG", 'codigo' => 3120839],
    		['id' => 2475, 'nome' => "Curral de Dentro", 'uf' => "MG", 'codigo' => 3120870],
    		['id' => 2476, 'nome' => "Curvelo", 'uf' => "MG", 'codigo' => 3120904],
    		['id' => 2477, 'nome' => "Datas", 'uf' => "MG", 'codigo' => 3121001],
    		['id' => 2478, 'nome' => "Delfim Moreira", 'uf' => "MG", 'codigo' => 3121100],
    		['id' => 2479, 'nome' => "Delfinópolis", 'uf' => "MG", 'codigo' => 3121209],
    		['id' => 2480, 'nome' => "Delta", 'uf' => "MG", 'codigo' => 3121258],
    		['id' => 2481, 'nome' => "Descoberto", 'uf' => "MG", 'codigo' => 3121308],
    		['id' => 2482, 'nome' => "Desterro de Entre Rios", 'uf' => "MG", 'codigo' => 3121407],
    		['id' => 2483, 'nome' => "Desterro do Melo", 'uf' => "MG", 'codigo' => 3121506],
    		['id' => 2484, 'nome' => "Diamantina", 'uf' => "MG", 'codigo' => 3121605],
    		['id' => 2485, 'nome' => "Diogo de Vasconcelos", 'uf' => "MG", 'codigo' => 3121704],
    		['id' => 2486, 'nome' => "Dionísio", 'uf' => "MG", 'codigo' => 3121803],
    		['id' => 2487, 'nome' => "Divinésia", 'uf' => "MG", 'codigo' => 3121902],
    		['id' => 2488, 'nome' => "Divino", 'uf' => "MG", 'codigo' => 3122009],
    		['id' => 2489, 'nome' => "Divino das Laranjeiras", 'uf' => "MG", 'codigo' => 3122108],
    		['id' => 2490, 'nome' => "Divinolândia de Minas", 'uf' => "MG", 'codigo' => 3122207],
    		['id' => 2491, 'nome' => "Divinópolis", 'uf' => "MG", 'codigo' => 3122306],
    		['id' => 2492, 'nome' => "Divisa Alegre", 'uf' => "MG", 'codigo' => 3122355],
    		['id' => 2493, 'nome' => "Divisa Nova", 'uf' => "MG", 'codigo' => 3122405],
    		['id' => 2494, 'nome' => "Divisópolis", 'uf' => "MG", 'codigo' => 3122454],
    		['id' => 2495, 'nome' => "Dom Bosco", 'uf' => "MG", 'codigo' => 3122470],
    		['id' => 2496, 'nome' => "Dom Cavati", 'uf' => "MG", 'codigo' => 3122504],
    		['id' => 2497, 'nome' => "Dom Joaquim", 'uf' => "MG", 'codigo' => 3122603],
    		['id' => 2498, 'nome' => "Dom Silvério", 'uf' => "MG", 'codigo' => 3122702],
    		['id' => 2499, 'nome' => "Dom Viçoso", 'uf' => "MG", 'codigo' => 3122801],
    		['id' => 2500, 'nome' => "Dona Eusébia", 'uf' => "MG", 'codigo' => 3122900],
    		['id' => 2501, 'nome' => "Dores de Campos", 'uf' => "MG", 'codigo' => 3123007],
    		['id' => 2502, 'nome' => "Dores de Guanhães", 'uf' => "MG", 'codigo' => 3123106],
    		['id' => 2503, 'nome' => "Dores do Indaiá", 'uf' => "MG", 'codigo' => 3123205],
    		['id' => 2504, 'nome' => "Dores do Turvo", 'uf' => "MG", 'codigo' => 3123304],
    		['id' => 2505, 'nome' => "Doresópolis", 'uf' => "MG", 'codigo' => 3123403],
    		['id' => 2506, 'nome' => "Douradoquara", 'uf' => "MG", 'codigo' => 3123502],
    		['id' => 2507, 'nome' => "Durandé", 'uf' => "MG", 'codigo' => 3123528],
    		['id' => 2508, 'nome' => "Elói Mendes", 'uf' => "MG", 'codigo' => 3123601],
    		['id' => 2509, 'nome' => "Engenheiro Caldas", 'uf' => "MG", 'codigo' => 3123700],
    		['id' => 2510, 'nome' => "Engenheiro Navarro", 'uf' => "MG", 'codigo' => 3123809],
    		['id' => 2511, 'nome' => "Entre Folhas", 'uf' => "MG", 'codigo' => 3123858],
    		['id' => 2512, 'nome' => "Entre Rios de Minas", 'uf' => "MG", 'codigo' => 3123908],
    		['id' => 2513, 'nome' => "Ervália", 'uf' => "MG", 'codigo' => 3124005],
    		['id' => 2514, 'nome' => "Esmeraldas", 'uf' => "MG", 'codigo' => 3124104],
    		['id' => 2515, 'nome' => "Espera Feliz", 'uf' => "MG", 'codigo' => 3124203],
    		['id' => 2516, 'nome' => "Espinosa", 'uf' => "MG", 'codigo' => 3124302],
    		['id' => 2517, 'nome' => "Espírito Santo do Dourado", 'uf' => "MG", 'codigo' => 3124401],
    		['id' => 2518, 'nome' => "Estiva", 'uf' => "MG", 'codigo' => 3124500],
    		['id' => 2519, 'nome' => "Estrela Dalva", 'uf' => "MG", 'codigo' => 3124609],
    		['id' => 2520, 'nome' => "Estrela do Indaiá", 'uf' => "MG", 'codigo' => 3124708],
    		['id' => 2521, 'nome' => "Estrela do Sul", 'uf' => "MG", 'codigo' => 3124807],
    		['id' => 2522, 'nome' => "Eugenópolis", 'uf' => "MG", 'codigo' => 3124906],
    		['id' => 2523, 'nome' => "Ewbank da Câmara", 'uf' => "MG", 'codigo' => 3125002],
    		['id' => 2524, 'nome' => "Extrema", 'uf' => "MG", 'codigo' => 3125101],
    		['id' => 2525, 'nome' => "Fama", 'uf' => "MG", 'codigo' => 3125200],
    		['id' => 2526, 'nome' => "Faria Lemos", 'uf' => "MG", 'codigo' => 3125309],
    		['id' => 2527, 'nome' => "Felício dos Santos", 'uf' => "MG", 'codigo' => 3125408],
    		['id' => 2528, 'nome' => "São Gonçalo do Rio Preto", 'uf' => "MG", 'codigo' => 3125507],
    		['id' => 2529, 'nome' => "Felisburgo", 'uf' => "MG", 'codigo' => 3125606],
    		['id' => 2530, 'nome' => "Felixlândia", 'uf' => "MG", 'codigo' => 3125705],
    		['id' => 2531, 'nome' => "Fernandes Tourinho", 'uf' => "MG", 'codigo' => 3125804],
    		['id' => 2532, 'nome' => "Ferros", 'uf' => "MG", 'codigo' => 3125903],
    		['id' => 2533, 'nome' => "Fervedouro", 'uf' => "MG", 'codigo' => 3125952],
    		['id' => 2534, 'nome' => "Florestal", 'uf' => "MG", 'codigo' => 3126000],
    		['id' => 2535, 'nome' => "Formiga", 'uf' => "MG", 'codigo' => 3126109],
    		['id' => 2536, 'nome' => "Formoso", 'uf' => "MG", 'codigo' => 3126208],
    		['id' => 2537, 'nome' => "Fortaleza de Minas", 'uf' => "MG", 'codigo' => 3126307],
    		['id' => 2538, 'nome' => "Fortuna de Minas", 'uf' => "MG", 'codigo' => 3126406],
    		['id' => 2539, 'nome' => "Francisco Badaró", 'uf' => "MG", 'codigo' => 3126505],
    		['id' => 2540, 'nome' => "Francisco Dumont", 'uf' => "MG", 'codigo' => 3126604],
    		['id' => 2541, 'nome' => "Francisco Sá", 'uf' => "MG", 'codigo' => 3126703],
    		['id' => 2542, 'nome' => "Franciscópolis", 'uf' => "MG", 'codigo' => 3126752],
    		['id' => 2543, 'nome' => "Frei Gaspar", 'uf' => "MG", 'codigo' => 3126802],
    		['id' => 2544, 'nome' => "Frei Inocêncio", 'uf' => "MG", 'codigo' => 3126901],
    		['id' => 2545, 'nome' => "Frei Lagonegro", 'uf' => "MG", 'codigo' => 3126950],
    		['id' => 2546, 'nome' => "Fronteira", 'uf' => "MG", 'codigo' => 3127008],
    		['id' => 2547, 'nome' => "Fronteira dos Vales", 'uf' => "MG", 'codigo' => 3127057],
    		['id' => 2548, 'nome' => "Fruta de Leite", 'uf' => "MG", 'codigo' => 3127073],
    		['id' => 2549, 'nome' => "Frutal", 'uf' => "MG", 'codigo' => 3127107],
    		['id' => 2550, 'nome' => "Funilândia", 'uf' => "MG", 'codigo' => 3127206],
    		['id' => 2551, 'nome' => "Galiléia", 'uf' => "MG", 'codigo' => 3127305],
    		['id' => 2552, 'nome' => "Gameleiras", 'uf' => "MG", 'codigo' => 3127339],
    		['id' => 2553, 'nome' => "Glaucilândia", 'uf' => "MG", 'codigo' => 3127354],
    		['id' => 2554, 'nome' => "Goiabeira", 'uf' => "MG", 'codigo' => 3127370],
    		['id' => 2555, 'nome' => "Goianá", 'uf' => "MG", 'codigo' => 3127388],
    		['id' => 2556, 'nome' => "Gonçalves", 'uf' => "MG", 'codigo' => 3127404],
    		['id' => 2557, 'nome' => "Gonzaga", 'uf' => "MG", 'codigo' => 3127503],
    		['id' => 2558, 'nome' => "Gouveia", 'uf' => "MG", 'codigo' => 3127602],
    		['id' => 2559, 'nome' => "Governador Valadares", 'uf' => "MG", 'codigo' => 3127701],
    		['id' => 2560, 'nome' => "Grão Mogol", 'uf' => "MG", 'codigo' => 3127800],
    		['id' => 2561, 'nome' => "Grupiara", 'uf' => "MG", 'codigo' => 3127909],
    		['id' => 2562, 'nome' => "Guanhães", 'uf' => "MG", 'codigo' => 3128006],
    		['id' => 2563, 'nome' => "Guapé", 'uf' => "MG", 'codigo' => 3128105],
    		['id' => 2564, 'nome' => "Guaraciaba", 'uf' => "MG", 'codigo' => 3128204],
    		['id' => 2565, 'nome' => "Guaraciama", 'uf' => "MG", 'codigo' => 3128253],
    		['id' => 2566, 'nome' => "Guaranésia", 'uf' => "MG", 'codigo' => 3128303],
    		['id' => 2567, 'nome' => "Guarani", 'uf' => "MG", 'codigo' => 3128402],
    		['id' => 2568, 'nome' => "Guarará", 'uf' => "MG", 'codigo' => 3128501],
    		['id' => 2569, 'nome' => "Guarda-Mor", 'uf' => "MG", 'codigo' => 3128600],
    		['id' => 2570, 'nome' => "Guaxupé", 'uf' => "MG", 'codigo' => 3128709],
    		['id' => 2571, 'nome' => "Guidoval", 'uf' => "MG", 'codigo' => 3128808],
    		['id' => 2572, 'nome' => "Guimarânia", 'uf' => "MG", 'codigo' => 3128907],
    		['id' => 2573, 'nome' => "Guiricema", 'uf' => "MG", 'codigo' => 3129004],
    		['id' => 2574, 'nome' => "Gurinhatã", 'uf' => "MG", 'codigo' => 3129103],
    		['id' => 2575, 'nome' => "Heliodora", 'uf' => "MG", 'codigo' => 3129202],
    		['id' => 2576, 'nome' => "Iapu", 'uf' => "MG", 'codigo' => 3129301],
    		['id' => 2577, 'nome' => "Ibertioga", 'uf' => "MG", 'codigo' => 3129400],
    		['id' => 2578, 'nome' => "Ibiá", 'uf' => "MG", 'codigo' => 3129509],
    		['id' => 2579, 'nome' => "Ibiaí", 'uf' => "MG", 'codigo' => 3129608],
    		['id' => 2580, 'nome' => "Ibiracatu", 'uf' => "MG", 'codigo' => 3129657],
    		['id' => 2581, 'nome' => "Ibiraci", 'uf' => "MG", 'codigo' => 3129707],
    		['id' => 2582, 'nome' => "Ibirité", 'uf' => "MG", 'codigo' => 3129806],
    		['id' => 2583, 'nome' => "Ibitiúra de Minas", 'uf' => "MG", 'codigo' => 3129905],
    		['id' => 2584, 'nome' => "Ibituruna", 'uf' => "MG", 'codigo' => 3130002],
    		['id' => 2585, 'nome' => "Icaraí de Minas", 'uf' => "MG", 'codigo' => 3130051],
    		['id' => 2586, 'nome' => "Igarapé", 'uf' => "MG", 'codigo' => 3130101],
    		['id' => 2587, 'nome' => "Igaratinga", 'uf' => "MG", 'codigo' => 3130200],
    		['id' => 2588, 'nome' => "Iguatama", 'uf' => "MG", 'codigo' => 3130309],
    		['id' => 2589, 'nome' => "Ijaci", 'uf' => "MG", 'codigo' => 3130408],
    		['id' => 2590, 'nome' => "Ilicínea", 'uf' => "MG", 'codigo' => 3130507],
    		['id' => 2591, 'nome' => "Imbé de Minas", 'uf' => "MG", 'codigo' => 3130556],
    		['id' => 2592, 'nome' => "Inconfidentes", 'uf' => "MG", 'codigo' => 3130606],
    		['id' => 2593, 'nome' => "Indaiabira", 'uf' => "MG", 'codigo' => 3130655],
    		['id' => 2594, 'nome' => "Indianópolis", 'uf' => "MG", 'codigo' => 3130705],
    		['id' => 2595, 'nome' => "Ingaí", 'uf' => "MG", 'codigo' => 3130804],
    		['id' => 2596, 'nome' => "Inhapim", 'uf' => "MG", 'codigo' => 3130903],
    		['id' => 2597, 'nome' => "Inhaúma", 'uf' => "MG", 'codigo' => 3131000],
    		['id' => 2598, 'nome' => "Inimutaba", 'uf' => "MG", 'codigo' => 3131109],
    		['id' => 2599, 'nome' => "Ipaba", 'uf' => "MG", 'codigo' => 3131158],
    		['id' => 2600, 'nome' => "Ipanema", 'uf' => "MG", 'codigo' => 3131208],
    		['id' => 2601, 'nome' => "Ipatinga", 'uf' => "MG", 'codigo' => 3131307],
    		['id' => 2602, 'nome' => "Ipiaçu", 'uf' => "MG", 'codigo' => 3131406],
    		['id' => 2603, 'nome' => "Ipuiúna", 'uf' => "MG", 'codigo' => 3131505],
    		['id' => 2604, 'nome' => "Iraí de Minas", 'uf' => "MG", 'codigo' => 3131604],
    		['id' => 2605, 'nome' => "Itabira", 'uf' => "MG", 'codigo' => 3131703],
    		['id' => 2606, 'nome' => "Itabirinha", 'uf' => "MG", 'codigo' => 3131802],
    		['id' => 2607, 'nome' => "Itabirito", 'uf' => "MG", 'codigo' => 3131901],
    		['id' => 2608, 'nome' => "Itacambira", 'uf' => "MG", 'codigo' => 3132008],
    		['id' => 2609, 'nome' => "Itacarambi", 'uf' => "MG", 'codigo' => 3132107],
    		['id' => 2610, 'nome' => "Itaguara", 'uf' => "MG", 'codigo' => 3132206],
    		['id' => 2611, 'nome' => "Itaipé", 'uf' => "MG", 'codigo' => 3132305],
    		['id' => 2612, 'nome' => "Itajubá", 'uf' => "MG", 'codigo' => 3132404],
    		['id' => 2613, 'nome' => "Itamarandiba", 'uf' => "MG", 'codigo' => 3132503],
    		['id' => 2614, 'nome' => "Itamarati de Minas", 'uf' => "MG", 'codigo' => 3132602],
    		['id' => 2615, 'nome' => "Itambacuri", 'uf' => "MG", 'codigo' => 3132701],
    		['id' => 2616, 'nome' => "Itambé do Mato Dentro", 'uf' => "MG", 'codigo' => 3132800],
    		['id' => 2617, 'nome' => "Itamogi", 'uf' => "MG", 'codigo' => 3132909],
    		['id' => 2618, 'nome' => "Itamonte", 'uf' => "MG", 'codigo' => 3133006],
    		['id' => 2619, 'nome' => "Itanhandu", 'uf' => "MG", 'codigo' => 3133105],
    		['id' => 2620, 'nome' => "Itanhomi", 'uf' => "MG", 'codigo' => 3133204],
    		['id' => 2621, 'nome' => "Itaobim", 'uf' => "MG", 'codigo' => 3133303],
    		['id' => 2622, 'nome' => "Itapagipe", 'uf' => "MG", 'codigo' => 3133402],
    		['id' => 2623, 'nome' => "Itapecerica", 'uf' => "MG", 'codigo' => 3133501],
    		['id' => 2624, 'nome' => "Itapeva", 'uf' => "MG", 'codigo' => 3133600],
    		['id' => 2625, 'nome' => "Itatiaiuçu", 'uf' => "MG", 'codigo' => 3133709],
    		['id' => 2626, 'nome' => "Itaú de Minas", 'uf' => "MG", 'codigo' => 3133758],
    		['id' => 2627, 'nome' => "Itaúna", 'uf' => "MG", 'codigo' => 3133808],
    		['id' => 2628, 'nome' => "Itaverava", 'uf' => "MG", 'codigo' => 3133907],
    		['id' => 2629, 'nome' => "Itinga", 'uf' => "MG", 'codigo' => 3134004],
    		['id' => 2630, 'nome' => "Itueta", 'uf' => "MG", 'codigo' => 3134103],
    		['id' => 2631, 'nome' => "Ituiutaba", 'uf' => "MG", 'codigo' => 3134202],
    		['id' => 2632, 'nome' => "Itumirim", 'uf' => "MG", 'codigo' => 3134301],
    		['id' => 2633, 'nome' => "Iturama", 'uf' => "MG", 'codigo' => 3134400],
    		['id' => 2634, 'nome' => "Itutinga", 'uf' => "MG", 'codigo' => 3134509],
    		['id' => 2635, 'nome' => "Jaboticatubas", 'uf' => "MG", 'codigo' => 3134608],
    		['id' => 2636, 'nome' => "Jacinto", 'uf' => "MG", 'codigo' => 3134707],
    		['id' => 2637, 'nome' => "Jacuí", 'uf' => "MG", 'codigo' => 3134806],
    		['id' => 2638, 'nome' => "Jacutinga", 'uf' => "MG", 'codigo' => 3134905],
    		['id' => 2639, 'nome' => "Jaguaraçu", 'uf' => "MG", 'codigo' => 3135001],
    		['id' => 2640, 'nome' => "Jaíba", 'uf' => "MG", 'codigo' => 3135050],
    		['id' => 2641, 'nome' => "Jampruca", 'uf' => "MG", 'codigo' => 3135076],
    		['id' => 2642, 'nome' => "Janaúba", 'uf' => "MG", 'codigo' => 3135100],
    		['id' => 2643, 'nome' => "Januária", 'uf' => "MG", 'codigo' => 3135209],
    		['id' => 2644, 'nome' => "Japaraíba", 'uf' => "MG", 'codigo' => 3135308],
    		['id' => 2645, 'nome' => "Japonvar", 'uf' => "MG", 'codigo' => 3135357],
    		['id' => 2646, 'nome' => "Jeceaba", 'uf' => "MG", 'codigo' => 3135407],
    		['id' => 2647, 'nome' => "Jenipapo de Minas", 'uf' => "MG", 'codigo' => 3135456],
    		['id' => 2648, 'nome' => "Jequeri", 'uf' => "MG", 'codigo' => 3135506],
    		['id' => 2649, 'nome' => "Jequitaí", 'uf' => "MG", 'codigo' => 3135605],
    		['id' => 2650, 'nome' => "Jequitibá", 'uf' => "MG", 'codigo' => 3135704],
    		['id' => 2651, 'nome' => "Jequitinhonha", 'uf' => "MG", 'codigo' => 3135803],
    		['id' => 2652, 'nome' => "Jesuânia", 'uf' => "MG", 'codigo' => 3135902],
    		['id' => 2653, 'nome' => "Joaíma", 'uf' => "MG", 'codigo' => 3136009],
    		['id' => 2654, 'nome' => "Joanésia", 'uf' => "MG", 'codigo' => 3136108],
    		['id' => 2655, 'nome' => "João Monlevade", 'uf' => "MG", 'codigo' => 3136207],
    		['id' => 2656, 'nome' => "João Pinheiro", 'uf' => "MG", 'codigo' => 3136306],
    		['id' => 2657, 'nome' => "Joaquim Felício", 'uf' => "MG", 'codigo' => 3136405],
    		['id' => 2658, 'nome' => "Jordânia", 'uf' => "MG", 'codigo' => 3136504],
    		['id' => 2659, 'nome' => "José Gonçalves de Minas", 'uf' => "MG", 'codigo' => 3136520],
    		['id' => 2660, 'nome' => "José Raydan", 'uf' => "MG", 'codigo' => 3136553],
    		['id' => 2661, 'nome' => "Josenópolis", 'uf' => "MG", 'codigo' => 3136579],
    		['id' => 2662, 'nome' => "Nova União", 'uf' => "MG", 'codigo' => 3136603],
    		['id' => 2663, 'nome' => "Juatuba", 'uf' => "MG", 'codigo' => 3136652],
    		['id' => 2664, 'nome' => "Juiz de Fora", 'uf' => "MG", 'codigo' => 3136702],
    		['id' => 2665, 'nome' => "Juramento", 'uf' => "MG", 'codigo' => 3136801],
    		['id' => 2666, 'nome' => "Juruaia", 'uf' => "MG", 'codigo' => 3136900],
    		['id' => 2667, 'nome' => "Juvenília", 'uf' => "MG", 'codigo' => 3136959],
    		['id' => 2668, 'nome' => "Ladainha", 'uf' => "MG", 'codigo' => 3137007],
    		['id' => 2669, 'nome' => "Lagamar", 'uf' => "MG", 'codigo' => 3137106],
    		['id' => 2670, 'nome' => "Lagoa da Prata", 'uf' => "MG", 'codigo' => 3137205],
    		['id' => 2671, 'nome' => "Lagoa dos Patos", 'uf' => "MG", 'codigo' => 3137304],
    		['id' => 2672, 'nome' => "Lagoa Dourada", 'uf' => "MG", 'codigo' => 3137403],
    		['id' => 2673, 'nome' => "Lagoa Formosa", 'uf' => "MG", 'codigo' => 3137502],
    		['id' => 2674, 'nome' => "Lagoa Grande", 'uf' => "MG", 'codigo' => 3137536],
    		['id' => 2675, 'nome' => "Lagoa Santa", 'uf' => "MG", 'codigo' => 3137601],
    		['id' => 2676, 'nome' => "Lajinha", 'uf' => "MG", 'codigo' => 3137700],
    		['id' => 2677, 'nome' => "Lambari", 'uf' => "MG", 'codigo' => 3137809],
    		['id' => 2678, 'nome' => "Lamim", 'uf' => "MG", 'codigo' => 3137908],
    		['id' => 2679, 'nome' => "Laranjal", 'uf' => "MG", 'codigo' => 3138005],
    		['id' => 2680, 'nome' => "Lassance", 'uf' => "MG", 'codigo' => 3138104],
    		['id' => 2681, 'nome' => "Lavras", 'uf' => "MG", 'codigo' => 3138203],
    		['id' => 2682, 'nome' => "Leandro Ferreira", 'uf' => "MG", 'codigo' => 3138302],
    		['id' => 2683, 'nome' => "Leme do Prado", 'uf' => "MG", 'codigo' => 3138351],
    		['id' => 2684, 'nome' => "Leopoldina", 'uf' => "MG", 'codigo' => 3138401],
    		['id' => 2685, 'nome' => "Liberdade", 'uf' => "MG", 'codigo' => 3138500],
    		['id' => 2686, 'nome' => "Lima Duarte", 'uf' => "MG", 'codigo' => 3138609],
    		['id' => 2687, 'nome' => "Limeira do Oeste", 'uf' => "MG", 'codigo' => 3138625],
    		['id' => 2688, 'nome' => "Lontra", 'uf' => "MG", 'codigo' => 3138658],
    		['id' => 2689, 'nome' => "Luisburgo", 'uf' => "MG", 'codigo' => 3138674],
    		['id' => 2690, 'nome' => "Luislândia", 'uf' => "MG", 'codigo' => 3138682],
    		['id' => 2691, 'nome' => "Luminárias", 'uf' => "MG", 'codigo' => 3138708],
    		['id' => 2692, 'nome' => "Luz", 'uf' => "MG", 'codigo' => 3138807],
    		['id' => 2693, 'nome' => "Machacalis", 'uf' => "MG", 'codigo' => 3138906],
    		['id' => 2694, 'nome' => "Machado", 'uf' => "MG", 'codigo' => 3139003],
    		['id' => 2695, 'nome' => "Madre de Deus de Minas", 'uf' => "MG", 'codigo' => 3139102],
    		['id' => 2696, 'nome' => "Malacacheta", 'uf' => "MG", 'codigo' => 3139201],
    		['id' => 2697, 'nome' => "Mamonas", 'uf' => "MG", 'codigo' => 3139250],
    		['id' => 2698, 'nome' => "Manga", 'uf' => "MG", 'codigo' => 3139300],
    		['id' => 2699, 'nome' => "Manhuaçu", 'uf' => "MG", 'codigo' => 3139409],
    		['id' => 2700, 'nome' => "Manhumirim", 'uf' => "MG", 'codigo' => 3139508],
    		['id' => 2701, 'nome' => "Mantena", 'uf' => "MG", 'codigo' => 3139607],
    		['id' => 2702, 'nome' => "Maravilhas", 'uf' => "MG", 'codigo' => 3139706],
    		['id' => 2703, 'nome' => "Mar de Espanha", 'uf' => "MG", 'codigo' => 3139805],
    		['id' => 2704, 'nome' => "Maria da Fé", 'uf' => "MG", 'codigo' => 3139904],
    		['id' => 2705, 'nome' => "Mariana", 'uf' => "MG", 'codigo' => 3140001],
    		['id' => 2706, 'nome' => "Marilac", 'uf' => "MG", 'codigo' => 3140100],
    		['id' => 2707, 'nome' => "Mário Campos", 'uf' => "MG", 'codigo' => 3140159],
    		['id' => 2708, 'nome' => "Maripá de Minas", 'uf' => "MG", 'codigo' => 3140209],
    		['id' => 2709, 'nome' => "Marliéria", 'uf' => "MG", 'codigo' => 3140308],
    		['id' => 2710, 'nome' => "Marmelópolis", 'uf' => "MG", 'codigo' => 3140407],
    		['id' => 2711, 'nome' => "Martinho Campos", 'uf' => "MG", 'codigo' => 3140506],
    		['id' => 2712, 'nome' => "Martins Soares", 'uf' => "MG", 'codigo' => 3140530],
    		['id' => 2713, 'nome' => "Mata Verde", 'uf' => "MG", 'codigo' => 3140555],
    		['id' => 2714, 'nome' => "Materlândia", 'uf' => "MG", 'codigo' => 3140605],
    		['id' => 2715, 'nome' => "Mateus Leme", 'uf' => "MG", 'codigo' => 3140704],
    		['id' => 2716, 'nome' => "Matias Barbosa", 'uf' => "MG", 'codigo' => 3140803],
    		['id' => 2717, 'nome' => "Matias Cardoso", 'uf' => "MG", 'codigo' => 3140852],
    		['id' => 2718, 'nome' => "Matipó", 'uf' => "MG", 'codigo' => 3140902],
    		['id' => 2719, 'nome' => "Mato Verde", 'uf' => "MG", 'codigo' => 3141009],
    		['id' => 2720, 'nome' => "Matozinhos", 'uf' => "MG", 'codigo' => 3141108],
    		['id' => 2721, 'nome' => "Matutina", 'uf' => "MG", 'codigo' => 3141207],
    		['id' => 2722, 'nome' => "Medeiros", 'uf' => "MG", 'codigo' => 3141306],
    		['id' => 2723, 'nome' => "Medina", 'uf' => "MG", 'codigo' => 3141405],
    		['id' => 2724, 'nome' => "Mendes Pimentel", 'uf' => "MG", 'codigo' => 3141504],
    		['id' => 2725, 'nome' => "Mercês", 'uf' => "MG", 'codigo' => 3141603],
    		['id' => 2726, 'nome' => "Mesquita", 'uf' => "MG", 'codigo' => 3141702],
    		['id' => 2727, 'nome' => "Minas Novas", 'uf' => "MG", 'codigo' => 3141801],
    		['id' => 2728, 'nome' => "Minduri", 'uf' => "MG", 'codigo' => 3141900],
    		['id' => 2729, 'nome' => "Mirabela", 'uf' => "MG", 'codigo' => 3142007],
    		['id' => 2730, 'nome' => "Miradouro", 'uf' => "MG", 'codigo' => 3142106],
    		['id' => 2731, 'nome' => "Miraí", 'uf' => "MG", 'codigo' => 3142205],
    		['id' => 2732, 'nome' => "Miravânia", 'uf' => "MG", 'codigo' => 3142254],
    		['id' => 2733, 'nome' => "Moeda", 'uf' => "MG", 'codigo' => 3142304],
    		['id' => 2734, 'nome' => "Moema", 'uf' => "MG", 'codigo' => 3142403],
    		['id' => 2735, 'nome' => "Monjolos", 'uf' => "MG", 'codigo' => 3142502],
    		['id' => 2736, 'nome' => "Monsenhor Paulo", 'uf' => "MG", 'codigo' => 3142601],
    		['id' => 2737, 'nome' => "Montalvânia", 'uf' => "MG", 'codigo' => 3142700],
    		['id' => 2738, 'nome' => "Monte Alegre de Minas", 'uf' => "MG", 'codigo' => 3142809],
    		['id' => 2739, 'nome' => "Monte Azul", 'uf' => "MG", 'codigo' => 3142908],
    		['id' => 2740, 'nome' => "Monte Belo", 'uf' => "MG", 'codigo' => 3143005],
    		['id' => 2741, 'nome' => "Monte Carmelo", 'uf' => "MG", 'codigo' => 3143104],
    		['id' => 2742, 'nome' => "Monte Formoso", 'uf' => "MG", 'codigo' => 3143153],
    		['id' => 2743, 'nome' => "Monte Santo de Minas", 'uf' => "MG", 'codigo' => 3143203],
    		['id' => 2744, 'nome' => "Montes Claros", 'uf' => "MG", 'codigo' => 3143302],
    		['id' => 2745, 'nome' => "Monte Sião", 'uf' => "MG", 'codigo' => 3143401],
    		['id' => 2746, 'nome' => "Montezuma", 'uf' => "MG", 'codigo' => 3143450],
    		['id' => 2747, 'nome' => "Morada Nova de Minas", 'uf' => "MG", 'codigo' => 3143500],
    		['id' => 2748, 'nome' => "Morro da Garça", 'uf' => "MG", 'codigo' => 3143609],
    		['id' => 2749, 'nome' => "Morro do Pilar", 'uf' => "MG", 'codigo' => 3143708],
    		['id' => 2750, 'nome' => "Munhoz", 'uf' => "MG", 'codigo' => 3143807],
    		['id' => 2751, 'nome' => "Muriaé", 'uf' => "MG", 'codigo' => 3143906],
    		['id' => 2752, 'nome' => "Mutum", 'uf' => "MG", 'codigo' => 3144003],
    		['id' => 2753, 'nome' => "Muzambinho", 'uf' => "MG", 'codigo' => 3144102],
    		['id' => 2754, 'nome' => "Nacip Raydan", 'uf' => "MG", 'codigo' => 3144201],
    		['id' => 2755, 'nome' => "Nanuque", 'uf' => "MG", 'codigo' => 3144300],
    		['id' => 2756, 'nome' => "Naque", 'uf' => "MG", 'codigo' => 3144359],
    		['id' => 2757, 'nome' => "Natalândia", 'uf' => "MG", 'codigo' => 3144375],
    		['id' => 2758, 'nome' => "Natércia", 'uf' => "MG", 'codigo' => 3144409],
    		['id' => 2759, 'nome' => "Nazareno", 'uf' => "MG", 'codigo' => 3144508],
    		['id' => 2760, 'nome' => "Nepomuceno", 'uf' => "MG", 'codigo' => 3144607],
    		['id' => 2761, 'nome' => "Ninheira", 'uf' => "MG", 'codigo' => 3144656],
    		['id' => 2762, 'nome' => "Nova Belém", 'uf' => "MG", 'codigo' => 3144672],
    		['id' => 2763, 'nome' => "Nova Era", 'uf' => "MG", 'codigo' => 3144706],
    		['id' => 2764, 'nome' => "Nova Lima", 'uf' => "MG", 'codigo' => 3144805],
    		['id' => 2765, 'nome' => "Nova Módica", 'uf' => "MG", 'codigo' => 3144904],
    		['id' => 2766, 'nome' => "Nova Ponte", 'uf' => "MG", 'codigo' => 3145000],
    		['id' => 2767, 'nome' => "Nova Porteirinha", 'uf' => "MG", 'codigo' => 3145059],
    		['id' => 2768, 'nome' => "Nova Resende", 'uf' => "MG", 'codigo' => 3145109],
    		['id' => 2769, 'nome' => "Nova Serrana", 'uf' => "MG", 'codigo' => 3145208],
    		['id' => 2770, 'nome' => "Novo Cruzeiro", 'uf' => "MG", 'codigo' => 3145307],
    		['id' => 2771, 'nome' => "Novo Oriente de Minas", 'uf' => "MG", 'codigo' => 3145356],
    		['id' => 2772, 'nome' => "Novorizonte", 'uf' => "MG", 'codigo' => 3145372],
    		['id' => 2773, 'nome' => "Olaria", 'uf' => "MG", 'codigo' => 3145406],
    		['id' => 2774, 'nome' => "Olhos-D'Água", 'uf' => "MG", 'codigo' => 3145455],
    		['id' => 2775, 'nome' => "Olímpio Noronha", 'uf' => "MG", 'codigo' => 3145505],
    		['id' => 2776, 'nome' => "Oliveira", 'uf' => "MG", 'codigo' => 3145604],
    		['id' => 2777, 'nome' => "Oliveira Fortes", 'uf' => "MG", 'codigo' => 3145703],
    		['id' => 2778, 'nome' => "Onça de Pitangui", 'uf' => "MG", 'codigo' => 3145802],
    		['id' => 2779, 'nome' => "Oratórios", 'uf' => "MG", 'codigo' => 3145851],
    		['id' => 2780, 'nome' => "Orizânia", 'uf' => "MG", 'codigo' => 3145877],
    		['id' => 2781, 'nome' => "Ouro Branco", 'uf' => "MG", 'codigo' => 3145901],
    		['id' => 2782, 'nome' => "Ouro Fino", 'uf' => "MG", 'codigo' => 3146008],
    		['id' => 2783, 'nome' => "Ouro Preto", 'uf' => "MG", 'codigo' => 3146107],
    		['id' => 2784, 'nome' => "Ouro Verde de Minas", 'uf' => "MG", 'codigo' => 3146206],
    		['id' => 2785, 'nome' => "Padre Carvalho", 'uf' => "MG", 'codigo' => 3146255],
    		['id' => 2786, 'nome' => "Padre Paraíso", 'uf' => "MG", 'codigo' => 3146305],
    		['id' => 2787, 'nome' => "Paineiras", 'uf' => "MG", 'codigo' => 3146404],
    		['id' => 2788, 'nome' => "Pains", 'uf' => "MG", 'codigo' => 3146503],
    		['id' => 2789, 'nome' => "Pai Pedro", 'uf' => "MG", 'codigo' => 3146552],
    		['id' => 2790, 'nome' => "Paiva", 'uf' => "MG", 'codigo' => 3146602],
    		['id' => 2791, 'nome' => "Palma", 'uf' => "MG", 'codigo' => 3146701],
    		['id' => 2792, 'nome' => "Palmópolis", 'uf' => "MG", 'codigo' => 3146750],
    		['id' => 2793, 'nome' => "Papagaios", 'uf' => "MG", 'codigo' => 3146909],
    		['id' => 2794, 'nome' => "Paracatu", 'uf' => "MG", 'codigo' => 3147006],
    		['id' => 2795, 'nome' => "Pará de Minas", 'uf' => "MG", 'codigo' => 3147105],
    		['id' => 2796, 'nome' => "Paraguaçu", 'uf' => "MG", 'codigo' => 3147204],
    		['id' => 2797, 'nome' => "Paraisópolis", 'uf' => "MG", 'codigo' => 3147303],
    		['id' => 2798, 'nome' => "Paraopeba", 'uf' => "MG", 'codigo' => 3147402],
    		['id' => 2799, 'nome' => "Passabém", 'uf' => "MG", 'codigo' => 3147501],
    		['id' => 2800, 'nome' => "Passa Quatro", 'uf' => "MG", 'codigo' => 3147600],
    		['id' => 2801, 'nome' => "Passa Tempo", 'uf' => "MG", 'codigo' => 3147709],
    		['id' => 2802, 'nome' => "Passa-Vinte", 'uf' => "MG", 'codigo' => 3147808],
    		['id' => 2803, 'nome' => "Passos", 'uf' => "MG", 'codigo' => 3147907],
    		['id' => 2804, 'nome' => "Patis", 'uf' => "MG", 'codigo' => 3147956],
    		['id' => 2805, 'nome' => "Patos de Minas", 'uf' => "MG", 'codigo' => 3148004],
    		['id' => 2806, 'nome' => "Patrocínio", 'uf' => "MG", 'codigo' => 3148103],
    		['id' => 2807, 'nome' => "Patrocínio do Muriaé", 'uf' => "MG", 'codigo' => 3148202],
    		['id' => 2808, 'nome' => "Paula Cândido", 'uf' => "MG", 'codigo' => 3148301],
    		['id' => 2809, 'nome' => "Paulistas", 'uf' => "MG", 'codigo' => 3148400],
    		['id' => 2810, 'nome' => "Pavão", 'uf' => "MG", 'codigo' => 3148509],
    		['id' => 2811, 'nome' => "Peçanha", 'uf' => "MG", 'codigo' => 3148608],
    		['id' => 2812, 'nome' => "Pedra Azul", 'uf' => "MG", 'codigo' => 3148707],
    		['id' => 2813, 'nome' => "Pedra Bonita", 'uf' => "MG", 'codigo' => 3148756],
    		['id' => 2814, 'nome' => "Pedra do Anta", 'uf' => "MG", 'codigo' => 3148806],
    		['id' => 2815, 'nome' => "Pedra do Indaiá", 'uf' => "MG", 'codigo' => 3148905],
    		['id' => 2816, 'nome' => "Pedra Dourada", 'uf' => "MG", 'codigo' => 3149002],
    		['id' => 2817, 'nome' => "Pedralva", 'uf' => "MG", 'codigo' => 3149101],
    		['id' => 2818, 'nome' => "Pedras de Maria da Cruz", 'uf' => "MG", 'codigo' => 3149150],
    		['id' => 2819, 'nome' => "Pedrinópolis", 'uf' => "MG", 'codigo' => 3149200],
    		['id' => 2820, 'nome' => "Pedro Leopoldo", 'uf' => "MG", 'codigo' => 3149309],
    		['id' => 2821, 'nome' => "Pedro Teixeira", 'uf' => "MG", 'codigo' => 3149408],
    		['id' => 2822, 'nome' => "Pequeri", 'uf' => "MG", 'codigo' => 3149507],
    		['id' => 2823, 'nome' => "Pequi", 'uf' => "MG", 'codigo' => 3149606],
    		['id' => 2824, 'nome' => "Perdigão", 'uf' => "MG", 'codigo' => 3149705],
    		['id' => 2825, 'nome' => "Perdizes", 'uf' => "MG", 'codigo' => 3149804],
    		['id' => 2826, 'nome' => "Perdões", 'uf' => "MG", 'codigo' => 3149903],
    		['id' => 2827, 'nome' => "Periquito", 'uf' => "MG", 'codigo' => 3149952],
    		['id' => 2828, 'nome' => "Pescador", 'uf' => "MG", 'codigo' => 3150000],
    		['id' => 2829, 'nome' => "Piau", 'uf' => "MG", 'codigo' => 3150109],
    		['id' => 2830, 'nome' => "Piedade de Caratinga", 'uf' => "MG", 'codigo' => 3150158],
    		['id' => 2831, 'nome' => "Piedade de Ponte Nova", 'uf' => "MG", 'codigo' => 3150208],
    		['id' => 2832, 'nome' => "Piedade do Rio Grande", 'uf' => "MG", 'codigo' => 3150307],
    		['id' => 2833, 'nome' => "Piedade dos Gerais", 'uf' => "MG", 'codigo' => 3150406],
    		['id' => 2834, 'nome' => "Pimenta", 'uf' => "MG", 'codigo' => 3150505],
    		['id' => 2835, 'nome' => "Pingo-D'Água", 'uf' => "MG", 'codigo' => 3150539],
    		['id' => 2836, 'nome' => "Pintópolis", 'uf' => "MG", 'codigo' => 3150570],
    		['id' => 2837, 'nome' => "Piracema", 'uf' => "MG", 'codigo' => 3150604],
    		['id' => 2838, 'nome' => "Pirajuba", 'uf' => "MG", 'codigo' => 3150703],
    		['id' => 2839, 'nome' => "Piranga", 'uf' => "MG", 'codigo' => 3150802],
    		['id' => 2840, 'nome' => "Piranguçu", 'uf' => "MG", 'codigo' => 3150901],
    		['id' => 2841, 'nome' => "Piranguinho", 'uf' => "MG", 'codigo' => 3151008],
    		['id' => 2842, 'nome' => "Pirapetinga", 'uf' => "MG", 'codigo' => 3151107],
    		['id' => 2843, 'nome' => "Pirapora", 'uf' => "MG", 'codigo' => 3151206],
    		['id' => 2844, 'nome' => "Piraúba", 'uf' => "MG", 'codigo' => 3151305],
    		['id' => 2845, 'nome' => "Pitangui", 'uf' => "MG", 'codigo' => 3151404],
    		['id' => 2846, 'nome' => "Piumhi", 'uf' => "MG", 'codigo' => 3151503],
    		['id' => 2847, 'nome' => "Planura", 'uf' => "MG", 'codigo' => 3151602],
    		['id' => 2848, 'nome' => "Poço Fundo", 'uf' => "MG", 'codigo' => 3151701],
    		['id' => 2849, 'nome' => "Poços de Caldas", 'uf' => "MG", 'codigo' => 3151800],
    		['id' => 2850, 'nome' => "Pocrane", 'uf' => "MG", 'codigo' => 3151909],
    		['id' => 2851, 'nome' => "Pompéu", 'uf' => "MG", 'codigo' => 3152006],
    		['id' => 2852, 'nome' => "Ponte Nova", 'uf' => "MG", 'codigo' => 3152105],
    		['id' => 2853, 'nome' => "Ponto Chique", 'uf' => "MG", 'codigo' => 3152131],
    		['id' => 2854, 'nome' => "Ponto dos Volantes", 'uf' => "MG", 'codigo' => 3152170],
    		['id' => 2855, 'nome' => "Porteirinha", 'uf' => "MG", 'codigo' => 3152204],
    		['id' => 2856, 'nome' => "Porto Firme", 'uf' => "MG", 'codigo' => 3152303],
    		['id' => 2857, 'nome' => "Poté", 'uf' => "MG", 'codigo' => 3152402],
    		['id' => 2858, 'nome' => "Pouso Alegre", 'uf' => "MG", 'codigo' => 3152501],
    		['id' => 2859, 'nome' => "Pouso Alto", 'uf' => "MG", 'codigo' => 3152600],
    		['id' => 2860, 'nome' => "Prados", 'uf' => "MG", 'codigo' => 3152709],
    		['id' => 2861, 'nome' => "Prata", 'uf' => "MG", 'codigo' => 3152808],
    		['id' => 2862, 'nome' => "Pratápolis", 'uf' => "MG", 'codigo' => 3152907],
    		['id' => 2863, 'nome' => "Pratinha", 'uf' => "MG", 'codigo' => 3153004],
    		['id' => 2864, 'nome' => "Presidente Bernardes", 'uf' => "MG", 'codigo' => 3153103],
    		['id' => 2865, 'nome' => "Presidente Juscelino", 'uf' => "MG", 'codigo' => 3153202],
    		['id' => 2866, 'nome' => "Presidente Kubitschek", 'uf' => "MG", 'codigo' => 3153301],
    		['id' => 2867, 'nome' => "Presidente Olegário", 'uf' => "MG", 'codigo' => 3153400],
    		['id' => 2868, 'nome' => "Alto Jequitibá", 'uf' => "MG", 'codigo' => 3153509],
    		['id' => 2869, 'nome' => "Prudente de Morais", 'uf' => "MG", 'codigo' => 3153608],
    		['id' => 2870, 'nome' => "Quartel Geral", 'uf' => "MG", 'codigo' => 3153707],
    		['id' => 2871, 'nome' => "Queluzito", 'uf' => "MG", 'codigo' => 3153806],
    		['id' => 2872, 'nome' => "Raposos", 'uf' => "MG", 'codigo' => 3153905],
    		['id' => 2873, 'nome' => "Raul Soares", 'uf' => "MG", 'codigo' => 3154002],
    		['id' => 2874, 'nome' => "Recreio", 'uf' => "MG", 'codigo' => 3154101],
    		['id' => 2875, 'nome' => "Reduto", 'uf' => "MG", 'codigo' => 3154150],
    		['id' => 2876, 'nome' => "Resende Costa", 'uf' => "MG", 'codigo' => 3154200],
    		['id' => 2877, 'nome' => "Resplendor", 'uf' => "MG", 'codigo' => 3154309],
    		['id' => 2878, 'nome' => "Ressaquinha", 'uf' => "MG", 'codigo' => 3154408],
    		['id' => 2879, 'nome' => "Riachinho", 'uf' => "MG", 'codigo' => 3154457],
    		['id' => 2880, 'nome' => "Riacho dos Machados", 'uf' => "MG", 'codigo' => 3154507],
    		['id' => 2881, 'nome' => "Ribeirão das Neves", 'uf' => "MG", 'codigo' => 3154606],
    		['id' => 2882, 'nome' => "Ribeirão Vermelho", 'uf' => "MG", 'codigo' => 3154705],
    		['id' => 2883, 'nome' => "Rio Acima", 'uf' => "MG", 'codigo' => 3154804],
    		['id' => 2884, 'nome' => "Rio Casca", 'uf' => "MG", 'codigo' => 3154903],
    		['id' => 2885, 'nome' => "Rio Doce", 'uf' => "MG", 'codigo' => 3155009],
    		['id' => 2886, 'nome' => "Rio do Prado", 'uf' => "MG", 'codigo' => 3155108],
    		['id' => 2887, 'nome' => "Rio Espera", 'uf' => "MG", 'codigo' => 3155207],
    		['id' => 2888, 'nome' => "Rio Manso", 'uf' => "MG", 'codigo' => 3155306],
    		['id' => 2889, 'nome' => "Rio Novo", 'uf' => "MG", 'codigo' => 3155405],
    		['id' => 2890, 'nome' => "Rio Paranaíba", 'uf' => "MG", 'codigo' => 3155504],
    		['id' => 2891, 'nome' => "Rio Pardo de Minas", 'uf' => "MG", 'codigo' => 3155603],
    		['id' => 2892, 'nome' => "Rio Piracicaba", 'uf' => "MG", 'codigo' => 3155702],
    		['id' => 2893, 'nome' => "Rio Pomba", 'uf' => "MG", 'codigo' => 3155801],
    		['id' => 2894, 'nome' => "Rio Preto", 'uf' => "MG", 'codigo' => 3155900],
    		['id' => 2895, 'nome' => "Rio Vermelho", 'uf' => "MG", 'codigo' => 3156007],
    		['id' => 2896, 'nome' => "Ritápolis", 'uf' => "MG", 'codigo' => 3156106],
    		['id' => 2897, 'nome' => "Rochedo de Minas", 'uf' => "MG", 'codigo' => 3156205],
    		['id' => 2898, 'nome' => "Rodeiro", 'uf' => "MG", 'codigo' => 3156304],
    		['id' => 2899, 'nome' => "Romaria", 'uf' => "MG", 'codigo' => 3156403],
    		['id' => 2900, 'nome' => "Rosário da Limeira", 'uf' => "MG", 'codigo' => 3156452],
    		['id' => 2901, 'nome' => "Rubelita", 'uf' => "MG", 'codigo' => 3156502],
    		['id' => 2902, 'nome' => "Rubim", 'uf' => "MG", 'codigo' => 3156601],
    		['id' => 2903, 'nome' => "Sabará", 'uf' => "MG", 'codigo' => 3156700],
    		['id' => 2904, 'nome' => "Sabinópolis", 'uf' => "MG", 'codigo' => 3156809],
    		['id' => 2905, 'nome' => "Sacramento", 'uf' => "MG", 'codigo' => 3156908],
    		['id' => 2906, 'nome' => "Salinas", 'uf' => "MG", 'codigo' => 3157005],
    		['id' => 2907, 'nome' => "Salto da Divisa", 'uf' => "MG", 'codigo' => 3157104],
    		['id' => 2908, 'nome' => "Santa Bárbara", 'uf' => "MG", 'codigo' => 3157203],
    		['id' => 2909, 'nome' => "Santa Bárbara do Leste", 'uf' => "MG", 'codigo' => 3157252],
    		['id' => 2910, 'nome' => "Santa Bárbara do Monte Verde", 'uf' => "MG", 'codigo' => 3157278],
    		['id' => 2911, 'nome' => "Santa Bárbara do Tugúrio", 'uf' => "MG", 'codigo' => 3157302],
    		['id' => 2912, 'nome' => "Santa Cruz de Minas", 'uf' => "MG", 'codigo' => 3157336],
    		['id' => 2913, 'nome' => "Santa Cruz de Salinas", 'uf' => "MG", 'codigo' => 3157377],
    		['id' => 2914, 'nome' => "Santa Cruz do Escalvado", 'uf' => "MG", 'codigo' => 3157401],
    		['id' => 2915, 'nome' => "Santa Efigênia de Minas", 'uf' => "MG", 'codigo' => 3157500],
    		['id' => 2916, 'nome' => "Santa Fé de Minas", 'uf' => "MG", 'codigo' => 3157609],
    		['id' => 2917, 'nome' => "Santa Helena de Minas", 'uf' => "MG", 'codigo' => 3157658],
    		['id' => 2918, 'nome' => "Santa Juliana", 'uf' => "MG", 'codigo' => 3157708],
    		['id' => 2919, 'nome' => "Santa Luzia", 'uf' => "MG", 'codigo' => 3157807],
    		['id' => 2920, 'nome' => "Santa Margarida", 'uf' => "MG", 'codigo' => 3157906],
    		['id' => 2921, 'nome' => "Santa Maria de Itabira", 'uf' => "MG", 'codigo' => 3158003],
    		['id' => 2922, 'nome' => "Santa Maria do Salto", 'uf' => "MG", 'codigo' => 3158102],
    		['id' => 2923, 'nome' => "Santa Maria do Suaçuí", 'uf' => "MG", 'codigo' => 3158201],
    		['id' => 2924, 'nome' => "Santana da Vargem", 'uf' => "MG", 'codigo' => 3158300],
    		['id' => 2925, 'nome' => "Santana de Cataguases", 'uf' => "MG", 'codigo' => 3158409],
    		['id' => 2926, 'nome' => "Santana de Pirapama", 'uf' => "MG", 'codigo' => 3158508],
    		['id' => 2927, 'nome' => "Santana do Deserto", 'uf' => "MG", 'codigo' => 3158607],
    		['id' => 2928, 'nome' => "Santana do Garambéu", 'uf' => "MG", 'codigo' => 3158706],
    		['id' => 2929, 'nome' => "Santana do Jacaré", 'uf' => "MG", 'codigo' => 3158805],
    		['id' => 2930, 'nome' => "Santana do Manhuaçu", 'uf' => "MG", 'codigo' => 3158904],
    		['id' => 2931, 'nome' => "Santana do Paraíso", 'uf' => "MG", 'codigo' => 3158953],
    		['id' => 2932, 'nome' => "Santana do Riacho", 'uf' => "MG", 'codigo' => 3159001],
    		['id' => 2933, 'nome' => "Santana dos Montes", 'uf' => "MG", 'codigo' => 3159100],
    		['id' => 2934, 'nome' => "Santa Rita de Caldas", 'uf' => "MG", 'codigo' => 3159209],
    		['id' => 2935, 'nome' => "Santa Rita de Jacutinga", 'uf' => "MG", 'codigo' => 3159308],
    		['id' => 2936, 'nome' => "Santa Rita de Minas", 'uf' => "MG", 'codigo' => 3159357],
    		['id' => 2937, 'nome' => "Santa Rita de Ibitipoca", 'uf' => "MG", 'codigo' => 3159407],
    		['id' => 2938, 'nome' => "Santa Rita do Itueto", 'uf' => "MG", 'codigo' => 3159506],
    		['id' => 2939, 'nome' => "Santa Rita do Sapucaí", 'uf' => "MG", 'codigo' => 3159605],
    		['id' => 2940, 'nome' => "Santa Rosa da Serra", 'uf' => "MG", 'codigo' => 3159704],
    		['id' => 2941, 'nome' => "Santa Vitória", 'uf' => "MG", 'codigo' => 3159803],
    		['id' => 2942, 'nome' => "Santo Antônio do Amparo", 'uf' => "MG", 'codigo' => 3159902],
    		['id' => 2943, 'nome' => "Santo Antônio do Aventureiro", 'uf' => "MG", 'codigo' => 3160009],
    		['id' => 2944, 'nome' => "Santo Antônio do Grama", 'uf' => "MG", 'codigo' => 3160108],
    		['id' => 2945, 'nome' => "Santo Antônio do Itambé", 'uf' => "MG", 'codigo' => 3160207],
    		['id' => 2946, 'nome' => "Santo Antônio do Jacinto", 'uf' => "MG", 'codigo' => 3160306],
    		['id' => 2947, 'nome' => "Santo Antônio do Monte", 'uf' => "MG", 'codigo' => 3160405],
    		['id' => 2948, 'nome' => "Santo Antônio do Retiro", 'uf' => "MG", 'codigo' => 3160454],
    		['id' => 2949, 'nome' => "Santo Antônio do Rio Abaixo", 'uf' => "MG", 'codigo' => 3160504],
    		['id' => 2950, 'nome' => "Santo Hipólito", 'uf' => "MG", 'codigo' => 3160603],
    		['id' => 2951, 'nome' => "Santos Dumont", 'uf' => "MG", 'codigo' => 3160702],
    		['id' => 2952, 'nome' => "São Bento Abade", 'uf' => "MG", 'codigo' => 3160801],
    		['id' => 2953, 'nome' => "São Brás do Suaçuí", 'uf' => "MG", 'codigo' => 3160900],
    		['id' => 2954, 'nome' => "São Domingos das Dores", 'uf' => "MG", 'codigo' => 3160959],
    		['id' => 2955, 'nome' => "São Domingos do Prata", 'uf' => "MG", 'codigo' => 3161007],
    		['id' => 2956, 'nome' => "São Félix de Minas", 'uf' => "MG", 'codigo' => 3161056],
    		['id' => 2957, 'nome' => "São Francisco", 'uf' => "MG", 'codigo' => 3161106],
    		['id' => 2958, 'nome' => "São Francisco de Paula", 'uf' => "MG", 'codigo' => 3161205],
    		['id' => 2959, 'nome' => "São Francisco de Sales", 'uf' => "MG", 'codigo' => 3161304],
    		['id' => 2960, 'nome' => "São Francisco do Glória", 'uf' => "MG", 'codigo' => 3161403],
    		['id' => 2961, 'nome' => "São Geraldo", 'uf' => "MG", 'codigo' => 3161502],
    		['id' => 2962, 'nome' => "São Geraldo da Piedade", 'uf' => "MG", 'codigo' => 3161601],
    		['id' => 2963, 'nome' => "São Geraldo do Baixio", 'uf' => "MG", 'codigo' => 3161650],
    		['id' => 2964, 'nome' => "São Gonçalo do Abaeté", 'uf' => "MG", 'codigo' => 3161700],
    		['id' => 2965, 'nome' => "São Gonçalo do Pará", 'uf' => "MG", 'codigo' => 3161809],
    		['id' => 2966, 'nome' => "São Gonçalo do Rio Abaixo", 'uf' => "MG", 'codigo' => 3161908],
    		['id' => 2967, 'nome' => "São Gonçalo do Sapucaí", 'uf' => "MG", 'codigo' => 3162005],
    		['id' => 2968, 'nome' => "São Gotardo", 'uf' => "MG", 'codigo' => 3162104],
    		['id' => 2969, 'nome' => "São João Batista do Glória", 'uf' => "MG", 'codigo' => 3162203],
    		['id' => 2970, 'nome' => "São João da Lagoa", 'uf' => "MG", 'codigo' => 3162252],
    		['id' => 2971, 'nome' => "São João da Mata", 'uf' => "MG", 'codigo' => 3162302],
    		['id' => 2972, 'nome' => "São João da Ponte", 'uf' => "MG", 'codigo' => 3162401],
    		['id' => 2973, 'nome' => "São João das Missões", 'uf' => "MG", 'codigo' => 3162450],
    		['id' => 2974, 'nome' => "São João del Rei", 'uf' => "MG", 'codigo' => 3162500],
    		['id' => 2975, 'nome' => "São João do Manhuaçu", 'uf' => "MG", 'codigo' => 3162559],
    		['id' => 2976, 'nome' => "São João do Manteninha", 'uf' => "MG", 'codigo' => 3162575],
    		['id' => 2977, 'nome' => "São João do Oriente", 'uf' => "MG", 'codigo' => 3162609],
    		['id' => 2978, 'nome' => "São João do Pacuí", 'uf' => "MG", 'codigo' => 3162658],
    		['id' => 2979, 'nome' => "São João do Paraíso", 'uf' => "MG", 'codigo' => 3162708],
    		['id' => 2980, 'nome' => "São João Evangelista", 'uf' => "MG", 'codigo' => 3162807],
    		['id' => 2981, 'nome' => "São João Nepomuceno", 'uf' => "MG", 'codigo' => 3162906],
    		['id' => 2982, 'nome' => "São Joaquim de Bicas", 'uf' => "MG", 'codigo' => 3162922],
    		['id' => 2983, 'nome' => "São José da Barra", 'uf' => "MG", 'codigo' => 3162948],
    		['id' => 2984, 'nome' => "São José da Lapa", 'uf' => "MG", 'codigo' => 3162955],
    		['id' => 2985, 'nome' => "São José da Safira", 'uf' => "MG", 'codigo' => 3163003],
    		['id' => 2986, 'nome' => "São José da Varginha", 'uf' => "MG", 'codigo' => 3163102],
    		['id' => 2987, 'nome' => "São José do Alegre", 'uf' => "MG", 'codigo' => 3163201],
    		['id' => 2988, 'nome' => "São José do Divino", 'uf' => "MG", 'codigo' => 3163300],
    		['id' => 2989, 'nome' => "São José do Goiabal", 'uf' => "MG", 'codigo' => 3163409],
    		['id' => 2990, 'nome' => "São José do Jacuri", 'uf' => "MG", 'codigo' => 3163508],
    		['id' => 2991, 'nome' => "São José do Mantimento", 'uf' => "MG", 'codigo' => 3163607],
    		['id' => 2992, 'nome' => "São Lourenço", 'uf' => "MG", 'codigo' => 3163706],
    		['id' => 2993, 'nome' => "São Miguel do Anta", 'uf' => "MG", 'codigo' => 3163805],
    		['id' => 2994, 'nome' => "São Pedro da União", 'uf' => "MG", 'codigo' => 3163904],
    		['id' => 2995, 'nome' => "São Pedro dos Ferros", 'uf' => "MG", 'codigo' => 3164001],
    		['id' => 2996, 'nome' => "São Pedro do Suaçuí", 'uf' => "MG", 'codigo' => 3164100],
    		['id' => 2997, 'nome' => "São Romão", 'uf' => "MG", 'codigo' => 3164209],
    		['id' => 2998, 'nome' => "São Roque de Minas", 'uf' => "MG", 'codigo' => 3164308],
    		['id' => 2999, 'nome' => "São Sebastião da Bela Vista", 'uf' => "MG", 'codigo' => 3164407],
    		['id' => 3000, 'nome' => "São Sebastião da Vargem Alegre", 'uf' => "MG", 'codigo' => 3164431],
    		['id' => 3001, 'nome' => "São Sebastião do Anta", 'uf' => "MG", 'codigo' => 3164472],
    		['id' => 3002, 'nome' => "São Sebastião do Maranhão", 'uf' => "MG", 'codigo' => 3164506],
    		['id' => 3003, 'nome' => "São Sebastião do Oeste", 'uf' => "MG", 'codigo' => 3164605],
    		['id' => 3004, 'nome' => "São Sebastião do Paraíso", 'uf' => "MG", 'codigo' => 3164704],
    		['id' => 3005, 'nome' => "São Sebastião do Rio Preto", 'uf' => "MG", 'codigo' => 3164803],
    		['id' => 3006, 'nome' => "São Sebastião do Rio Verde", 'uf' => "MG", 'codigo' => 3164902],
    		['id' => 3007, 'nome' => "São Tiago", 'uf' => "MG", 'codigo' => 3165008],
    		['id' => 3008, 'nome' => "São Tomás de Aquino", 'uf' => "MG", 'codigo' => 3165107],
    		['id' => 3009, 'nome' => "São Thomé das Letras", 'uf' => "MG", 'codigo' => 3165206],
    		['id' => 3010, 'nome' => "São Vicente de Minas", 'uf' => "MG", 'codigo' => 3165305],
    		['id' => 3011, 'nome' => "Sapucaí-Mirim", 'uf' => "MG", 'codigo' => 3165404],
    		['id' => 3012, 'nome' => "Sardoá", 'uf' => "MG", 'codigo' => 3165503],
    		['id' => 3013, 'nome' => "Sarzedo", 'uf' => "MG", 'codigo' => 3165537],
    		['id' => 3014, 'nome' => "Setubinha", 'uf' => "MG", 'codigo' => 3165552],
    		['id' => 3015, 'nome' => "Sem-Peixe", 'uf' => "MG", 'codigo' => 3165560],
    		['id' => 3016, 'nome' => "Senador Amaral", 'uf' => "MG", 'codigo' => 3165578],
    		['id' => 3017, 'nome' => "Senador Cortes", 'uf' => "MG", 'codigo' => 3165602],
    		['id' => 3018, 'nome' => "Senador Firmino", 'uf' => "MG", 'codigo' => 3165701],
    		['id' => 3019, 'nome' => "Senador José Bento", 'uf' => "MG", 'codigo' => 3165800],
    		['id' => 3020, 'nome' => "Senador Modestino Gonçalves", 'uf' => "MG", 'codigo' => 3165909],
    		['id' => 3021, 'nome' => "Senhora de Oliveira", 'uf' => "MG", 'codigo' => 3166006],
    		['id' => 3022, 'nome' => "Senhora do Porto", 'uf' => "MG", 'codigo' => 3166105],
    		['id' => 3023, 'nome' => "Senhora dos Remédios", 'uf' => "MG", 'codigo' => 3166204],
    		['id' => 3024, 'nome' => "Sericita", 'uf' => "MG", 'codigo' => 3166303],
    		['id' => 3025, 'nome' => "Seritinga", 'uf' => "MG", 'codigo' => 3166402],
    		['id' => 3026, 'nome' => "Serra Azul de Minas", 'uf' => "MG", 'codigo' => 3166501],
    		['id' => 3027, 'nome' => "Serra da Saudade", 'uf' => "MG", 'codigo' => 3166600],
    		['id' => 3028, 'nome' => "Serra dos Aimorés", 'uf' => "MG", 'codigo' => 3166709],
    		['id' => 3029, 'nome' => "Serra do Salitre", 'uf' => "MG", 'codigo' => 3166808],
    		['id' => 3030, 'nome' => "Serrania", 'uf' => "MG", 'codigo' => 3166907],
    		['id' => 3031, 'nome' => "Serranópolis de Minas", 'uf' => "MG", 'codigo' => 3166956],
    		['id' => 3032, 'nome' => "Serranos", 'uf' => "MG", 'codigo' => 3167004],
    		['id' => 3033, 'nome' => "Serro", 'uf' => "MG", 'codigo' => 3167103],
    		['id' => 3034, 'nome' => "Sete Lagoas", 'uf' => "MG", 'codigo' => 3167202],
    		['id' => 3035, 'nome' => "Silveirânia", 'uf' => "MG", 'codigo' => 3167301],
    		['id' => 3036, 'nome' => "Silvianópolis", 'uf' => "MG", 'codigo' => 3167400],
    		['id' => 3037, 'nome' => "Simão Pereira", 'uf' => "MG", 'codigo' => 3167509],
    		['id' => 3038, 'nome' => "Simonésia", 'uf' => "MG", 'codigo' => 3167608],
    		['id' => 3039, 'nome' => "Sobrália", 'uf' => "MG", 'codigo' => 3167707],
    		['id' => 3040, 'nome' => "Soledade de Minas", 'uf' => "MG", 'codigo' => 3167806],
    		['id' => 3041, 'nome' => "Tabuleiro", 'uf' => "MG", 'codigo' => 3167905],
    		['id' => 3042, 'nome' => "Taiobeiras", 'uf' => "MG", 'codigo' => 3168002],
    		['id' => 3043, 'nome' => "Taparuba", 'uf' => "MG", 'codigo' => 3168051],
    		['id' => 3044, 'nome' => "Tapira", 'uf' => "MG", 'codigo' => 3168101],
    		['id' => 3045, 'nome' => "Tapiraí", 'uf' => "MG", 'codigo' => 3168200],
    		['id' => 3046, 'nome' => "Taquaraçu de Minas", 'uf' => "MG", 'codigo' => 3168309],
    		['id' => 3047, 'nome' => "Tarumirim", 'uf' => "MG", 'codigo' => 3168408],
    		['id' => 3048, 'nome' => "Teixeiras", 'uf' => "MG", 'codigo' => 3168507],
    		['id' => 3049, 'nome' => "Teófilo Otoni", 'uf' => "MG", 'codigo' => 3168606],
    		['id' => 3050, 'nome' => "Timóteo", 'uf' => "MG", 'codigo' => 3168705],
    		['id' => 3051, 'nome' => "Tiradentes", 'uf' => "MG", 'codigo' => 3168804],
    		['id' => 3052, 'nome' => "Tiros", 'uf' => "MG", 'codigo' => 3168903],
    		['id' => 3053, 'nome' => "Tocantins", 'uf' => "MG", 'codigo' => 3169000],
    		['id' => 3054, 'nome' => "Tocos do Moji", 'uf' => "MG", 'codigo' => 3169059],
    		['id' => 3055, 'nome' => "Toledo", 'uf' => "MG", 'codigo' => 3169109],
    		['id' => 3056, 'nome' => "Tombos", 'uf' => "MG", 'codigo' => 3169208],
    		['id' => 3057, 'nome' => "Três Corações", 'uf' => "MG", 'codigo' => 3169307],
    		['id' => 3058, 'nome' => "Três Marias", 'uf' => "MG", 'codigo' => 3169356],
    		['id' => 3059, 'nome' => "Três Pontas", 'uf' => "MG", 'codigo' => 3169406],
    		['id' => 3060, 'nome' => "Tumiritinga", 'uf' => "MG", 'codigo' => 3169505],
    		['id' => 3061, 'nome' => "Tupaciguara", 'uf' => "MG", 'codigo' => 3169604],
    		['id' => 3062, 'nome' => "Turmalina", 'uf' => "MG", 'codigo' => 3169703],
    		['id' => 3063, 'nome' => "Turvolândia", 'uf' => "MG", 'codigo' => 3169802],
    		['id' => 3064, 'nome' => "Ubá", 'uf' => "MG", 'codigo' => 3169901],
    		['id' => 3065, 'nome' => "Ubaí", 'uf' => "MG", 'codigo' => 3170008],
    		['id' => 3066, 'nome' => "Ubaporanga", 'uf' => "MG", 'codigo' => 3170057],
    		['id' => 3067, 'nome' => "Uberaba", 'uf' => "MG", 'codigo' => 3170107],
    		['id' => 3068, 'nome' => "Uberlândia", 'uf' => "MG", 'codigo' => 3170206],
    		['id' => 3069, 'nome' => "Umburatiba", 'uf' => "MG", 'codigo' => 3170305],
    		['id' => 3070, 'nome' => "Unaí", 'uf' => "MG", 'codigo' => 3170404],
    		['id' => 3071, 'nome' => "União de Minas", 'uf' => "MG", 'codigo' => 3170438],
    		['id' => 3072, 'nome' => "Uruana de Minas", 'uf' => "MG", 'codigo' => 3170479],
    		['id' => 3073, 'nome' => "Urucânia", 'uf' => "MG", 'codigo' => 3170503],
    		['id' => 3074, 'nome' => "Urucuia", 'uf' => "MG", 'codigo' => 3170529],
    		['id' => 3075, 'nome' => "Vargem Alegre", 'uf' => "MG", 'codigo' => 3170578],
    		['id' => 3076, 'nome' => "Vargem Bonita", 'uf' => "MG", 'codigo' => 3170602],
    		['id' => 3077, 'nome' => "Vargem Grande do Rio Pardo", 'uf' => "MG", 'codigo' => 3170651],
    		['id' => 3078, 'nome' => "Varginha", 'uf' => "MG", 'codigo' => 3170701],
    		['id' => 3079, 'nome' => "Varjão de Minas", 'uf' => "MG", 'codigo' => 3170750],
    		['id' => 3080, 'nome' => "Várzea da Palma", 'uf' => "MG", 'codigo' => 3170800],
    		['id' => 3081, 'nome' => "Varzelândia", 'uf' => "MG", 'codigo' => 3170909],
    		['id' => 3082, 'nome' => "Vazante", 'uf' => "MG", 'codigo' => 3171006],
    		['id' => 3083, 'nome' => "Verdelândia", 'uf' => "MG", 'codigo' => 3171030],
    		['id' => 3084, 'nome' => "Veredinha", 'uf' => "MG", 'codigo' => 3171071],
    		['id' => 3085, 'nome' => "Veríssimo", 'uf' => "MG", 'codigo' => 3171105],
    		['id' => 3086, 'nome' => "Vermelho Novo", 'uf' => "MG", 'codigo' => 3171154],
    		['id' => 3087, 'nome' => "Vespasiano", 'uf' => "MG", 'codigo' => 3171204],
    		['id' => 3088, 'nome' => "Viçosa", 'uf' => "MG", 'codigo' => 3171303],
    		['id' => 3089, 'nome' => "Vieiras", 'uf' => "MG", 'codigo' => 3171402],
    		['id' => 3090, 'nome' => "Mathias Lobato", 'uf' => "MG", 'codigo' => 3171501],
    		['id' => 3091, 'nome' => "Virgem da Lapa", 'uf' => "MG", 'codigo' => 3171600],
    		['id' => 3092, 'nome' => "Virgínia", 'uf' => "MG", 'codigo' => 3171709],
    		['id' => 3093, 'nome' => "Virginópolis", 'uf' => "MG", 'codigo' => 3171808],
    		['id' => 3094, 'nome' => "Virgolândia", 'uf' => "MG", 'codigo' => 3171907],
    		['id' => 3095, 'nome' => "Visconde do Rio Branco", 'uf' => "MG", 'codigo' => 3172004],
    		['id' => 3096, 'nome' => "Volta Grande", 'uf' => "MG", 'codigo' => 3172103],
    		['id' => 3097, 'nome' => "Wenceslau Braz", 'uf' => "MG", 'codigo' => 3172202],
    		['id' => 3098, 'nome' => "Afonso Cláudio", 'uf' => "ES", 'codigo' => 3200102],
    		['id' => 3099, 'nome' => "Águia Branca", 'uf' => "ES", 'codigo' => 3200136],
    		['id' => 3100, 'nome' => "Água Doce do Norte", 'uf' => "ES", 'codigo' => 3200169],
    		['id' => 3101, 'nome' => "Alegre", 'uf' => "ES", 'codigo' => 3200201],
    		['id' => 3102, 'nome' => "Alfredo Chaves", 'uf' => "ES", 'codigo' => 3200300],
    		['id' => 3103, 'nome' => "Alto Rio Novo", 'uf' => "ES", 'codigo' => 3200359],
    		['id' => 3104, 'nome' => "Anchieta", 'uf' => "ES", 'codigo' => 3200409],
    		['id' => 3105, 'nome' => "Apiacá", 'uf' => "ES", 'codigo' => 3200508],
    		['id' => 3106, 'nome' => "Aracruz", 'uf' => "ES", 'codigo' => 3200607],
    		['id' => 3107, 'nome' => "Atilio Vivacqua", 'uf' => "ES", 'codigo' => 3200706],
    		['id' => 3108, 'nome' => "Baixo Guandu", 'uf' => "ES", 'codigo' => 3200805],
    		['id' => 3109, 'nome' => "Barra de São Francisco", 'uf' => "ES", 'codigo' => 3200904],
    		['id' => 3110, 'nome' => "Boa Esperança", 'uf' => "ES", 'codigo' => 3201001],
    		['id' => 3111, 'nome' => "Bom Jesus do Norte", 'uf' => "ES", 'codigo' => 3201100],
    		['id' => 3112, 'nome' => "Brejetuba", 'uf' => "ES", 'codigo' => 3201159],
    		['id' => 3113, 'nome' => "Cachoeiro de Itapemirim", 'uf' => "ES", 'codigo' => 3201209],
    		['id' => 3114, 'nome' => "Cariacica", 'uf' => "ES", 'codigo' => 3201308],
    		['id' => 3115, 'nome' => "Castelo", 'uf' => "ES", 'codigo' => 3201407],
    		['id' => 3116, 'nome' => "Colatina", 'uf' => "ES", 'codigo' => 3201506],
    		['id' => 3117, 'nome' => "Conceição da Barra", 'uf' => "ES", 'codigo' => 3201605],
    		['id' => 3118, 'nome' => "Conceição do Castelo", 'uf' => "ES", 'codigo' => 3201704],
    		['id' => 3119, 'nome' => "Divino de São Lourenço", 'uf' => "ES", 'codigo' => 3201803],
    		['id' => 3120, 'nome' => "Domingos Martins", 'uf' => "ES", 'codigo' => 3201902],
    		['id' => 3121, 'nome' => "Dores do Rio Preto", 'uf' => "ES", 'codigo' => 3202009],
    		['id' => 3122, 'nome' => "Ecoporanga", 'uf' => "ES", 'codigo' => 3202108],
    		['id' => 3123, 'nome' => "Fundão", 'uf' => "ES", 'codigo' => 3202207],
    		['id' => 3124, 'nome' => "Governador Lindenberg", 'uf' => "ES", 'codigo' => 3202256],
    		['id' => 3125, 'nome' => "Guaçuí", 'uf' => "ES", 'codigo' => 3202306],
    		['id' => 3126, 'nome' => "Guarapari", 'uf' => "ES", 'codigo' => 3202405],
    		['id' => 3127, 'nome' => "Ibatiba", 'uf' => "ES", 'codigo' => 3202454],
    		['id' => 3128, 'nome' => "Ibiraçu", 'uf' => "ES", 'codigo' => 3202504],
    		['id' => 3129, 'nome' => "Ibitirama", 'uf' => "ES", 'codigo' => 3202553],
    		['id' => 3130, 'nome' => "Iconha", 'uf' => "ES", 'codigo' => 3202603],
    		['id' => 3131, 'nome' => "Irupi", 'uf' => "ES", 'codigo' => 3202652],
    		['id' => 3132, 'nome' => "Itaguaçu", 'uf' => "ES", 'codigo' => 3202702],
    		['id' => 3133, 'nome' => "Itapemirim", 'uf' => "ES", 'codigo' => 3202801],
    		['id' => 3134, 'nome' => "Itarana", 'uf' => "ES", 'codigo' => 3202900],
    		['id' => 3135, 'nome' => "Iúna", 'uf' => "ES", 'codigo' => 3203007],
    		['id' => 3136, 'nome' => "Jaguaré", 'uf' => "ES", 'codigo' => 3203056],
    		['id' => 3137, 'nome' => "Jerônimo Monteiro", 'uf' => "ES", 'codigo' => 3203106],
    		['id' => 3138, 'nome' => "João Neiva", 'uf' => "ES", 'codigo' => 3203130],
    		['id' => 3139, 'nome' => "Laranja da Terra", 'uf' => "ES", 'codigo' => 3203163],
    		['id' => 3140, 'nome' => "Linhares", 'uf' => "ES", 'codigo' => 3203205],
    		['id' => 3141, 'nome' => "Mantenópolis", 'uf' => "ES", 'codigo' => 3203304],
    		['id' => 3142, 'nome' => "Marataízes", 'uf' => "ES", 'codigo' => 3203320],
    		['id' => 3143, 'nome' => "Marechal Floriano", 'uf' => "ES", 'codigo' => 3203346],
    		['id' => 3144, 'nome' => "Marilândia", 'uf' => "ES", 'codigo' => 3203353],
    		['id' => 3145, 'nome' => "Mimoso do Sul", 'uf' => "ES", 'codigo' => 3203403],
    		['id' => 3146, 'nome' => "Montanha", 'uf' => "ES", 'codigo' => 3203502],
    		['id' => 3147, 'nome' => "Mucurici", 'uf' => "ES", 'codigo' => 3203601],
    		['id' => 3148, 'nome' => "Muniz Freire", 'uf' => "ES", 'codigo' => 3203700],
    		['id' => 3149, 'nome' => "Muqui", 'uf' => "ES", 'codigo' => 3203809],
    		['id' => 3150, 'nome' => "Nova Venécia", 'uf' => "ES", 'codigo' => 3203908],
    		['id' => 3151, 'nome' => "Pancas", 'uf' => "ES", 'codigo' => 3204005],
    		['id' => 3152, 'nome' => "Pedro Canário", 'uf' => "ES", 'codigo' => 3204054],
    		['id' => 3153, 'nome' => "Pinheiros", 'uf' => "ES", 'codigo' => 3204104],
    		['id' => 3154, 'nome' => "Piúma", 'uf' => "ES", 'codigo' => 3204203],
    		['id' => 3155, 'nome' => "Ponto Belo", 'uf' => "ES", 'codigo' => 3204252],
    		['id' => 3156, 'nome' => "Presidente Kennedy", 'uf' => "ES", 'codigo' => 3204302],
    		['id' => 3157, 'nome' => "Rio Bananal", 'uf' => "ES", 'codigo' => 3204351],
    		['id' => 3158, 'nome' => "Rio Novo do Sul", 'uf' => "ES", 'codigo' => 3204401],
    		['id' => 3159, 'nome' => "Santa Leopoldina", 'uf' => "ES", 'codigo' => 3204500],
    		['id' => 3160, 'nome' => "Santa Maria de Jetibá", 'uf' => "ES", 'codigo' => 3204559],
    		['id' => 3161, 'nome' => "Santa Teresa", 'uf' => "ES", 'codigo' => 3204609],
    		['id' => 3162, 'nome' => "São Domingos do Norte", 'uf' => "ES", 'codigo' => 3204658],
    		['id' => 3163, 'nome' => "São Gabriel da Palha", 'uf' => "ES", 'codigo' => 3204708],
    		['id' => 3164, 'nome' => "São José do Calçado", 'uf' => "ES", 'codigo' => 3204807],
    		['id' => 3165, 'nome' => "São Mateus", 'uf' => "ES", 'codigo' => 3204906],
    		['id' => 3166, 'nome' => "São Roque do Canaã", 'uf' => "ES", 'codigo' => 3204955],
    		['id' => 3167, 'nome' => "Serra", 'uf' => "ES", 'codigo' => 3205002],
    		['id' => 3168, 'nome' => "Sooretama", 'uf' => "ES", 'codigo' => 3205010],
    		['id' => 3169, 'nome' => "Vargem Alta", 'uf' => "ES", 'codigo' => 3205036],
    		['id' => 3170, 'nome' => "Venda Nova do Imigrante", 'uf' => "ES", 'codigo' => 3205069],
    		['id' => 3171, 'nome' => "Viana", 'uf' => "ES", 'codigo' => 3205101],
    		['id' => 3172, 'nome' => "Vila Pavão", 'uf' => "ES", 'codigo' => 3205150],
    		['id' => 3173, 'nome' => "Vila Valério", 'uf' => "ES", 'codigo' => 3205176],
    		['id' => 3174, 'nome' => "Vila Velha", 'uf' => "ES", 'codigo' => 3205200],
    		['id' => 3175, 'nome' => "Vitória", 'uf' => "ES", 'codigo' => 3205309],
    		['id' => 3176, 'nome' => "Angra dos Reis", 'uf' => "RJ", 'codigo' => 3300100],
    		['id' => 3177, 'nome' => "Aperibé", 'uf' => "RJ", 'codigo' => 3300159],
    		['id' => 3178, 'nome' => "Araruama", 'uf' => "RJ", 'codigo' => 3300209],
    		['id' => 3179, 'nome' => "Areal", 'uf' => "RJ", 'codigo' => 3300225],
    		['id' => 3180, 'nome' => "Armação dos Búzios", 'uf' => "RJ", 'codigo' => 3300233],
    		['id' => 3181, 'nome' => "Arraial do Cabo", 'uf' => "RJ", 'codigo' => 3300258],
    		['id' => 3182, 'nome' => "Barra do Piraí", 'uf' => "RJ", 'codigo' => 3300308],
    		['id' => 3183, 'nome' => "Barra Mansa", 'uf' => "RJ", 'codigo' => 3300407],
    		['id' => 3184, 'nome' => "Belford Roxo", 'uf' => "RJ", 'codigo' => 3300456],
    		['id' => 3185, 'nome' => "Bom Jardim", 'uf' => "RJ", 'codigo' => 3300506],
    		['id' => 3186, 'nome' => "Bom Jesus do Itabapoana", 'uf' => "RJ", 'codigo' => 3300605],
    		['id' => 3187, 'nome' => "Cabo Frio", 'uf' => "RJ", 'codigo' => 3300704],
    		['id' => 3188, 'nome' => "Cachoeiras de Macacu", 'uf' => "RJ", 'codigo' => 3300803],
    		['id' => 3189, 'nome' => "Cambuci", 'uf' => "RJ", 'codigo' => 3300902],
    		['id' => 3190, 'nome' => "Carapebus", 'uf' => "RJ", 'codigo' => 3300936],
    		['id' => 3191, 'nome' => "Comendador Levy Gasparian", 'uf' => "RJ", 'codigo' => 3300951],
    		['id' => 3192, 'nome' => "Campos dos Goytacazes", 'uf' => "RJ", 'codigo' => 3301009],
    		['id' => 3193, 'nome' => "Cantagalo", 'uf' => "RJ", 'codigo' => 3301108],
    		['id' => 3194, 'nome' => "Cardoso Moreira", 'uf' => "RJ", 'codigo' => 3301157],
    		['id' => 3195, 'nome' => "Carmo", 'uf' => "RJ", 'codigo' => 3301207],
    		['id' => 3196, 'nome' => "Casimiro de Abreu", 'uf' => "RJ", 'codigo' => 3301306],
    		['id' => 3197, 'nome' => "Conceição de Macabu", 'uf' => "RJ", 'codigo' => 3301405],
    		['id' => 3198, 'nome' => "Cordeiro", 'uf' => "RJ", 'codigo' => 3301504],
    		['id' => 3199, 'nome' => "Duas Barras", 'uf' => "RJ", 'codigo' => 3301603],
    		['id' => 3200, 'nome' => "Duque de Caxias", 'uf' => "RJ", 'codigo' => 3301702],
    		['id' => 3201, 'nome' => "Engenheiro Paulo de Frontin", 'uf' => "RJ", 'codigo' => 3301801],
    		['id' => 3202, 'nome' => "Guapimirim", 'uf' => "RJ", 'codigo' => 3301850],
    		['id' => 3203, 'nome' => "Iguaba Grande", 'uf' => "RJ", 'codigo' => 3301876],
    		['id' => 3204, 'nome' => "Itaboraí", 'uf' => "RJ", 'codigo' => 3301900],
    		['id' => 3205, 'nome' => "Itaguaí", 'uf' => "RJ", 'codigo' => 3302007],
    		['id' => 3206, 'nome' => "Italva", 'uf' => "RJ", 'codigo' => 3302056],
    		['id' => 3207, 'nome' => "Itaocara", 'uf' => "RJ", 'codigo' => 3302106],
    		['id' => 3208, 'nome' => "Itaperuna", 'uf' => "RJ", 'codigo' => 3302205],
    		['id' => 3209, 'nome' => "Itatiaia", 'uf' => "RJ", 'codigo' => 3302254],
    		['id' => 3210, 'nome' => "Japeri", 'uf' => "RJ", 'codigo' => 3302270],
    		['id' => 3211, 'nome' => "Laje do Muriaé", 'uf' => "RJ", 'codigo' => 3302304],
    		['id' => 3212, 'nome' => "Macaé", 'uf' => "RJ", 'codigo' => 3302403],
    		['id' => 3213, 'nome' => "Macuco", 'uf' => "RJ", 'codigo' => 3302452],
    		['id' => 3214, 'nome' => "Magé", 'uf' => "RJ", 'codigo' => 3302502],
    		['id' => 3215, 'nome' => "Mangaratiba", 'uf' => "RJ", 'codigo' => 3302601],
    		['id' => 3216, 'nome' => "Maricá", 'uf' => "RJ", 'codigo' => 3302700],
    		['id' => 3217, 'nome' => "Mendes", 'uf' => "RJ", 'codigo' => 3302809],
    		['id' => 3218, 'nome' => "Mesquita", 'uf' => "RJ", 'codigo' => 3302858],
    		['id' => 3219, 'nome' => "Miguel Pereira", 'uf' => "RJ", 'codigo' => 3302908],
    		['id' => 3220, 'nome' => "Miracema", 'uf' => "RJ", 'codigo' => 3303005],
    		['id' => 3221, 'nome' => "Natividade", 'uf' => "RJ", 'codigo' => 3303104],
    		['id' => 3222, 'nome' => "Nilópolis", 'uf' => "RJ", 'codigo' => 3303203],
    		['id' => 3223, 'nome' => "Niterói", 'uf' => "RJ", 'codigo' => 3303302],
    		['id' => 3224, 'nome' => "Nova Friburgo", 'uf' => "RJ", 'codigo' => 3303401],
    		['id' => 3225, 'nome' => "Nova Iguaçu", 'uf' => "RJ", 'codigo' => 3303500],
    		['id' => 3226, 'nome' => "Paracambi", 'uf' => "RJ", 'codigo' => 3303609],
    		['id' => 3227, 'nome' => "Paraíba do Sul", 'uf' => "RJ", 'codigo' => 3303708],
    		['id' => 3228, 'nome' => "Paraty", 'uf' => "RJ", 'codigo' => 3303807],
    		['id' => 3229, 'nome' => "Paty do Alferes", 'uf' => "RJ", 'codigo' => 3303856],
    		['id' => 3230, 'nome' => "Petrópolis", 'uf' => "RJ", 'codigo' => 3303906],
    		['id' => 3231, 'nome' => "Pinheiral", 'uf' => "RJ", 'codigo' => 3303955],
    		['id' => 3232, 'nome' => "Piraí", 'uf' => "RJ", 'codigo' => 3304003],
    		['id' => 3233, 'nome' => "Porciúncula", 'uf' => "RJ", 'codigo' => 3304102],
    		['id' => 3234, 'nome' => "Porto Real", 'uf' => "RJ", 'codigo' => 3304110],
    		['id' => 3235, 'nome' => "Quatis", 'uf' => "RJ", 'codigo' => 3304128],
    		['id' => 3236, 'nome' => "Queimados", 'uf' => "RJ", 'codigo' => 3304144],
    		['id' => 3237, 'nome' => "Quissamã", 'uf' => "RJ", 'codigo' => 3304151],
    		['id' => 3238, 'nome' => "Resende", 'uf' => "RJ", 'codigo' => 3304201],
    		['id' => 3239, 'nome' => "Rio Bonito", 'uf' => "RJ", 'codigo' => 3304300],
    		['id' => 3240, 'nome' => "Rio Claro", 'uf' => "RJ", 'codigo' => 3304409],
    		['id' => 3241, 'nome' => "Rio das Flores", 'uf' => "RJ", 'codigo' => 3304508],
    		['id' => 3242, 'nome' => "Rio das Ostras", 'uf' => "RJ", 'codigo' => 3304524],
    		['id' => 3243, 'nome' => "Rio de Janeiro", 'uf' => "RJ", 'codigo' => 3304557],
    		['id' => 3244, 'nome' => "Santa Maria Madalena", 'uf' => "RJ", 'codigo' => 3304607],
    		['id' => 3245, 'nome' => "Santo Antônio de Pádua", 'uf' => "RJ", 'codigo' => 3304706],
    		['id' => 3246, 'nome' => "São Francisco de Itabapoana", 'uf' => "RJ", 'codigo' => 3304755],
    		['id' => 3247, 'nome' => "São Fidélis", 'uf' => "RJ", 'codigo' => 3304805],
    		['id' => 3248, 'nome' => "São Gonçalo", 'uf' => "RJ", 'codigo' => 3304904],
    		['id' => 3249, 'nome' => "São João da Barra", 'uf' => "RJ", 'codigo' => 3305000],
    		['id' => 3250, 'nome' => "São João de Meriti", 'uf' => "RJ", 'codigo' => 3305109],
    		['id' => 3251, 'nome' => "São José de Ubá", 'uf' => "RJ", 'codigo' => 3305133],
    		['id' => 3252, 'nome' => "São José do Vale do Rio Preto", 'uf' => "RJ", 'codigo' => 3305158],
    		['id' => 3253, 'nome' => "São Pedro da Aldeia", 'uf' => "RJ", 'codigo' => 3305208],
    		['id' => 3254, 'nome' => "São Sebastião do Alto", 'uf' => "RJ", 'codigo' => 3305307],
    		['id' => 3255, 'nome' => "Sapucaia", 'uf' => "RJ", 'codigo' => 3305406],
    		['id' => 3256, 'nome' => "Saquarema", 'uf' => "RJ", 'codigo' => 3305505],
    		['id' => 3257, 'nome' => "Seropédica", 'uf' => "RJ", 'codigo' => 3305554],
    		['id' => 3258, 'nome' => "Silva Jardim", 'uf' => "RJ", 'codigo' => 3305604],
    		['id' => 3259, 'nome' => "Sumidouro", 'uf' => "RJ", 'codigo' => 3305703],
    		['id' => 3260, 'nome' => "Tanguá", 'uf' => "RJ", 'codigo' => 3305752],
    		['id' => 3261, 'nome' => "Teresópolis", 'uf' => "RJ", 'codigo' => 3305802],
    		['id' => 3262, 'nome' => "Trajano de Moraes", 'uf' => "RJ", 'codigo' => 3305901],
    		['id' => 3263, 'nome' => "Três Rios", 'uf' => "RJ", 'codigo' => 3306008],
    		['id' => 3264, 'nome' => "Valença", 'uf' => "RJ", 'codigo' => 3306107],
    		['id' => 3265, 'nome' => "Varre-Sai", 'uf' => "RJ", 'codigo' => 3306156],
    		['id' => 3266, 'nome' => "Vassouras", 'uf' => "RJ", 'codigo' => 3306206],
    		['id' => 3267, 'nome' => "Volta Redonda", 'uf' => "RJ", 'codigo' => 3306305],
    		['id' => 3268, 'nome' => "Adamantina", 'uf' => "SP", 'codigo' => 3500105],
    		['id' => 3269, 'nome' => "Adolfo", 'uf' => "SP", 'codigo' => 3500204],
    		['id' => 3270, 'nome' => "Aguaí", 'uf' => "SP", 'codigo' => 3500303],
    		['id' => 3271, 'nome' => "Águas da Prata", 'uf' => "SP", 'codigo' => 3500402],
    		['id' => 3272, 'nome' => "Águas de Lindóia", 'uf' => "SP", 'codigo' => 3500501],
    		['id' => 3273, 'nome' => "Águas de Santa Bárbara", 'uf' => "SP", 'codigo' => 3500550],
    		['id' => 3274, 'nome' => "Águas de São Pedro", 'uf' => "SP", 'codigo' => 3500600],
    		['id' => 3275, 'nome' => "Agudos", 'uf' => "SP", 'codigo' => 3500709],
    		['id' => 3276, 'nome' => "Alambari", 'uf' => "SP", 'codigo' => 3500758],
    		['id' => 3277, 'nome' => "Alfredo Marcondes", 'uf' => "SP", 'codigo' => 3500808],
    		['id' => 3278, 'nome' => "Altair", 'uf' => "SP", 'codigo' => 3500907],
    		['id' => 3279, 'nome' => "Altinópolis", 'uf' => "SP", 'codigo' => 3501004],
    		['id' => 3280, 'nome' => "Alto Alegre", 'uf' => "SP", 'codigo' => 3501103],
    		['id' => 3281, 'nome' => "Alumínio", 'uf' => "SP", 'codigo' => 3501152],
    		['id' => 3282, 'nome' => "Álvares Florence", 'uf' => "SP", 'codigo' => 3501202],
    		['id' => 3283, 'nome' => "Álvares Machado", 'uf' => "SP", 'codigo' => 3501301],
    		['id' => 3284, 'nome' => "Álvaro de Carvalho", 'uf' => "SP", 'codigo' => 3501400],
    		['id' => 3285, 'nome' => "Alvinlândia", 'uf' => "SP", 'codigo' => 3501509],
    		['id' => 3286, 'nome' => "Americana", 'uf' => "SP", 'codigo' => 3501608],
    		['id' => 3287, 'nome' => "Américo Brasiliense", 'uf' => "SP", 'codigo' => 3501707],
    		['id' => 3288, 'nome' => "Américo de Campos", 'uf' => "SP", 'codigo' => 3501806],
    		['id' => 3289, 'nome' => "Amparo", 'uf' => "SP", 'codigo' => 3501905],
    		['id' => 3290, 'nome' => "Analândia", 'uf' => "SP", 'codigo' => 3502002],
    		['id' => 3291, 'nome' => "Andradina", 'uf' => "SP", 'codigo' => 3502101],
    		['id' => 3292, 'nome' => "Angatuba", 'uf' => "SP", 'codigo' => 3502200],
    		['id' => 3293, 'nome' => "Anhembi", 'uf' => "SP", 'codigo' => 3502309],
    		['id' => 3294, 'nome' => "Anhumas", 'uf' => "SP", 'codigo' => 3502408],
    		['id' => 3295, 'nome' => "Aparecida", 'uf' => "SP", 'codigo' => 3502507],
    		['id' => 3296, 'nome' => "Aparecida D'Oeste", 'uf' => "SP", 'codigo' => 3502606],
    		['id' => 3297, 'nome' => "Apiaí", 'uf' => "SP", 'codigo' => 3502705],
    		['id' => 3298, 'nome' => "Araçariguama", 'uf' => "SP", 'codigo' => 3502754],
    		['id' => 3299, 'nome' => "Araçatuba", 'uf' => "SP", 'codigo' => 3502804],
    		['id' => 3300, 'nome' => "Araçoiaba da Serra", 'uf' => "SP", 'codigo' => 3502903],
    		['id' => 3301, 'nome' => "Aramina", 'uf' => "SP", 'codigo' => 3503000],
    		['id' => 3302, 'nome' => "Arandu", 'uf' => "SP", 'codigo' => 3503109],
    		['id' => 3303, 'nome' => "Arapeí", 'uf' => "SP", 'codigo' => 3503158],
    		['id' => 3304, 'nome' => "Araraquara", 'uf' => "SP", 'codigo' => 3503208],
    		['id' => 3305, 'nome' => "Araras", 'uf' => "SP", 'codigo' => 3503307],
    		['id' => 3306, 'nome' => "Arco-Íris", 'uf' => "SP", 'codigo' => 3503356],
    		['id' => 3307, 'nome' => "Arealva", 'uf' => "SP", 'codigo' => 3503406],
    		['id' => 3308, 'nome' => "Areias", 'uf' => "SP", 'codigo' => 3503505],
    		['id' => 3309, 'nome' => "Areiópolis", 'uf' => "SP", 'codigo' => 3503604],
    		['id' => 3310, 'nome' => "Ariranha", 'uf' => "SP", 'codigo' => 3503703],
    		['id' => 3311, 'nome' => "Artur Nogueira", 'uf' => "SP", 'codigo' => 3503802],
    		['id' => 3312, 'nome' => "Arujá", 'uf' => "SP", 'codigo' => 3503901],
    		['id' => 3313, 'nome' => "Aspásia", 'uf' => "SP", 'codigo' => 3503950],
    		['id' => 3314, 'nome' => "Assis", 'uf' => "SP", 'codigo' => 3504008],
    		['id' => 3315, 'nome' => "Atibaia", 'uf' => "SP", 'codigo' => 3504107],
    		['id' => 3316, 'nome' => "Auriflama", 'uf' => "SP", 'codigo' => 3504206],
    		['id' => 3317, 'nome' => "Avaí", 'uf' => "SP", 'codigo' => 3504305],
    		['id' => 3318, 'nome' => "Avanhandava", 'uf' => "SP", 'codigo' => 3504404],
    		['id' => 3319, 'nome' => "Avaré", 'uf' => "SP", 'codigo' => 3504503],
    		['id' => 3320, 'nome' => "Bady Bassitt", 'uf' => "SP", 'codigo' => 3504602],
    		['id' => 3321, 'nome' => "Balbinos", 'uf' => "SP", 'codigo' => 3504701],
    		['id' => 3322, 'nome' => "Bálsamo", 'uf' => "SP", 'codigo' => 3504800],
    		['id' => 3323, 'nome' => "Bananal", 'uf' => "SP", 'codigo' => 3504909],
    		['id' => 3324, 'nome' => "Barão de Antonina", 'uf' => "SP", 'codigo' => 3505005],
    		['id' => 3325, 'nome' => "Barbosa", 'uf' => "SP", 'codigo' => 3505104],
    		['id' => 3326, 'nome' => "Bariri", 'uf' => "SP", 'codigo' => 3505203],
    		['id' => 3327, 'nome' => "Barra Bonita", 'uf' => "SP", 'codigo' => 3505302],
    		['id' => 3328, 'nome' => "Barra do Chapéu", 'uf' => "SP", 'codigo' => 3505351],
    		['id' => 3329, 'nome' => "Barra do Turvo", 'uf' => "SP", 'codigo' => 3505401],
    		['id' => 3330, 'nome' => "Barretos", 'uf' => "SP", 'codigo' => 3505500],
    		['id' => 3331, 'nome' => "Barrinha", 'uf' => "SP", 'codigo' => 3505609],
    		['id' => 3332, 'nome' => "Barueri", 'uf' => "SP", 'codigo' => 3505708],
    		['id' => 3333, 'nome' => "Bastos", 'uf' => "SP", 'codigo' => 3505807],
    		['id' => 3334, 'nome' => "Batatais", 'uf' => "SP", 'codigo' => 3505906],
    		['id' => 3335, 'nome' => "Bauru", 'uf' => "SP", 'codigo' => 3506003],
    		['id' => 3336, 'nome' => "Bebedouro", 'uf' => "SP", 'codigo' => 3506102],
    		['id' => 3337, 'nome' => "Bento de Abreu", 'uf' => "SP", 'codigo' => 3506201],
    		['id' => 3338, 'nome' => "Bernardino de Campos", 'uf' => "SP", 'codigo' => 3506300],
    		['id' => 3339, 'nome' => "Bertioga", 'uf' => "SP", 'codigo' => 3506359],
    		['id' => 3340, 'nome' => "Bilac", 'uf' => "SP", 'codigo' => 3506409],
    		['id' => 3341, 'nome' => "Birigui", 'uf' => "SP", 'codigo' => 3506508],
    		['id' => 3342, 'nome' => "Biritiba-Mirim", 'uf' => "SP", 'codigo' => 3506607],
    		['id' => 3343, 'nome' => "Boa Esperança do Sul", 'uf' => "SP", 'codigo' => 3506706],
    		['id' => 3344, 'nome' => "Bocaina", 'uf' => "SP", 'codigo' => 3506805],
    		['id' => 3345, 'nome' => "Bofete", 'uf' => "SP", 'codigo' => 3506904],
    		['id' => 3346, 'nome' => "Boituva", 'uf' => "SP", 'codigo' => 3507001],
    		['id' => 3347, 'nome' => "Bom Jesus dos Perdões", 'uf' => "SP", 'codigo' => 3507100],
    		['id' => 3348, 'nome' => "Bom Sucesso de Itararé", 'uf' => "SP", 'codigo' => 3507159],
    		['id' => 3349, 'nome' => "Borá", 'uf' => "SP", 'codigo' => 3507209],
    		['id' => 3350, 'nome' => "Boracéia", 'uf' => "SP", 'codigo' => 3507308],
    		['id' => 3351, 'nome' => "Borborema", 'uf' => "SP", 'codigo' => 3507407],
    		['id' => 3352, 'nome' => "Borebi", 'uf' => "SP", 'codigo' => 3507456],
    		['id' => 3353, 'nome' => "Botucatu", 'uf' => "SP", 'codigo' => 3507506],
    		['id' => 3354, 'nome' => "Bragança Paulista", 'uf' => "SP", 'codigo' => 3507605],
    		['id' => 3355, 'nome' => "Braúna", 'uf' => "SP", 'codigo' => 3507704],
    		['id' => 3356, 'nome' => "Brejo Alegre", 'uf' => "SP", 'codigo' => 3507753],
    		['id' => 3357, 'nome' => "Brodowski", 'uf' => "SP", 'codigo' => 3507803],
    		['id' => 3358, 'nome' => "Brotas", 'uf' => "SP", 'codigo' => 3507902],
    		['id' => 3359, 'nome' => "Buri", 'uf' => "SP", 'codigo' => 3508009],
    		['id' => 3360, 'nome' => "Buritama", 'uf' => "SP", 'codigo' => 3508108],
    		['id' => 3361, 'nome' => "Buritizal", 'uf' => "SP", 'codigo' => 3508207],
    		['id' => 3362, 'nome' => "Cabrália Paulista", 'uf' => "SP", 'codigo' => 3508306],
    		['id' => 3363, 'nome' => "Cabreúva", 'uf' => "SP", 'codigo' => 3508405],
    		['id' => 3364, 'nome' => "Caçapava", 'uf' => "SP", 'codigo' => 3508504],
    		['id' => 3365, 'nome' => "Cachoeira Paulista", 'uf' => "SP", 'codigo' => 3508603],
    		['id' => 3366, 'nome' => "Caconde", 'uf' => "SP", 'codigo' => 3508702],
    		['id' => 3367, 'nome' => "Cafelândia", 'uf' => "SP", 'codigo' => 3508801],
    		['id' => 3368, 'nome' => "Caiabu", 'uf' => "SP", 'codigo' => 3508900],
    		['id' => 3369, 'nome' => "Caieiras", 'uf' => "SP", 'codigo' => 3509007],
    		['id' => 3370, 'nome' => "Caiuá", 'uf' => "SP", 'codigo' => 3509106],
    		['id' => 3371, 'nome' => "Cajamar", 'uf' => "SP", 'codigo' => 3509205],
    		['id' => 3372, 'nome' => "Cajati", 'uf' => "SP", 'codigo' => 3509254],
    		['id' => 3373, 'nome' => "Cajobi", 'uf' => "SP", 'codigo' => 3509304],
    		['id' => 3374, 'nome' => "Cajuru", 'uf' => "SP", 'codigo' => 3509403],
    		['id' => 3375, 'nome' => "Campina do Monte Alegre", 'uf' => "SP", 'codigo' => 3509452],
    		['id' => 3376, 'nome' => "Campinas", 'uf' => "SP", 'codigo' => 3509502],
    		['id' => 3377, 'nome' => "Campo Limpo Paulista", 'uf' => "SP", 'codigo' => 3509601],
    		['id' => 3378, 'nome' => "Campos do Jordão", 'uf' => "SP", 'codigo' => 3509700],
    		['id' => 3379, 'nome' => "Campos Novos Paulista", 'uf' => "SP", 'codigo' => 3509809],
    		['id' => 3380, 'nome' => "Cananéia", 'uf' => "SP", 'codigo' => 3509908],
    		['id' => 3381, 'nome' => "Canas", 'uf' => "SP", 'codigo' => 3509957],
    		['id' => 3382, 'nome' => "Cândido Mota", 'uf' => "SP", 'codigo' => 3510005],
    		['id' => 3383, 'nome' => "Cândido Rodrigues", 'uf' => "SP", 'codigo' => 3510104],
    		['id' => 3384, 'nome' => "Canitar", 'uf' => "SP", 'codigo' => 3510153],
    		['id' => 3385, 'nome' => "Capão Bonito", 'uf' => "SP", 'codigo' => 3510203],
    		['id' => 3386, 'nome' => "Capela do Alto", 'uf' => "SP", 'codigo' => 3510302],
    		['id' => 3387, 'nome' => "Capivari", 'uf' => "SP", 'codigo' => 3510401],
    		['id' => 3388, 'nome' => "Caraguatatuba", 'uf' => "SP", 'codigo' => 3510500],
    		['id' => 3389, 'nome' => "Carapicuíba", 'uf' => "SP", 'codigo' => 3510609],
    		['id' => 3390, 'nome' => "Cardoso", 'uf' => "SP", 'codigo' => 3510708],
    		['id' => 3391, 'nome' => "Casa Branca", 'uf' => "SP", 'codigo' => 3510807],
    		['id' => 3392, 'nome' => "Cássia dos Coqueiros", 'uf' => "SP", 'codigo' => 3510906],
    		['id' => 3393, 'nome' => "Castilho", 'uf' => "SP", 'codigo' => 3511003],
    		['id' => 3394, 'nome' => "Catanduva", 'uf' => "SP", 'codigo' => 3511102],
    		['id' => 3395, 'nome' => "Catiguá", 'uf' => "SP", 'codigo' => 3511201],
    		['id' => 3396, 'nome' => "Cedral", 'uf' => "SP", 'codigo' => 3511300],
    		['id' => 3397, 'nome' => "Cerqueira César", 'uf' => "SP", 'codigo' => 3511409],
    		['id' => 3398, 'nome' => "Cerquilho", 'uf' => "SP", 'codigo' => 3511508],
    		['id' => 3399, 'nome' => "Cesário Lange", 'uf' => "SP", 'codigo' => 3511607],
    		['id' => 3400, 'nome' => "Charqueada", 'uf' => "SP", 'codigo' => 3511706],
    		['id' => 3401, 'nome' => "Clementina", 'uf' => "SP", 'codigo' => 3511904],
    		['id' => 3402, 'nome' => "Colina", 'uf' => "SP", 'codigo' => 3512001],
    		['id' => 3403, 'nome' => "Colômbia", 'uf' => "SP", 'codigo' => 3512100],
    		['id' => 3404, 'nome' => "Conchal", 'uf' => "SP", 'codigo' => 3512209],
    		['id' => 3405, 'nome' => "Conchas", 'uf' => "SP", 'codigo' => 3512308],
    		['id' => 3406, 'nome' => "Cordeirópolis", 'uf' => "SP", 'codigo' => 3512407],
    		['id' => 3407, 'nome' => "Coroados", 'uf' => "SP", 'codigo' => 3512506],
    		['id' => 3408, 'nome' => "Coronel Macedo", 'uf' => "SP", 'codigo' => 3512605],
    		['id' => 3409, 'nome' => "Corumbataí", 'uf' => "SP", 'codigo' => 3512704],
    		['id' => 3410, 'nome' => "Cosmópolis", 'uf' => "SP", 'codigo' => 3512803],
    		['id' => 3411, 'nome' => "Cosmorama", 'uf' => "SP", 'codigo' => 3512902],
    		['id' => 3412, 'nome' => "Cotia", 'uf' => "SP", 'codigo' => 3513009],
    		['id' => 3413, 'nome' => "Cravinhos", 'uf' => "SP", 'codigo' => 3513108],
    		['id' => 3414, 'nome' => "Cristais Paulista", 'uf' => "SP", 'codigo' => 3513207],
    		['id' => 3415, 'nome' => "Cruzália", 'uf' => "SP", 'codigo' => 3513306],
    		['id' => 3416, 'nome' => "Cruzeiro", 'uf' => "SP", 'codigo' => 3513405],
    		['id' => 3417, 'nome' => "Cubatão", 'uf' => "SP", 'codigo' => 3513504],
    		['id' => 3418, 'nome' => "Cunha", 'uf' => "SP", 'codigo' => 3513603],
    		['id' => 3419, 'nome' => "Descalvado", 'uf' => "SP", 'codigo' => 3513702],
    		['id' => 3420, 'nome' => "Diadema", 'uf' => "SP", 'codigo' => 3513801],
    		['id' => 3421, 'nome' => "Dirce Reis", 'uf' => "SP", 'codigo' => 3513850],
    		['id' => 3422, 'nome' => "Divinolândia", 'uf' => "SP", 'codigo' => 3513900],
    		['id' => 3423, 'nome' => "Dobrada", 'uf' => "SP", 'codigo' => 3514007],
    		['id' => 3424, 'nome' => "Dois Córregos", 'uf' => "SP", 'codigo' => 3514106],
    		['id' => 3425, 'nome' => "Dolcinópolis", 'uf' => "SP", 'codigo' => 3514205],
    		['id' => 3426, 'nome' => "Dourado", 'uf' => "SP", 'codigo' => 3514304],
    		['id' => 3427, 'nome' => "Dracena", 'uf' => "SP", 'codigo' => 3514403],
    		['id' => 3428, 'nome' => "Duartina", 'uf' => "SP", 'codigo' => 3514502],
    		['id' => 3429, 'nome' => "Dumont", 'uf' => "SP", 'codigo' => 3514601],
    		['id' => 3430, 'nome' => "Echaporã", 'uf' => "SP", 'codigo' => 3514700],
    		['id' => 3431, 'nome' => "Eldorado", 'uf' => "SP", 'codigo' => 3514809],
    		['id' => 3432, 'nome' => "Elias Fausto", 'uf' => "SP", 'codigo' => 3514908],
    		['id' => 3433, 'nome' => "Elisiário", 'uf' => "SP", 'codigo' => 3514924],
    		['id' => 3434, 'nome' => "Embaúba", 'uf' => "SP", 'codigo' => 3514957],
    		['id' => 3435, 'nome' => "Embu das Artes", 'uf' => "SP", 'codigo' => 3515004],
    		['id' => 3436, 'nome' => "Embu-Guaçu", 'uf' => "SP", 'codigo' => 3515103],
    		['id' => 3437, 'nome' => "Emilianópolis", 'uf' => "SP", 'codigo' => 3515129],
    		['id' => 3438, 'nome' => "Engenheiro Coelho", 'uf' => "SP", 'codigo' => 3515152],
    		['id' => 3439, 'nome' => "Espírito Santo do Pinhal", 'uf' => "SP", 'codigo' => 3515186],
    		['id' => 3440, 'nome' => "Espírito Santo do Turvo", 'uf' => "SP", 'codigo' => 3515194],
    		['id' => 3441, 'nome' => "Estrela D'Oeste", 'uf' => "SP", 'codigo' => 3515202],
    		['id' => 3442, 'nome' => "Estrela do Norte", 'uf' => "SP", 'codigo' => 3515301],
    		['id' => 3443, 'nome' => "Euclides da Cunha Paulista", 'uf' => "SP", 'codigo' => 3515350],
    		['id' => 3444, 'nome' => "Fartura", 'uf' => "SP", 'codigo' => 3515400],
    		['id' => 3445, 'nome' => "Fernandópolis", 'uf' => "SP", 'codigo' => 3515509],
    		['id' => 3446, 'nome' => "Fernando Prestes", 'uf' => "SP", 'codigo' => 3515608],
    		['id' => 3447, 'nome' => "Fernão", 'uf' => "SP", 'codigo' => 3515657],
    		['id' => 3448, 'nome' => "Ferraz de Vasconcelos", 'uf' => "SP", 'codigo' => 3515707],
    		['id' => 3449, 'nome' => "Flora Rica", 'uf' => "SP", 'codigo' => 3515806],
    		['id' => 3450, 'nome' => "Floreal", 'uf' => "SP", 'codigo' => 3515905],
    		['id' => 3451, 'nome' => "Flórida Paulista", 'uf' => "SP", 'codigo' => 3516002],
    		['id' => 3452, 'nome' => "Florínia", 'uf' => "SP", 'codigo' => 3516101],
    		['id' => 3453, 'nome' => "Franca", 'uf' => "SP", 'codigo' => 3516200],
    		['id' => 3454, 'nome' => "Francisco Morato", 'uf' => "SP", 'codigo' => 3516309],
    		['id' => 3455, 'nome' => "Franco da Rocha", 'uf' => "SP", 'codigo' => 3516408],
    		['id' => 3456, 'nome' => "Gabriel Monteiro", 'uf' => "SP", 'codigo' => 3516507],
    		['id' => 3457, 'nome' => "Gália", 'uf' => "SP", 'codigo' => 3516606],
    		['id' => 3458, 'nome' => "Garça", 'uf' => "SP", 'codigo' => 3516705],
    		['id' => 3459, 'nome' => "Gastão Vidigal", 'uf' => "SP", 'codigo' => 3516804],
    		['id' => 3460, 'nome' => "Gavião Peixoto", 'uf' => "SP", 'codigo' => 3516853],
    		['id' => 3461, 'nome' => "General Salgado", 'uf' => "SP", 'codigo' => 3516903],
    		['id' => 3462, 'nome' => "Getulina", 'uf' => "SP", 'codigo' => 3517000],
    		['id' => 3463, 'nome' => "Glicério", 'uf' => "SP", 'codigo' => 3517109],
    		['id' => 3464, 'nome' => "Guaiçara", 'uf' => "SP", 'codigo' => 3517208],
    		['id' => 3465, 'nome' => "Guaimbê", 'uf' => "SP", 'codigo' => 3517307],
    		['id' => 3466, 'nome' => "Guaíra", 'uf' => "SP", 'codigo' => 3517406],
    		['id' => 3467, 'nome' => "Guapiaçu", 'uf' => "SP", 'codigo' => 3517505],
    		['id' => 3468, 'nome' => "Guapiara", 'uf' => "SP", 'codigo' => 3517604],
    		['id' => 3469, 'nome' => "Guará", 'uf' => "SP", 'codigo' => 3517703],
    		['id' => 3470, 'nome' => "Guaraçaí", 'uf' => "SP", 'codigo' => 3517802],
    		['id' => 3471, 'nome' => "Guaraci", 'uf' => "SP", 'codigo' => 3517901],
    		['id' => 3472, 'nome' => "Guarani D'Oeste", 'uf' => "SP", 'codigo' => 3518008],
    		['id' => 3473, 'nome' => "Guarantã", 'uf' => "SP", 'codigo' => 3518107],
    		['id' => 3474, 'nome' => "Guararapes", 'uf' => "SP", 'codigo' => 3518206],
    		['id' => 3475, 'nome' => "Guararema", 'uf' => "SP", 'codigo' => 3518305],
    		['id' => 3476, 'nome' => "Guaratinguetá", 'uf' => "SP", 'codigo' => 3518404],
    		['id' => 3477, 'nome' => "Guareí", 'uf' => "SP", 'codigo' => 3518503],
    		['id' => 3478, 'nome' => "Guariba", 'uf' => "SP", 'codigo' => 3518602],
    		['id' => 3479, 'nome' => "Guarujá", 'uf' => "SP", 'codigo' => 3518701],
    		['id' => 3480, 'nome' => "Guarulhos", 'uf' => "SP", 'codigo' => 3518800],
    		['id' => 3481, 'nome' => "Guatapará", 'uf' => "SP", 'codigo' => 3518859],
    		['id' => 3482, 'nome' => "Guzolândia", 'uf' => "SP", 'codigo' => 3518909],
    		['id' => 3483, 'nome' => "Herculândia", 'uf' => "SP", 'codigo' => 3519006],
    		['id' => 3484, 'nome' => "Holambra", 'uf' => "SP", 'codigo' => 3519055],
    		['id' => 3485, 'nome' => "Hortolândia", 'uf' => "SP", 'codigo' => 3519071],
    		['id' => 3486, 'nome' => "Iacanga", 'uf' => "SP", 'codigo' => 3519105],
    		['id' => 3487, 'nome' => "Iacri", 'uf' => "SP", 'codigo' => 3519204],
    		['id' => 3488, 'nome' => "Iaras", 'uf' => "SP", 'codigo' => 3519253],
    		['id' => 3489, 'nome' => "Ibaté", 'uf' => "SP", 'codigo' => 3519303],
    		['id' => 3490, 'nome' => "Ibirá", 'uf' => "SP", 'codigo' => 3519402],
    		['id' => 3491, 'nome' => "Ibirarema", 'uf' => "SP", 'codigo' => 3519501],
    		['id' => 3492, 'nome' => "Ibitinga", 'uf' => "SP", 'codigo' => 3519600],
    		['id' => 3493, 'nome' => "Ibiúna", 'uf' => "SP", 'codigo' => 3519709],
    		['id' => 3494, 'nome' => "Icém", 'uf' => "SP", 'codigo' => 3519808],
    		['id' => 3495, 'nome' => "Iepê", 'uf' => "SP", 'codigo' => 3519907],
    		['id' => 3496, 'nome' => "Igaraçu do Tietê", 'uf' => "SP", 'codigo' => 3520004],
    		['id' => 3497, 'nome' => "Igarapava", 'uf' => "SP", 'codigo' => 3520103],
    		['id' => 3498, 'nome' => "Igaratá", 'uf' => "SP", 'codigo' => 3520202],
    		['id' => 3499, 'nome' => "Iguape", 'uf' => "SP", 'codigo' => 3520301],
    		['id' => 3500, 'nome' => "Ilhabela", 'uf' => "SP", 'codigo' => 3520400],
    		['id' => 3501, 'nome' => "Ilha Comprida", 'uf' => "SP", 'codigo' => 3520426],
    		['id' => 3502, 'nome' => "Ilha Solteira", 'uf' => "SP", 'codigo' => 3520442],
    		['id' => 3503, 'nome' => "Indaiatuba", 'uf' => "SP", 'codigo' => 3520509],
    		['id' => 3504, 'nome' => "Indiana", 'uf' => "SP", 'codigo' => 3520608],
    		['id' => 3505, 'nome' => "Indiaporã", 'uf' => "SP", 'codigo' => 3520707],
    		['id' => 3506, 'nome' => "Inúbia Paulista", 'uf' => "SP", 'codigo' => 3520806],
    		['id' => 3507, 'nome' => "Ipaussu", 'uf' => "SP", 'codigo' => 3520905],
    		['id' => 3508, 'nome' => "Iperó", 'uf' => "SP", 'codigo' => 3521002],
    		['id' => 3509, 'nome' => "Ipeúna", 'uf' => "SP", 'codigo' => 3521101],
    		['id' => 3510, 'nome' => "Ipiguá", 'uf' => "SP", 'codigo' => 3521150],
    		['id' => 3511, 'nome' => "Iporanga", 'uf' => "SP", 'codigo' => 3521200],
    		['id' => 3512, 'nome' => "Ipuã", 'uf' => "SP", 'codigo' => 3521309],
    		['id' => 3513, 'nome' => "Iracemápolis", 'uf' => "SP", 'codigo' => 3521408],
    		['id' => 3514, 'nome' => "Irapuã", 'uf' => "SP", 'codigo' => 3521507],
    		['id' => 3515, 'nome' => "Irapuru", 'uf' => "SP", 'codigo' => 3521606],
    		['id' => 3516, 'nome' => "Itaberá", 'uf' => "SP", 'codigo' => 3521705],
    		['id' => 3517, 'nome' => "Itaí", 'uf' => "SP", 'codigo' => 3521804],
    		['id' => 3518, 'nome' => "Itajobi", 'uf' => "SP", 'codigo' => 3521903],
    		['id' => 3519, 'nome' => "Itaju", 'uf' => "SP", 'codigo' => 3522000],
    		['id' => 3520, 'nome' => "Itanhaém", 'uf' => "SP", 'codigo' => 3522109],
    		['id' => 3521, 'nome' => "Itaóca", 'uf' => "SP", 'codigo' => 3522158],
    		['id' => 3522, 'nome' => "Itapecerica da Serra", 'uf' => "SP", 'codigo' => 3522208],
    		['id' => 3523, 'nome' => "Itapetininga", 'uf' => "SP", 'codigo' => 3522307],
    		['id' => 3524, 'nome' => "Itapeva", 'uf' => "SP", 'codigo' => 3522406],
    		['id' => 3525, 'nome' => "Itapevi", 'uf' => "SP", 'codigo' => 3522505],
    		['id' => 3526, 'nome' => "Itapira", 'uf' => "SP", 'codigo' => 3522604],
    		['id' => 3527, 'nome' => "Itapirapuã Paulista", 'uf' => "SP", 'codigo' => 3522653],
    		['id' => 3528, 'nome' => "Itápolis", 'uf' => "SP", 'codigo' => 3522703],
    		['id' => 3529, 'nome' => "Itaporanga", 'uf' => "SP", 'codigo' => 3522802],
    		['id' => 3530, 'nome' => "Itapuí", 'uf' => "SP", 'codigo' => 3522901],
    		['id' => 3531, 'nome' => "Itapura", 'uf' => "SP", 'codigo' => 3523008],
    		['id' => 3532, 'nome' => "Itaquaquecetuba", 'uf' => "SP", 'codigo' => 3523107],
    		['id' => 3533, 'nome' => "Itararé", 'uf' => "SP", 'codigo' => 3523206],
    		['id' => 3534, 'nome' => "Itariri", 'uf' => "SP", 'codigo' => 3523305],
    		['id' => 3535, 'nome' => "Itatiba", 'uf' => "SP", 'codigo' => 3523404],
    		['id' => 3536, 'nome' => "Itatinga", 'uf' => "SP", 'codigo' => 3523503],
    		['id' => 3537, 'nome' => "Itirapina", 'uf' => "SP", 'codigo' => 3523602],
    		['id' => 3538, 'nome' => "Itirapuã", 'uf' => "SP", 'codigo' => 3523701],
    		['id' => 3539, 'nome' => "Itobi", 'uf' => "SP", 'codigo' => 3523800],
    		['id' => 3540, 'nome' => "Itu", 'uf' => "SP", 'codigo' => 3523909],
    		['id' => 3541, 'nome' => "Itupeva", 'uf' => "SP", 'codigo' => 3524006],
    		['id' => 3542, 'nome' => "Ituverava", 'uf' => "SP", 'codigo' => 3524105],
    		['id' => 3543, 'nome' => "Jaborandi", 'uf' => "SP", 'codigo' => 3524204],
    		['id' => 3544, 'nome' => "Jaboticabal", 'uf' => "SP", 'codigo' => 3524303],
    		['id' => 3545, 'nome' => "Jacareí", 'uf' => "SP", 'codigo' => 3524402],
    		['id' => 3546, 'nome' => "Jaci", 'uf' => "SP", 'codigo' => 3524501],
    		['id' => 3547, 'nome' => "Jacupiranga", 'uf' => "SP", 'codigo' => 3524600],
    		['id' => 3548, 'nome' => "Jaguariúna", 'uf' => "SP", 'codigo' => 3524709],
    		['id' => 3549, 'nome' => "Jales", 'uf' => "SP", 'codigo' => 3524808],
    		['id' => 3550, 'nome' => "Jambeiro", 'uf' => "SP", 'codigo' => 3524907],
    		['id' => 3551, 'nome' => "Jandira", 'uf' => "SP", 'codigo' => 3525003],
    		['id' => 3552, 'nome' => "Jardinópolis", 'uf' => "SP", 'codigo' => 3525102],
    		['id' => 3553, 'nome' => "Jarinu", 'uf' => "SP", 'codigo' => 3525201],
    		['id' => 3554, 'nome' => "Jaú", 'uf' => "SP", 'codigo' => 3525300],
    		['id' => 3555, 'nome' => "Jeriquara", 'uf' => "SP", 'codigo' => 3525409],
    		['id' => 3556, 'nome' => "Joanópolis", 'uf' => "SP", 'codigo' => 3525508],
    		['id' => 3557, 'nome' => "João Ramalho", 'uf' => "SP", 'codigo' => 3525607],
    		['id' => 3558, 'nome' => "José Bonifácio", 'uf' => "SP", 'codigo' => 3525706],
    		['id' => 3559, 'nome' => "Júlio Mesquita", 'uf' => "SP", 'codigo' => 3525805],
    		['id' => 3560, 'nome' => "Jumirim", 'uf' => "SP", 'codigo' => 3525854],
    		['id' => 3561, 'nome' => "Jundiaí", 'uf' => "SP", 'codigo' => 3525904],
    		['id' => 3562, 'nome' => "Junqueirópolis", 'uf' => "SP", 'codigo' => 3526001],
    		['id' => 3563, 'nome' => "Juquiá", 'uf' => "SP", 'codigo' => 3526100],
    		['id' => 3564, 'nome' => "Juquitiba", 'uf' => "SP", 'codigo' => 3526209],
    		['id' => 3565, 'nome' => "Lagoinha", 'uf' => "SP", 'codigo' => 3526308],
    		['id' => 3566, 'nome' => "Laranjal Paulista", 'uf' => "SP", 'codigo' => 3526407],
    		['id' => 3567, 'nome' => "Lavínia", 'uf' => "SP", 'codigo' => 3526506],
    		['id' => 3568, 'nome' => "Lavrinhas", 'uf' => "SP", 'codigo' => 3526605],
    		['id' => 3569, 'nome' => "Leme", 'uf' => "SP", 'codigo' => 3526704],
    		['id' => 3570, 'nome' => "Lençóis Paulista", 'uf' => "SP", 'codigo' => 3526803],
    		['id' => 3571, 'nome' => "Limeira", 'uf' => "SP", 'codigo' => 3526902],
    		['id' => 3572, 'nome' => "Lindóia", 'uf' => "SP", 'codigo' => 3527009],
    		['id' => 3573, 'nome' => "Lins", 'uf' => "SP", 'codigo' => 3527108],
    		['id' => 3574, 'nome' => "Lorena", 'uf' => "SP", 'codigo' => 3527207],
    		['id' => 3575, 'nome' => "Lourdes", 'uf' => "SP", 'codigo' => 3527256],
    		['id' => 3576, 'nome' => "Louveira", 'uf' => "SP", 'codigo' => 3527306],
    		['id' => 3577, 'nome' => "Lucélia", 'uf' => "SP", 'codigo' => 3527405],
    		['id' => 3578, 'nome' => "Lucianópolis", 'uf' => "SP", 'codigo' => 3527504],
    		['id' => 3579, 'nome' => "Luís Antônio", 'uf' => "SP", 'codigo' => 3527603],
    		['id' => 3580, 'nome' => "Luiziânia", 'uf' => "SP", 'codigo' => 3527702],
    		['id' => 3581, 'nome' => "Lupércio", 'uf' => "SP", 'codigo' => 3527801],
    		['id' => 3582, 'nome' => "Lutécia", 'uf' => "SP", 'codigo' => 3527900],
    		['id' => 3583, 'nome' => "Macatuba", 'uf' => "SP", 'codigo' => 3528007],
    		['id' => 3584, 'nome' => "Macaubal", 'uf' => "SP", 'codigo' => 3528106],
    		['id' => 3585, 'nome' => "Macedônia", 'uf' => "SP", 'codigo' => 3528205],
    		['id' => 3586, 'nome' => "Magda", 'uf' => "SP", 'codigo' => 3528304],
    		['id' => 3587, 'nome' => "Mairinque", 'uf' => "SP", 'codigo' => 3528403],
    		['id' => 3588, 'nome' => "Mairiporã", 'uf' => "SP", 'codigo' => 3528502],
    		['id' => 3589, 'nome' => "Manduri", 'uf' => "SP", 'codigo' => 3528601],
    		['id' => 3590, 'nome' => "Marabá Paulista", 'uf' => "SP", 'codigo' => 3528700],
    		['id' => 3591, 'nome' => "Maracaí", 'uf' => "SP", 'codigo' => 3528809],
    		['id' => 3592, 'nome' => "Marapoama", 'uf' => "SP", 'codigo' => 3528858],
    		['id' => 3593, 'nome' => "Mariápolis", 'uf' => "SP", 'codigo' => 3528908],
    		['id' => 3594, 'nome' => "Marília", 'uf' => "SP", 'codigo' => 3529005],
    		['id' => 3595, 'nome' => "Marinópolis", 'uf' => "SP", 'codigo' => 3529104],
    		['id' => 3596, 'nome' => "Martinópolis", 'uf' => "SP", 'codigo' => 3529203],
    		['id' => 3597, 'nome' => "Matão", 'uf' => "SP", 'codigo' => 3529302],
    		['id' => 3598, 'nome' => "Mauá", 'uf' => "SP", 'codigo' => 3529401],
    		['id' => 3599, 'nome' => "Mendonça", 'uf' => "SP", 'codigo' => 3529500],
    		['id' => 3600, 'nome' => "Meridiano", 'uf' => "SP", 'codigo' => 3529609],
    		['id' => 3601, 'nome' => "Mesópolis", 'uf' => "SP", 'codigo' => 3529658],
    		['id' => 3602, 'nome' => "Miguelópolis", 'uf' => "SP", 'codigo' => 3529708],
    		['id' => 3603, 'nome' => "Mineiros do Tietê", 'uf' => "SP", 'codigo' => 3529807],
    		['id' => 3604, 'nome' => "Miracatu", 'uf' => "SP", 'codigo' => 3529906],
    		['id' => 3605, 'nome' => "Mira Estrela", 'uf' => "SP", 'codigo' => 3530003],
    		['id' => 3606, 'nome' => "Mirandópolis", 'uf' => "SP", 'codigo' => 3530102],
    		['id' => 3607, 'nome' => "Mirante do Paranapanema", 'uf' => "SP", 'codigo' => 3530201],
    		['id' => 3608, 'nome' => "Mirassol", 'uf' => "SP", 'codigo' => 3530300],
    		['id' => 3609, 'nome' => "Mirassolândia", 'uf' => "SP", 'codigo' => 3530409],
    		['id' => 3610, 'nome' => "Mococa", 'uf' => "SP", 'codigo' => 3530508],
    		['id' => 3611, 'nome' => "Mogi das Cruzes", 'uf' => "SP", 'codigo' => 3530607],
    		['id' => 3612, 'nome' => "Mogi Guaçu", 'uf' => "SP", 'codigo' => 3530706],
    		['id' => 3613, 'nome' => "Moji Mirim", 'uf' => "SP", 'codigo' => 3530805],
    		['id' => 3614, 'nome' => "Mombuca", 'uf' => "SP", 'codigo' => 3530904],
    		['id' => 3615, 'nome' => "Monções", 'uf' => "SP", 'codigo' => 3531001],
    		['id' => 3616, 'nome' => "Mongaguá", 'uf' => "SP", 'codigo' => 3531100],
    		['id' => 3617, 'nome' => "Monte Alegre do Sul", 'uf' => "SP", 'codigo' => 3531209],
    		['id' => 3618, 'nome' => "Monte Alto", 'uf' => "SP", 'codigo' => 3531308],
    		['id' => 3619, 'nome' => "Monte Aprazível", 'uf' => "SP", 'codigo' => 3531407],
    		['id' => 3620, 'nome' => "Monte Azul Paulista", 'uf' => "SP", 'codigo' => 3531506],
    		['id' => 3621, 'nome' => "Monte Castelo", 'uf' => "SP", 'codigo' => 3531605],
    		['id' => 3622, 'nome' => "Monteiro Lobato", 'uf' => "SP", 'codigo' => 3531704],
    		['id' => 3623, 'nome' => "Monte Mor", 'uf' => "SP", 'codigo' => 3531803],
    		['id' => 3624, 'nome' => "Morro Agudo", 'uf' => "SP", 'codigo' => 3531902],
    		['id' => 3625, 'nome' => "Morungaba", 'uf' => "SP", 'codigo' => 3532009],
    		['id' => 3626, 'nome' => "Motuca", 'uf' => "SP", 'codigo' => 3532058],
    		['id' => 3627, 'nome' => "Murutinga do Sul", 'uf' => "SP", 'codigo' => 3532108],
    		['id' => 3628, 'nome' => "Nantes", 'uf' => "SP", 'codigo' => 3532157],
    		['id' => 3629, 'nome' => "Narandiba", 'uf' => "SP", 'codigo' => 3532207],
    		['id' => 3630, 'nome' => "Natividade da Serra", 'uf' => "SP", 'codigo' => 3532306],
    		['id' => 3631, 'nome' => "Nazaré Paulista", 'uf' => "SP", 'codigo' => 3532405],
    		['id' => 3632, 'nome' => "Neves Paulista", 'uf' => "SP", 'codigo' => 3532504],
    		['id' => 3633, 'nome' => "Nhandeara", 'uf' => "SP", 'codigo' => 3532603],
    		['id' => 3634, 'nome' => "Nipoã", 'uf' => "SP", 'codigo' => 3532702],
    		['id' => 3635, 'nome' => "Nova Aliança", 'uf' => "SP", 'codigo' => 3532801],
    		['id' => 3636, 'nome' => "Nova Campina", 'uf' => "SP", 'codigo' => 3532827],
    		['id' => 3637, 'nome' => "Nova Canaã Paulista", 'uf' => "SP", 'codigo' => 3532843],
    		['id' => 3638, 'nome' => "Nova Castilho", 'uf' => "SP", 'codigo' => 3532868],
    		['id' => 3639, 'nome' => "Nova Europa", 'uf' => "SP", 'codigo' => 3532900],
    		['id' => 3640, 'nome' => "Nova Granada", 'uf' => "SP", 'codigo' => 3533007],
    		['id' => 3641, 'nome' => "Nova Guataporanga", 'uf' => "SP", 'codigo' => 3533106],
    		['id' => 3642, 'nome' => "Nova Independência", 'uf' => "SP", 'codigo' => 3533205],
    		['id' => 3643, 'nome' => "Novais", 'uf' => "SP", 'codigo' => 3533254],
    		['id' => 3644, 'nome' => "Nova Luzitânia", 'uf' => "SP", 'codigo' => 3533304],
    		['id' => 3645, 'nome' => "Nova Odessa", 'uf' => "SP", 'codigo' => 3533403],
    		['id' => 3646, 'nome' => "Novo Horizonte", 'uf' => "SP", 'codigo' => 3533502],
    		['id' => 3647, 'nome' => "Nuporanga", 'uf' => "SP", 'codigo' => 3533601],
    		['id' => 3648, 'nome' => "Ocauçu", 'uf' => "SP", 'codigo' => 3533700],
    		['id' => 3649, 'nome' => "Óleo", 'uf' => "SP", 'codigo' => 3533809],
    		['id' => 3650, 'nome' => "Olímpia", 'uf' => "SP", 'codigo' => 3533908],
    		['id' => 3651, 'nome' => "Onda Verde", 'uf' => "SP", 'codigo' => 3534005],
    		['id' => 3652, 'nome' => "Oriente", 'uf' => "SP", 'codigo' => 3534104],
    		['id' => 3653, 'nome' => "Orindiúva", 'uf' => "SP", 'codigo' => 3534203],
    		['id' => 3654, 'nome' => "Orlândia", 'uf' => "SP", 'codigo' => 3534302],
    		['id' => 3655, 'nome' => "Osasco", 'uf' => "SP", 'codigo' => 3534401],
    		['id' => 3656, 'nome' => "Oscar Bressane", 'uf' => "SP", 'codigo' => 3534500],
    		['id' => 3657, 'nome' => "Osvaldo Cruz", 'uf' => "SP", 'codigo' => 3534609],
    		['id' => 3658, 'nome' => "Ourinhos", 'uf' => "SP", 'codigo' => 3534708],
    		['id' => 3659, 'nome' => "Ouroeste", 'uf' => "SP", 'codigo' => 3534757],
    		['id' => 3660, 'nome' => "Ouro Verde", 'uf' => "SP", 'codigo' => 3534807],
    		['id' => 3661, 'nome' => "Pacaembu", 'uf' => "SP", 'codigo' => 3534906],
    		['id' => 3662, 'nome' => "Palestina", 'uf' => "SP", 'codigo' => 3535002],
    		['id' => 3663, 'nome' => "Palmares Paulista", 'uf' => "SP", 'codigo' => 3535101],
    		['id' => 3664, 'nome' => "Palmeira D'Oeste", 'uf' => "SP", 'codigo' => 3535200],
    		['id' => 3665, 'nome' => "Palmital", 'uf' => "SP", 'codigo' => 3535309],
    		['id' => 3666, 'nome' => "Panorama", 'uf' => "SP", 'codigo' => 3535408],
    		['id' => 3667, 'nome' => "Paraguaçu Paulista", 'uf' => "SP", 'codigo' => 3535507],
    		['id' => 3668, 'nome' => "Paraibuna", 'uf' => "SP", 'codigo' => 3535606],
    		['id' => 3669, 'nome' => "Paraíso", 'uf' => "SP", 'codigo' => 3535705],
    		['id' => 3670, 'nome' => "Paranapanema", 'uf' => "SP", 'codigo' => 3535804],
    		['id' => 3671, 'nome' => "Paranapuã", 'uf' => "SP", 'codigo' => 3535903],
    		['id' => 3672, 'nome' => "Parapuã", 'uf' => "SP", 'codigo' => 3536000],
    		['id' => 3673, 'nome' => "Pardinho", 'uf' => "SP", 'codigo' => 3536109],
    		['id' => 3674, 'nome' => "Pariquera-Açu", 'uf' => "SP", 'codigo' => 3536208],
    		['id' => 3675, 'nome' => "Parisi", 'uf' => "SP", 'codigo' => 3536257],
    		['id' => 3676, 'nome' => "Patrocínio Paulista", 'uf' => "SP", 'codigo' => 3536307],
    		['id' => 3677, 'nome' => "Paulicéia", 'uf' => "SP", 'codigo' => 3536406],
    		['id' => 3678, 'nome' => "Paulínia", 'uf' => "SP", 'codigo' => 3536505],
    		['id' => 3679, 'nome' => "Paulistânia", 'uf' => "SP", 'codigo' => 3536570],
    		['id' => 3680, 'nome' => "Paulo de Faria", 'uf' => "SP", 'codigo' => 3536604],
    		['id' => 3681, 'nome' => "Pederneiras", 'uf' => "SP", 'codigo' => 3536703],
    		['id' => 3682, 'nome' => "Pedra Bela", 'uf' => "SP", 'codigo' => 3536802],
    		['id' => 3683, 'nome' => "Pedranópolis", 'uf' => "SP", 'codigo' => 3536901],
    		['id' => 3684, 'nome' => "Pedregulho", 'uf' => "SP", 'codigo' => 3537008],
    		['id' => 3685, 'nome' => "Pedreira", 'uf' => "SP", 'codigo' => 3537107],
    		['id' => 3686, 'nome' => "Pedrinhas Paulista", 'uf' => "SP", 'codigo' => 3537156],
    		['id' => 3687, 'nome' => "Pedro de Toledo", 'uf' => "SP", 'codigo' => 3537206],
    		['id' => 3688, 'nome' => "Penápolis", 'uf' => "SP", 'codigo' => 3537305],
    		['id' => 3689, 'nome' => "Pereira Barreto", 'uf' => "SP", 'codigo' => 3537404],
    		['id' => 3690, 'nome' => "Pereiras", 'uf' => "SP", 'codigo' => 3537503],
    		['id' => 3691, 'nome' => "Peruíbe", 'uf' => "SP", 'codigo' => 3537602],
    		['id' => 3692, 'nome' => "Piacatu", 'uf' => "SP", 'codigo' => 3537701],
    		['id' => 3693, 'nome' => "Piedade", 'uf' => "SP", 'codigo' => 3537800],
    		['id' => 3694, 'nome' => "Pilar do Sul", 'uf' => "SP", 'codigo' => 3537909],
    		['id' => 3695, 'nome' => "Pindamonhangaba", 'uf' => "SP", 'codigo' => 3538006],
    		['id' => 3696, 'nome' => "Pindorama", 'uf' => "SP", 'codigo' => 3538105],
    		['id' => 3697, 'nome' => "Pinhalzinho", 'uf' => "SP", 'codigo' => 3538204],
    		['id' => 3698, 'nome' => "Piquerobi", 'uf' => "SP", 'codigo' => 3538303],
    		['id' => 3699, 'nome' => "Piquete", 'uf' => "SP", 'codigo' => 3538501],
    		['id' => 3700, 'nome' => "Piracaia", 'uf' => "SP", 'codigo' => 3538600],
    		['id' => 3701, 'nome' => "Piracicaba", 'uf' => "SP", 'codigo' => 3538709],
    		['id' => 3702, 'nome' => "Piraju", 'uf' => "SP", 'codigo' => 3538808],
    		['id' => 3703, 'nome' => "Pirajuí", 'uf' => "SP", 'codigo' => 3538907],
    		['id' => 3704, 'nome' => "Pirangi", 'uf' => "SP", 'codigo' => 3539004],
    		['id' => 3705, 'nome' => "Pirapora do Bom Jesus", 'uf' => "SP", 'codigo' => 3539103],
    		['id' => 3706, 'nome' => "Pirapozinho", 'uf' => "SP", 'codigo' => 3539202],
    		['id' => 3707, 'nome' => "Pirassununga", 'uf' => "SP", 'codigo' => 3539301],
    		['id' => 3708, 'nome' => "Piratininga", 'uf' => "SP", 'codigo' => 3539400],
    		['id' => 3709, 'nome' => "Pitangueiras", 'uf' => "SP", 'codigo' => 3539509],
    		['id' => 3710, 'nome' => "Planalto", 'uf' => "SP", 'codigo' => 3539608],
    		['id' => 3711, 'nome' => "Platina", 'uf' => "SP", 'codigo' => 3539707],
    		['id' => 3712, 'nome' => "Poá", 'uf' => "SP", 'codigo' => 3539806],
    		['id' => 3713, 'nome' => "Poloni", 'uf' => "SP", 'codigo' => 3539905],
    		['id' => 3714, 'nome' => "Pompéia", 'uf' => "SP", 'codigo' => 3540002],
    		['id' => 3715, 'nome' => "Pongaí", 'uf' => "SP", 'codigo' => 3540101],
    		['id' => 3716, 'nome' => "Pontal", 'uf' => "SP", 'codigo' => 3540200],
    		['id' => 3717, 'nome' => "Pontalinda", 'uf' => "SP", 'codigo' => 3540259],
    		['id' => 3718, 'nome' => "Pontes Gestal", 'uf' => "SP", 'codigo' => 3540309],
    		['id' => 3719, 'nome' => "Populina", 'uf' => "SP", 'codigo' => 3540408],
    		['id' => 3720, 'nome' => "Porangaba", 'uf' => "SP", 'codigo' => 3540507],
    		['id' => 3721, 'nome' => "Porto Feliz", 'uf' => "SP", 'codigo' => 3540606],
    		['id' => 3722, 'nome' => "Porto Ferreira", 'uf' => "SP", 'codigo' => 3540705],
    		['id' => 3723, 'nome' => "Potim", 'uf' => "SP", 'codigo' => 3540754],
    		['id' => 3724, 'nome' => "Potirendaba", 'uf' => "SP", 'codigo' => 3540804],
    		['id' => 3725, 'nome' => "Pracinha", 'uf' => "SP", 'codigo' => 3540853],
    		['id' => 3726, 'nome' => "Pradópolis", 'uf' => "SP", 'codigo' => 3540903],
    		['id' => 3727, 'nome' => "Praia Grande", 'uf' => "SP", 'codigo' => 3541000],
    		['id' => 3728, 'nome' => "Pratânia", 'uf' => "SP", 'codigo' => 3541059],
    		['id' => 3729, 'nome' => "Presidente Alves", 'uf' => "SP", 'codigo' => 3541109],
    		['id' => 3730, 'nome' => "Presidente Bernardes", 'uf' => "SP", 'codigo' => 3541208],
    		['id' => 3731, 'nome' => "Presidente Epitácio", 'uf' => "SP", 'codigo' => 3541307],
    		['id' => 3732, 'nome' => "Presidente Prudente", 'uf' => "SP", 'codigo' => 3541406],
    		['id' => 3733, 'nome' => "Presidente Venceslau", 'uf' => "SP", 'codigo' => 3541505],
    		['id' => 3734, 'nome' => "Promissão", 'uf' => "SP", 'codigo' => 3541604],
    		['id' => 3735, 'nome' => "Quadra", 'uf' => "SP", 'codigo' => 3541653],
    		['id' => 3736, 'nome' => "Quatá", 'uf' => "SP", 'codigo' => 3541703],
    		['id' => 3737, 'nome' => "Queiroz", 'uf' => "SP", 'codigo' => 3541802],
    		['id' => 3738, 'nome' => "Queluz", 'uf' => "SP", 'codigo' => 3541901],
    		['id' => 3739, 'nome' => "Quintana", 'uf' => "SP", 'codigo' => 3542008],
    		['id' => 3740, 'nome' => "Rafard", 'uf' => "SP", 'codigo' => 3542107],
    		['id' => 3741, 'nome' => "Rancharia", 'uf' => "SP", 'codigo' => 3542206],
    		['id' => 3742, 'nome' => "Redenção da Serra", 'uf' => "SP", 'codigo' => 3542305],
    		['id' => 3743, 'nome' => "Regente Feijó", 'uf' => "SP", 'codigo' => 3542404],
    		['id' => 3744, 'nome' => "Reginópolis", 'uf' => "SP", 'codigo' => 3542503],
    		['id' => 3745, 'nome' => "Registro", 'uf' => "SP", 'codigo' => 3542602],
    		['id' => 3746, 'nome' => "Restinga", 'uf' => "SP", 'codigo' => 3542701],
    		['id' => 3747, 'nome' => "Ribeira", 'uf' => "SP", 'codigo' => 3542800],
    		['id' => 3748, 'nome' => "Ribeirão Bonito", 'uf' => "SP", 'codigo' => 3542909],
    		['id' => 3749, 'nome' => "Ribeirão Branco", 'uf' => "SP", 'codigo' => 3543006],
    		['id' => 3750, 'nome' => "Ribeirão Corrente", 'uf' => "SP", 'codigo' => 3543105],
    		['id' => 3751, 'nome' => "Ribeirão do Sul", 'uf' => "SP", 'codigo' => 3543204],
    		['id' => 3752, 'nome' => "Ribeirão dos Índios", 'uf' => "SP", 'codigo' => 3543238],
    		['id' => 3753, 'nome' => "Ribeirão Grande", 'uf' => "SP", 'codigo' => 3543253],
    		['id' => 3754, 'nome' => "Ribeirão Pires", 'uf' => "SP", 'codigo' => 3543303],
    		['id' => 3755, 'nome' => "Ribeirão Preto", 'uf' => "SP", 'codigo' => 3543402],
    		['id' => 3756, 'nome' => "Riversul", 'uf' => "SP", 'codigo' => 3543501],
    		['id' => 3757, 'nome' => "Rifaina", 'uf' => "SP", 'codigo' => 3543600],
    		['id' => 3758, 'nome' => "Rincão", 'uf' => "SP", 'codigo' => 3543709],
    		['id' => 3759, 'nome' => "Rinópolis", 'uf' => "SP", 'codigo' => 3543808],
    		['id' => 3760, 'nome' => "Rio Claro", 'uf' => "SP", 'codigo' => 3543907],
    		['id' => 3761, 'nome' => "Rio das Pedras", 'uf' => "SP", 'codigo' => 3544004],
    		['id' => 3762, 'nome' => "Rio Grande da Serra", 'uf' => "SP", 'codigo' => 3544103],
    		['id' => 3763, 'nome' => "Riolândia", 'uf' => "SP", 'codigo' => 3544202],
    		['id' => 3764, 'nome' => "Rosana", 'uf' => "SP", 'codigo' => 3544251],
    		['id' => 3765, 'nome' => "Roseira", 'uf' => "SP", 'codigo' => 3544301],
    		['id' => 3766, 'nome' => "Rubiácea", 'uf' => "SP", 'codigo' => 3544400],
    		['id' => 3767, 'nome' => "Rubinéia", 'uf' => "SP", 'codigo' => 3544509],
    		['id' => 3768, 'nome' => "Sabino", 'uf' => "SP", 'codigo' => 3544608],
    		['id' => 3769, 'nome' => "Sagres", 'uf' => "SP", 'codigo' => 3544707],
    		['id' => 3770, 'nome' => "Sales", 'uf' => "SP", 'codigo' => 3544806],
    		['id' => 3771, 'nome' => "Sales Oliveira", 'uf' => "SP", 'codigo' => 3544905],
    		['id' => 3772, 'nome' => "Salesópolis", 'uf' => "SP", 'codigo' => 3545001],
    		['id' => 3773, 'nome' => "Salmourão", 'uf' => "SP", 'codigo' => 3545100],
    		['id' => 3774, 'nome' => "Saltinho", 'uf' => "SP", 'codigo' => 3545159],
    		['id' => 3775, 'nome' => "Salto", 'uf' => "SP", 'codigo' => 3545209],
    		['id' => 3776, 'nome' => "Salto de Pirapora", 'uf' => "SP", 'codigo' => 3545308],
    		['id' => 3777, 'nome' => "Salto Grande", 'uf' => "SP", 'codigo' => 3545407],
    		['id' => 3778, 'nome' => "Sandovalina", 'uf' => "SP", 'codigo' => 3545506],
    		['id' => 3779, 'nome' => "Santa Adélia", 'uf' => "SP", 'codigo' => 3545605],
    		['id' => 3780, 'nome' => "Santa Albertina", 'uf' => "SP", 'codigo' => 3545704],
    		['id' => 3781, 'nome' => "Santa Bárbara D'Oeste", 'uf' => "SP", 'codigo' => 3545803],
    		['id' => 3782, 'nome' => "Santa Branca", 'uf' => "SP", 'codigo' => 3546009],
    		['id' => 3783, 'nome' => "Santa Clara D'Oeste", 'uf' => "SP", 'codigo' => 3546108],
    		['id' => 3784, 'nome' => "Santa Cruz da Conceição", 'uf' => "SP", 'codigo' => 3546207],
    		['id' => 3785, 'nome' => "Santa Cruz da Esperança", 'uf' => "SP", 'codigo' => 3546256],
    		['id' => 3786, 'nome' => "Santa Cruz das Palmeiras", 'uf' => "SP", 'codigo' => 3546306],
    		['id' => 3787, 'nome' => "Santa Cruz do Rio Pardo", 'uf' => "SP", 'codigo' => 3546405],
    		['id' => 3788, 'nome' => "Santa Ernestina", 'uf' => "SP", 'codigo' => 3546504],
    		['id' => 3789, 'nome' => "Santa Fé do Sul", 'uf' => "SP", 'codigo' => 3546603],
    		['id' => 3790, 'nome' => "Santa Gertrudes", 'uf' => "SP", 'codigo' => 3546702],
    		['id' => 3791, 'nome' => "Santa Isabel", 'uf' => "SP", 'codigo' => 3546801],
    		['id' => 3792, 'nome' => "Santa Lúcia", 'uf' => "SP", 'codigo' => 3546900],
    		['id' => 3793, 'nome' => "Santa Maria da Serra", 'uf' => "SP", 'codigo' => 3547007],
    		['id' => 3794, 'nome' => "Santa Mercedes", 'uf' => "SP", 'codigo' => 3547106],
    		['id' => 3795, 'nome' => "Santana da Ponte Pensa", 'uf' => "SP", 'codigo' => 3547205],
    		['id' => 3796, 'nome' => "Santana de Parnaíba", 'uf' => "SP", 'codigo' => 3547304],
    		['id' => 3797, 'nome' => "Santa Rita D'Oeste", 'uf' => "SP", 'codigo' => 3547403],
    		['id' => 3798, 'nome' => "Santa Rita do Passa Quatro", 'uf' => "SP", 'codigo' => 3547502],
    		['id' => 3799, 'nome' => "Santa Rosa de Viterbo", 'uf' => "SP", 'codigo' => 3547601],
    		['id' => 3800, 'nome' => "Santa Salete", 'uf' => "SP", 'codigo' => 3547650],
    		['id' => 3801, 'nome' => "Santo Anastácio", 'uf' => "SP", 'codigo' => 3547700],
    		['id' => 3802, 'nome' => "Santo André", 'uf' => "SP", 'codigo' => 3547809],
    		['id' => 3803, 'nome' => "Santo Antônio da Alegria", 'uf' => "SP", 'codigo' => 3547908],
    		['id' => 3804, 'nome' => "Santo Antônio de Posse", 'uf' => "SP", 'codigo' => 3548005],
    		['id' => 3805, 'nome' => "Santo Antônio do Aracanguá", 'uf' => "SP", 'codigo' => 3548054],
    		['id' => 3806, 'nome' => "Santo Antônio do Jardim", 'uf' => "SP", 'codigo' => 3548104],
    		['id' => 3807, 'nome' => "Santo Antônio do Pinhal", 'uf' => "SP", 'codigo' => 3548203],
    		['id' => 3808, 'nome' => "Santo Expedito", 'uf' => "SP", 'codigo' => 3548302],
    		['id' => 3809, 'nome' => "Santópolis do Aguapeí", 'uf' => "SP", 'codigo' => 3548401],
    		['id' => 3810, 'nome' => "Santos", 'uf' => "SP", 'codigo' => 3548500],
    		['id' => 3811, 'nome' => "São Bento do Sapucaí", 'uf' => "SP", 'codigo' => 3548609],
    		['id' => 3812, 'nome' => "São Bernardo do Campo", 'uf' => "SP", 'codigo' => 3548708],
    		['id' => 3813, 'nome' => "São Caetano do Sul", 'uf' => "SP", 'codigo' => 3548807],
    		['id' => 3814, 'nome' => "São Carlos", 'uf' => "SP", 'codigo' => 3548906],
    		['id' => 3815, 'nome' => "São Francisco", 'uf' => "SP", 'codigo' => 3549003],
    		['id' => 3816, 'nome' => "São João da Boa Vista", 'uf' => "SP", 'codigo' => 3549102],
    		['id' => 3817, 'nome' => "São João das Duas Pontes", 'uf' => "SP", 'codigo' => 3549201],
    		['id' => 3818, 'nome' => "São João de Iracema", 'uf' => "SP", 'codigo' => 3549250],
    		['id' => 3819, 'nome' => "São João do Pau D'Alho", 'uf' => "SP", 'codigo' => 3549300],
    		['id' => 3820, 'nome' => "São Joaquim da Barra", 'uf' => "SP", 'codigo' => 3549409],
    		['id' => 3821, 'nome' => "São José da Bela Vista", 'uf' => "SP", 'codigo' => 3549508],
    		['id' => 3822, 'nome' => "São José do Barreiro", 'uf' => "SP", 'codigo' => 3549607],
    		['id' => 3823, 'nome' => "São José do Rio Pardo", 'uf' => "SP", 'codigo' => 3549706],
    		['id' => 3824, 'nome' => "São José do Rio Preto", 'uf' => "SP", 'codigo' => 3549805],
    		['id' => 3825, 'nome' => "São José dos Campos", 'uf' => "SP", 'codigo' => 3549904],
    		['id' => 3826, 'nome' => "São Lourenço da Serra", 'uf' => "SP", 'codigo' => 3549953],
    		['id' => 3827, 'nome' => "São Luís do Paraitinga", 'uf' => "SP", 'codigo' => 3550001],
    		['id' => 3828, 'nome' => "São Manuel", 'uf' => "SP", 'codigo' => 3550100],
    		['id' => 3829, 'nome' => "São Miguel Arcanjo", 'uf' => "SP", 'codigo' => 3550209],
    		['id' => 3830, 'nome' => "São Paulo", 'uf' => "SP", 'codigo' => 3550308],
    		['id' => 3831, 'nome' => "São Pedro", 'uf' => "SP", 'codigo' => 3550407],
    		['id' => 3832, 'nome' => "São Pedro do Turvo", 'uf' => "SP", 'codigo' => 3550506],
    		['id' => 3833, 'nome' => "São Roque", 'uf' => "SP", 'codigo' => 3550605],
    		['id' => 3834, 'nome' => "São Sebastião", 'uf' => "SP", 'codigo' => 3550704],
    		['id' => 3835, 'nome' => "São Sebastião da Grama", 'uf' => "SP", 'codigo' => 3550803],
    		['id' => 3836, 'nome' => "São Simão", 'uf' => "SP", 'codigo' => 3550902],
    		['id' => 3837, 'nome' => "São Vicente", 'uf' => "SP", 'codigo' => 3551009],
    		['id' => 3838, 'nome' => "Sarapuí", 'uf' => "SP", 'codigo' => 3551108],
    		['id' => 3839, 'nome' => "Sarutaiá", 'uf' => "SP", 'codigo' => 3551207],
    		['id' => 3840, 'nome' => "Sebastianópolis do Sul", 'uf' => "SP", 'codigo' => 3551306],
    		['id' => 3841, 'nome' => "Serra Azul", 'uf' => "SP", 'codigo' => 3551405],
    		['id' => 3842, 'nome' => "Serrana", 'uf' => "SP", 'codigo' => 3551504],
    		['id' => 3843, 'nome' => "Serra Negra", 'uf' => "SP", 'codigo' => 3551603],
    		['id' => 3844, 'nome' => "Sertãozinho", 'uf' => "SP", 'codigo' => 3551702],
    		['id' => 3845, 'nome' => "Sete Barras", 'uf' => "SP", 'codigo' => 3551801],
    		['id' => 3846, 'nome' => "Severínia", 'uf' => "SP", 'codigo' => 3551900],
    		['id' => 3847, 'nome' => "Silveiras", 'uf' => "SP", 'codigo' => 3552007],
    		['id' => 3848, 'nome' => "Socorro", 'uf' => "SP", 'codigo' => 3552106],
    		['id' => 3849, 'nome' => "Sorocaba", 'uf' => "SP", 'codigo' => 3552205],
    		['id' => 3850, 'nome' => "Sud Mennucci", 'uf' => "SP", 'codigo' => 3552304],
    		['id' => 3851, 'nome' => "Sumaré", 'uf' => "SP", 'codigo' => 3552403],
    		['id' => 3852, 'nome' => "Suzano", 'uf' => "SP", 'codigo' => 3552502],
    		['id' => 3853, 'nome' => "Suzanápolis", 'uf' => "SP", 'codigo' => 3552551],
    		['id' => 3854, 'nome' => "Tabapuã", 'uf' => "SP", 'codigo' => 3552601],
    		['id' => 3855, 'nome' => "Tabatinga", 'uf' => "SP", 'codigo' => 3552700],
    		['id' => 3856, 'nome' => "Taboão da Serra", 'uf' => "SP", 'codigo' => 3552809],
    		['id' => 3857, 'nome' => "Taciba", 'uf' => "SP", 'codigo' => 3552908],
    		['id' => 3858, 'nome' => "Taguaí", 'uf' => "SP", 'codigo' => 3553005],
    		['id' => 3859, 'nome' => "Taiaçu", 'uf' => "SP", 'codigo' => 3553104],
    		['id' => 3860, 'nome' => "Taiúva", 'uf' => "SP", 'codigo' => 3553203],
    		['id' => 3861, 'nome' => "Tambaú", 'uf' => "SP", 'codigo' => 3553302],
    		['id' => 3862, 'nome' => "Tanabi", 'uf' => "SP", 'codigo' => 3553401],
    		['id' => 3863, 'nome' => "Tapiraí", 'uf' => "SP", 'codigo' => 3553500],
    		['id' => 3864, 'nome' => "Tapiratiba", 'uf' => "SP", 'codigo' => 3553609],
    		['id' => 3865, 'nome' => "Taquaral", 'uf' => "SP", 'codigo' => 3553658],
    		['id' => 3866, 'nome' => "Taquaritinga", 'uf' => "SP", 'codigo' => 3553708],
    		['id' => 3867, 'nome' => "Taquarituba", 'uf' => "SP", 'codigo' => 3553807],
    		['id' => 3868, 'nome' => "Taquarivaí", 'uf' => "SP", 'codigo' => 3553856],
    		['id' => 3869, 'nome' => "Tarabai", 'uf' => "SP", 'codigo' => 3553906],
    		['id' => 3870, 'nome' => "Tarumã", 'uf' => "SP", 'codigo' => 3553955],
    		['id' => 3871, 'nome' => "Tatuí", 'uf' => "SP", 'codigo' => 3554003],
    		['id' => 3872, 'nome' => "Taubaté", 'uf' => "SP", 'codigo' => 3554102],
    		['id' => 3873, 'nome' => "Tejupá", 'uf' => "SP", 'codigo' => 3554201],
    		['id' => 3874, 'nome' => "Teodoro Sampaio", 'uf' => "SP", 'codigo' => 3554300],
    		['id' => 3875, 'nome' => "Terra Roxa", 'uf' => "SP", 'codigo' => 3554409],
    		['id' => 3876, 'nome' => "Tietê", 'uf' => "SP", 'codigo' => 3554508],
    		['id' => 3877, 'nome' => "Timburi", 'uf' => "SP", 'codigo' => 3554607],
    		['id' => 3878, 'nome' => "Torre de Pedra", 'uf' => "SP", 'codigo' => 3554656],
    		['id' => 3879, 'nome' => "Torrinha", 'uf' => "SP", 'codigo' => 3554706],
    		['id' => 3880, 'nome' => "Trabiju", 'uf' => "SP", 'codigo' => 3554755],
    		['id' => 3881, 'nome' => "Tremembé", 'uf' => "SP", 'codigo' => 3554805],
    		['id' => 3882, 'nome' => "Três Fronteiras", 'uf' => "SP", 'codigo' => 3554904],
    		['id' => 3883, 'nome' => "Tuiuti", 'uf' => "SP", 'codigo' => 3554953],
    		['id' => 3884, 'nome' => "Tupã", 'uf' => "SP", 'codigo' => 3555000],
    		['id' => 3885, 'nome' => "Tupi Paulista", 'uf' => "SP", 'codigo' => 3555109],
    		['id' => 3886, 'nome' => "Turiúba", 'uf' => "SP", 'codigo' => 3555208],
    		['id' => 3887, 'nome' => "Turmalina", 'uf' => "SP", 'codigo' => 3555307],
    		['id' => 3888, 'nome' => "Ubarana", 'uf' => "SP", 'codigo' => 3555356],
    		['id' => 3889, 'nome' => "Ubatuba", 'uf' => "SP", 'codigo' => 3555406],
    		['id' => 3890, 'nome' => "Ubirajara", 'uf' => "SP", 'codigo' => 3555505],
    		['id' => 3891, 'nome' => "Uchoa", 'uf' => "SP", 'codigo' => 3555604],
    		['id' => 3892, 'nome' => "União Paulista", 'uf' => "SP", 'codigo' => 3555703],
    		['id' => 3893, 'nome' => "Urânia", 'uf' => "SP", 'codigo' => 3555802],
    		['id' => 3894, 'nome' => "Uru", 'uf' => "SP", 'codigo' => 3555901],
    		['id' => 3895, 'nome' => "Urupês", 'uf' => "SP", 'codigo' => 3556008],
    		['id' => 3896, 'nome' => "Valentim Gentil", 'uf' => "SP", 'codigo' => 3556107],
    		['id' => 3897, 'nome' => "Valinhos", 'uf' => "SP", 'codigo' => 3556206],
    		['id' => 3898, 'nome' => "Valparaíso", 'uf' => "SP", 'codigo' => 3556305],
    		['id' => 3899, 'nome' => "Vargem", 'uf' => "SP", 'codigo' => 3556354],
    		['id' => 3900, 'nome' => "Vargem Grande do Sul", 'uf' => "SP", 'codigo' => 3556404],
    		['id' => 3901, 'nome' => "Vargem Grande Paulista", 'uf' => "SP", 'codigo' => 3556453],
    		['id' => 3902, 'nome' => "Várzea Paulista", 'uf' => "SP", 'codigo' => 3556503],
    		['id' => 3903, 'nome' => "Vera Cruz", 'uf' => "SP", 'codigo' => 3556602],
    		['id' => 3904, 'nome' => "Vinhedo", 'uf' => "SP", 'codigo' => 3556701],
    		['id' => 3905, 'nome' => "Viradouro", 'uf' => "SP", 'codigo' => 3556800],
    		['id' => 3906, 'nome' => "Vista Alegre do Alto", 'uf' => "SP", 'codigo' => 3556909],
    		['id' => 3907, 'nome' => "Vitória Brasil", 'uf' => "SP", 'codigo' => 3556958],
    		['id' => 3908, 'nome' => "Votorantim", 'uf' => "SP", 'codigo' => 3557006],
    		['id' => 3909, 'nome' => "Votuporanga", 'uf' => "SP", 'codigo' => 3557105],
    		['id' => 3910, 'nome' => "Zacarias", 'uf' => "SP", 'codigo' => 3557154],
    		['id' => 3911, 'nome' => "Chavantes", 'uf' => "SP", 'codigo' => 3557204],
    		['id' => 3912, 'nome' => "Estiva Gerbi", 'uf' => "SP", 'codigo' => 3557303],
    		['id' => 3913, 'nome' => "Abatiá", 'uf' => "PR", 'codigo' => 4100103],
    		['id' => 3914, 'nome' => "Adrianópolis", 'uf' => "PR", 'codigo' => 4100202],
    		['id' => 3915, 'nome' => "Agudos do Sul", 'uf' => "PR", 'codigo' => 4100301],
    		['id' => 3916, 'nome' => "Almirante Tamandaré", 'uf' => "PR", 'codigo' => 4100400],
    		['id' => 3917, 'nome' => "Altamira do Paraná", 'uf' => "PR", 'codigo' => 4100459],
    		['id' => 3918, 'nome' => "Altônia", 'uf' => "PR", 'codigo' => 4100509],
    		['id' => 3919, 'nome' => "Alto Paraná", 'uf' => "PR", 'codigo' => 4100608],
    		['id' => 3920, 'nome' => "Alto Piquiri", 'uf' => "PR", 'codigo' => 4100707],
    		['id' => 3921, 'nome' => "Alvorada do Sul", 'uf' => "PR", 'codigo' => 4100806],
    		['id' => 3922, 'nome' => "Amaporã", 'uf' => "PR", 'codigo' => 4100905],
    		['id' => 3923, 'nome' => "Ampére", 'uf' => "PR", 'codigo' => 4101002],
    		['id' => 3924, 'nome' => "Anahy", 'uf' => "PR", 'codigo' => 4101051],
    		['id' => 3925, 'nome' => "Andirá", 'uf' => "PR", 'codigo' => 4101101],
    		['id' => 3926, 'nome' => "Ângulo", 'uf' => "PR", 'codigo' => 4101150],
    		['id' => 3927, 'nome' => "Antonina", 'uf' => "PR", 'codigo' => 4101200],
    		['id' => 3928, 'nome' => "Antônio Olinto", 'uf' => "PR", 'codigo' => 4101309],
    		['id' => 3929, 'nome' => "Apucarana", 'uf' => "PR", 'codigo' => 4101408],
    		['id' => 3930, 'nome' => "Arapongas", 'uf' => "PR", 'codigo' => 4101507],
    		['id' => 3931, 'nome' => "Arapoti", 'uf' => "PR", 'codigo' => 4101606],
    		['id' => 3932, 'nome' => "Arapuã", 'uf' => "PR", 'codigo' => 4101655],
    		['id' => 3933, 'nome' => "Araruna", 'uf' => "PR", 'codigo' => 4101705],
    		['id' => 3934, 'nome' => "Araucária", 'uf' => "PR", 'codigo' => 4101804],
    		['id' => 3935, 'nome' => "Ariranha do Ivaí", 'uf' => "PR", 'codigo' => 4101853],
    		['id' => 3936, 'nome' => "Assaí", 'uf' => "PR", 'codigo' => 4101903],
    		['id' => 3937, 'nome' => "Assis Chateaubriand", 'uf' => "PR", 'codigo' => 4102000],
    		['id' => 3938, 'nome' => "Astorga", 'uf' => "PR", 'codigo' => 4102109],
    		['id' => 3939, 'nome' => "Atalaia", 'uf' => "PR", 'codigo' => 4102208],
    		['id' => 3940, 'nome' => "Balsa Nova", 'uf' => "PR", 'codigo' => 4102307],
    		['id' => 3941, 'nome' => "Bandeirantes", 'uf' => "PR", 'codigo' => 4102406],
    		['id' => 3942, 'nome' => "Barbosa Ferraz", 'uf' => "PR", 'codigo' => 4102505],
    		['id' => 3943, 'nome' => "Barracão", 'uf' => "PR", 'codigo' => 4102604],
    		['id' => 3944, 'nome' => "Barra do Jacaré", 'uf' => "PR", 'codigo' => 4102703],
    		['id' => 3945, 'nome' => "Bela Vista da Caroba", 'uf' => "PR", 'codigo' => 4102752],
    		['id' => 3946, 'nome' => "Bela Vista do Paraíso", 'uf' => "PR", 'codigo' => 4102802],
    		['id' => 3947, 'nome' => "Bituruna", 'uf' => "PR", 'codigo' => 4102901],
    		['id' => 3948, 'nome' => "Boa Esperança", 'uf' => "PR", 'codigo' => 4103008],
    		['id' => 3949, 'nome' => "Boa Esperança do Iguaçu", 'uf' => "PR", 'codigo' => 4103024],
    		['id' => 3950, 'nome' => "Boa Ventura de São Roque", 'uf' => "PR", 'codigo' => 4103040],
    		['id' => 3951, 'nome' => "Boa Vista da Aparecida", 'uf' => "PR", 'codigo' => 4103057],
    		['id' => 3952, 'nome' => "Bocaiúva do Sul", 'uf' => "PR", 'codigo' => 4103107],
    		['id' => 3953, 'nome' => "Bom Jesus do Sul", 'uf' => "PR", 'codigo' => 4103156],
    		['id' => 3954, 'nome' => "Bom Sucesso", 'uf' => "PR", 'codigo' => 4103206],
    		['id' => 3955, 'nome' => "Bom Sucesso do Sul", 'uf' => "PR", 'codigo' => 4103222],
    		['id' => 3956, 'nome' => "Borrazópolis", 'uf' => "PR", 'codigo' => 4103305],
    		['id' => 3957, 'nome' => "Braganey", 'uf' => "PR", 'codigo' => 4103354],
    		['id' => 3958, 'nome' => "Brasilândia do Sul", 'uf' => "PR", 'codigo' => 4103370],
    		['id' => 3959, 'nome' => "Cafeara", 'uf' => "PR", 'codigo' => 4103404],
    		['id' => 3960, 'nome' => "Cafelândia", 'uf' => "PR", 'codigo' => 4103453],
    		['id' => 3961, 'nome' => "Cafezal do Sul", 'uf' => "PR", 'codigo' => 4103479],
    		['id' => 3962, 'nome' => "Califórnia", 'uf' => "PR", 'codigo' => 4103503],
    		['id' => 3963, 'nome' => "Cambará", 'uf' => "PR", 'codigo' => 4103602],
    		['id' => 3964, 'nome' => "Cambé", 'uf' => "PR", 'codigo' => 4103701],
    		['id' => 3965, 'nome' => "Cambira", 'uf' => "PR", 'codigo' => 4103800],
    		['id' => 3966, 'nome' => "Campina da Lagoa", 'uf' => "PR", 'codigo' => 4103909],
    		['id' => 3967, 'nome' => "Campina do Simão", 'uf' => "PR", 'codigo' => 4103958],
    		['id' => 3968, 'nome' => "Campina Grande do Sul", 'uf' => "PR", 'codigo' => 4104006],
    		['id' => 3969, 'nome' => "Campo Bonito", 'uf' => "PR", 'codigo' => 4104055],
    		['id' => 3970, 'nome' => "Campo do Tenente", 'uf' => "PR", 'codigo' => 4104105],
    		['id' => 3971, 'nome' => "Campo Largo", 'uf' => "PR", 'codigo' => 4104204],
    		['id' => 3972, 'nome' => "Campo Magro", 'uf' => "PR", 'codigo' => 4104253],
    		['id' => 3973, 'nome' => "Campo Mourão", 'uf' => "PR", 'codigo' => 4104303],
    		['id' => 3974, 'nome' => "Cândido de Abreu", 'uf' => "PR", 'codigo' => 4104402],
    		['id' => 3975, 'nome' => "Candói", 'uf' => "PR", 'codigo' => 4104428],
    		['id' => 3976, 'nome' => "Cantagalo", 'uf' => "PR", 'codigo' => 4104451],
    		['id' => 3977, 'nome' => "Capanema", 'uf' => "PR", 'codigo' => 4104501],
    		['id' => 3978, 'nome' => "Capitão Leônidas Marques", 'uf' => "PR", 'codigo' => 4104600],
    		['id' => 3979, 'nome' => "Carambeí", 'uf' => "PR", 'codigo' => 4104659],
    		['id' => 3980, 'nome' => "Carlópolis", 'uf' => "PR", 'codigo' => 4104709],
    		['id' => 3981, 'nome' => "Cascavel", 'uf' => "PR", 'codigo' => 4104808],
    		['id' => 3982, 'nome' => "Castro", 'uf' => "PR", 'codigo' => 4104907],
    		['id' => 3983, 'nome' => "Catanduvas", 'uf' => "PR", 'codigo' => 4105003],
    		['id' => 3984, 'nome' => "Centenário do Sul", 'uf' => "PR", 'codigo' => 4105102],
    		['id' => 3985, 'nome' => "Cerro Azul", 'uf' => "PR", 'codigo' => 4105201],
    		['id' => 3986, 'nome' => "Céu Azul", 'uf' => "PR", 'codigo' => 4105300],
    		['id' => 3987, 'nome' => "Chopinzinho", 'uf' => "PR", 'codigo' => 4105409],
    		['id' => 3988, 'nome' => "Cianorte", 'uf' => "PR", 'codigo' => 4105508],
    		['id' => 3989, 'nome' => "cidades Gaúcha", 'uf' => "PR", 'codigo' => 4105607],
    		['id' => 3990, 'nome' => "Clevelândia", 'uf' => "PR", 'codigo' => 4105706],
    		['id' => 3991, 'nome' => "Colombo", 'uf' => "PR", 'codigo' => 4105805],
    		['id' => 3992, 'nome' => "Colorado", 'uf' => "PR", 'codigo' => 4105904],
    		['id' => 3993, 'nome' => "Congonhinhas", 'uf' => "PR", 'codigo' => 4106001],
    		['id' => 3994, 'nome' => "Conselheiro Mairinck", 'uf' => "PR", 'codigo' => 4106100],
    		['id' => 3995, 'nome' => "Contenda", 'uf' => "PR", 'codigo' => 4106209],
    		['id' => 3996, 'nome' => "Corbélia", 'uf' => "PR", 'codigo' => 4106308],
    		['id' => 3997, 'nome' => "Cornélio Procópio", 'uf' => "PR", 'codigo' => 4106407],
    		['id' => 3998, 'nome' => "Coronel Domingos Soares", 'uf' => "PR", 'codigo' => 4106456],
    		['id' => 3999, 'nome' => "Coronel Vivida", 'uf' => "PR", 'codigo' => 4106506],
    		['id' => 4000, 'nome' => "Corumbataí do Sul", 'uf' => "PR", 'codigo' => 4106555],
    		['id' => 4001, 'nome' => "Cruzeiro do Iguaçu", 'uf' => "PR", 'codigo' => 4106571],
    		['id' => 4002, 'nome' => "Cruzeiro do Oeste", 'uf' => "PR", 'codigo' => 4106605],
    		['id' => 4003, 'nome' => "Cruzeiro do Sul", 'uf' => "PR", 'codigo' => 4106704],
    		['id' => 4004, 'nome' => "Cruz Machado", 'uf' => "PR", 'codigo' => 4106803],
    		['id' => 4005, 'nome' => "Cruzmaltina", 'uf' => "PR", 'codigo' => 4106852],
    		['id' => 4006, 'nome' => "Curitiba", 'uf' => "PR", 'codigo' => 4106902],
    		['id' => 4007, 'nome' => "Curiúva", 'uf' => "PR", 'codigo' => 4107009],
    		['id' => 4008, 'nome' => "Diamante do Norte", 'uf' => "PR", 'codigo' => 4107108],
    		['id' => 4009, 'nome' => "Diamante do Sul", 'uf' => "PR", 'codigo' => 4107124],
    		['id' => 4010, 'nome' => "Diamante D'Oeste", 'uf' => "PR", 'codigo' => 4107157],
    		['id' => 4011, 'nome' => "Dois Vizinhos", 'uf' => "PR", 'codigo' => 4107207],
    		['id' => 4012, 'nome' => "Douradina", 'uf' => "PR", 'codigo' => 4107256],
    		['id' => 4013, 'nome' => "Doutor Camargo", 'uf' => "PR", 'codigo' => 4107306],
    		['id' => 4014, 'nome' => "Enéas Marques", 'uf' => "PR", 'codigo' => 4107405],
    		['id' => 4015, 'nome' => "Engenheiro Beltrão", 'uf' => "PR", 'codigo' => 4107504],
    		['id' => 4016, 'nome' => "Esperança Nova", 'uf' => "PR", 'codigo' => 4107520],
    		['id' => 4017, 'nome' => "Entre Rios do Oeste", 'uf' => "PR", 'codigo' => 4107538],
    		['id' => 4018, 'nome' => "Espigão Alto do Iguaçu", 'uf' => "PR", 'codigo' => 4107546],
    		['id' => 4019, 'nome' => "Farol", 'uf' => "PR", 'codigo' => 4107553],
    		['id' => 4020, 'nome' => "Faxinal", 'uf' => "PR", 'codigo' => 4107603],
    		['id' => 4021, 'nome' => "Fazenda Rio Grande", 'uf' => "PR", 'codigo' => 4107652],
    		['id' => 4022, 'nome' => "Fênix", 'uf' => "PR", 'codigo' => 4107702],
    		['id' => 4023, 'nome' => "Fernandes Pinheiro", 'uf' => "PR", 'codigo' => 4107736],
    		['id' => 4024, 'nome' => "Figueira", 'uf' => "PR", 'codigo' => 4107751],
    		['id' => 4025, 'nome' => "Floraí", 'uf' => "PR", 'codigo' => 4107801],
    		['id' => 4026, 'nome' => "Flor da Serra do Sul", 'uf' => "PR", 'codigo' => 4107850],
    		['id' => 4027, 'nome' => "Floresta", 'uf' => "PR", 'codigo' => 4107900],
    		['id' => 4028, 'nome' => "Florestópolis", 'uf' => "PR", 'codigo' => 4108007],
    		['id' => 4029, 'nome' => "Flórida", 'uf' => "PR", 'codigo' => 4108106],
    		['id' => 4030, 'nome' => "Formosa do Oeste", 'uf' => "PR", 'codigo' => 4108205],
    		['id' => 4031, 'nome' => "Foz do Iguaçu", 'uf' => "PR", 'codigo' => 4108304],
    		['id' => 4032, 'nome' => "Francisco Alves", 'uf' => "PR", 'codigo' => 4108320],
    		['id' => 4033, 'nome' => "Francisco Beltrão", 'uf' => "PR", 'codigo' => 4108403],
    		['id' => 4034, 'nome' => "Foz do Jordão", 'uf' => "PR", 'codigo' => 4108452],
    		['id' => 4035, 'nome' => "General Carneiro", 'uf' => "PR", 'codigo' => 4108502],
    		['id' => 4036, 'nome' => "Godoy Moreira", 'uf' => "PR", 'codigo' => 4108551],
    		['id' => 4037, 'nome' => "Goioerê", 'uf' => "PR", 'codigo' => 4108601],
    		['id' => 4038, 'nome' => "Goioxim", 'uf' => "PR", 'codigo' => 4108650],
    		['id' => 4039, 'nome' => "Grandes Rios", 'uf' => "PR", 'codigo' => 4108700],
    		['id' => 4040, 'nome' => "Guaíra", 'uf' => "PR", 'codigo' => 4108809],
    		['id' => 4041, 'nome' => "Guairaçá", 'uf' => "PR", 'codigo' => 4108908],
    		['id' => 4042, 'nome' => "Guamiranga", 'uf' => "PR", 'codigo' => 4108957],
    		['id' => 4043, 'nome' => "Guapirama", 'uf' => "PR", 'codigo' => 4109005],
    		['id' => 4044, 'nome' => "Guaporema", 'uf' => "PR", 'codigo' => 4109104],
    		['id' => 4045, 'nome' => "Guaraci", 'uf' => "PR", 'codigo' => 4109203],
    		['id' => 4046, 'nome' => "Guaraniaçu", 'uf' => "PR", 'codigo' => 4109302],
    		['id' => 4047, 'nome' => "Guarapuava", 'uf' => "PR", 'codigo' => 4109401],
    		['id' => 4048, 'nome' => "Guaraqueçaba", 'uf' => "PR", 'codigo' => 4109500],
    		['id' => 4049, 'nome' => "Guaratuba", 'uf' => "PR", 'codigo' => 4109609],
    		['id' => 4050, 'nome' => "Honório Serpa", 'uf' => "PR", 'codigo' => 4109658],
    		['id' => 4051, 'nome' => "Ibaiti", 'uf' => "PR", 'codigo' => 4109708],
    		['id' => 4052, 'nome' => "Ibema", 'uf' => "PR", 'codigo' => 4109757],
    		['id' => 4053, 'nome' => "Ibiporã", 'uf' => "PR", 'codigo' => 4109807],
    		['id' => 4054, 'nome' => "Icaraíma", 'uf' => "PR", 'codigo' => 4109906],
    		['id' => 4055, 'nome' => "Iguaraçu", 'uf' => "PR", 'codigo' => 4110003],
    		['id' => 4056, 'nome' => "Iguatu", 'uf' => "PR", 'codigo' => 4110052],
    		['id' => 4057, 'nome' => "Imbaú", 'uf' => "PR", 'codigo' => 4110078],
    		['id' => 4058, 'nome' => "Imbituva", 'uf' => "PR", 'codigo' => 4110102],
    		['id' => 4059, 'nome' => "Inácio Martins", 'uf' => "PR", 'codigo' => 4110201],
    		['id' => 4060, 'nome' => "Inajá", 'uf' => "PR", 'codigo' => 4110300],
    		['id' => 4061, 'nome' => "Indianópolis", 'uf' => "PR", 'codigo' => 4110409],
    		['id' => 4062, 'nome' => "Ipiranga", 'uf' => "PR", 'codigo' => 4110508],
    		['id' => 4063, 'nome' => "Iporã", 'uf' => "PR", 'codigo' => 4110607],
    		['id' => 4064, 'nome' => "Iracema do Oeste", 'uf' => "PR", 'codigo' => 4110656],
    		['id' => 4065, 'nome' => "Irati", 'uf' => "PR", 'codigo' => 4110706],
    		['id' => 4066, 'nome' => "Iretama", 'uf' => "PR", 'codigo' => 4110805],
    		['id' => 4067, 'nome' => "Itaguajé", 'uf' => "PR", 'codigo' => 4110904],
    		['id' => 4068, 'nome' => "Itaipulândia", 'uf' => "PR", 'codigo' => 4110953],
    		['id' => 4069, 'nome' => "Itambaracá", 'uf' => "PR", 'codigo' => 4111001],
    		['id' => 4070, 'nome' => "Itambé", 'uf' => "PR", 'codigo' => 4111100],
    		['id' => 4071, 'nome' => "Itapejara D'Oeste", 'uf' => "PR", 'codigo' => 4111209],
    		['id' => 4072, 'nome' => "Itaperuçu", 'uf' => "PR", 'codigo' => 4111258],
    		['id' => 4073, 'nome' => "Itaúna do Sul", 'uf' => "PR", 'codigo' => 4111308],
    		['id' => 4074, 'nome' => "Ivaí", 'uf' => "PR", 'codigo' => 4111407],
    		['id' => 4075, 'nome' => "Ivaiporã", 'uf' => "PR", 'codigo' => 4111506],
    		['id' => 4076, 'nome' => "Ivaté", 'uf' => "PR", 'codigo' => 4111555],
    		['id' => 4077, 'nome' => "Ivatuba", 'uf' => "PR", 'codigo' => 4111605],
    		['id' => 4078, 'nome' => "Jaboti", 'uf' => "PR", 'codigo' => 4111704],
    		['id' => 4079, 'nome' => "Jacarezinho", 'uf' => "PR", 'codigo' => 4111803],
    		['id' => 4080, 'nome' => "Jaguapitã", 'uf' => "PR", 'codigo' => 4111902],
    		['id' => 4081, 'nome' => "Jaguariaíva", 'uf' => "PR", 'codigo' => 4112009],
    		['id' => 4082, 'nome' => "Jandaia do Sul", 'uf' => "PR", 'codigo' => 4112108],
    		['id' => 4083, 'nome' => "Janiópolis", 'uf' => "PR", 'codigo' => 4112207],
    		['id' => 4084, 'nome' => "Japira", 'uf' => "PR", 'codigo' => 4112306],
    		['id' => 4085, 'nome' => "Japurá", 'uf' => "PR", 'codigo' => 4112405],
    		['id' => 4086, 'nome' => "Jardim Alegre", 'uf' => "PR", 'codigo' => 4112504],
    		['id' => 4087, 'nome' => "Jardim Olinda", 'uf' => "PR", 'codigo' => 4112603],
    		['id' => 4088, 'nome' => "Jataizinho", 'uf' => "PR", 'codigo' => 4112702],
    		['id' => 4089, 'nome' => "Jesuítas", 'uf' => "PR", 'codigo' => 4112751],
    		['id' => 4090, 'nome' => "Joaquim Távora", 'uf' => "PR", 'codigo' => 4112801],
    		['id' => 4091, 'nome' => "Jundiaí do Sul", 'uf' => "PR", 'codigo' => 4112900],
    		['id' => 4092, 'nome' => "Juranda", 'uf' => "PR", 'codigo' => 4112959],
    		['id' => 4093, 'nome' => "Jussara", 'uf' => "PR", 'codigo' => 4113007],
    		['id' => 4094, 'nome' => "Kaloré", 'uf' => "PR", 'codigo' => 4113106],
    		['id' => 4095, 'nome' => "Lapa", 'uf' => "PR", 'codigo' => 4113205],
    		['id' => 4096, 'nome' => "Laranjal", 'uf' => "PR", 'codigo' => 4113254],
    		['id' => 4097, 'nome' => "Laranjeiras do Sul", 'uf' => "PR", 'codigo' => 4113304],
    		['id' => 4098, 'nome' => "Leópolis", 'uf' => "PR", 'codigo' => 4113403],
    		['id' => 4099, 'nome' => "Lidianópolis", 'uf' => "PR", 'codigo' => 4113429],
    		['id' => 4100, 'nome' => "Lindoeste", 'uf' => "PR", 'codigo' => 4113452],
    		['id' => 4101, 'nome' => "Loanda", 'uf' => "PR", 'codigo' => 4113502],
    		['id' => 4102, 'nome' => "Lobato", 'uf' => "PR", 'codigo' => 4113601],
    		['id' => 4103, 'nome' => "Londrina", 'uf' => "PR", 'codigo' => 4113700],
    		['id' => 4104, 'nome' => "Luiziana", 'uf' => "PR", 'codigo' => 4113734],
    		['id' => 4105, 'nome' => "Lunardelli", 'uf' => "PR", 'codigo' => 4113759],
    		['id' => 4106, 'nome' => "Lupionópolis", 'uf' => "PR", 'codigo' => 4113809],
    		['id' => 4107, 'nome' => "Mallet", 'uf' => "PR", 'codigo' => 4113908],
    		['id' => 4108, 'nome' => "Mamborê", 'uf' => "PR", 'codigo' => 4114005],
    		['id' => 4109, 'nome' => "Mandaguaçu", 'uf' => "PR", 'codigo' => 4114104],
    		['id' => 4110, 'nome' => "Mandaguari", 'uf' => "PR", 'codigo' => 4114203],
    		['id' => 4111, 'nome' => "Mandirituba", 'uf' => "PR", 'codigo' => 4114302],
    		['id' => 4112, 'nome' => "Manfrinópolis", 'uf' => "PR", 'codigo' => 4114351],
    		['id' => 4113, 'nome' => "Mangueirinha", 'uf' => "PR", 'codigo' => 4114401],
    		['id' => 4114, 'nome' => "Manoel Ribas", 'uf' => "PR", 'codigo' => 4114500],
    		['id' => 4115, 'nome' => "Marechal Cândido Rondon", 'uf' => "PR", 'codigo' => 4114609],
    		['id' => 4116, 'nome' => "Maria Helena", 'uf' => "PR", 'codigo' => 4114708],
    		['id' => 4117, 'nome' => "Marialva", 'uf' => "PR", 'codigo' => 4114807],
    		['id' => 4118, 'nome' => "Marilândia do Sul", 'uf' => "PR", 'codigo' => 4114906],
    		['id' => 4119, 'nome' => "Marilena", 'uf' => "PR", 'codigo' => 4115002],
    		['id' => 4120, 'nome' => "Mariluz", 'uf' => "PR", 'codigo' => 4115101],
    		['id' => 4121, 'nome' => "Maringá", 'uf' => "PR", 'codigo' => 4115200],
    		['id' => 4122, 'nome' => "Mariópolis", 'uf' => "PR", 'codigo' => 4115309],
    		['id' => 4123, 'nome' => "Maripá", 'uf' => "PR", 'codigo' => 4115358],
    		['id' => 4124, 'nome' => "Marmeleiro", 'uf' => "PR", 'codigo' => 4115408],
    		['id' => 4125, 'nome' => "Marquinho", 'uf' => "PR", 'codigo' => 4115457],
    		['id' => 4126, 'nome' => "Marumbi", 'uf' => "PR", 'codigo' => 4115507],
    		['id' => 4127, 'nome' => "Matelândia", 'uf' => "PR", 'codigo' => 4115606],
    		['id' => 4128, 'nome' => "Matinhos", 'uf' => "PR", 'codigo' => 4115705],
    		['id' => 4129, 'nome' => "Mato Rico", 'uf' => "PR", 'codigo' => 4115739],
    		['id' => 4130, 'nome' => "Mauá da Serra", 'uf' => "PR", 'codigo' => 4115754],
    		['id' => 4131, 'nome' => "Medianeira", 'uf' => "PR", 'codigo' => 4115804],
    		['id' => 4132, 'nome' => "Mercedes", 'uf' => "PR", 'codigo' => 4115853],
    		['id' => 4133, 'nome' => "Mirador", 'uf' => "PR", 'codigo' => 4115903],
    		['id' => 4134, 'nome' => "Miraselva", 'uf' => "PR", 'codigo' => 4116000],
    		['id' => 4135, 'nome' => "Missal", 'uf' => "PR", 'codigo' => 4116059],
    		['id' => 4136, 'nome' => "Moreira Sales", 'uf' => "PR", 'codigo' => 4116109],
    		['id' => 4137, 'nome' => "Morretes", 'uf' => "PR", 'codigo' => 4116208],
    		['id' => 4138, 'nome' => "Munhoz de Melo", 'uf' => "PR", 'codigo' => 4116307],
    		['id' => 4139, 'nome' => "Nossa Senhora das Graças", 'uf' => "PR", 'codigo' => 4116406],
    		['id' => 4140, 'nome' => "Nova Aliança do Ivaí", 'uf' => "PR", 'codigo' => 4116505],
    		['id' => 4141, 'nome' => "Nova América da Colina", 'uf' => "PR", 'codigo' => 4116604],
    		['id' => 4142, 'nome' => "Nova Aurora", 'uf' => "PR", 'codigo' => 4116703],
    		['id' => 4143, 'nome' => "Nova Cantu", 'uf' => "PR", 'codigo' => 4116802],
    		['id' => 4144, 'nome' => "Nova Esperança", 'uf' => "PR", 'codigo' => 4116901],
    		['id' => 4145, 'nome' => "Nova Esperança do Sudoeste", 'uf' => "PR", 'codigo' => 4116950],
    		['id' => 4146, 'nome' => "Nova Fátima", 'uf' => "PR", 'codigo' => 4117008],
    		['id' => 4147, 'nome' => "Nova Laranjeiras", 'uf' => "PR", 'codigo' => 4117057],
    		['id' => 4148, 'nome' => "Nova Londrina", 'uf' => "PR", 'codigo' => 4117107],
    		['id' => 4149, 'nome' => "Nova Olímpia", 'uf' => "PR", 'codigo' => 4117206],
    		['id' => 4150, 'nome' => "Nova Santa Bárbara", 'uf' => "PR", 'codigo' => 4117214],
    		['id' => 4151, 'nome' => "Nova Santa Rosa", 'uf' => "PR", 'codigo' => 4117222],
    		['id' => 4152, 'nome' => "Nova Prata do Iguaçu", 'uf' => "PR", 'codigo' => 4117255],
    		['id' => 4153, 'nome' => "Nova Tebas", 'uf' => "PR", 'codigo' => 4117271],
    		['id' => 4154, 'nome' => "Novo Itacolomi", 'uf' => "PR", 'codigo' => 4117297],
    		['id' => 4155, 'nome' => "Ortigueira", 'uf' => "PR", 'codigo' => 4117305],
    		['id' => 4156, 'nome' => "Ourizona", 'uf' => "PR", 'codigo' => 4117404],
    		['id' => 4157, 'nome' => "Ouro Verde do Oeste", 'uf' => "PR", 'codigo' => 4117453],
    		['id' => 4158, 'nome' => "Paiçandu", 'uf' => "PR", 'codigo' => 4117503],
    		['id' => 4159, 'nome' => "Palmas", 'uf' => "PR", 'codigo' => 4117602],
    		['id' => 4160, 'nome' => "Palmeira", 'uf' => "PR", 'codigo' => 4117701],
    		['id' => 4161, 'nome' => "Palmital", 'uf' => "PR", 'codigo' => 4117800],
    		['id' => 4162, 'nome' => "Palotina", 'uf' => "PR", 'codigo' => 4117909],
    		['id' => 4163, 'nome' => "Paraíso do Norte", 'uf' => "PR", 'codigo' => 4118006],
    		['id' => 4164, 'nome' => "Paranacity", 'uf' => "PR", 'codigo' => 4118105],
    		['id' => 4165, 'nome' => "Paranaguá", 'uf' => "PR", 'codigo' => 4118204],
    		['id' => 4166, 'nome' => "Paranapoema", 'uf' => "PR", 'codigo' => 4118303],
    		['id' => 4167, 'nome' => "Paranavaí", 'uf' => "PR", 'codigo' => 4118402],
    		['id' => 4168, 'nome' => "Pato Bragado", 'uf' => "PR", 'codigo' => 4118451],
    		['id' => 4169, 'nome' => "Pato Branco", 'uf' => "PR", 'codigo' => 4118501],
    		['id' => 4170, 'nome' => "Paula Freitas", 'uf' => "PR", 'codigo' => 4118600],
    		['id' => 4171, 'nome' => "Paulo Frontin", 'uf' => "PR", 'codigo' => 4118709],
    		['id' => 4172, 'nome' => "Peabiru", 'uf' => "PR", 'codigo' => 4118808],
    		['id' => 4173, 'nome' => "Perobal", 'uf' => "PR", 'codigo' => 4118857],
    		['id' => 4174, 'nome' => "Pérola", 'uf' => "PR", 'codigo' => 4118907],
    		['id' => 4175, 'nome' => "Pérola D'Oeste", 'uf' => "PR", 'codigo' => 4119004],
    		['id' => 4176, 'nome' => "Piên", 'uf' => "PR", 'codigo' => 4119103],
    		['id' => 4177, 'nome' => "Pinhais", 'uf' => "PR", 'codigo' => 4119152],
    		['id' => 4178, 'nome' => "Pinhalão", 'uf' => "PR", 'codigo' => 4119202],
    		['id' => 4179, 'nome' => "Pinhal de São Bento", 'uf' => "PR", 'codigo' => 4119251],
    		['id' => 4180, 'nome' => "Pinhão", 'uf' => "PR", 'codigo' => 4119301],
    		['id' => 4181, 'nome' => "Piraí do Sul", 'uf' => "PR", 'codigo' => 4119400],
    		['id' => 4182, 'nome' => "Piraquara", 'uf' => "PR", 'codigo' => 4119509],
    		['id' => 4183, 'nome' => "Pitanga", 'uf' => "PR", 'codigo' => 4119608],
    		['id' => 4184, 'nome' => "Pitangueiras", 'uf' => "PR", 'codigo' => 4119657],
    		['id' => 4185, 'nome' => "Planaltina do Paraná", 'uf' => "PR", 'codigo' => 4119707],
    		['id' => 4186, 'nome' => "Planalto", 'uf' => "PR", 'codigo' => 4119806],
    		['id' => 4187, 'nome' => "Ponta Grossa", 'uf' => "PR", 'codigo' => 4119905],
    		['id' => 4188, 'nome' => "Pontal do Paraná", 'uf' => "PR", 'codigo' => 4119954],
    		['id' => 4189, 'nome' => "Porecatu", 'uf' => "PR", 'codigo' => 4120002],
    		['id' => 4190, 'nome' => "Porto Amazonas", 'uf' => "PR", 'codigo' => 4120101],
    		['id' => 4191, 'nome' => "Porto Barreiro", 'uf' => "PR", 'codigo' => 4120150],
    		['id' => 4192, 'nome' => "Porto Rico", 'uf' => "PR", 'codigo' => 4120200],
    		['id' => 4193, 'nome' => "Porto Vitória", 'uf' => "PR", 'codigo' => 4120309],
    		['id' => 4194, 'nome' => "Prado Ferreira", 'uf' => "PR", 'codigo' => 4120333],
    		['id' => 4195, 'nome' => "Pranchita", 'uf' => "PR", 'codigo' => 4120358],
    		['id' => 4196, 'nome' => "Presidente Castelo Branco", 'uf' => "PR", 'codigo' => 4120408],
    		['id' => 4197, 'nome' => "Primeiro de Maio", 'uf' => "PR", 'codigo' => 4120507],
    		['id' => 4198, 'nome' => "Prudentópolis", 'uf' => "PR", 'codigo' => 4120606],
    		['id' => 4199, 'nome' => "Quarto Centenário", 'uf' => "PR", 'codigo' => 4120655],
    		['id' => 4200, 'nome' => "Quatiguá", 'uf' => "PR", 'codigo' => 4120705],
    		['id' => 4201, 'nome' => "Quatro Barras", 'uf' => "PR", 'codigo' => 4120804],
    		['id' => 4202, 'nome' => "Quatro Pontes", 'uf' => "PR", 'codigo' => 4120853],
    		['id' => 4203, 'nome' => "Quedas do Iguaçu", 'uf' => "PR", 'codigo' => 4120903],
    		['id' => 4204, 'nome' => "Querência do Norte", 'uf' => "PR", 'codigo' => 4121000],
    		['id' => 4205, 'nome' => "Quinta do Sol", 'uf' => "PR", 'codigo' => 4121109],
    		['id' => 4206, 'nome' => "Quitandinha", 'uf' => "PR", 'codigo' => 4121208],
    		['id' => 4207, 'nome' => "Ramilândia", 'uf' => "PR", 'codigo' => 4121257],
    		['id' => 4208, 'nome' => "Rancho Alegre", 'uf' => "PR", 'codigo' => 4121307],
    		['id' => 4209, 'nome' => "Rancho Alegre D'Oeste", 'uf' => "PR", 'codigo' => 4121356],
    		['id' => 4210, 'nome' => "Realeza", 'uf' => "PR", 'codigo' => 4121406],
    		['id' => 4211, 'nome' => "Rebouças", 'uf' => "PR", 'codigo' => 4121505],
    		['id' => 4212, 'nome' => "Renascença", 'uf' => "PR", 'codigo' => 4121604],
    		['id' => 4213, 'nome' => "Reserva", 'uf' => "PR", 'codigo' => 4121703],
    		['id' => 4214, 'nome' => "Reserva do Iguaçu", 'uf' => "PR", 'codigo' => 4121752],
    		['id' => 4215, 'nome' => "Ribeirão Claro", 'uf' => "PR", 'codigo' => 4121802],
    		['id' => 4216, 'nome' => "Ribeirão do Pinhal", 'uf' => "PR", 'codigo' => 4121901],
    		['id' => 4217, 'nome' => "Rio Azul", 'uf' => "PR", 'codigo' => 4122008],
    		['id' => 4218, 'nome' => "Rio Bom", 'uf' => "PR", 'codigo' => 4122107],
    		['id' => 4219, 'nome' => "Rio Bonito do Iguaçu", 'uf' => "PR", 'codigo' => 4122156],
    		['id' => 4220, 'nome' => "Rio Branco do Ivaí", 'uf' => "PR", 'codigo' => 4122172],
    		['id' => 4221, 'nome' => "Rio Branco do Sul", 'uf' => "PR", 'codigo' => 4122206],
    		['id' => 4222, 'nome' => "Rio Negro", 'uf' => "PR", 'codigo' => 4122305],
    		['id' => 4223, 'nome' => "Rolândia", 'uf' => "PR", 'codigo' => 4122404],
    		['id' => 4224, 'nome' => "Roncador", 'uf' => "PR", 'codigo' => 4122503],
    		['id' => 4225, 'nome' => "Rondon", 'uf' => "PR", 'codigo' => 4122602],
    		['id' => 4226, 'nome' => "Rosário do Ivaí", 'uf' => "PR", 'codigo' => 4122651],
    		['id' => 4227, 'nome' => "Sabáudia", 'uf' => "PR", 'codigo' => 4122701],
    		['id' => 4228, 'nome' => "Salgado Filho", 'uf' => "PR", 'codigo' => 4122800],
    		['id' => 4229, 'nome' => "Salto do Itararé", 'uf' => "PR", 'codigo' => 4122909],
    		['id' => 4230, 'nome' => "Salto do Lontra", 'uf' => "PR", 'codigo' => 4123006],
    		['id' => 4231, 'nome' => "Santa Amélia", 'uf' => "PR", 'codigo' => 4123105],
    		['id' => 4232, 'nome' => "Santa Cecília do Pavão", 'uf' => "PR", 'codigo' => 4123204],
    		['id' => 4233, 'nome' => "Santa Cruz de Monte Castelo", 'uf' => "PR", 'codigo' => 4123303],
    		['id' => 4234, 'nome' => "Santa Fé", 'uf' => "PR", 'codigo' => 4123402],
    		['id' => 4235, 'nome' => "Santa Helena", 'uf' => "PR", 'codigo' => 4123501],
    		['id' => 4236, 'nome' => "Santa Inês", 'uf' => "PR", 'codigo' => 4123600],
    		['id' => 4237, 'nome' => "Santa Isabel do Ivaí", 'uf' => "PR", 'codigo' => 4123709],
    		['id' => 4238, 'nome' => "Santa Izabel do Oeste", 'uf' => "PR", 'codigo' => 4123808],
    		['id' => 4239, 'nome' => "Santa Lúcia", 'uf' => "PR", 'codigo' => 4123824],
    		['id' => 4240, 'nome' => "Santa Maria do Oeste", 'uf' => "PR", 'codigo' => 4123857],
    		['id' => 4241, 'nome' => "Santa Mariana", 'uf' => "PR", 'codigo' => 4123907],
    		['id' => 4242, 'nome' => "Santa Mônica", 'uf' => "PR", 'codigo' => 4123956],
    		['id' => 4243, 'nome' => "Santana do Itararé", 'uf' => "PR", 'codigo' => 4124004],
    		['id' => 4244, 'nome' => "Santa Tereza do Oeste", 'uf' => "PR", 'codigo' => 4124020],
    		['id' => 4245, 'nome' => "Santa Terezinha de Itaipu", 'uf' => "PR", 'codigo' => 4124053],
    		['id' => 4246, 'nome' => "Santo Antônio da Platina", 'uf' => "PR", 'codigo' => 4124103],
    		['id' => 4247, 'nome' => "Santo Antônio do Caiuá", 'uf' => "PR", 'codigo' => 4124202],
    		['id' => 4248, 'nome' => "Santo Antônio do Paraíso", 'uf' => "PR", 'codigo' => 4124301],
    		['id' => 4249, 'nome' => "Santo Antônio do Sudoeste", 'uf' => "PR", 'codigo' => 4124400],
    		['id' => 4250, 'nome' => "Santo Inácio", 'uf' => "PR", 'codigo' => 4124509],
    		['id' => 4251, 'nome' => "São Carlos do Ivaí", 'uf' => "PR", 'codigo' => 4124608],
    		['id' => 4252, 'nome' => "São Jerônimo da Serra", 'uf' => "PR", 'codigo' => 4124707],
    		['id' => 4253, 'nome' => "São João", 'uf' => "PR", 'codigo' => 4124806],
    		['id' => 4254, 'nome' => "São João do Caiuá", 'uf' => "PR", 'codigo' => 4124905],
    		['id' => 4255, 'nome' => "São João do Ivaí", 'uf' => "PR", 'codigo' => 4125001],
    		['id' => 4256, 'nome' => "São João do Triunfo", 'uf' => "PR", 'codigo' => 4125100],
    		['id' => 4257, 'nome' => "São Jorge D'Oeste", 'uf' => "PR", 'codigo' => 4125209],
    		['id' => 4258, 'nome' => "São Jorge do Ivaí", 'uf' => "PR", 'codigo' => 4125308],
    		['id' => 4259, 'nome' => "São Jorge do Patrocínio", 'uf' => "PR", 'codigo' => 4125357],
    		['id' => 4260, 'nome' => "São José da Boa Vista", 'uf' => "PR", 'codigo' => 4125407],
    		['id' => 4261, 'nome' => "São José das Palmeiras", 'uf' => "PR", 'codigo' => 4125456],
    		['id' => 4262, 'nome' => "São José dos Pinhais", 'uf' => "PR", 'codigo' => 4125506],
    		['id' => 4263, 'nome' => "São Manoel do Paraná", 'uf' => "PR", 'codigo' => 4125555],
    		['id' => 4264, 'nome' => "São Mateus do Sul", 'uf' => "PR", 'codigo' => 4125605],
    		['id' => 4265, 'nome' => "São Miguel do Iguaçu", 'uf' => "PR", 'codigo' => 4125704],
    		['id' => 4266, 'nome' => "São Pedro do Iguaçu", 'uf' => "PR", 'codigo' => 4125753],
    		['id' => 4267, 'nome' => "São Pedro do Ivaí", 'uf' => "PR", 'codigo' => 4125803],
    		['id' => 4268, 'nome' => "São Pedro do Paraná", 'uf' => "PR", 'codigo' => 4125902],
    		['id' => 4269, 'nome' => "São Sebastião da Amoreira", 'uf' => "PR", 'codigo' => 4126009],
    		['id' => 4270, 'nome' => "São Tomé", 'uf' => "PR", 'codigo' => 4126108],
    		['id' => 4271, 'nome' => "Sapopema", 'uf' => "PR", 'codigo' => 4126207],
    		['id' => 4272, 'nome' => "Sarandi", 'uf' => "PR", 'codigo' => 4126256],
    		['id' => 4273, 'nome' => "Saudade do Iguaçu", 'uf' => "PR", 'codigo' => 4126272],
    		['id' => 4274, 'nome' => "Sengés", 'uf' => "PR", 'codigo' => 4126306],
    		['id' => 4275, 'nome' => "Serranópolis do Iguaçu", 'uf' => "PR", 'codigo' => 4126355],
    		['id' => 4276, 'nome' => "Sertaneja", 'uf' => "PR", 'codigo' => 4126405],
    		['id' => 4277, 'nome' => "Sertanópolis", 'uf' => "PR", 'codigo' => 4126504],
    		['id' => 4278, 'nome' => "Siqueira Campos", 'uf' => "PR", 'codigo' => 4126603],
    		['id' => 4279, 'nome' => "Sulina", 'uf' => "PR", 'codigo' => 4126652],
    		['id' => 4280, 'nome' => "Tamarana", 'uf' => "PR", 'codigo' => 4126678],
    		['id' => 4281, 'nome' => "Tamboara", 'uf' => "PR", 'codigo' => 4126702],
    		['id' => 4282, 'nome' => "Tapejara", 'uf' => "PR", 'codigo' => 4126801],
    		['id' => 4283, 'nome' => "Tapira", 'uf' => "PR", 'codigo' => 4126900],
    		['id' => 4284, 'nome' => "Teixeira Soares", 'uf' => "PR", 'codigo' => 4127007],
    		['id' => 4285, 'nome' => "Telêmaco Borba", 'uf' => "PR", 'codigo' => 4127106],
    		['id' => 4286, 'nome' => "Terra Boa", 'uf' => "PR", 'codigo' => 4127205],
    		['id' => 4287, 'nome' => "Terra Rica", 'uf' => "PR", 'codigo' => 4127304],
    		['id' => 4288, 'nome' => "Terra Roxa", 'uf' => "PR", 'codigo' => 4127403],
    		['id' => 4289, 'nome' => "Tibagi", 'uf' => "PR", 'codigo' => 4127502],
    		['id' => 4290, 'nome' => "Tijucas do Sul", 'uf' => "PR", 'codigo' => 4127601],
    		['id' => 4291, 'nome' => "Toledo", 'uf' => "PR", 'codigo' => 4127700],
    		['id' => 4292, 'nome' => "Tomazina", 'uf' => "PR", 'codigo' => 4127809],
    		['id' => 4293, 'nome' => "Três Barras do Paraná", 'uf' => "PR", 'codigo' => 4127858],
    		['id' => 4294, 'nome' => "Tunas do Paraná", 'uf' => "PR", 'codigo' => 4127882],
    		['id' => 4295, 'nome' => "Tuneiras do Oeste", 'uf' => "PR", 'codigo' => 4127908],
    		['id' => 4296, 'nome' => "Tupãssi", 'uf' => "PR", 'codigo' => 4127957],
    		['id' => 4297, 'nome' => "Turvo", 'uf' => "PR", 'codigo' => 4127965],
    		['id' => 4298, 'nome' => "Ubiratã", 'uf' => "PR", 'codigo' => 4128005],
    		['id' => 4299, 'nome' => "Umuarama", 'uf' => "PR", 'codigo' => 4128104],
    		['id' => 4300, 'nome' => "União da Vitória", 'uf' => "PR", 'codigo' => 4128203],
    		['id' => 4301, 'nome' => "Uniflor", 'uf' => "PR", 'codigo' => 4128302],
    		['id' => 4302, 'nome' => "Uraí", 'uf' => "PR", 'codigo' => 4128401],
    		['id' => 4303, 'nome' => "Wenceslau Braz", 'uf' => "PR", 'codigo' => 4128500],
    		['id' => 4304, 'nome' => "Ventania", 'uf' => "PR", 'codigo' => 4128534],
    		['id' => 4305, 'nome' => "Vera Cruz do Oeste", 'uf' => "PR", 'codigo' => 4128559],
    		['id' => 4306, 'nome' => "Verê", 'uf' => "PR", 'codigo' => 4128609],
    		['id' => 4307, 'nome' => "Alto Paraíso", 'uf' => "PR", 'codigo' => 4128625],
    		['id' => 4308, 'nome' => "Doutor Ulysses", 'uf' => "PR", 'codigo' => 4128633],
    		['id' => 4309, 'nome' => "Virmond", 'uf' => "PR", 'codigo' => 4128658],
    		['id' => 4310, 'nome' => "Vitorino", 'uf' => "PR", 'codigo' => 4128708],
    		['id' => 4311, 'nome' => "Xambrê", 'uf' => "PR", 'codigo' => 4128807],
    		['id' => 4312, 'nome' => "Abdon Batista", 'uf' => "SC", 'codigo' => 4200051],
    		['id' => 4313, 'nome' => "Abelardo Luz", 'uf' => "SC", 'codigo' => 4200101],
    		['id' => 4314, 'nome' => "Agrolândia", 'uf' => "SC", 'codigo' => 4200200],
    		['id' => 4315, 'nome' => "Agronômica", 'uf' => "SC", 'codigo' => 4200309],
    		['id' => 4316, 'nome' => "Água Doce", 'uf' => "SC", 'codigo' => 4200408],
    		['id' => 4317, 'nome' => "Águas de Chapecó", 'uf' => "SC", 'codigo' => 4200507],
    		['id' => 4318, 'nome' => "Águas Frias", 'uf' => "SC", 'codigo' => 4200556],
    		['id' => 4319, 'nome' => "Águas Mornas", 'uf' => "SC", 'codigo' => 4200606],
    		['id' => 4320, 'nome' => "Alfredo Wagner", 'uf' => "SC", 'codigo' => 4200705],
    		['id' => 4321, 'nome' => "Alto Bela Vista", 'uf' => "SC", 'codigo' => 4200754],
    		['id' => 4322, 'nome' => "Anchieta", 'uf' => "SC", 'codigo' => 4200804],
    		['id' => 4323, 'nome' => "Angelina", 'uf' => "SC", 'codigo' => 4200903],
    		['id' => 4324, 'nome' => "Anita Garibaldi", 'uf' => "SC", 'codigo' => 4201000],
    		['id' => 4325, 'nome' => "Anitápolis", 'uf' => "SC", 'codigo' => 4201109],
    		['id' => 4326, 'nome' => "Antônio Carlos", 'uf' => "SC", 'codigo' => 4201208],
    		['id' => 4327, 'nome' => "Apiúna", 'uf' => "SC", 'codigo' => 4201257],
    		['id' => 4328, 'nome' => "Arabutã", 'uf' => "SC", 'codigo' => 4201273],
    		['id' => 4329, 'nome' => "Araquari", 'uf' => "SC", 'codigo' => 4201307],
    		['id' => 4330, 'nome' => "Araranguá", 'uf' => "SC", 'codigo' => 4201406],
    		['id' => 4331, 'nome' => "Armazém", 'uf' => "SC", 'codigo' => 4201505],
    		['id' => 4332, 'nome' => "Arroio Trinta", 'uf' => "SC", 'codigo' => 4201604],
    		['id' => 4333, 'nome' => "Arvoredo", 'uf' => "SC", 'codigo' => 4201653],
    		['id' => 4334, 'nome' => "Ascurra", 'uf' => "SC", 'codigo' => 4201703],
    		['id' => 4335, 'nome' => "Atalanta", 'uf' => "SC", 'codigo' => 4201802],
    		['id' => 4336, 'nome' => "Aurora", 'uf' => "SC", 'codigo' => 4201901],
    		['id' => 4337, 'nome' => "Balneário Arroio do Silva", 'uf' => "SC", 'codigo' => 4201950],
    		['id' => 4338, 'nome' => "Balneário Camboriú", 'uf' => "SC", 'codigo' => 4202008],
    		['id' => 4339, 'nome' => "Balneário Barra do Sul", 'uf' => "SC", 'codigo' => 4202057],
    		['id' => 4340, 'nome' => "Balneário Gaivota", 'uf' => "SC", 'codigo' => 4202073],
    		['id' => 4341, 'nome' => "Bandeirante", 'uf' => "SC", 'codigo' => 4202081],
    		['id' => 4342, 'nome' => "Barra Bonita", 'uf' => "SC", 'codigo' => 4202099],
    		['id' => 4343, 'nome' => "Barra Velha", 'uf' => "SC", 'codigo' => 4202107],
    		['id' => 4344, 'nome' => "Bela Vista do Toldo", 'uf' => "SC", 'codigo' => 4202131],
    		['id' => 4345, 'nome' => "Belmonte", 'uf' => "SC", 'codigo' => 4202156],
    		['id' => 4346, 'nome' => "Benedito Novo", 'uf' => "SC", 'codigo' => 4202206],
    		['id' => 4347, 'nome' => "Biguaçu", 'uf' => "SC", 'codigo' => 4202305],
    		['id' => 4348, 'nome' => "Blumenau", 'uf' => "SC", 'codigo' => 4202404],
    		['id' => 4349, 'nome' => "Bocaina do Sul", 'uf' => "SC", 'codigo' => 4202438],
    		['id' => 4350, 'nome' => "Bombinhas", 'uf' => "SC", 'codigo' => 4202453],
    		['id' => 4351, 'nome' => "Bom Jardim da Serra", 'uf' => "SC", 'codigo' => 4202503],
    		['id' => 4352, 'nome' => "Bom Jesus", 'uf' => "SC", 'codigo' => 4202537],
    		['id' => 4353, 'nome' => "Bom Jesus do Oeste", 'uf' => "SC", 'codigo' => 4202578],
    		['id' => 4354, 'nome' => "Bom Retiro", 'uf' => "SC", 'codigo' => 4202602],
    		['id' => 4355, 'nome' => "Botuverá", 'uf' => "SC", 'codigo' => 4202701],
    		['id' => 4356, 'nome' => "Braço do Norte", 'uf' => "SC", 'codigo' => 4202800],
    		['id' => 4357, 'nome' => "Braço do Trombudo", 'uf' => "SC", 'codigo' => 4202859],
    		['id' => 4358, 'nome' => "Brunópolis", 'uf' => "SC", 'codigo' => 4202875],
    		['id' => 4359, 'nome' => "Brusque", 'uf' => "SC", 'codigo' => 4202909],
    		['id' => 4360, 'nome' => "Caçador", 'uf' => "SC", 'codigo' => 4203006],
    		['id' => 4361, 'nome' => "Caibi", 'uf' => "SC", 'codigo' => 4203105],
    		['id' => 4362, 'nome' => "Calmon", 'uf' => "SC", 'codigo' => 4203154],
    		['id' => 4363, 'nome' => "Camboriú", 'uf' => "SC", 'codigo' => 4203204],
    		['id' => 4364, 'nome' => "Capão Alto", 'uf' => "SC", 'codigo' => 4203253],
    		['id' => 4365, 'nome' => "Campo Alegre", 'uf' => "SC", 'codigo' => 4203303],
    		['id' => 4366, 'nome' => "Campo Belo do Sul", 'uf' => "SC", 'codigo' => 4203402],
    		['id' => 4367, 'nome' => "Campo Erê", 'uf' => "SC", 'codigo' => 4203501],
    		['id' => 4368, 'nome' => "Campos Novos", 'uf' => "SC", 'codigo' => 4203600],
    		['id' => 4369, 'nome' => "Canelinha", 'uf' => "SC", 'codigo' => 4203709],
    		['id' => 4370, 'nome' => "Canoinhas", 'uf' => "SC", 'codigo' => 4203808],
    		['id' => 4371, 'nome' => "Capinzal", 'uf' => "SC", 'codigo' => 4203907],
    		['id' => 4372, 'nome' => "Capivari de Baixo", 'uf' => "SC", 'codigo' => 4203956],
    		['id' => 4373, 'nome' => "Catanduvas", 'uf' => "SC", 'codigo' => 4204004],
    		['id' => 4374, 'nome' => "Caxambu do Sul", 'uf' => "SC", 'codigo' => 4204103],
    		['id' => 4375, 'nome' => "Celso Ramos", 'uf' => "SC", 'codigo' => 4204152],
    		['id' => 4376, 'nome' => "Cerro Negro", 'uf' => "SC", 'codigo' => 4204178],
    		['id' => 4377, 'nome' => "Chapadão do Lageado", 'uf' => "SC", 'codigo' => 4204194],
    		['id' => 4378, 'nome' => "Chapecó", 'uf' => "SC", 'codigo' => 4204202],
    		['id' => 4379, 'nome' => "Cocal do Sul", 'uf' => "SC", 'codigo' => 4204251],
    		['id' => 4380, 'nome' => "Concórdia", 'uf' => "SC", 'codigo' => 4204301],
    		['id' => 4381, 'nome' => "Cordilheira Alta", 'uf' => "SC", 'codigo' => 4204350],
    		['id' => 4382, 'nome' => "Coronel Freitas", 'uf' => "SC", 'codigo' => 4204400],
    		['id' => 4383, 'nome' => "Coronel Martins", 'uf' => "SC", 'codigo' => 4204459],
    		['id' => 4384, 'nome' => "Corupá", 'uf' => "SC", 'codigo' => 4204509],
    		['id' => 4385, 'nome' => "Correia Pinto", 'uf' => "SC", 'codigo' => 4204558],
    		['id' => 4386, 'nome' => "Criciúma", 'uf' => "SC", 'codigo' => 4204608],
    		['id' => 4387, 'nome' => "Cunha Porã", 'uf' => "SC", 'codigo' => 4204707],
    		['id' => 4388, 'nome' => "Cunhataí", 'uf' => "SC", 'codigo' => 4204756],
    		['id' => 4389, 'nome' => "Curitibanos", 'uf' => "SC", 'codigo' => 4204806],
    		['id' => 4390, 'nome' => "Descanso", 'uf' => "SC", 'codigo' => 4204905],
    		['id' => 4391, 'nome' => "Dionísio Cerqueira", 'uf' => "SC", 'codigo' => 4205001],
    		['id' => 4392, 'nome' => "Dona Emma", 'uf' => "SC", 'codigo' => 4205100],
    		['id' => 4393, 'nome' => "Doutor Pedrinho", 'uf' => "SC", 'codigo' => 4205159],
    		['id' => 4394, 'nome' => "Entre Rios", 'uf' => "SC", 'codigo' => 4205175],
    		['id' => 4395, 'nome' => "Ermo", 'uf' => "SC", 'codigo' => 4205191],
    		['id' => 4396, 'nome' => "Erval Velho", 'uf' => "SC", 'codigo' => 4205209],
    		['id' => 4397, 'nome' => "Faxinal dos Guedes", 'uf' => "SC", 'codigo' => 4205308],
    		['id' => 4398, 'nome' => "Flor do Sertão", 'uf' => "SC", 'codigo' => 4205357],
    		['id' => 4399, 'nome' => "Florianópolis", 'uf' => "SC", 'codigo' => 4205407],
    		['id' => 4400, 'nome' => "Formosa do Sul", 'uf' => "SC", 'codigo' => 4205431],
    		['id' => 4401, 'nome' => "Forquilhinha", 'uf' => "SC", 'codigo' => 4205456],
    		['id' => 4402, 'nome' => "Fraiburgo", 'uf' => "SC", 'codigo' => 4205506],
    		['id' => 4403, 'nome' => "Frei Rogério", 'uf' => "SC", 'codigo' => 4205555],
    		['id' => 4404, 'nome' => "Galvão", 'uf' => "SC", 'codigo' => 4205605],
    		['id' => 4405, 'nome' => "Garopaba", 'uf' => "SC", 'codigo' => 4205704],
    		['id' => 4406, 'nome' => "Garuva", 'uf' => "SC", 'codigo' => 4205803],
    		['id' => 4407, 'nome' => "Gaspar", 'uf' => "SC", 'codigo' => 4205902],
    		['id' => 4408, 'nome' => "Governador Celso Ramos", 'uf' => "SC", 'codigo' => 4206009],
    		['id' => 4409, 'nome' => "Grão Pará", 'uf' => "SC", 'codigo' => 4206108],
    		['id' => 4410, 'nome' => "Gravatal", 'uf' => "SC", 'codigo' => 4206207],
    		['id' => 4411, 'nome' => "Guabiruba", 'uf' => "SC", 'codigo' => 4206306],
    		['id' => 4412, 'nome' => "Guaraciaba", 'uf' => "SC", 'codigo' => 4206405],
    		['id' => 4413, 'nome' => "Guaramirim", 'uf' => "SC", 'codigo' => 4206504],
    		['id' => 4414, 'nome' => "Guarujá do Sul", 'uf' => "SC", 'codigo' => 4206603],
    		['id' => 4415, 'nome' => "Guatambú", 'uf' => "SC", 'codigo' => 4206652],
    		['id' => 4416, 'nome' => "Herval D'Oeste", 'uf' => "SC", 'codigo' => 4206702],
    		['id' => 4417, 'nome' => "Ibiam", 'uf' => "SC", 'codigo' => 4206751],
    		['id' => 4418, 'nome' => "Ibicaré", 'uf' => "SC", 'codigo' => 4206801],
    		['id' => 4419, 'nome' => "Ibirama", 'uf' => "SC", 'codigo' => 4206900],
    		['id' => 4420, 'nome' => "Içara", 'uf' => "SC", 'codigo' => 4207007],
    		['id' => 4421, 'nome' => "Ilhota", 'uf' => "SC", 'codigo' => 4207106],
    		['id' => 4422, 'nome' => "Imaruí", 'uf' => "SC", 'codigo' => 4207205],
    		['id' => 4423, 'nome' => "Imbituba", 'uf' => "SC", 'codigo' => 4207304],
    		['id' => 4424, 'nome' => "Imbuia", 'uf' => "SC", 'codigo' => 4207403],
    		['id' => 4425, 'nome' => "Indaial", 'uf' => "SC", 'codigo' => 4207502],
    		['id' => 4426, 'nome' => "Iomerê", 'uf' => "SC", 'codigo' => 4207577],
    		['id' => 4427, 'nome' => "Ipira", 'uf' => "SC", 'codigo' => 4207601],
    		['id' => 4428, 'nome' => "Iporã do Oeste", 'uf' => "SC", 'codigo' => 4207650],
    		['id' => 4429, 'nome' => "Ipuaçu", 'uf' => "SC", 'codigo' => 4207684],
    		['id' => 4430, 'nome' => "Ipumirim", 'uf' => "SC", 'codigo' => 4207700],
    		['id' => 4431, 'nome' => "Iraceminha", 'uf' => "SC", 'codigo' => 4207759],
    		['id' => 4432, 'nome' => "Irani", 'uf' => "SC", 'codigo' => 4207809],
    		['id' => 4433, 'nome' => "Irati", 'uf' => "SC", 'codigo' => 4207858],
    		['id' => 4434, 'nome' => "Irineópolis", 'uf' => "SC", 'codigo' => 4207908],
    		['id' => 4435, 'nome' => "Itá", 'uf' => "SC", 'codigo' => 4208005],
    		['id' => 4436, 'nome' => "Itaiópolis", 'uf' => "SC", 'codigo' => 4208104],
    		['id' => 4437, 'nome' => "Itajaí", 'uf' => "SC", 'codigo' => 4208203],
    		['id' => 4438, 'nome' => "Itapema", 'uf' => "SC", 'codigo' => 4208302],
    		['id' => 4439, 'nome' => "Itapiranga", 'uf' => "SC", 'codigo' => 4208401],
    		['id' => 4440, 'nome' => "Itapoá", 'uf' => "SC", 'codigo' => 4208450],
    		['id' => 4441, 'nome' => "Ituporanga", 'uf' => "SC", 'codigo' => 4208500],
    		['id' => 4442, 'nome' => "Jaborá", 'uf' => "SC", 'codigo' => 4208609],
    		['id' => 4443, 'nome' => "Jacinto Machado", 'uf' => "SC", 'codigo' => 4208708],
    		['id' => 4444, 'nome' => "Jaguaruna", 'uf' => "SC", 'codigo' => 4208807],
    		['id' => 4445, 'nome' => "Jaraguá do Sul", 'uf' => "SC", 'codigo' => 4208906],
    		['id' => 4446, 'nome' => "Jardinópolis", 'uf' => "SC", 'codigo' => 4208955],
    		['id' => 4447, 'nome' => "Joaçaba", 'uf' => "SC", 'codigo' => 4209003],
    		['id' => 4448, 'nome' => "Joinville", 'uf' => "SC", 'codigo' => 4209102],
    		['id' => 4449, 'nome' => "José Boiteux", 'uf' => "SC", 'codigo' => 4209151],
    		['id' => 4450, 'nome' => "Jupiá", 'uf' => "SC", 'codigo' => 4209177],
    		['id' => 4451, 'nome' => "Lacerdópolis", 'uf' => "SC", 'codigo' => 4209201],
    		['id' => 4452, 'nome' => "Lages", 'uf' => "SC", 'codigo' => 4209300],
    		['id' => 4453, 'nome' => "Laguna", 'uf' => "SC", 'codigo' => 4209409],
    		['id' => 4454, 'nome' => "Lajeado Grande", 'uf' => "SC", 'codigo' => 4209458],
    		['id' => 4455, 'nome' => "Laurentino", 'uf' => "SC", 'codigo' => 4209508],
    		['id' => 4456, 'nome' => "Lauro Muller", 'uf' => "SC", 'codigo' => 4209607],
    		['id' => 4457, 'nome' => "Lebon Régis", 'uf' => "SC", 'codigo' => 4209706],
    		['id' => 4458, 'nome' => "Leoberto Leal", 'uf' => "SC", 'codigo' => 4209805],
    		['id' => 4459, 'nome' => "Lindóia do Sul", 'uf' => "SC", 'codigo' => 4209854],
    		['id' => 4460, 'nome' => "Lontras", 'uf' => "SC", 'codigo' => 4209904],
    		['id' => 4461, 'nome' => "Luiz Alves", 'uf' => "SC", 'codigo' => 4210001],
    		['id' => 4462, 'nome' => "Luzerna", 'uf' => "SC", 'codigo' => 4210035],
    		['id' => 4463, 'nome' => "Macieira", 'uf' => "SC", 'codigo' => 4210050],
    		['id' => 4464, 'nome' => "Mafra", 'uf' => "SC", 'codigo' => 4210100],
    		['id' => 4465, 'nome' => "Major Gercino", 'uf' => "SC", 'codigo' => 4210209],
    		['id' => 4466, 'nome' => "Major Vieira", 'uf' => "SC", 'codigo' => 4210308],
    		['id' => 4467, 'nome' => "Maracajá", 'uf' => "SC", 'codigo' => 4210407],
    		['id' => 4468, 'nome' => "Maravilha", 'uf' => "SC", 'codigo' => 4210506],
    		['id' => 4469, 'nome' => "Marema", 'uf' => "SC", 'codigo' => 4210555],
    		['id' => 4470, 'nome' => "Massaranduba", 'uf' => "SC", 'codigo' => 4210605],
    		['id' => 4471, 'nome' => "Matos Costa", 'uf' => "SC", 'codigo' => 4210704],
    		['id' => 4472, 'nome' => "Meleiro", 'uf' => "SC", 'codigo' => 4210803],
    		['id' => 4473, 'nome' => "Mirim Doce", 'uf' => "SC", 'codigo' => 4210852],
    		['id' => 4474, 'nome' => "Modelo", 'uf' => "SC", 'codigo' => 4210902],
    		['id' => 4475, 'nome' => "Mondaí", 'uf' => "SC", 'codigo' => 4211009],
    		['id' => 4476, 'nome' => "Monte Carlo", 'uf' => "SC", 'codigo' => 4211058],
    		['id' => 4477, 'nome' => "Monte Castelo", 'uf' => "SC", 'codigo' => 4211108],
    		['id' => 4478, 'nome' => "Morro da Fumaça", 'uf' => "SC", 'codigo' => 4211207],
    		['id' => 4479, 'nome' => "Morro Grande", 'uf' => "SC", 'codigo' => 4211256],
    		['id' => 4480, 'nome' => "Navegantes", 'uf' => "SC", 'codigo' => 4211306],
    		['id' => 4481, 'nome' => "Nova Erechim", 'uf' => "SC", 'codigo' => 4211405],
    		['id' => 4482, 'nome' => "Nova Itaberaba", 'uf' => "SC", 'codigo' => 4211454],
    		['id' => 4483, 'nome' => "Nova Trento", 'uf' => "SC", 'codigo' => 4211504],
    		['id' => 4484, 'nome' => "Nova Veneza", 'uf' => "SC", 'codigo' => 4211603],
    		['id' => 4485, 'nome' => "Novo Horizonte", 'uf' => "SC", 'codigo' => 4211652],
    		['id' => 4486, 'nome' => "Orleans", 'uf' => "SC", 'codigo' => 4211702],
    		['id' => 4487, 'nome' => "Otacílio Costa", 'uf' => "SC", 'codigo' => 4211751],
    		['id' => 4488, 'nome' => "Ouro", 'uf' => "SC", 'codigo' => 4211801],
    		['id' => 4489, 'nome' => "Ouro Verde", 'uf' => "SC", 'codigo' => 4211850],
    		['id' => 4490, 'nome' => "Paial", 'uf' => "SC", 'codigo' => 4211876],
    		['id' => 4491, 'nome' => "Painel", 'uf' => "SC", 'codigo' => 4211892],
    		['id' => 4492, 'nome' => "Palhoça", 'uf' => "SC", 'codigo' => 4211900],
    		['id' => 4493, 'nome' => "Palma Sola", 'uf' => "SC", 'codigo' => 4212007],
    		['id' => 4494, 'nome' => "Palmeira", 'uf' => "SC", 'codigo' => 4212056],
    		['id' => 4495, 'nome' => "Palmitos", 'uf' => "SC", 'codigo' => 4212106],
    		['id' => 4496, 'nome' => "Papanduva", 'uf' => "SC", 'codigo' => 4212205],
    		['id' => 4497, 'nome' => "Paraíso", 'uf' => "SC", 'codigo' => 4212239],
    		['id' => 4498, 'nome' => "Passo de Torres", 'uf' => "SC", 'codigo' => 4212254],
    		['id' => 4499, 'nome' => "Passos Maia", 'uf' => "SC", 'codigo' => 4212270],
    		['id' => 4500, 'nome' => "Paulo Lopes", 'uf' => "SC", 'codigo' => 4212304],
    		['id' => 4501, 'nome' => "Pedras Grandes", 'uf' => "SC", 'codigo' => 4212403],
    		['id' => 4502, 'nome' => "Penha", 'uf' => "SC", 'codigo' => 4212502],
    		['id' => 4503, 'nome' => "Peritiba", 'uf' => "SC", 'codigo' => 4212601],
    		['id' => 4504, 'nome' => "Pescaria Brava", 'uf' => "SC", 'codigo' => 4212650],
    		['id' => 4505, 'nome' => "Petrolândia", 'uf' => "SC", 'codigo' => 4212700],
    		['id' => 4506, 'nome' => "Balneário Piçarras", 'uf' => "SC", 'codigo' => 4212809],
    		['id' => 4507, 'nome' => "Pinhalzinho", 'uf' => "SC", 'codigo' => 4212908],
    		['id' => 4508, 'nome' => "Pinheiro Preto", 'uf' => "SC", 'codigo' => 4213005],
    		['id' => 4509, 'nome' => "Piratuba", 'uf' => "SC", 'codigo' => 4213104],
    		['id' => 4510, 'nome' => "Planalto Alegre", 'uf' => "SC", 'codigo' => 4213153],
    		['id' => 4511, 'nome' => "Pomerode", 'uf' => "SC", 'codigo' => 4213203],
    		['id' => 4512, 'nome' => "Ponte Alta", 'uf' => "SC", 'codigo' => 4213302],
    		['id' => 4513, 'nome' => "Ponte Alta do Norte", 'uf' => "SC", 'codigo' => 4213351],
    		['id' => 4514, 'nome' => "Ponte Serrada", 'uf' => "SC", 'codigo' => 4213401],
    		['id' => 4515, 'nome' => "Porto Belo", 'uf' => "SC", 'codigo' => 4213500],
    		['id' => 4516, 'nome' => "Porto União", 'uf' => "SC", 'codigo' => 4213609],
    		['id' => 4517, 'nome' => "Pouso Redondo", 'uf' => "SC", 'codigo' => 4213708],
    		['id' => 4518, 'nome' => "Praia Grande", 'uf' => "SC", 'codigo' => 4213807],
    		['id' => 4519, 'nome' => "Presidente Castello Branco", 'uf' => "SC", 'codigo' => 4213906],
    		['id' => 4520, 'nome' => "Presidente Getúlio", 'uf' => "SC", 'codigo' => 4214003],
    		['id' => 4521, 'nome' => "Presidente Nereu", 'uf' => "SC", 'codigo' => 4214102],
    		['id' => 4522, 'nome' => "Princesa", 'uf' => "SC", 'codigo' => 4214151],
    		['id' => 4523, 'nome' => "Quilombo", 'uf' => "SC", 'codigo' => 4214201],
    		['id' => 4524, 'nome' => "Rancho Queimado", 'uf' => "SC", 'codigo' => 4214300],
    		['id' => 4525, 'nome' => "Rio das Antas", 'uf' => "SC", 'codigo' => 4214409],
    		['id' => 4526, 'nome' => "Rio do Campo", 'uf' => "SC", 'codigo' => 4214508],
    		['id' => 4527, 'nome' => "Rio do Oeste", 'uf' => "SC", 'codigo' => 4214607],
    		['id' => 4528, 'nome' => "Rio dos Cedros", 'uf' => "SC", 'codigo' => 4214706],
    		['id' => 4529, 'nome' => "Rio do Sul", 'uf' => "SC", 'codigo' => 4214805],
    		['id' => 4530, 'nome' => "Rio Fortuna", 'uf' => "SC", 'codigo' => 4214904],
    		['id' => 4531, 'nome' => "Rio Negrinho", 'uf' => "SC", 'codigo' => 4215000],
    		['id' => 4532, 'nome' => "Rio Rufino", 'uf' => "SC", 'codigo' => 4215059],
    		['id' => 4533, 'nome' => "Riqueza", 'uf' => "SC", 'codigo' => 4215075],
    		['id' => 4534, 'nome' => "Rodeio", 'uf' => "SC", 'codigo' => 4215109],
    		['id' => 4535, 'nome' => "Romelândia", 'uf' => "SC", 'codigo' => 4215208],
    		['id' => 4536, 'nome' => "Salete", 'uf' => "SC", 'codigo' => 4215307],
    		['id' => 4537, 'nome' => "Saltinho", 'uf' => "SC", 'codigo' => 4215356],
    		['id' => 4538, 'nome' => "Salto Veloso", 'uf' => "SC", 'codigo' => 4215406],
    		['id' => 4539, 'nome' => "Sangão", 'uf' => "SC", 'codigo' => 4215455],
    		['id' => 4540, 'nome' => "Santa Cecília", 'uf' => "SC", 'codigo' => 4215505],
    		['id' => 4541, 'nome' => "Santa Helena", 'uf' => "SC", 'codigo' => 4215554],
    		['id' => 4542, 'nome' => "Santa Rosa de Lima", 'uf' => "SC", 'codigo' => 4215604],
    		['id' => 4543, 'nome' => "Santa Rosa do Sul", 'uf' => "SC", 'codigo' => 4215653],
    		['id' => 4544, 'nome' => "Santa Terezinha", 'uf' => "SC", 'codigo' => 4215679],
    		['id' => 4545, 'nome' => "Santa Terezinha do Progresso", 'uf' => "SC", 'codigo' => 4215687],
    		['id' => 4546, 'nome' => "Santiago do Sul", 'uf' => "SC", 'codigo' => 4215695],
    		['id' => 4547, 'nome' => "Santo Amaro da Imperatriz", 'uf' => "SC", 'codigo' => 4215703],
    		['id' => 4548, 'nome' => "São Bernardino", 'uf' => "SC", 'codigo' => 4215752],
    		['id' => 4549, 'nome' => "São Bento do Sul", 'uf' => "SC", 'codigo' => 4215802],
    		['id' => 4550, 'nome' => "São Bonifácio", 'uf' => "SC", 'codigo' => 4215901],
    		['id' => 4551, 'nome' => "São Carlos", 'uf' => "SC", 'codigo' => 4216008],
    		['id' => 4552, 'nome' => "São Cristovão do Sul", 'uf' => "SC", 'codigo' => 4216057],
    		['id' => 4553, 'nome' => "São Domingos", 'uf' => "SC", 'codigo' => 4216107],
    		['id' => 4554, 'nome' => "São Francisco do Sul", 'uf' => "SC", 'codigo' => 4216206],
    		['id' => 4555, 'nome' => "São João do Oeste", 'uf' => "SC", 'codigo' => 4216255],
    		['id' => 4556, 'nome' => "São João Batista", 'uf' => "SC", 'codigo' => 4216305],
    		['id' => 4557, 'nome' => "São João do Itaperiú", 'uf' => "SC", 'codigo' => 4216354],
    		['id' => 4558, 'nome' => "São João do Sul", 'uf' => "SC", 'codigo' => 4216404],
    		['id' => 4559, 'nome' => "São Joaquim", 'uf' => "SC", 'codigo' => 4216503],
    		['id' => 4560, 'nome' => "São José", 'uf' => "SC", 'codigo' => 4216602],
    		['id' => 4561, 'nome' => "São José do Cedro", 'uf' => "SC", 'codigo' => 4216701],
    		['id' => 4562, 'nome' => "São José do Cerrito", 'uf' => "SC", 'codigo' => 4216800],
    		['id' => 4563, 'nome' => "São Lourenço do Oeste", 'uf' => "SC", 'codigo' => 4216909],
    		['id' => 4564, 'nome' => "São Ludgero", 'uf' => "SC", 'codigo' => 4217006],
    		['id' => 4565, 'nome' => "São Martinho", 'uf' => "SC", 'codigo' => 4217105],
    		['id' => 4566, 'nome' => "São Miguel da Boa Vista", 'uf' => "SC", 'codigo' => 4217154],
    		['id' => 4567, 'nome' => "São Miguel do Oeste", 'uf' => "SC", 'codigo' => 4217204],
    		['id' => 4568, 'nome' => "São Pedro de Alcântara", 'uf' => "SC", 'codigo' => 4217253],
    		['id' => 4569, 'nome' => "Saudades", 'uf' => "SC", 'codigo' => 4217303],
    		['id' => 4570, 'nome' => "Schroeder", 'uf' => "SC", 'codigo' => 4217402],
    		['id' => 4571, 'nome' => "Seara", 'uf' => "SC", 'codigo' => 4217501],
    		['id' => 4572, 'nome' => "Serra Alta", 'uf' => "SC", 'codigo' => 4217550],
    		['id' => 4573, 'nome' => "Siderópolis", 'uf' => "SC", 'codigo' => 4217600],
    		['id' => 4574, 'nome' => "Sombrio", 'uf' => "SC", 'codigo' => 4217709],
    		['id' => 4575, 'nome' => "Sul Brasil", 'uf' => "SC", 'codigo' => 4217758],
    		['id' => 4576, 'nome' => "Taió", 'uf' => "SC", 'codigo' => 4217808],
    		['id' => 4577, 'nome' => "Tangará", 'uf' => "SC", 'codigo' => 4217907],
    		['id' => 4578, 'nome' => "Tigrinhos", 'uf' => "SC", 'codigo' => 4217956],
    		['id' => 4579, 'nome' => "Tijucas", 'uf' => "SC", 'codigo' => 4218004],
    		['id' => 4580, 'nome' => "Timbé do Sul", 'uf' => "SC", 'codigo' => 4218103],
    		['id' => 4581, 'nome' => "Timbó", 'uf' => "SC", 'codigo' => 4218202],
    		['id' => 4582, 'nome' => "Timbó Grande", 'uf' => "SC", 'codigo' => 4218251],
    		['id' => 4583, 'nome' => "Três Barras", 'uf' => "SC", 'codigo' => 4218301],
    		['id' => 4584, 'nome' => "Treviso", 'uf' => "SC", 'codigo' => 4218350],
    		['id' => 4585, 'nome' => "Treze de Maio", 'uf' => "SC", 'codigo' => 4218400],
    		['id' => 4586, 'nome' => "Treze Tílias", 'uf' => "SC", 'codigo' => 4218509],
    		['id' => 4587, 'nome' => "Trombudo Central", 'uf' => "SC", 'codigo' => 4218608],
    		['id' => 4588, 'nome' => "Tubarão", 'uf' => "SC", 'codigo' => 4218707],
    		['id' => 4589, 'nome' => "Tunápolis", 'uf' => "SC", 'codigo' => 4218756],
    		['id' => 4590, 'nome' => "Turvo", 'uf' => "SC", 'codigo' => 4218806],
    		['id' => 4591, 'nome' => "União do Oeste", 'uf' => "SC", 'codigo' => 4218855],
    		['id' => 4592, 'nome' => "Urubici", 'uf' => "SC", 'codigo' => 4218905],
    		['id' => 4593, 'nome' => "Urupema", 'uf' => "SC", 'codigo' => 4218954],
    		['id' => 4594, 'nome' => "Urussanga", 'uf' => "SC", 'codigo' => 4219002],
    		['id' => 4595, 'nome' => "Vargeão", 'uf' => "SC", 'codigo' => 4219101],
    		['id' => 4596, 'nome' => "Vargem", 'uf' => "SC", 'codigo' => 4219150],
    		['id' => 4597, 'nome' => "Vargem Bonita", 'uf' => "SC", 'codigo' => 4219176],
    		['id' => 4598, 'nome' => "Vidal Ramos", 'uf' => "SC", 'codigo' => 4219200],
    		['id' => 4599, 'nome' => "Videira", 'uf' => "SC", 'codigo' => 4219309],
    		['id' => 4600, 'nome' => "Vitor Meireles", 'uf' => "SC", 'codigo' => 4219358],
    		['id' => 4601, 'nome' => "Witmarsum", 'uf' => "SC", 'codigo' => 4219408],
    		['id' => 4602, 'nome' => "Xanxerê", 'uf' => "SC", 'codigo' => 4219507],
    		['id' => 4603, 'nome' => "Xavantina", 'uf' => "SC", 'codigo' => 4219606],
    		['id' => 4604, 'nome' => "Xaxim", 'uf' => "SC", 'codigo' => 4219705],
    		['id' => 4605, 'nome' => "Zortéa", 'uf' => "SC", 'codigo' => 4219853],
    		['id' => 4606, 'nome' => "Balneário Rincão", 'uf' => "SC", 'codigo' => 4220000],
    		['id' => 4607, 'nome' => "Aceguá", 'uf' => "RS", 'codigo' => 4300034],
    		['id' => 4608, 'nome' => "Água Santa", 'uf' => "RS", 'codigo' => 4300059],
    		['id' => 4609, 'nome' => "Agudo", 'uf' => "RS", 'codigo' => 4300109],
    		['id' => 4610, 'nome' => "Ajuricaba", 'uf' => "RS", 'codigo' => 4300208],
    		['id' => 4611, 'nome' => "Alecrim", 'uf' => "RS", 'codigo' => 4300307],
    		['id' => 4612, 'nome' => "Alegrete", 'uf' => "RS", 'codigo' => 4300406],
    		['id' => 4613, 'nome' => "Alegria", 'uf' => "RS", 'codigo' => 4300455],
    		['id' => 4614, 'nome' => "Almirante Tamandaré do Sul", 'uf' => "RS", 'codigo' => 4300471],
    		['id' => 4615, 'nome' => "Alpestre", 'uf' => "RS", 'codigo' => 4300505],
    		['id' => 4616, 'nome' => "Alto Alegre", 'uf' => "RS", 'codigo' => 4300554],
    		['id' => 4617, 'nome' => "Alto Feliz", 'uf' => "RS", 'codigo' => 4300570],
    		['id' => 4618, 'nome' => "Alvorada", 'uf' => "RS", 'codigo' => 4300604],
    		['id' => 4619, 'nome' => "Amaral Ferrador", 'uf' => "RS", 'codigo' => 4300638],
    		['id' => 4620, 'nome' => "Ametista do Sul", 'uf' => "RS", 'codigo' => 4300646],
    		['id' => 4621, 'nome' => "André da Rocha", 'uf' => "RS", 'codigo' => 4300661],
    		['id' => 4622, 'nome' => "Anta Gorda", 'uf' => "RS", 'codigo' => 4300703],
    		['id' => 4623, 'nome' => "Antônio Prado", 'uf' => "RS", 'codigo' => 4300802],
    		['id' => 4624, 'nome' => "Arambaré", 'uf' => "RS", 'codigo' => 4300851],
    		['id' => 4625, 'nome' => "Araricá", 'uf' => "RS", 'codigo' => 4300877],
    		['id' => 4626, 'nome' => "Aratiba", 'uf' => "RS", 'codigo' => 4300901],
    		['id' => 4627, 'nome' => "Arroio do Meio", 'uf' => "RS", 'codigo' => 4301008],
    		['id' => 4628, 'nome' => "Arroio do Sal", 'uf' => "RS", 'codigo' => 4301057],
    		['id' => 4629, 'nome' => "Arroio do Padre", 'uf' => "RS", 'codigo' => 4301073],
    		['id' => 4630, 'nome' => "Arroio dos Ratos", 'uf' => "RS", 'codigo' => 4301107],
    		['id' => 4631, 'nome' => "Arroio do Tigre", 'uf' => "RS", 'codigo' => 4301206],
    		['id' => 4632, 'nome' => "Arroio Grande", 'uf' => "RS", 'codigo' => 4301305],
    		['id' => 4633, 'nome' => "Arvorezinha", 'uf' => "RS", 'codigo' => 4301404],
    		['id' => 4634, 'nome' => "Augusto Pestana", 'uf' => "RS", 'codigo' => 4301503],
    		['id' => 4635, 'nome' => "Áurea", 'uf' => "RS", 'codigo' => 4301552],
    		['id' => 4636, 'nome' => "Bagé", 'uf' => "RS", 'codigo' => 4301602],
    		['id' => 4637, 'nome' => "Balneário Pinhal", 'uf' => "RS", 'codigo' => 4301636],
    		['id' => 4638, 'nome' => "Barão", 'uf' => "RS", 'codigo' => 4301651],
    		['id' => 4639, 'nome' => "Barão de Cotegipe", 'uf' => "RS", 'codigo' => 4301701],
    		['id' => 4640, 'nome' => "Barão do Triunfo", 'uf' => "RS", 'codigo' => 4301750],
    		['id' => 4641, 'nome' => "Barracão", 'uf' => "RS", 'codigo' => 4301800],
    		['id' => 4642, 'nome' => "Barra do Guarita", 'uf' => "RS", 'codigo' => 4301859],
    		['id' => 4643, 'nome' => "Barra do Quaraí", 'uf' => "RS", 'codigo' => 4301875],
    		['id' => 4644, 'nome' => "Barra do Ribeiro", 'uf' => "RS", 'codigo' => 4301909],
    		['id' => 4645, 'nome' => "Barra do Rio Azul", 'uf' => "RS", 'codigo' => 4301925],
    		['id' => 4646, 'nome' => "Barra Funda", 'uf' => "RS", 'codigo' => 4301958],
    		['id' => 4647, 'nome' => "Barros Cassal", 'uf' => "RS", 'codigo' => 4302006],
    		['id' => 4648, 'nome' => "Benjamin Constant do Sul", 'uf' => "RS", 'codigo' => 4302055],
    		['id' => 4649, 'nome' => "Bento Gonçalves", 'uf' => "RS", 'codigo' => 4302105],
    		['id' => 4650, 'nome' => "Boa Vista das Missões", 'uf' => "RS", 'codigo' => 4302154],
    		['id' => 4651, 'nome' => "Boa Vista do Buricá", 'uf' => "RS", 'codigo' => 4302204],
    		['id' => 4652, 'nome' => "Boa Vista do Cadeado", 'uf' => "RS", 'codigo' => 4302220],
    		['id' => 4653, 'nome' => "Boa Vista do Incra", 'uf' => "RS", 'codigo' => 4302238],
    		['id' => 4654, 'nome' => "Boa Vista do Sul", 'uf' => "RS", 'codigo' => 4302253],
    		['id' => 4655, 'nome' => "Bom Jesus", 'uf' => "RS", 'codigo' => 4302303],
    		['id' => 4656, 'nome' => "Bom Princípio", 'uf' => "RS", 'codigo' => 4302352],
    		['id' => 4657, 'nome' => "Bom Progresso", 'uf' => "RS", 'codigo' => 4302378],
    		['id' => 4658, 'nome' => "Bom Retiro do Sul", 'uf' => "RS", 'codigo' => 4302402],
    		['id' => 4659, 'nome' => "Boqueirão do Leão", 'uf' => "RS", 'codigo' => 4302451],
    		['id' => 4660, 'nome' => "Bossoroca", 'uf' => "RS", 'codigo' => 4302501],
    		['id' => 4661, 'nome' => "Bozano", 'uf' => "RS", 'codigo' => 4302584],
    		['id' => 4662, 'nome' => "Braga", 'uf' => "RS", 'codigo' => 4302600],
    		['id' => 4663, 'nome' => "Brochier", 'uf' => "RS", 'codigo' => 4302659],
    		['id' => 4664, 'nome' => "Butiá", 'uf' => "RS", 'codigo' => 4302709],
    		['id' => 4665, 'nome' => "Caçapava do Sul", 'uf' => "RS", 'codigo' => 4302808],
    		['id' => 4666, 'nome' => "Cacequi", 'uf' => "RS", 'codigo' => 4302907],
    		['id' => 4667, 'nome' => "Cachoeira do Sul", 'uf' => "RS", 'codigo' => 4303004],
    		['id' => 4668, 'nome' => "Cachoeirinha", 'uf' => "RS", 'codigo' => 4303103],
    		['id' => 4669, 'nome' => "Cacique Doble", 'uf' => "RS", 'codigo' => 4303202],
    		['id' => 4670, 'nome' => "Caibaté", 'uf' => "RS", 'codigo' => 4303301],
    		['id' => 4671, 'nome' => "Caiçara", 'uf' => "RS", 'codigo' => 4303400],
    		['id' => 4672, 'nome' => "Camaquã", 'uf' => "RS", 'codigo' => 4303509],
    		['id' => 4673, 'nome' => "Camargo", 'uf' => "RS", 'codigo' => 4303558],
    		['id' => 4674, 'nome' => "Cambará do Sul", 'uf' => "RS", 'codigo' => 4303608],
    		['id' => 4675, 'nome' => "Campestre da Serra", 'uf' => "RS", 'codigo' => 4303673],
    		['id' => 4676, 'nome' => "Campina das Missões", 'uf' => "RS", 'codigo' => 4303707],
    		['id' => 4677, 'nome' => "Campinas do Sul", 'uf' => "RS", 'codigo' => 4303806],
    		['id' => 4678, 'nome' => "Campo Bom", 'uf' => "RS", 'codigo' => 4303905],
    		['id' => 4679, 'nome' => "Campo Novo", 'uf' => "RS", 'codigo' => 4304002],
    		['id' => 4680, 'nome' => "Campos Borges", 'uf' => "RS", 'codigo' => 4304101],
    		['id' => 4681, 'nome' => "Candelária", 'uf' => "RS", 'codigo' => 4304200],
    		['id' => 4682, 'nome' => "Cândido Godói", 'uf' => "RS", 'codigo' => 4304309],
    		['id' => 4683, 'nome' => "Candiota", 'uf' => "RS", 'codigo' => 4304358],
    		['id' => 4684, 'nome' => "Canela", 'uf' => "RS", 'codigo' => 4304408],
    		['id' => 4685, 'nome' => "Canguçu", 'uf' => "RS", 'codigo' => 4304507],
    		['id' => 4686, 'nome' => "Canoas", 'uf' => "RS", 'codigo' => 4304606],
    		['id' => 4687, 'nome' => "Canudos do Vale", 'uf' => "RS", 'codigo' => 4304614],
    		['id' => 4688, 'nome' => "Capão Bonito do Sul", 'uf' => "RS", 'codigo' => 4304622],
    		['id' => 4689, 'nome' => "Capão da Canoa", 'uf' => "RS", 'codigo' => 4304630],
    		['id' => 4690, 'nome' => "Capão do Cipó", 'uf' => "RS", 'codigo' => 4304655],
    		['id' => 4691, 'nome' => "Capão do Leão", 'uf' => "RS", 'codigo' => 4304663],
    		['id' => 4692, 'nome' => "Capivari do Sul", 'uf' => "RS", 'codigo' => 4304671],
    		['id' => 4693, 'nome' => "Capela de Santana", 'uf' => "RS", 'codigo' => 4304689],
    		['id' => 4694, 'nome' => "Capitão", 'uf' => "RS", 'codigo' => 4304697],
    		['id' => 4695, 'nome' => "Carazinho", 'uf' => "RS", 'codigo' => 4304705],
    		['id' => 4696, 'nome' => "Caraá", 'uf' => "RS", 'codigo' => 4304713],
    		['id' => 4697, 'nome' => "Carlos Barbosa", 'uf' => "RS", 'codigo' => 4304804],
    		['id' => 4698, 'nome' => "Carlos Gomes", 'uf' => "RS", 'codigo' => 4304853],
    		['id' => 4699, 'nome' => "Casca", 'uf' => "RS", 'codigo' => 4304903],
    		['id' => 4700, 'nome' => "Caseiros", 'uf' => "RS", 'codigo' => 4304952],
    		['id' => 4701, 'nome' => "Catuípe", 'uf' => "RS", 'codigo' => 4305009],
    		['id' => 4702, 'nome' => "Caxias do Sul", 'uf' => "RS", 'codigo' => 4305108],
    		['id' => 4703, 'nome' => "Centenário", 'uf' => "RS", 'codigo' => 4305116],
    		['id' => 4704, 'nome' => "Cerrito", 'uf' => "RS", 'codigo' => 4305124],
    		['id' => 4705, 'nome' => "Cerro Branco", 'uf' => "RS", 'codigo' => 4305132],
    		['id' => 4706, 'nome' => "Cerro Grande", 'uf' => "RS", 'codigo' => 4305157],
    		['id' => 4707, 'nome' => "Cerro Grande do Sul", 'uf' => "RS", 'codigo' => 4305173],
    		['id' => 4708, 'nome' => "Cerro Largo", 'uf' => "RS", 'codigo' => 4305207],
    		['id' => 4709, 'nome' => "Chapada", 'uf' => "RS", 'codigo' => 4305306],
    		['id' => 4710, 'nome' => "Charqueadas", 'uf' => "RS", 'codigo' => 4305355],
    		['id' => 4711, 'nome' => "Charrua", 'uf' => "RS", 'codigo' => 4305371],
    		['id' => 4712, 'nome' => "Chiapetta", 'uf' => "RS", 'codigo' => 4305405],
    		['id' => 4713, 'nome' => "Chuí", 'uf' => "RS", 'codigo' => 4305439],
    		['id' => 4714, 'nome' => "Chuvisca", 'uf' => "RS", 'codigo' => 4305447],
    		['id' => 4715, 'nome' => "Cidreira", 'uf' => "RS", 'codigo' => 4305454],
    		['id' => 4716, 'nome' => "Ciríaco", 'uf' => "RS", 'codigo' => 4305504],
    		['id' => 4717, 'nome' => "Colinas", 'uf' => "RS", 'codigo' => 4305587],
    		['id' => 4718, 'nome' => "Colorado", 'uf' => "RS", 'codigo' => 4305603],
    		['id' => 4719, 'nome' => "Condor", 'uf' => "RS", 'codigo' => 4305702],
    		['id' => 4720, 'nome' => "Constantina", 'uf' => "RS", 'codigo' => 4305801],
    		['id' => 4721, 'nome' => "Coqueiro Baixo", 'uf' => "RS", 'codigo' => 4305835],
    		['id' => 4722, 'nome' => "Coqueiros do Sul", 'uf' => "RS", 'codigo' => 4305850],
    		['id' => 4723, 'nome' => "Coronel Barros", 'uf' => "RS", 'codigo' => 4305871],
    		['id' => 4724, 'nome' => "Coronel Bicaco", 'uf' => "RS", 'codigo' => 4305900],
    		['id' => 4725, 'nome' => "Coronel Pilar", 'uf' => "RS", 'codigo' => 4305934],
    		['id' => 4726, 'nome' => "Cotiporã", 'uf' => "RS", 'codigo' => 4305959],
    		['id' => 4727, 'nome' => "Coxilha", 'uf' => "RS", 'codigo' => 4305975],
    		['id' => 4728, 'nome' => "Crissiumal", 'uf' => "RS", 'codigo' => 4306007],
    		['id' => 4729, 'nome' => "Cristal", 'uf' => "RS", 'codigo' => 4306056],
    		['id' => 4730, 'nome' => "Cristal do Sul", 'uf' => "RS", 'codigo' => 4306072],
    		['id' => 4731, 'nome' => "Cruz Alta", 'uf' => "RS", 'codigo' => 4306106],
    		['id' => 4732, 'nome' => "Cruzaltense", 'uf' => "RS", 'codigo' => 4306130],
    		['id' => 4733, 'nome' => "Cruzeiro do Sul", 'uf' => "RS", 'codigo' => 4306205],
    		['id' => 4734, 'nome' => "David Canabarro", 'uf' => "RS", 'codigo' => 4306304],
    		['id' => 4735, 'nome' => "Derrubadas", 'uf' => "RS", 'codigo' => 4306320],
    		['id' => 4736, 'nome' => "Dezesseis de Novembro", 'uf' => "RS", 'codigo' => 4306353],
    		['id' => 4737, 'nome' => "Dilermando de Aguiar", 'uf' => "RS", 'codigo' => 4306379],
    		['id' => 4738, 'nome' => "Dois Irmãos", 'uf' => "RS", 'codigo' => 4306403],
    		['id' => 4739, 'nome' => "Dois Irmãos das Missões", 'uf' => "RS", 'codigo' => 4306429],
    		['id' => 4740, 'nome' => "Dois Lajeados", 'uf' => "RS", 'codigo' => 4306452],
    		['id' => 4741, 'nome' => "Dom Feliciano", 'uf' => "RS", 'codigo' => 4306502],
    		['id' => 4742, 'nome' => "Dom Pedro de Alcântara", 'uf' => "RS", 'codigo' => 4306551],
    		['id' => 4743, 'nome' => "Dom Pedrito", 'uf' => "RS", 'codigo' => 4306601],
    		['id' => 4744, 'nome' => "Dona Francisca", 'uf' => "RS", 'codigo' => 4306700],
    		['id' => 4745, 'nome' => "Doutor Maurício Cardoso", 'uf' => "RS", 'codigo' => 4306734],
    		['id' => 4746, 'nome' => "Doutor Ricardo", 'uf' => "RS", 'codigo' => 4306759],
    		['id' => 4747, 'nome' => "Eldorado do Sul", 'uf' => "RS", 'codigo' => 4306767],
    		['id' => 4748, 'nome' => "Encantado", 'uf' => "RS", 'codigo' => 4306809],
    		['id' => 4749, 'nome' => "Encruzilhada do Sul", 'uf' => "RS", 'codigo' => 4306908],
    		['id' => 4750, 'nome' => "Engenho Velho", 'uf' => "RS", 'codigo' => 4306924],
    		['id' => 4751, 'nome' => "Entre-Ijuís", 'uf' => "RS", 'codigo' => 4306932],
    		['id' => 4752, 'nome' => "Entre Rios do Sul", 'uf' => "RS", 'codigo' => 4306957],
    		['id' => 4753, 'nome' => "Erebango", 'uf' => "RS", 'codigo' => 4306973],
    		['id' => 4754, 'nome' => "Erechim", 'uf' => "RS", 'codigo' => 4307005],
    		['id' => 4755, 'nome' => "Ernestina", 'uf' => "RS", 'codigo' => 4307054],
    		['id' => 4756, 'nome' => "Herval", 'uf' => "RS", 'codigo' => 4307104],
    		['id' => 4757, 'nome' => "Erval Grande", 'uf' => "RS", 'codigo' => 4307203],
    		['id' => 4758, 'nome' => "Erval Seco", 'uf' => "RS", 'codigo' => 4307302],
    		['id' => 4759, 'nome' => "Esmeralda", 'uf' => "RS", 'codigo' => 4307401],
    		['id' => 4760, 'nome' => "Esperança do Sul", 'uf' => "RS", 'codigo' => 4307450],
    		['id' => 4761, 'nome' => "Espumoso", 'uf' => "RS", 'codigo' => 4307500],
    		['id' => 4762, 'nome' => "Estação", 'uf' => "RS", 'codigo' => 4307559],
    		['id' => 4763, 'nome' => "Estância Velha", 'uf' => "RS", 'codigo' => 4307609],
    		['id' => 4764, 'nome' => "Esteio", 'uf' => "RS", 'codigo' => 4307708],
    		['id' => 4765, 'nome' => "Estrela", 'uf' => "RS", 'codigo' => 4307807],
    		['id' => 4766, 'nome' => "Estrela Velha", 'uf' => "RS", 'codigo' => 4307815],
    		['id' => 4767, 'nome' => "Eugênio de Castro", 'uf' => "RS", 'codigo' => 4307831],
    		['id' => 4768, 'nome' => "Fagundes Varela", 'uf' => "RS", 'codigo' => 4307864],
    		['id' => 4769, 'nome' => "Farroupilha", 'uf' => "RS", 'codigo' => 4307906],
    		['id' => 4770, 'nome' => "Faxinal do Soturno", 'uf' => "RS", 'codigo' => 4308003],
    		['id' => 4771, 'nome' => "Faxinalzinho", 'uf' => "RS", 'codigo' => 4308052],
    		['id' => 4772, 'nome' => "Fazenda Vilanova", 'uf' => "RS", 'codigo' => 4308078],
    		['id' => 4773, 'nome' => "Feliz", 'uf' => "RS", 'codigo' => 4308102],
    		['id' => 4774, 'nome' => "Flores da Cunha", 'uf' => "RS", 'codigo' => 4308201],
    		['id' => 4775, 'nome' => "Floriano Peixoto", 'uf' => "RS", 'codigo' => 4308250],
    		['id' => 4776, 'nome' => "Fontoura Xavier", 'uf' => "RS", 'codigo' => 4308300],
    		['id' => 4777, 'nome' => "Formigueiro", 'uf' => "RS", 'codigo' => 4308409],
    		['id' => 4778, 'nome' => "Forquetinha", 'uf' => "RS", 'codigo' => 4308433],
    		['id' => 4779, 'nome' => "Fortaleza dos Valos", 'uf' => "RS", 'codigo' => 4308458],
    		['id' => 4780, 'nome' => "Frederico Westphalen", 'uf' => "RS", 'codigo' => 4308508],
    		['id' => 4781, 'nome' => "Garibaldi", 'uf' => "RS", 'codigo' => 4308607],
    		['id' => 4782, 'nome' => "Garruchos", 'uf' => "RS", 'codigo' => 4308656],
    		['id' => 4783, 'nome' => "Gaurama", 'uf' => "RS", 'codigo' => 4308706],
    		['id' => 4784, 'nome' => "General Câmara", 'uf' => "RS", 'codigo' => 4308805],
    		['id' => 4785, 'nome' => "Gentil", 'uf' => "RS", 'codigo' => 4308854],
    		['id' => 4786, 'nome' => "Getúlio Vargas", 'uf' => "RS", 'codigo' => 4308904],
    		['id' => 4787, 'nome' => "Giruá", 'uf' => "RS", 'codigo' => 4309001],
    		['id' => 4788, 'nome' => "Glorinha", 'uf' => "RS", 'codigo' => 4309050],
    		['id' => 4789, 'nome' => "Gramado", 'uf' => "RS", 'codigo' => 4309100],
    		['id' => 4790, 'nome' => "Gramado dos Loureiros", 'uf' => "RS", 'codigo' => 4309126],
    		['id' => 4791, 'nome' => "Gramado Xavier", 'uf' => "RS", 'codigo' => 4309159],
    		['id' => 4792, 'nome' => "Gravataí", 'uf' => "RS", 'codigo' => 4309209],
    		['id' => 4793, 'nome' => "Guabiju", 'uf' => "RS", 'codigo' => 4309258],
    		['id' => 4794, 'nome' => "Guaíba", 'uf' => "RS", 'codigo' => 4309308],
    		['id' => 4795, 'nome' => "Guaporé", 'uf' => "RS", 'codigo' => 4309407],
    		['id' => 4796, 'nome' => "Guarani das Missões", 'uf' => "RS", 'codigo' => 4309506],
    		['id' => 4797, 'nome' => "Harmonia", 'uf' => "RS", 'codigo' => 4309555],
    		['id' => 4798, 'nome' => "Herveiras", 'uf' => "RS", 'codigo' => 4309571],
    		['id' => 4799, 'nome' => "Horizontina", 'uf' => "RS", 'codigo' => 4309605],
    		['id' => 4800, 'nome' => "Hulha Negra", 'uf' => "RS", 'codigo' => 4309654],
    		['id' => 4801, 'nome' => "Humaitá", 'uf' => "RS", 'codigo' => 4309704],
    		['id' => 4802, 'nome' => "Ibarama", 'uf' => "RS", 'codigo' => 4309753],
    		['id' => 4803, 'nome' => "Ibiaçá", 'uf' => "RS", 'codigo' => 4309803],
    		['id' => 4804, 'nome' => "Ibiraiaras", 'uf' => "RS", 'codigo' => 4309902],
    		['id' => 4805, 'nome' => "Ibirapuitã", 'uf' => "RS", 'codigo' => 4309951],
    		['id' => 4806, 'nome' => "Ibirubá", 'uf' => "RS", 'codigo' => 4310009],
    		['id' => 4807, 'nome' => "Igrejinha", 'uf' => "RS", 'codigo' => 4310108],
    		['id' => 4808, 'nome' => "Ijuí", 'uf' => "RS", 'codigo' => 4310207],
    		['id' => 4809, 'nome' => "Ilópolis", 'uf' => "RS", 'codigo' => 4310306],
    		['id' => 4810, 'nome' => "Imbé", 'uf' => "RS", 'codigo' => 4310330],
    		['id' => 4811, 'nome' => "Imigrante", 'uf' => "RS", 'codigo' => 4310363],
    		['id' => 4812, 'nome' => "Independência", 'uf' => "RS", 'codigo' => 4310405],
    		['id' => 4813, 'nome' => "Inhacorá", 'uf' => "RS", 'codigo' => 4310413],
    		['id' => 4814, 'nome' => "Ipê", 'uf' => "RS", 'codigo' => 4310439],
    		['id' => 4815, 'nome' => "Ipiranga do Sul", 'uf' => "RS", 'codigo' => 4310462],
    		['id' => 4816, 'nome' => "Iraí", 'uf' => "RS", 'codigo' => 4310504],
    		['id' => 4817, 'nome' => "Itaara", 'uf' => "RS", 'codigo' => 4310538],
    		['id' => 4818, 'nome' => "Itacurubi", 'uf' => "RS", 'codigo' => 4310553],
    		['id' => 4819, 'nome' => "Itapuca", 'uf' => "RS", 'codigo' => 4310579],
    		['id' => 4820, 'nome' => "Itaqui", 'uf' => "RS", 'codigo' => 4310603],
    		['id' => 4821, 'nome' => "Itati", 'uf' => "RS", 'codigo' => 4310652],
    		['id' => 4822, 'nome' => "Itatiba do Sul", 'uf' => "RS", 'codigo' => 4310702],
    		['id' => 4823, 'nome' => "Ivorá", 'uf' => "RS", 'codigo' => 4310751],
    		['id' => 4824, 'nome' => "Ivoti", 'uf' => "RS", 'codigo' => 4310801],
    		['id' => 4825, 'nome' => "Jaboticaba", 'uf' => "RS", 'codigo' => 4310850],
    		['id' => 4826, 'nome' => "Jacuizinho", 'uf' => "RS", 'codigo' => 4310876],
    		['id' => 4827, 'nome' => "Jacutinga", 'uf' => "RS", 'codigo' => 4310900],
    		['id' => 4828, 'nome' => "Jaguarão", 'uf' => "RS", 'codigo' => 4311007],
    		['id' => 4829, 'nome' => "Jaguari", 'uf' => "RS", 'codigo' => 4311106],
    		['id' => 4830, 'nome' => "Jaquirana", 'uf' => "RS", 'codigo' => 4311122],
    		['id' => 4831, 'nome' => "Jari", 'uf' => "RS", 'codigo' => 4311130],
    		['id' => 4832, 'nome' => "Jóia", 'uf' => "RS", 'codigo' => 4311155],
    		['id' => 4833, 'nome' => "Júlio de Castilhos", 'uf' => "RS", 'codigo' => 4311205],
    		['id' => 4834, 'nome' => "Lagoa Bonita do Sul", 'uf' => "RS", 'codigo' => 4311239],
    		['id' => 4835, 'nome' => "Lagoão", 'uf' => "RS", 'codigo' => 4311254],
    		['id' => 4836, 'nome' => "Lagoa dos Três Cantos", 'uf' => "RS", 'codigo' => 4311270],
    		['id' => 4837, 'nome' => "Lagoa Vermelha", 'uf' => "RS", 'codigo' => 4311304],
    		['id' => 4838, 'nome' => "Lajeado", 'uf' => "RS", 'codigo' => 4311403],
    		['id' => 4839, 'nome' => "Lajeado do Bugre", 'uf' => "RS", 'codigo' => 4311429],
    		['id' => 4840, 'nome' => "Lavras do Sul", 'uf' => "RS", 'codigo' => 4311502],
    		['id' => 4841, 'nome' => "Liberato Salzano", 'uf' => "RS", 'codigo' => 4311601],
    		['id' => 4842, 'nome' => "Lindolfo Collor", 'uf' => "RS", 'codigo' => 4311627],
    		['id' => 4843, 'nome' => "Linha Nova", 'uf' => "RS", 'codigo' => 4311643],
    		['id' => 4844, 'nome' => "Machadinho", 'uf' => "RS", 'codigo' => 4311700],
    		['id' => 4845, 'nome' => "Maçambará", 'uf' => "RS", 'codigo' => 4311718],
    		['id' => 4846, 'nome' => "Mampituba", 'uf' => "RS", 'codigo' => 4311734],
    		['id' => 4847, 'nome' => "Manoel Viana", 'uf' => "RS", 'codigo' => 4311759],
    		['id' => 4848, 'nome' => "Maquiné", 'uf' => "RS", 'codigo' => 4311775],
    		['id' => 4849, 'nome' => "Maratá", 'uf' => "RS", 'codigo' => 4311791],
    		['id' => 4850, 'nome' => "Marau", 'uf' => "RS", 'codigo' => 4311809],
    		['id' => 4851, 'nome' => "Marcelino Ramos", 'uf' => "RS", 'codigo' => 4311908],
    		['id' => 4852, 'nome' => "Mariana Pimentel", 'uf' => "RS", 'codigo' => 4311981],
    		['id' => 4853, 'nome' => "Mariano Moro", 'uf' => "RS", 'codigo' => 4312005],
    		['id' => 4854, 'nome' => "Marques de Souza", 'uf' => "RS", 'codigo' => 4312054],
    		['id' => 4855, 'nome' => "Mata", 'uf' => "RS", 'codigo' => 4312104],
    		['id' => 4856, 'nome' => "Mato Castelhano", 'uf' => "RS", 'codigo' => 4312138],
    		['id' => 4857, 'nome' => "Mato Leitão", 'uf' => "RS", 'codigo' => 4312153],
    		['id' => 4858, 'nome' => "Mato Queimado", 'uf' => "RS", 'codigo' => 4312179],
    		['id' => 4859, 'nome' => "Maximiliano de Almeida", 'uf' => "RS", 'codigo' => 4312203],
    		['id' => 4860, 'nome' => "Minas do Leão", 'uf' => "RS", 'codigo' => 4312252],
    		['id' => 4861, 'nome' => "Miraguaí", 'uf' => "RS", 'codigo' => 4312302],
    		['id' => 4862, 'nome' => "Montauri", 'uf' => "RS", 'codigo' => 4312351],
    		['id' => 4863, 'nome' => "Monte Alegre dos Campos", 'uf' => "RS", 'codigo' => 4312377],
    		['id' => 4864, 'nome' => "Monte Belo do Sul", 'uf' => "RS", 'codigo' => 4312385],
    		['id' => 4865, 'nome' => "Montenegro", 'uf' => "RS", 'codigo' => 4312401],
    		['id' => 4866, 'nome' => "Mormaço", 'uf' => "RS", 'codigo' => 4312427],
    		['id' => 4867, 'nome' => "Morrinhos do Sul", 'uf' => "RS", 'codigo' => 4312443],
    		['id' => 4868, 'nome' => "Morro Redondo", 'uf' => "RS", 'codigo' => 4312450],
    		['id' => 4869, 'nome' => "Morro Reuter", 'uf' => "RS", 'codigo' => 4312476],
    		['id' => 4870, 'nome' => "Mostardas", 'uf' => "RS", 'codigo' => 4312500],
    		['id' => 4871, 'nome' => "Muçum", 'uf' => "RS", 'codigo' => 4312609],
    		['id' => 4872, 'nome' => "Muitos Capões", 'uf' => "RS", 'codigo' => 4312617],
    		['id' => 4873, 'nome' => "Muliterno", 'uf' => "RS", 'codigo' => 4312625],
    		['id' => 4874, 'nome' => "Não-Me-Toque", 'uf' => "RS", 'codigo' => 4312658],
    		['id' => 4875, 'nome' => "Nicolau Vergueiro", 'uf' => "RS", 'codigo' => 4312674],
    		['id' => 4876, 'nome' => "Nonoai", 'uf' => "RS", 'codigo' => 4312708],
    		['id' => 4877, 'nome' => "Nova Alvorada", 'uf' => "RS", 'codigo' => 4312757],
    		['id' => 4878, 'nome' => "Nova Araçá", 'uf' => "RS", 'codigo' => 4312807],
    		['id' => 4879, 'nome' => "Nova Bassano", 'uf' => "RS", 'codigo' => 4312906],
    		['id' => 4880, 'nome' => "Nova Boa Vista", 'uf' => "RS", 'codigo' => 4312955],
    		['id' => 4881, 'nome' => "Nova Bréscia", 'uf' => "RS", 'codigo' => 4313003],
    		['id' => 4882, 'nome' => "Nova Candelária", 'uf' => "RS", 'codigo' => 4313011],
    		['id' => 4883, 'nome' => "Nova Esperança do Sul", 'uf' => "RS", 'codigo' => 4313037],
    		['id' => 4884, 'nome' => "Nova Hartz", 'uf' => "RS", 'codigo' => 4313060],
    		['id' => 4885, 'nome' => "Nova Pádua", 'uf' => "RS", 'codigo' => 4313086],
    		['id' => 4886, 'nome' => "Nova Palma", 'uf' => "RS", 'codigo' => 4313102],
    		['id' => 4887, 'nome' => "Nova Petrópolis", 'uf' => "RS", 'codigo' => 4313201],
    		['id' => 4888, 'nome' => "Nova Prata", 'uf' => "RS", 'codigo' => 4313300],
    		['id' => 4889, 'nome' => "Nova Ramada", 'uf' => "RS", 'codigo' => 4313334],
    		['id' => 4890, 'nome' => "Nova Roma do Sul", 'uf' => "RS", 'codigo' => 4313359],
    		['id' => 4891, 'nome' => "Nova Santa Rita", 'uf' => "RS", 'codigo' => 4313375],
    		['id' => 4892, 'nome' => "Novo Cabrais", 'uf' => "RS", 'codigo' => 4313391],
    		['id' => 4893, 'nome' => "Novo Hamburgo", 'uf' => "RS", 'codigo' => 4313409],
    		['id' => 4894, 'nome' => "Novo Machado", 'uf' => "RS", 'codigo' => 4313425],
    		['id' => 4895, 'nome' => "Novo Tiradentes", 'uf' => "RS", 'codigo' => 4313441],
    		['id' => 4896, 'nome' => "Novo Xingu", 'uf' => "RS", 'codigo' => 4313466],
    		['id' => 4897, 'nome' => "Novo Barreiro", 'uf' => "RS", 'codigo' => 4313490],
    		['id' => 4898, 'nome' => "Osório", 'uf' => "RS", 'codigo' => 4313508],
    		['id' => 4899, 'nome' => "Paim Filho", 'uf' => "RS", 'codigo' => 4313607],
    		['id' => 4900, 'nome' => "Palmares do Sul", 'uf' => "RS", 'codigo' => 4313656],
    		['id' => 4901, 'nome' => "Palmeira das Missões", 'uf' => "RS", 'codigo' => 4313706],
    		['id' => 4902, 'nome' => "Palmitinho", 'uf' => "RS", 'codigo' => 4313805],
    		['id' => 4903, 'nome' => "Panambi", 'uf' => "RS", 'codigo' => 4313904],
    		['id' => 4904, 'nome' => "Pantano Grande", 'uf' => "RS", 'codigo' => 4313953],
    		['id' => 4905, 'nome' => "Paraí", 'uf' => "RS", 'codigo' => 4314001],
    		['id' => 4906, 'nome' => "Paraíso do Sul", 'uf' => "RS", 'codigo' => 4314027],
    		['id' => 4907, 'nome' => "Pareci Novo", 'uf' => "RS", 'codigo' => 4314035],
    		['id' => 4908, 'nome' => "Parobé", 'uf' => "RS", 'codigo' => 4314050],
    		['id' => 4909, 'nome' => "Passa Sete", 'uf' => "RS", 'codigo' => 4314068],
    		['id' => 4910, 'nome' => "Passo do Sobrado", 'uf' => "RS", 'codigo' => 4314076],
    		['id' => 4911, 'nome' => "Passo Fundo", 'uf' => "RS", 'codigo' => 4314100],
    		['id' => 4912, 'nome' => "Paulo Bento", 'uf' => "RS", 'codigo' => 4314134],
    		['id' => 4913, 'nome' => "Paverama", 'uf' => "RS", 'codigo' => 4314159],
    		['id' => 4914, 'nome' => "Pedras Altas", 'uf' => "RS", 'codigo' => 4314175],
    		['id' => 4915, 'nome' => "Pedro Osório", 'uf' => "RS", 'codigo' => 4314209],
    		['id' => 4916, 'nome' => "Pejuçara", 'uf' => "RS", 'codigo' => 4314308],
    		['id' => 4917, 'nome' => "Pelotas", 'uf' => "RS", 'codigo' => 4314407],
    		['id' => 4918, 'nome' => "Picada Café", 'uf' => "RS", 'codigo' => 4314423],
    		['id' => 4919, 'nome' => "Pinhal", 'uf' => "RS", 'codigo' => 4314456],
    		['id' => 4920, 'nome' => "Pinhal da Serra", 'uf' => "RS", 'codigo' => 4314464],
    		['id' => 4921, 'nome' => "Pinhal Grande", 'uf' => "RS", 'codigo' => 4314472],
    		['id' => 4922, 'nome' => "Pinheirinho do Vale", 'uf' => "RS", 'codigo' => 4314498],
    		['id' => 4923, 'nome' => "Pinheiro Machado", 'uf' => "RS", 'codigo' => 4314506],
    		['id' => 4924, 'nome' => "Pinto Bandeira", 'uf' => "RS", 'codigo' => 4314548],
    		['id' => 4925, 'nome' => "Pirapó", 'uf' => "RS", 'codigo' => 4314555],
    		['id' => 4926, 'nome' => "Piratini", 'uf' => "RS", 'codigo' => 4314605],
    		['id' => 4927, 'nome' => "Planalto", 'uf' => "RS", 'codigo' => 4314704],
    		['id' => 4928, 'nome' => "Poço das Antas", 'uf' => "RS", 'codigo' => 4314753],
    		['id' => 4929, 'nome' => "Pontão", 'uf' => "RS", 'codigo' => 4314779],
    		['id' => 4930, 'nome' => "Ponte Preta", 'uf' => "RS", 'codigo' => 4314787],
    		['id' => 4931, 'nome' => "Portão", 'uf' => "RS", 'codigo' => 4314803],
    		['id' => 4932, 'nome' => "Porto Alegre", 'uf' => "RS", 'codigo' => 4314902],
    		['id' => 4933, 'nome' => "Porto Lucena", 'uf' => "RS", 'codigo' => 4315008],
    		['id' => 4934, 'nome' => "Porto Mauá", 'uf' => "RS", 'codigo' => 4315057],
    		['id' => 4935, 'nome' => "Porto Vera Cruz", 'uf' => "RS", 'codigo' => 4315073],
    		['id' => 4936, 'nome' => "Porto Xavier", 'uf' => "RS", 'codigo' => 4315107],
    		['id' => 4937, 'nome' => "Pouso Novo", 'uf' => "RS", 'codigo' => 4315131],
    		['id' => 4938, 'nome' => "Presidente Lucena", 'uf' => "RS", 'codigo' => 4315149],
    		['id' => 4939, 'nome' => "Progresso", 'uf' => "RS", 'codigo' => 4315156],
    		['id' => 4940, 'nome' => "Protásio Alves", 'uf' => "RS", 'codigo' => 4315172],
    		['id' => 4941, 'nome' => "Putinga", 'uf' => "RS", 'codigo' => 4315206],
    		['id' => 4942, 'nome' => "Quaraí", 'uf' => "RS", 'codigo' => 4315305],
    		['id' => 4943, 'nome' => "Quatro Irmãos", 'uf' => "RS", 'codigo' => 4315313],
    		['id' => 4944, 'nome' => "Quevedos", 'uf' => "RS", 'codigo' => 4315321],
    		['id' => 4945, 'nome' => "Quinze de Novembro", 'uf' => "RS", 'codigo' => 4315354],
    		['id' => 4946, 'nome' => "Redentora", 'uf' => "RS", 'codigo' => 4315404],
    		['id' => 4947, 'nome' => "Relvado", 'uf' => "RS", 'codigo' => 4315453],
    		['id' => 4948, 'nome' => "Restinga Seca", 'uf' => "RS", 'codigo' => 4315503],
    		['id' => 4949, 'nome' => "Rio dos Índios", 'uf' => "RS", 'codigo' => 4315552],
    		['id' => 4950, 'nome' => "Rio Grande", 'uf' => "RS", 'codigo' => 4315602],
    		['id' => 4951, 'nome' => "Rio Pardo", 'uf' => "RS", 'codigo' => 4315701],
    		['id' => 4952, 'nome' => "Riozinho", 'uf' => "RS", 'codigo' => 4315750],
    		['id' => 4953, 'nome' => "Roca Sales", 'uf' => "RS", 'codigo' => 4315800],
    		['id' => 4954, 'nome' => "Rodeio Bonito", 'uf' => "RS", 'codigo' => 4315909],
    		['id' => 4955, 'nome' => "Rolador", 'uf' => "RS", 'codigo' => 4315958],
    		['id' => 4956, 'nome' => "Rolante", 'uf' => "RS", 'codigo' => 4316006],
    		['id' => 4957, 'nome' => "Ronda Alta", 'uf' => "RS", 'codigo' => 4316105],
    		['id' => 4958, 'nome' => "Rondinha", 'uf' => "RS", 'codigo' => 4316204],
    		['id' => 4959, 'nome' => "Roque Gonzales", 'uf' => "RS", 'codigo' => 4316303],
    		['id' => 4960, 'nome' => "Rosário do Sul", 'uf' => "RS", 'codigo' => 4316402],
    		['id' => 4961, 'nome' => "Sagrada Família", 'uf' => "RS", 'codigo' => 4316428],
    		['id' => 4962, 'nome' => "Saldanha Marinho", 'uf' => "RS", 'codigo' => 4316436],
    		['id' => 4963, 'nome' => "Salto do Jacuí", 'uf' => "RS", 'codigo' => 4316451],
    		['id' => 4964, 'nome' => "Salvador das Missões", 'uf' => "RS", 'codigo' => 4316477],
    		['id' => 4965, 'nome' => "Salvador do Sul", 'uf' => "RS", 'codigo' => 4316501],
    		['id' => 4966, 'nome' => "Sananduva", 'uf' => "RS", 'codigo' => 4316600],
    		['id' => 4967, 'nome' => "Santa Bárbara do Sul", 'uf' => "RS", 'codigo' => 4316709],
    		['id' => 4968, 'nome' => "Santa Cecília do Sul", 'uf' => "RS", 'codigo' => 4316733],
    		['id' => 4969, 'nome' => "Santa Clara do Sul", 'uf' => "RS", 'codigo' => 4316758],
    		['id' => 4970, 'nome' => "Santa Cruz do Sul", 'uf' => "RS", 'codigo' => 4316808],
    		['id' => 4971, 'nome' => "Santa Maria", 'uf' => "RS", 'codigo' => 4316907],
    		['id' => 4972, 'nome' => "Santa Maria do Herval", 'uf' => "RS", 'codigo' => 4316956],
    		['id' => 4973, 'nome' => "Santa Margarida do Sul", 'uf' => "RS", 'codigo' => 4316972],
    		['id' => 4974, 'nome' => "Santana da Boa Vista", 'uf' => "RS", 'codigo' => 4317004],
    		['id' => 4975, 'nome' => "Sant'Ana do Livramento", 'uf' => "RS", 'codigo' => 4317103],
    		['id' => 4976, 'nome' => "Santa Rosa", 'uf' => "RS", 'codigo' => 4317202],
    		['id' => 4977, 'nome' => "Santa Tereza", 'uf' => "RS", 'codigo' => 4317251],
    		['id' => 4978, 'nome' => "Santa Vitória do Palmar", 'uf' => "RS", 'codigo' => 4317301],
    		['id' => 4979, 'nome' => "Santiago", 'uf' => "RS", 'codigo' => 4317400],
    		['id' => 4980, 'nome' => "Santo Ângelo", 'uf' => "RS", 'codigo' => 4317509],
    		['id' => 4981, 'nome' => "Santo Antônio do Palma", 'uf' => "RS", 'codigo' => 4317558],
    		['id' => 4982, 'nome' => "Santo Antônio da Patrulha", 'uf' => "RS", 'codigo' => 4317608],
    		['id' => 4983, 'nome' => "Santo Antônio das Missões", 'uf' => "RS", 'codigo' => 4317707],
    		['id' => 4984, 'nome' => "Santo Antônio do Planalto", 'uf' => "RS", 'codigo' => 4317756],
    		['id' => 4985, 'nome' => "Santo Augusto", 'uf' => "RS", 'codigo' => 4317806],
    		['id' => 4986, 'nome' => "Santo Cristo", 'uf' => "RS", 'codigo' => 4317905],
    		['id' => 4987, 'nome' => "Santo Expedito do Sul", 'uf' => "RS", 'codigo' => 4317954],
    		['id' => 4988, 'nome' => "São Borja", 'uf' => "RS", 'codigo' => 4318002],
    		['id' => 4989, 'nome' => "São Domingos do Sul", 'uf' => "RS", 'codigo' => 4318051],
    		['id' => 4990, 'nome' => "São Francisco de Assis", 'uf' => "RS", 'codigo' => 4318101],
    		['id' => 4991, 'nome' => "São Francisco de Paula", 'uf' => "RS", 'codigo' => 4318200],
    		['id' => 4992, 'nome' => "São Gabriel", 'uf' => "RS", 'codigo' => 4318309],
    		['id' => 4993, 'nome' => "São Jerônimo", 'uf' => "RS", 'codigo' => 4318408],
    		['id' => 4994, 'nome' => "São João da Urtiga", 'uf' => "RS", 'codigo' => 4318424],
    		['id' => 4995, 'nome' => "São João do Polêsine", 'uf' => "RS", 'codigo' => 4318432],
    		['id' => 4996, 'nome' => "São Jorge", 'uf' => "RS", 'codigo' => 4318440],
    		['id' => 4997, 'nome' => "São José das Missões", 'uf' => "RS", 'codigo' => 4318457],
    		['id' => 4998, 'nome' => "São José do Herval", 'uf' => "RS", 'codigo' => 4318465],
    		['id' => 4999, 'nome' => "São José do Hortêncio", 'uf' => "RS", 'codigo' => 4318481],
    		['id' => 5000, 'nome' => "São José do Inhacorá", 'uf' => "RS", 'codigo' => 4318499],
    		['id' => 5001, 'nome' => "São José do Norte", 'uf' => "RS", 'codigo' => 4318507],
    		['id' => 5002, 'nome' => "São José do Ouro", 'uf' => "RS", 'codigo' => 4318606],
    		['id' => 5003, 'nome' => "São José do Sul", 'uf' => "RS", 'codigo' => 4318614],
    		['id' => 5004, 'nome' => "São José dos Ausentes", 'uf' => "RS", 'codigo' => 4318622],
    		['id' => 5005, 'nome' => "São Leopoldo", 'uf' => "RS", 'codigo' => 4318705],
    		['id' => 5006, 'nome' => "São Lourenço do Sul", 'uf' => "RS", 'codigo' => 4318804],
    		['id' => 5007, 'nome' => "São Luiz Gonzaga", 'uf' => "RS", 'codigo' => 4318903],
    		['id' => 5008, 'nome' => "São Marcos", 'uf' => "RS", 'codigo' => 4319000],
    		['id' => 5009, 'nome' => "São Martinho", 'uf' => "RS", 'codigo' => 4319109],
    		['id' => 5010, 'nome' => "São Martinho da Serra", 'uf' => "RS", 'codigo' => 4319125],
    		['id' => 5011, 'nome' => "São Miguel das Missões", 'uf' => "RS", 'codigo' => 4319158],
    		['id' => 5012, 'nome' => "São Nicolau", 'uf' => "RS", 'codigo' => 4319208],
    		['id' => 5013, 'nome' => "São Paulo das Missões", 'uf' => "RS", 'codigo' => 4319307],
    		['id' => 5014, 'nome' => "São Pedro da Serra", 'uf' => "RS", 'codigo' => 4319356],
    		['id' => 5015, 'nome' => "São Pedro das Missões", 'uf' => "RS", 'codigo' => 4319364],
    		['id' => 5016, 'nome' => "São Pedro do Butiá", 'uf' => "RS", 'codigo' => 4319372],
    		['id' => 5017, 'nome' => "São Pedro do Sul", 'uf' => "RS", 'codigo' => 4319406],
    		['id' => 5018, 'nome' => "São Sebastião do Caí", 'uf' => "RS", 'codigo' => 4319505],
    		['id' => 5019, 'nome' => "São Sepé", 'uf' => "RS", 'codigo' => 4319604],
    		['id' => 5020, 'nome' => "São Valentim", 'uf' => "RS", 'codigo' => 4319703],
    		['id' => 5021, 'nome' => "São Valentim do Sul", 'uf' => "RS", 'codigo' => 4319711],
    		['id' => 5022, 'nome' => "São Valério do Sul", 'uf' => "RS", 'codigo' => 4319737],
    		['id' => 5023, 'nome' => "São Vendelino", 'uf' => "RS", 'codigo' => 4319752],
    		['id' => 5024, 'nome' => "São Vicente do Sul", 'uf' => "RS", 'codigo' => 4319802],
    		['id' => 5025, 'nome' => "Sapiranga", 'uf' => "RS", 'codigo' => 4319901],
    		['id' => 5026, 'nome' => "Sapucaia do Sul", 'uf' => "RS", 'codigo' => 4320008],
    		['id' => 5027, 'nome' => "Sarandi", 'uf' => "RS", 'codigo' => 4320107],
    		['id' => 5028, 'nome' => "Seberi", 'uf' => "RS", 'codigo' => 4320206],
    		['id' => 5029, 'nome' => "Sede Nova", 'uf' => "RS", 'codigo' => 4320230],
    		['id' => 5030, 'nome' => "Segredo", 'uf' => "RS", 'codigo' => 4320263],
    		['id' => 5031, 'nome' => "Selbach", 'uf' => "RS", 'codigo' => 4320305],
    		['id' => 5032, 'nome' => "Senador Salgado Filho", 'uf' => "RS", 'codigo' => 4320321],
    		['id' => 5033, 'nome' => "Sentinela do Sul", 'uf' => "RS", 'codigo' => 4320354],
    		['id' => 5034, 'nome' => "Serafina Corrêa", 'uf' => "RS", 'codigo' => 4320404],
    		['id' => 5035, 'nome' => "Sério", 'uf' => "RS", 'codigo' => 4320453],
    		['id' => 5036, 'nome' => "Sertão", 'uf' => "RS", 'codigo' => 4320503],
    		['id' => 5037, 'nome' => "Sertão Santana", 'uf' => "RS", 'codigo' => 4320552],
    		['id' => 5038, 'nome' => "Sete de Setembro", 'uf' => "RS", 'codigo' => 4320578],
    		['id' => 5039, 'nome' => "Severiano de Almeida", 'uf' => "RS", 'codigo' => 4320602],
    		['id' => 5040, 'nome' => "Silveira Martins", 'uf' => "RS", 'codigo' => 4320651],
    		['id' => 5041, 'nome' => "Sinimbu", 'uf' => "RS", 'codigo' => 4320677],
    		['id' => 5042, 'nome' => "Sobradinho", 'uf' => "RS", 'codigo' => 4320701],
    		['id' => 5043, 'nome' => "Soledade", 'uf' => "RS", 'codigo' => 4320800],
    		['id' => 5044, 'nome' => "Tabaí", 'uf' => "RS", 'codigo' => 4320859],
    		['id' => 5045, 'nome' => "Tapejara", 'uf' => "RS", 'codigo' => 4320909],
    		['id' => 5046, 'nome' => "Tapera", 'uf' => "RS", 'codigo' => 4321006],
    		['id' => 5047, 'nome' => "Tapes", 'uf' => "RS", 'codigo' => 4321105],
    		['id' => 5048, 'nome' => "Taquara", 'uf' => "RS", 'codigo' => 4321204],
    		['id' => 5049, 'nome' => "Taquari", 'uf' => "RS", 'codigo' => 4321303],
    		['id' => 5050, 'nome' => "Taquaruçu do Sul", 'uf' => "RS", 'codigo' => 4321329],
    		['id' => 5051, 'nome' => "Tavares", 'uf' => "RS", 'codigo' => 4321352],
    		['id' => 5052, 'nome' => "Tenente Portela", 'uf' => "RS", 'codigo' => 4321402],
    		['id' => 5053, 'nome' => "Terra de Areia", 'uf' => "RS", 'codigo' => 4321436],
    		['id' => 5054, 'nome' => "Teutônia", 'uf' => "RS", 'codigo' => 4321451],
    		['id' => 5055, 'nome' => "Tio Hugo", 'uf' => "RS", 'codigo' => 4321469],
    		['id' => 5056, 'nome' => "Tiradentes do Sul", 'uf' => "RS", 'codigo' => 4321477],
    		['id' => 5057, 'nome' => "Toropi", 'uf' => "RS", 'codigo' => 4321493],
    		['id' => 5058, 'nome' => "Torres", 'uf' => "RS", 'codigo' => 4321501],
    		['id' => 5059, 'nome' => "Tramandaí", 'uf' => "RS", 'codigo' => 4321600],
    		['id' => 5060, 'nome' => "Travesseiro", 'uf' => "RS", 'codigo' => 4321626],
    		['id' => 5061, 'nome' => "Três Arroios", 'uf' => "RS", 'codigo' => 4321634],
    		['id' => 5062, 'nome' => "Três Cachoeiras", 'uf' => "RS", 'codigo' => 4321667],
    		['id' => 5063, 'nome' => "Três Coroas", 'uf' => "RS", 'codigo' => 4321709],
    		['id' => 5064, 'nome' => "Três de Maio", 'uf' => "RS", 'codigo' => 4321808],
    		['id' => 5065, 'nome' => "Três Forquilhas", 'uf' => "RS", 'codigo' => 4321832],
    		['id' => 5066, 'nome' => "Três Palmeiras", 'uf' => "RS", 'codigo' => 4321857],
    		['id' => 5067, 'nome' => "Três Passos", 'uf' => "RS", 'codigo' => 4321907],
    		['id' => 5068, 'nome' => "Trindade do Sul", 'uf' => "RS", 'codigo' => 4321956],
    		['id' => 5069, 'nome' => "Triunfo", 'uf' => "RS", 'codigo' => 4322004],
    		['id' => 5070, 'nome' => "Tucunduva", 'uf' => "RS", 'codigo' => 4322103],
    		['id' => 5071, 'nome' => "Tunas", 'uf' => "RS", 'codigo' => 4322152],
    		['id' => 5072, 'nome' => "Tupanci do Sul", 'uf' => "RS", 'codigo' => 4322186],
    		['id' => 5073, 'nome' => "Tupanciretã", 'uf' => "RS", 'codigo' => 4322202],
    		['id' => 5074, 'nome' => "Tupandi", 'uf' => "RS", 'codigo' => 4322251],
    		['id' => 5075, 'nome' => "Tuparendi", 'uf' => "RS", 'codigo' => 4322301],
    		['id' => 5076, 'nome' => "Turuçu", 'uf' => "RS", 'codigo' => 4322327],
    		['id' => 5077, 'nome' => "Ubiretama", 'uf' => "RS", 'codigo' => 4322343],
    		['id' => 5078, 'nome' => "União da Serra", 'uf' => "RS", 'codigo' => 4322350],
    		['id' => 5079, 'nome' => "Unistalda", 'uf' => "RS", 'codigo' => 4322376],
    		['id' => 5080, 'nome' => "Uruguaiana", 'uf' => "RS", 'codigo' => 4322400],
    		['id' => 5081, 'nome' => "Vacaria", 'uf' => "RS", 'codigo' => 4322509],
    		['id' => 5082, 'nome' => "Vale Verde", 'uf' => "RS", 'codigo' => 4322525],
    		['id' => 5083, 'nome' => "Vale do Sol", 'uf' => "RS", 'codigo' => 4322533],
    		['id' => 5084, 'nome' => "Vale Real", 'uf' => "RS", 'codigo' => 4322541],
    		['id' => 5085, 'nome' => "Vanini", 'uf' => "RS", 'codigo' => 4322558],
    		['id' => 5086, 'nome' => "Venâncio Aires", 'uf' => "RS", 'codigo' => 4322608],
    		['id' => 5087, 'nome' => "Vera Cruz", 'uf' => "RS", 'codigo' => 4322707],
    		['id' => 5088, 'nome' => "Veranópolis", 'uf' => "RS", 'codigo' => 4322806],
    		['id' => 5089, 'nome' => "Vespasiano Correa", 'uf' => "RS", 'codigo' => 4322855],
    		['id' => 5090, 'nome' => "Viadutos", 'uf' => "RS", 'codigo' => 4322905],
    		['id' => 5091, 'nome' => "Viamão", 'uf' => "RS", 'codigo' => 4323002],
    		['id' => 5092, 'nome' => "Vicente Dutra", 'uf' => "RS", 'codigo' => 4323101],
    		['id' => 5093, 'nome' => "Victor Graeff", 'uf' => "RS", 'codigo' => 4323200],
    		['id' => 5094, 'nome' => "Vila Flores", 'uf' => "RS", 'codigo' => 4323309],
    		['id' => 5095, 'nome' => "Vila Lângaro", 'uf' => "RS", 'codigo' => 4323358],
    		['id' => 5096, 'nome' => "Vila Maria", 'uf' => "RS", 'codigo' => 4323408],
    		['id' => 5097, 'nome' => "Vila Nova do Sul", 'uf' => "RS", 'codigo' => 4323457],
    		['id' => 5098, 'nome' => "Vista Alegre", 'uf' => "RS", 'codigo' => 4323507],
    		['id' => 5099, 'nome' => "Vista Alegre do Prata", 'uf' => "RS", 'codigo' => 4323606],
    		['id' => 5100, 'nome' => "Vista Gaúcha", 'uf' => "RS", 'codigo' => 4323705],
    		['id' => 5101, 'nome' => "Vitória das Missões", 'uf' => "RS", 'codigo' => 4323754],
    		['id' => 5102, 'nome' => "Westfalia", 'uf' => "RS", 'codigo' => 4323770],
    		['id' => 5103, 'nome' => "Xangri-lá", 'uf' => "RS", 'codigo' => 4323804],
    		['id' => 5104, 'nome' => "Água Clara", 'uf' => "MS", 'codigo' => 5000203],
    		['id' => 5105, 'nome' => "Alcinópolis", 'uf' => "MS", 'codigo' => 5000252],
    		['id' => 5106, 'nome' => "Amambai", 'uf' => "MS", 'codigo' => 5000609],
    		['id' => 5107, 'nome' => "Anastácio", 'uf' => "MS", 'codigo' => 5000708],
    		['id' => 5108, 'nome' => "Anaurilândia", 'uf' => "MS", 'codigo' => 5000807],
    		['id' => 5109, 'nome' => "Angélica", 'uf' => "MS", 'codigo' => 5000856],
    		['id' => 5110, 'nome' => "Antônio João", 'uf' => "MS", 'codigo' => 5000906],
    		['id' => 5111, 'nome' => "Aparecida do Taboado", 'uf' => "MS", 'codigo' => 5001003],
    		['id' => 5112, 'nome' => "Aquidauana", 'uf' => "MS", 'codigo' => 5001102],
    		['id' => 5113, 'nome' => "Aral Moreira", 'uf' => "MS", 'codigo' => 5001243],
    		['id' => 5114, 'nome' => "Bandeirantes", 'uf' => "MS", 'codigo' => 5001508],
    		['id' => 5115, 'nome' => "Bataguassu", 'uf' => "MS", 'codigo' => 5001904],
    		['id' => 5116, 'nome' => "Batayporã", 'uf' => "MS", 'codigo' => 5002001],
    		['id' => 5117, 'nome' => "Bela Vista", 'uf' => "MS", 'codigo' => 5002100],
    		['id' => 5118, 'nome' => "Bodoquena", 'uf' => "MS", 'codigo' => 5002159],
    		['id' => 5119, 'nome' => "Bonito", 'uf' => "MS", 'codigo' => 5002209],
    		['id' => 5120, 'nome' => "Brasilândia", 'uf' => "MS", 'codigo' => 5002308],
    		['id' => 5121, 'nome' => "Caarapó", 'uf' => "MS", 'codigo' => 5002407],
    		['id' => 5122, 'nome' => "Camapuã", 'uf' => "MS", 'codigo' => 5002605],
    		['id' => 5123, 'nome' => "Campo Grande", 'uf' => "MS", 'codigo' => 5002704],
    		['id' => 5124, 'nome' => "Caracol", 'uf' => "MS", 'codigo' => 5002803],
    		['id' => 5125, 'nome' => "Cassilândia", 'uf' => "MS", 'codigo' => 5002902],
    		['id' => 5126, 'nome' => "Chapadão do Sul", 'uf' => "MS", 'codigo' => 5002951],
    		['id' => 5127, 'nome' => "Corguinho", 'uf' => "MS", 'codigo' => 5003108],
    		['id' => 5128, 'nome' => "Coronel Sapucaia", 'uf' => "MS", 'codigo' => 5003157],
    		['id' => 5129, 'nome' => "Corumbá", 'uf' => "MS", 'codigo' => 5003207],
    		['id' => 5130, 'nome' => "Costa Rica", 'uf' => "MS", 'codigo' => 5003256],
    		['id' => 5131, 'nome' => "Coxim", 'uf' => "MS", 'codigo' => 5003306],
    		['id' => 5132, 'nome' => "Deodápolis", 'uf' => "MS", 'codigo' => 5003454],
    		['id' => 5133, 'nome' => "Dois Irmãos do Buriti", 'uf' => "MS", 'codigo' => 5003488],
    		['id' => 5134, 'nome' => "Douradina", 'uf' => "MS", 'codigo' => 5003504],
    		['id' => 5135, 'nome' => "Dourados", 'uf' => "MS", 'codigo' => 5003702],
    		['id' => 5136, 'nome' => "Eldorado", 'uf' => "MS", 'codigo' => 5003751],
    		['id' => 5137, 'nome' => "Fátima do Sul", 'uf' => "MS", 'codigo' => 5003801],
    		['id' => 5138, 'nome' => "Figueirão", 'uf' => "MS", 'codigo' => 5003900],
    		['id' => 5139, 'nome' => "Glória de Dourados", 'uf' => "MS", 'codigo' => 5004007],
    		['id' => 5140, 'nome' => "Guia Lopes da Laguna", 'uf' => "MS", 'codigo' => 5004106],
    		['id' => 5141, 'nome' => "Iguatemi", 'uf' => "MS", 'codigo' => 5004304],
    		['id' => 5142, 'nome' => "Inocência", 'uf' => "MS", 'codigo' => 5004403],
    		['id' => 5143, 'nome' => "Itaporã", 'uf' => "MS", 'codigo' => 5004502],
    		['id' => 5144, 'nome' => "Itaquiraí", 'uf' => "MS", 'codigo' => 5004601],
    		['id' => 5145, 'nome' => "Ivinhema", 'uf' => "MS", 'codigo' => 5004700],
    		['id' => 5146, 'nome' => "Japorã", 'uf' => "MS", 'codigo' => 5004809],
    		['id' => 5147, 'nome' => "Jaraguari", 'uf' => "MS", 'codigo' => 5004908],
    		['id' => 5148, 'nome' => "Jardim", 'uf' => "MS", 'codigo' => 5005004],
    		['id' => 5149, 'nome' => "Jateí", 'uf' => "MS", 'codigo' => 5005103],
    		['id' => 5150, 'nome' => "Juti", 'uf' => "MS", 'codigo' => 5005152],
    		['id' => 5151, 'nome' => "Ladário", 'uf' => "MS", 'codigo' => 5005202],
    		['id' => 5152, 'nome' => "Laguna Carapã", 'uf' => "MS", 'codigo' => 5005251],
    		['id' => 5153, 'nome' => "Maracaju", 'uf' => "MS", 'codigo' => 5005400],
    		['id' => 5154, 'nome' => "Miranda", 'uf' => "MS", 'codigo' => 5005608],
    		['id' => 5155, 'nome' => "Mundo Novo", 'uf' => "MS", 'codigo' => 5005681],
    		['id' => 5156, 'nome' => "Naviraí", 'uf' => "MS", 'codigo' => 5005707],
    		['id' => 5157, 'nome' => "Nioaque", 'uf' => "MS", 'codigo' => 5005806],
    		['id' => 5158, 'nome' => "Nova Alvorada do Sul", 'uf' => "MS", 'codigo' => 5006002],
    		['id' => 5159, 'nome' => "Nova Andradina", 'uf' => "MS", 'codigo' => 5006200],
    		['id' => 5160, 'nome' => "Novo Horizonte do Sul", 'uf' => "MS", 'codigo' => 5006259],
    		['id' => 5161, 'nome' => "Paraíso das Águas", 'uf' => "MS", 'codigo' => 5006275],
    		['id' => 5162, 'nome' => "Paranaíba", 'uf' => "MS", 'codigo' => 5006309],
    		['id' => 5163, 'nome' => "Paranhos", 'uf' => "MS", 'codigo' => 5006358],
    		['id' => 5164, 'nome' => "Pedro Gomes", 'uf' => "MS", 'codigo' => 5006408],
    		['id' => 5165, 'nome' => "Ponta Porã", 'uf' => "MS", 'codigo' => 5006606],
    		['id' => 5166, 'nome' => "Porto Murtinho", 'uf' => "MS", 'codigo' => 5006903],
    		['id' => 5167, 'nome' => "Ribas do Rio Pardo", 'uf' => "MS", 'codigo' => 5007109],
    		['id' => 5168, 'nome' => "Rio Brilhante", 'uf' => "MS", 'codigo' => 5007208],
    		['id' => 5169, 'nome' => "Rio Negro", 'uf' => "MS", 'codigo' => 5007307],
    		['id' => 5170, 'nome' => "Rio Verde de Mato Grosso", 'uf' => "MS", 'codigo' => 5007406],
    		['id' => 5171, 'nome' => "Rochedo", 'uf' => "MS", 'codigo' => 5007505],
    		['id' => 5172, 'nome' => "Santa Rita do Pardo", 'uf' => "MS", 'codigo' => 5007554],
    		['id' => 5173, 'nome' => "São Gabriel do Oeste", 'uf' => "MS", 'codigo' => 5007695],
    		['id' => 5174, 'nome' => "Sete Quedas", 'uf' => "MS", 'codigo' => 5007703],
    		['id' => 5175, 'nome' => "Selvíria", 'uf' => "MS", 'codigo' => 5007802],
    		['id' => 5176, 'nome' => "Sidrolândia", 'uf' => "MS", 'codigo' => 5007901],
    		['id' => 5177, 'nome' => "Sonora", 'uf' => "MS", 'codigo' => 5007935],
    		['id' => 5178, 'nome' => "Tacuru", 'uf' => "MS", 'codigo' => 5007950],
    		['id' => 5179, 'nome' => "Taquarussu", 'uf' => "MS", 'codigo' => 5007976],
    		['id' => 5180, 'nome' => "Terenos", 'uf' => "MS", 'codigo' => 5008008],
    		['id' => 5181, 'nome' => "Três Lagoas", 'uf' => "MS", 'codigo' => 5008305],
    		['id' => 5182, 'nome' => "Vicentina", 'uf' => "MS", 'codigo' => 5008404],
    		['id' => 5183, 'nome' => "Acorizal", 'uf' => "MT", 'codigo' => 5100102],
    		['id' => 5184, 'nome' => "Água Boa", 'uf' => "MT", 'codigo' => 5100201],
    		['id' => 5185, 'nome' => "Alta Floresta", 'uf' => "MT", 'codigo' => 5100250],
    		['id' => 5186, 'nome' => "Alto Araguaia", 'uf' => "MT", 'codigo' => 5100300],
    		['id' => 5187, 'nome' => "Alto Boa Vista", 'uf' => "MT", 'codigo' => 5100359],
    		['id' => 5188, 'nome' => "Alto Garças", 'uf' => "MT", 'codigo' => 5100409],
    		['id' => 5189, 'nome' => "Alto Paraguai", 'uf' => "MT", 'codigo' => 5100508],
    		['id' => 5190, 'nome' => "Alto Taquari", 'uf' => "MT", 'codigo' => 5100607],
    		['id' => 5191, 'nome' => "Apiacás", 'uf' => "MT", 'codigo' => 5100805],
    		['id' => 5192, 'nome' => "Araguaiana", 'uf' => "MT", 'codigo' => 5101001],
    		['id' => 5193, 'nome' => "Araguainha", 'uf' => "MT", 'codigo' => 5101209],
    		['id' => 5194, 'nome' => "Araputanga", 'uf' => "MT", 'codigo' => 5101258],
    		['id' => 5195, 'nome' => "Arenápolis", 'uf' => "MT", 'codigo' => 5101308],
    		['id' => 5196, 'nome' => "Aripuanã", 'uf' => "MT", 'codigo' => 5101407],
    		['id' => 5197, 'nome' => "Barão de Melgaço", 'uf' => "MT", 'codigo' => 5101605],
    		['id' => 5198, 'nome' => "Barra do Bugres", 'uf' => "MT", 'codigo' => 5101704],
    		['id' => 5199, 'nome' => "Barra do Garças", 'uf' => "MT", 'codigo' => 5101803],
    		['id' => 5200, 'nome' => "Bom Jesus do Araguaia", 'uf' => "MT", 'codigo' => 5101852],
    		['id' => 5201, 'nome' => "Brasnorte", 'uf' => "MT", 'codigo' => 5101902],
    		['id' => 5202, 'nome' => "Cáceres", 'uf' => "MT", 'codigo' => 5102504],
    		['id' => 5203, 'nome' => "Campinápolis", 'uf' => "MT", 'codigo' => 5102603],
    		['id' => 5204, 'nome' => "Campo Novo do Parecis", 'uf' => "MT", 'codigo' => 5102637],
    		['id' => 5205, 'nome' => "Campo Verde", 'uf' => "MT", 'codigo' => 5102678],
    		['id' => 5206, 'nome' => "Campos de Júlio", 'uf' => "MT", 'codigo' => 5102686],
    		['id' => 5207, 'nome' => "Canabrava do Norte", 'uf' => "MT", 'codigo' => 5102694],
    		['id' => 5208, 'nome' => "Canarana", 'uf' => "MT", 'codigo' => 5102702],
    		['id' => 5209, 'nome' => "Carlinda", 'uf' => "MT", 'codigo' => 5102793],
    		['id' => 5210, 'nome' => "Castanheira", 'uf' => "MT", 'codigo' => 5102850],
    		['id' => 5211, 'nome' => "Chapada dos Guimarães", 'uf' => "MT", 'codigo' => 5103007],
    		['id' => 5212, 'nome' => "Cláudia", 'uf' => "MT", 'codigo' => 5103056],
    		['id' => 5213, 'nome' => "Cocalinho", 'uf' => "MT", 'codigo' => 5103106],
    		['id' => 5214, 'nome' => "Colíder", 'uf' => "MT", 'codigo' => 5103205],
    		['id' => 5215, 'nome' => "Colniza", 'uf' => "MT", 'codigo' => 5103254],
    		['id' => 5216, 'nome' => "Comodoro", 'uf' => "MT", 'codigo' => 5103304],
    		['id' => 5217, 'nome' => "Confresa", 'uf' => "MT", 'codigo' => 5103353],
    		['id' => 5218, 'nome' => "Conquista D'Oeste", 'uf' => "MT", 'codigo' => 5103361],
    		['id' => 5219, 'nome' => "Cotriguaçu", 'uf' => "MT", 'codigo' => 5103379],
    		['id' => 5220, 'nome' => "Cuiabá", 'uf' => "MT", 'codigo' => 5103403],
    		['id' => 5221, 'nome' => "Curvelândia", 'uf' => "MT", 'codigo' => 5103437],
    		['id' => 5222, 'nome' => "Denise", 'uf' => "MT", 'codigo' => 5103452],
    		['id' => 5223, 'nome' => "Diamantino", 'uf' => "MT", 'codigo' => 5103502],
    		['id' => 5224, 'nome' => "Dom Aquino", 'uf' => "MT", 'codigo' => 5103601],
    		['id' => 5225, 'nome' => "Feliz Natal", 'uf' => "MT", 'codigo' => 5103700],
    		['id' => 5226, 'nome' => "Figueirópolis D'Oeste", 'uf' => "MT", 'codigo' => 5103809],
    		['id' => 5227, 'nome' => "Gaúcha do Norte", 'uf' => "MT", 'codigo' => 5103858],
    		['id' => 5228, 'nome' => "General Carneiro", 'uf' => "MT", 'codigo' => 5103908],
    		['id' => 5229, 'nome' => "Glória D'Oeste", 'uf' => "MT", 'codigo' => 5103957],
    		['id' => 5230, 'nome' => "Guarantã do Norte", 'uf' => "MT", 'codigo' => 5104104],
    		['id' => 5231, 'nome' => "Guiratinga", 'uf' => "MT", 'codigo' => 5104203],
    		['id' => 5232, 'nome' => "Indiavaí", 'uf' => "MT", 'codigo' => 5104500],
    		['id' => 5233, 'nome' => "Ipiranga do Norte", 'uf' => "MT", 'codigo' => 5104526],
    		['id' => 5234, 'nome' => "Itanhangá", 'uf' => "MT", 'codigo' => 5104542],
    		['id' => 5235, 'nome' => "Itaúba", 'uf' => "MT", 'codigo' => 5104559],
    		['id' => 5236, 'nome' => "Itiquira", 'uf' => "MT", 'codigo' => 5104609],
    		['id' => 5237, 'nome' => "Jaciara", 'uf' => "MT", 'codigo' => 5104807],
    		['id' => 5238, 'nome' => "Jangada", 'uf' => "MT", 'codigo' => 5104906],
    		['id' => 5239, 'nome' => "Jauru", 'uf' => "MT", 'codigo' => 5105002],
    		['id' => 5240, 'nome' => "Juara", 'uf' => "MT", 'codigo' => 5105101],
    		['id' => 5241, 'nome' => "Juína", 'uf' => "MT", 'codigo' => 5105150],
    		['id' => 5242, 'nome' => "Juruena", 'uf' => "MT", 'codigo' => 5105176],
    		['id' => 5243, 'nome' => "Juscimeira", 'uf' => "MT", 'codigo' => 5105200],
    		['id' => 5244, 'nome' => "Lambari D'Oeste", 'uf' => "MT", 'codigo' => 5105234],
    		['id' => 5245, 'nome' => "Lucas do Rio Verde", 'uf' => "MT", 'codigo' => 5105259],
    		['id' => 5246, 'nome' => "Luciara", 'uf' => "MT", 'codigo' => 5105309],
    		['id' => 5247, 'nome' => "Vila Bela da Santíssima Trindade", 'uf' => "MT", 'codigo' => 5105507],
    		['id' => 5248, 'nome' => "Marcelândia", 'uf' => "MT", 'codigo' => 5105580],
    		['id' => 5249, 'nome' => "Matupá", 'uf' => "MT", 'codigo' => 5105606],
    		['id' => 5250, 'nome' => "Mirassol D'Oeste", 'uf' => "MT", 'codigo' => 5105622],
    		['id' => 5251, 'nome' => "Nobres", 'uf' => "MT", 'codigo' => 5105903],
    		['id' => 5252, 'nome' => "Nortelândia", 'uf' => "MT", 'codigo' => 5106000],
    		['id' => 5253, 'nome' => "Nossa Senhora do Livramento", 'uf' => "MT", 'codigo' => 5106109],
    		['id' => 5254, 'nome' => "Nova Bandeirantes", 'uf' => "MT", 'codigo' => 5106158],
    		['id' => 5255, 'nome' => "Nova Nazaré", 'uf' => "MT", 'codigo' => 5106174],
    		['id' => 5256, 'nome' => "Nova Lacerda", 'uf' => "MT", 'codigo' => 5106182],
    		['id' => 5257, 'nome' => "Nova Santa Helena", 'uf' => "MT", 'codigo' => 5106190],
    		['id' => 5258, 'nome' => "Nova Brasilândia", 'uf' => "MT", 'codigo' => 5106208],
    		['id' => 5259, 'nome' => "Nova Canaã do Norte", 'uf' => "MT", 'codigo' => 5106216],
    		['id' => 5260, 'nome' => "Nova Mutum", 'uf' => "MT", 'codigo' => 5106224],
    		['id' => 5261, 'nome' => "Nova Olímpia", 'uf' => "MT", 'codigo' => 5106232],
    		['id' => 5262, 'nome' => "Nova Ubiratã", 'uf' => "MT", 'codigo' => 5106240],
    		['id' => 5263, 'nome' => "Nova Xavantina", 'uf' => "MT", 'codigo' => 5106257],
    		['id' => 5264, 'nome' => "Novo Mundo", 'uf' => "MT", 'codigo' => 5106265],
    		['id' => 5265, 'nome' => "Novo Horizonte do Norte", 'uf' => "MT", 'codigo' => 5106273],
    		['id' => 5266, 'nome' => "Novo São Joaquim", 'uf' => "MT", 'codigo' => 5106281],
    		['id' => 5267, 'nome' => "Paranaíta", 'uf' => "MT", 'codigo' => 5106299],
    		['id' => 5268, 'nome' => "Paranatinga", 'uf' => "MT", 'codigo' => 5106307],
    		['id' => 5269, 'nome' => "Novo Santo Antônio", 'uf' => "MT", 'codigo' => 5106315],
    		['id' => 5270, 'nome' => "Pedra Preta", 'uf' => "MT", 'codigo' => 5106372],
    		['id' => 5271, 'nome' => "Peixoto de Azevedo", 'uf' => "MT", 'codigo' => 5106422],
    		['id' => 5272, 'nome' => "Planalto da Serra", 'uf' => "MT", 'codigo' => 5106455],
    		['id' => 5273, 'nome' => "Poconé", 'uf' => "MT", 'codigo' => 5106505],
    		['id' => 5274, 'nome' => "Pontal do Araguaia", 'uf' => "MT", 'codigo' => 5106653],
    		['id' => 5275, 'nome' => "Ponte Branca", 'uf' => "MT", 'codigo' => 5106703],
    		['id' => 5276, 'nome' => "Pontes e Lacerda", 'uf' => "MT", 'codigo' => 5106752],
    		['id' => 5277, 'nome' => "Porto Alegre do Norte", 'uf' => "MT", 'codigo' => 5106778],
    		['id' => 5278, 'nome' => "Porto dos Gaúchos", 'uf' => "MT", 'codigo' => 5106802],
    		['id' => 5279, 'nome' => "Porto Esperidião", 'uf' => "MT", 'codigo' => 5106828],
    		['id' => 5280, 'nome' => "Porto Estrela", 'uf' => "MT", 'codigo' => 5106851],
    		['id' => 5281, 'nome' => "Poxoréo", 'uf' => "MT", 'codigo' => 5107008],
    		['id' => 5282, 'nome' => "Primavera do Leste", 'uf' => "MT", 'codigo' => 5107040],
    		['id' => 5283, 'nome' => "Querência", 'uf' => "MT", 'codigo' => 5107065],
    		['id' => 5284, 'nome' => "São José dos Quatro Marcos", 'uf' => "MT", 'codigo' => 5107107],
    		['id' => 5285, 'nome' => "Reserva do Cabaçal", 'uf' => "MT", 'codigo' => 5107156],
    		['id' => 5286, 'nome' => "Ribeirão Cascalheira", 'uf' => "MT", 'codigo' => 5107180],
    		['id' => 5287, 'nome' => "Ribeirãozinho", 'uf' => "MT", 'codigo' => 5107198],
    		['id' => 5288, 'nome' => "Rio Branco", 'uf' => "MT", 'codigo' => 5107206],
    		['id' => 5289, 'nome' => "Santa Carmem", 'uf' => "MT", 'codigo' => 5107248],
    		['id' => 5290, 'nome' => "Santo Afonso", 'uf' => "MT", 'codigo' => 5107263],
    		['id' => 5291, 'nome' => "São José do Povo", 'uf' => "MT", 'codigo' => 5107297],
    		['id' => 5292, 'nome' => "São José do Rio Claro", 'uf' => "MT", 'codigo' => 5107305],
    		['id' => 5293, 'nome' => "São José do Xingu", 'uf' => "MT", 'codigo' => 5107354],
    		['id' => 5294, 'nome' => "São Pedro da Cipa", 'uf' => "MT", 'codigo' => 5107404],
    		['id' => 5295, 'nome' => "Rondolândia", 'uf' => "MT", 'codigo' => 5107578],
    		['id' => 5296, 'nome' => "Rondonópolis", 'uf' => "MT", 'codigo' => 5107602],
    		['id' => 5297, 'nome' => "Rosário Oeste", 'uf' => "MT", 'codigo' => 5107701],
    		['id' => 5298, 'nome' => "Santa Cruz do Xingu", 'uf' => "MT", 'codigo' => 5107743],
    		['id' => 5299, 'nome' => "Salto do Céu", 'uf' => "MT", 'codigo' => 5107750],
    		['id' => 5300, 'nome' => "Santa Rita do Trivelato", 'uf' => "MT", 'codigo' => 5107768],
    		['id' => 5301, 'nome' => "Santa Terezinha", 'uf' => "MT", 'codigo' => 5107776],
    		['id' => 5302, 'nome' => "Santo Antônio do Leste", 'uf' => "MT", 'codigo' => 5107792],
    		['id' => 5303, 'nome' => "Santo Antônio do Leverger", 'uf' => "MT", 'codigo' => 5107800],
    		['id' => 5304, 'nome' => "São Félix do Araguaia", 'uf' => "MT", 'codigo' => 5107859],
    		['id' => 5305, 'nome' => "Sapezal", 'uf' => "MT", 'codigo' => 5107875],
    		['id' => 5306, 'nome' => "Serra Nova Dourada", 'uf' => "MT", 'codigo' => 5107883],
    		['id' => 5307, 'nome' => "Sinop", 'uf' => "MT", 'codigo' => 5107909],
    		['id' => 5308, 'nome' => "Sorriso", 'uf' => "MT", 'codigo' => 5107925],
    		['id' => 5309, 'nome' => "Tabaporã", 'uf' => "MT", 'codigo' => 5107941],
    		['id' => 5310, 'nome' => "Tangará da Serra", 'uf' => "MT", 'codigo' => 5107958],
    		['id' => 5311, 'nome' => "Tapurah", 'uf' => "MT", 'codigo' => 5108006],
    		['id' => 5312, 'nome' => "Terra Nova do Norte", 'uf' => "MT", 'codigo' => 5108055],
    		['id' => 5313, 'nome' => "Tesouro", 'uf' => "MT", 'codigo' => 5108105],
    		['id' => 5314, 'nome' => "Torixoréu", 'uf' => "MT", 'codigo' => 5108204],
    		['id' => 5315, 'nome' => "União do Sul", 'uf' => "MT", 'codigo' => 5108303],
    		['id' => 5316, 'nome' => "Vale de São Domingos", 'uf' => "MT", 'codigo' => 5108352],
    		['id' => 5317, 'nome' => "Várzea Grande", 'uf' => "MT", 'codigo' => 5108402],
    		['id' => 5318, 'nome' => "Vera", 'uf' => "MT", 'codigo' => 5108501],
    		['id' => 5319, 'nome' => "Vila Rica", 'uf' => "MT", 'codigo' => 5108600],
    		['id' => 5320, 'nome' => "Nova Guarita", 'uf' => "MT", 'codigo' => 5108808],
    		['id' => 5321, 'nome' => "Nova Marilândia", 'uf' => "MT", 'codigo' => 5108857],
    		['id' => 5322, 'nome' => "Nova Maringá", 'uf' => "MT", 'codigo' => 5108907],
    		['id' => 5323, 'nome' => "Nova Monte Verde", 'uf' => "MT", 'codigo' => 5108956],
    		['id' => 5324, 'nome' => "Abadia de Goiás", 'uf' => "GO", 'codigo' => 5200050],
    		['id' => 5325, 'nome' => "Abadiânia", 'uf' => "GO", 'codigo' => 5200100],
    		['id' => 5326, 'nome' => "Acreúna", 'uf' => "GO", 'codigo' => 5200134],
    		['id' => 5327, 'nome' => "Adelândia", 'uf' => "GO", 'codigo' => 5200159],
    		['id' => 5328, 'nome' => "Água Fria de Goiás", 'uf' => "GO", 'codigo' => 5200175],
    		['id' => 5329, 'nome' => "Água Limpa", 'uf' => "GO", 'codigo' => 5200209],
    		['id' => 5330, 'nome' => "Águas Lindas de Goiás", 'uf' => "GO", 'codigo' => 5200258],
    		['id' => 5331, 'nome' => "Alexânia", 'uf' => "GO", 'codigo' => 5200308],
    		['id' => 5332, 'nome' => "Aloândia", 'uf' => "GO", 'codigo' => 5200506],
    		['id' => 5333, 'nome' => "Alto Horizonte", 'uf' => "GO", 'codigo' => 5200555],
    		['id' => 5334, 'nome' => "Alto Paraíso de Goiás", 'uf' => "GO", 'codigo' => 5200605],
    		['id' => 5335, 'nome' => "Alvorada do Norte", 'uf' => "GO", 'codigo' => 5200803],
    		['id' => 5336, 'nome' => "Amaralina", 'uf' => "GO", 'codigo' => 5200829],
    		['id' => 5337, 'nome' => "Americano do Brasil", 'uf' => "GO", 'codigo' => 5200852],
    		['id' => 5338, 'nome' => "Amorinópolis", 'uf' => "GO", 'codigo' => 5200902],
    		['id' => 5339, 'nome' => "Anápolis", 'uf' => "GO", 'codigo' => 5201108],
    		['id' => 5340, 'nome' => "Anhanguera", 'uf' => "GO", 'codigo' => 5201207],
    		['id' => 5341, 'nome' => "Anicuns", 'uf' => "GO", 'codigo' => 5201306],
    		['id' => 5342, 'nome' => "Aparecida de Goiânia", 'uf' => "GO", 'codigo' => 5201405],
    		['id' => 5343, 'nome' => "Aparecida do Rio Doce", 'uf' => "GO", 'codigo' => 5201454],
    		['id' => 5344, 'nome' => "Aporé", 'uf' => "GO", 'codigo' => 5201504],
    		['id' => 5345, 'nome' => "Araçu", 'uf' => "GO", 'codigo' => 5201603],
    		['id' => 5346, 'nome' => "Aragarças", 'uf' => "GO", 'codigo' => 5201702],
    		['id' => 5347, 'nome' => "Aragoiânia", 'uf' => "GO", 'codigo' => 5201801],
    		['id' => 5348, 'nome' => "Araguapaz", 'uf' => "GO", 'codigo' => 5202155],
    		['id' => 5349, 'nome' => "Arenópolis", 'uf' => "GO", 'codigo' => 5202353],
    		['id' => 5350, 'nome' => "Aruanã", 'uf' => "GO", 'codigo' => 5202502],
    		['id' => 5351, 'nome' => "Aurilândia", 'uf' => "GO", 'codigo' => 5202601],
    		['id' => 5352, 'nome' => "Avelinópolis", 'uf' => "GO", 'codigo' => 5202809],
    		['id' => 5353, 'nome' => "Baliza", 'uf' => "GO", 'codigo' => 5203104],
    		['id' => 5354, 'nome' => "Barro Alto", 'uf' => "GO", 'codigo' => 5203203],
    		['id' => 5355, 'nome' => "Bela Vista de Goiás", 'uf' => "GO", 'codigo' => 5203302],
    		['id' => 5356, 'nome' => "Bom Jardim de Goiás", 'uf' => "GO", 'codigo' => 5203401],
    		['id' => 5357, 'nome' => "Bom Jesus de Goiás", 'uf' => "GO", 'codigo' => 5203500],
    		['id' => 5358, 'nome' => "Bonfinópolis", 'uf' => "GO", 'codigo' => 5203559],
    		['id' => 5359, 'nome' => "Bonópolis", 'uf' => "GO", 'codigo' => 5203575],
    		['id' => 5360, 'nome' => "Brazabrantes", 'uf' => "GO", 'codigo' => 5203609],
    		['id' => 5361, 'nome' => "Britânia", 'uf' => "GO", 'codigo' => 5203807],
    		['id' => 5362, 'nome' => "Buriti Alegre", 'uf' => "GO", 'codigo' => 5203906],
    		['id' => 5363, 'nome' => "Buriti de Goiás", 'uf' => "GO", 'codigo' => 5203939],
    		['id' => 5364, 'nome' => "Buritinópolis", 'uf' => "GO", 'codigo' => 5203962],
    		['id' => 5365, 'nome' => "Cabeceiras", 'uf' => "GO", 'codigo' => 5204003],
    		['id' => 5366, 'nome' => "Cachoeira Alta", 'uf' => "GO", 'codigo' => 5204102],
    		['id' => 5367, 'nome' => "Cachoeira de Goiás", 'uf' => "GO", 'codigo' => 5204201],
    		['id' => 5368, 'nome' => "Cachoeira Dourada", 'uf' => "GO", 'codigo' => 5204250],
    		['id' => 5369, 'nome' => "Caçu", 'uf' => "GO", 'codigo' => 5204300],
    		['id' => 5370, 'nome' => "Caiapônia", 'uf' => "GO", 'codigo' => 5204409],
    		['id' => 5371, 'nome' => "Caldas Novas", 'uf' => "GO", 'codigo' => 5204508],
    		['id' => 5372, 'nome' => "Caldazinha", 'uf' => "GO", 'codigo' => 5204557],
    		['id' => 5373, 'nome' => "Campestre de Goiás", 'uf' => "GO", 'codigo' => 5204607],
    		['id' => 5374, 'nome' => "Campinaçu", 'uf' => "GO", 'codigo' => 5204656],
    		['id' => 5375, 'nome' => "Campinorte", 'uf' => "GO", 'codigo' => 5204706],
    		['id' => 5376, 'nome' => "Campo Alegre de Goiás", 'uf' => "GO", 'codigo' => 5204805],
    		['id' => 5377, 'nome' => "Campo Limpo de Goiás", 'uf' => "GO", 'codigo' => 5204854],
    		['id' => 5378, 'nome' => "Campos Belos", 'uf' => "GO", 'codigo' => 5204904],
    		['id' => 5379, 'nome' => "Campos Verdes", 'uf' => "GO", 'codigo' => 5204953],
    		['id' => 5380, 'nome' => "Carmo do Rio Verde", 'uf' => "GO", 'codigo' => 5205000],
    		['id' => 5381, 'nome' => "Castelândia", 'uf' => "GO", 'codigo' => 5205059],
    		['id' => 5382, 'nome' => "Catalão", 'uf' => "GO", 'codigo' => 5205109],
    		['id' => 5383, 'nome' => "Caturaí", 'uf' => "GO", 'codigo' => 5205208],
    		['id' => 5384, 'nome' => "Cavalcante", 'uf' => "GO", 'codigo' => 5205307],
    		['id' => 5385, 'nome' => "Ceres", 'uf' => "GO", 'codigo' => 5205406],
    		['id' => 5386, 'nome' => "Cezarina", 'uf' => "GO", 'codigo' => 5205455],
    		['id' => 5387, 'nome' => "Chapadão do Céu", 'uf' => "GO", 'codigo' => 5205471],
    		['id' => 5388, 'nome' => "cidades Ocidental", 'uf' => "GO", 'codigo' => 5205497],
    		['id' => 5389, 'nome' => "Cocalzinho de Goiás", 'uf' => "GO", 'codigo' => 5205513],
    		['id' => 5390, 'nome' => "Colinas do Sul", 'uf' => "GO", 'codigo' => 5205521],
    		['id' => 5391, 'nome' => "Córrego do Ouro", 'uf' => "GO", 'codigo' => 5205703],
    		['id' => 5392, 'nome' => "Corumbá de Goiás", 'uf' => "GO", 'codigo' => 5205802],
    		['id' => 5393, 'nome' => "Corumbaíba", 'uf' => "GO", 'codigo' => 5205901],
    		['id' => 5394, 'nome' => "Cristalina", 'uf' => "GO", 'codigo' => 5206206],
    		['id' => 5395, 'nome' => "Cristianópolis", 'uf' => "GO", 'codigo' => 5206305],
    		['id' => 5396, 'nome' => "Crixás", 'uf' => "GO", 'codigo' => 5206404],
    		['id' => 5397, 'nome' => "Cromínia", 'uf' => "GO", 'codigo' => 5206503],
    		['id' => 5398, 'nome' => "Cumari", 'uf' => "GO", 'codigo' => 5206602],
    		['id' => 5399, 'nome' => "Damianópolis", 'uf' => "GO", 'codigo' => 5206701],
    		['id' => 5400, 'nome' => "Damolândia", 'uf' => "GO", 'codigo' => 5206800],
    		['id' => 5401, 'nome' => "Davinópolis", 'uf' => "GO", 'codigo' => 5206909],
    		['id' => 5402, 'nome' => "Diorama", 'uf' => "GO", 'codigo' => 5207105],
    		['id' => 5403, 'nome' => "Doverlândia", 'uf' => "GO", 'codigo' => 5207253],
    		['id' => 5404, 'nome' => "Edealina", 'uf' => "GO", 'codigo' => 5207352],
    		['id' => 5405, 'nome' => "Edéia", 'uf' => "GO", 'codigo' => 5207402],
    		['id' => 5406, 'nome' => "Estrela do Norte", 'uf' => "GO", 'codigo' => 5207501],
    		['id' => 5407, 'nome' => "Faina", 'uf' => "GO", 'codigo' => 5207535],
    		['id' => 5408, 'nome' => "Fazenda Nova", 'uf' => "GO", 'codigo' => 5207600],
    		['id' => 5409, 'nome' => "Firminópolis", 'uf' => "GO", 'codigo' => 5207808],
    		['id' => 5410, 'nome' => "Flores de Goiás", 'uf' => "GO", 'codigo' => 5207907],
    		['id' => 5411, 'nome' => "Formosa", 'uf' => "GO", 'codigo' => 5208004],
    		['id' => 5412, 'nome' => "Formoso", 'uf' => "GO", 'codigo' => 5208103],
    		['id' => 5413, 'nome' => "Gameleira de Goiás", 'uf' => "GO", 'codigo' => 5208152],
    		['id' => 5414, 'nome' => "Divinópolis de Goiás", 'uf' => "GO", 'codigo' => 5208301],
    		['id' => 5415, 'nome' => "Goianápolis", 'uf' => "GO", 'codigo' => 5208400],
    		['id' => 5416, 'nome' => "Goiandira", 'uf' => "GO", 'codigo' => 5208509],
    		['id' => 5417, 'nome' => "Goianésia", 'uf' => "GO", 'codigo' => 5208608],
    		['id' => 5418, 'nome' => "Goiânia", 'uf' => "GO", 'codigo' => 5208707],
    		['id' => 5419, 'nome' => "Goianira", 'uf' => "GO", 'codigo' => 5208806],
    		['id' => 5420, 'nome' => "Goiás", 'uf' => "GO", 'codigo' => 5208905],
    		['id' => 5421, 'nome' => "Goiatuba", 'uf' => "GO", 'codigo' => 5209101],
    		['id' => 5422, 'nome' => "Gouvelândia", 'uf' => "GO", 'codigo' => 5209150],
    		['id' => 5423, 'nome' => "Guapó", 'uf' => "GO", 'codigo' => 5209200],
    		['id' => 5424, 'nome' => "Guaraíta", 'uf' => "GO", 'codigo' => 5209291],
    		['id' => 5425, 'nome' => "Guarani de Goiás", 'uf' => "GO", 'codigo' => 5209408],
    		['id' => 5426, 'nome' => "Guarinos", 'uf' => "GO", 'codigo' => 5209457],
    		['id' => 5427, 'nome' => "Heitoraí", 'uf' => "GO", 'codigo' => 5209606],
    		['id' => 5428, 'nome' => "Hidrolândia", 'uf' => "GO", 'codigo' => 5209705],
    		['id' => 5429, 'nome' => "Hidrolina", 'uf' => "GO", 'codigo' => 5209804],
    		['id' => 5430, 'nome' => "Iaciara", 'uf' => "GO", 'codigo' => 5209903],
    		['id' => 5431, 'nome' => "Inaciolândia", 'uf' => "GO", 'codigo' => 5209937],
    		['id' => 5432, 'nome' => "Indiara", 'uf' => "GO", 'codigo' => 5209952],
    		['id' => 5433, 'nome' => "Inhumas", 'uf' => "GO", 'codigo' => 5210000],
    		['id' => 5434, 'nome' => "Ipameri", 'uf' => "GO", 'codigo' => 5210109],
    		['id' => 5435, 'nome' => "Ipiranga de Goiás", 'uf' => "GO", 'codigo' => 5210158],
    		['id' => 5436, 'nome' => "Iporá", 'uf' => "GO", 'codigo' => 5210208],
    		['id' => 5437, 'nome' => "Israelândia", 'uf' => "GO", 'codigo' => 5210307],
    		['id' => 5438, 'nome' => "Itaberaí", 'uf' => "GO", 'codigo' => 5210406],
    		['id' => 5439, 'nome' => "Itaguari", 'uf' => "GO", 'codigo' => 5210562],
    		['id' => 5440, 'nome' => "Itaguaru", 'uf' => "GO", 'codigo' => 5210604],
    		['id' => 5441, 'nome' => "Itajá", 'uf' => "GO", 'codigo' => 5210802],
    		['id' => 5442, 'nome' => "Itapaci", 'uf' => "GO", 'codigo' => 5210901],
    		['id' => 5443, 'nome' => "Itapirapuã", 'uf' => "GO", 'codigo' => 5211008],
    		['id' => 5444, 'nome' => "Itapuranga", 'uf' => "GO", 'codigo' => 5211206],
    		['id' => 5445, 'nome' => "Itarumã", 'uf' => "GO", 'codigo' => 5211305],
    		['id' => 5446, 'nome' => "Itauçu", 'uf' => "GO", 'codigo' => 5211404],
    		['id' => 5447, 'nome' => "Itumbiara", 'uf' => "GO", 'codigo' => 5211503],
    		['id' => 5448, 'nome' => "Ivolândia", 'uf' => "GO", 'codigo' => 5211602],
    		['id' => 5449, 'nome' => "Jandaia", 'uf' => "GO", 'codigo' => 5211701],
    		['id' => 5450, 'nome' => "Jaraguá", 'uf' => "GO", 'codigo' => 5211800],
    		['id' => 5451, 'nome' => "Jataí", 'uf' => "GO", 'codigo' => 5211909],
    		['id' => 5452, 'nome' => "Jaupaci", 'uf' => "GO", 'codigo' => 5212006],
    		['id' => 5453, 'nome' => "Jesúpolis", 'uf' => "GO", 'codigo' => 5212055],
    		['id' => 5454, 'nome' => "Joviânia", 'uf' => "GO", 'codigo' => 5212105],
    		['id' => 5455, 'nome' => "Jussara", 'uf' => "GO", 'codigo' => 5212204],
    		['id' => 5456, 'nome' => "Lagoa Santa", 'uf' => "GO", 'codigo' => 5212253],
    		['id' => 5457, 'nome' => "Leopoldo de Bulhões", 'uf' => "GO", 'codigo' => 5212303],
    		['id' => 5458, 'nome' => "Luziânia", 'uf' => "GO", 'codigo' => 5212501],
    		['id' => 5459, 'nome' => "Mairipotaba", 'uf' => "GO", 'codigo' => 5212600],
    		['id' => 5460, 'nome' => "Mambaí", 'uf' => "GO", 'codigo' => 5212709],
    		['id' => 5461, 'nome' => "Mara Rosa", 'uf' => "GO", 'codigo' => 5212808],
    		['id' => 5462, 'nome' => "Marzagão", 'uf' => "GO", 'codigo' => 5212907],
    		['id' => 5463, 'nome' => "Matrinchã", 'uf' => "GO", 'codigo' => 5212956],
    		['id' => 5464, 'nome' => "Maurilândia", 'uf' => "GO", 'codigo' => 5213004],
    		['id' => 5465, 'nome' => "Mimoso de Goiás", 'uf' => "GO", 'codigo' => 5213053],
    		['id' => 5466, 'nome' => "Minaçu", 'uf' => "GO", 'codigo' => 5213087],
    		['id' => 5467, 'nome' => "Mineiros", 'uf' => "GO", 'codigo' => 5213103],
    		['id' => 5468, 'nome' => "Moiporá", 'uf' => "GO", 'codigo' => 5213400],
    		['id' => 5469, 'nome' => "Monte Alegre de Goiás", 'uf' => "GO", 'codigo' => 5213509],
    		['id' => 5470, 'nome' => "Montes Claros de Goiás", 'uf' => "GO", 'codigo' => 5213707],
    		['id' => 5471, 'nome' => "Montividiu", 'uf' => "GO", 'codigo' => 5213756],
    		['id' => 5472, 'nome' => "Montividiu do Norte", 'uf' => "GO", 'codigo' => 5213772],
    		['id' => 5473, 'nome' => "Morrinhos", 'uf' => "GO", 'codigo' => 5213806],
    		['id' => 5474, 'nome' => "Morro Agudo de Goiás", 'uf' => "GO", 'codigo' => 5213855],
    		['id' => 5475, 'nome' => "Mossâmedes", 'uf' => "GO", 'codigo' => 5213905],
    		['id' => 5476, 'nome' => "Mozarlândia", 'uf' => "GO", 'codigo' => 5214002],
    		['id' => 5477, 'nome' => "Mundo Novo", 'uf' => "GO", 'codigo' => 5214051],
    		['id' => 5478, 'nome' => "Mutunópolis", 'uf' => "GO", 'codigo' => 5214101],
    		['id' => 5479, 'nome' => "Nazário", 'uf' => "GO", 'codigo' => 5214408],
    		['id' => 5480, 'nome' => "Nerópolis", 'uf' => "GO", 'codigo' => 5214507],
    		['id' => 5481, 'nome' => "Niquelândia", 'uf' => "GO", 'codigo' => 5214606],
    		['id' => 5482, 'nome' => "Nova América", 'uf' => "GO", 'codigo' => 5214705],
    		['id' => 5483, 'nome' => "Nova Aurora", 'uf' => "GO", 'codigo' => 5214804],
    		['id' => 5484, 'nome' => "Nova Crixás", 'uf' => "GO", 'codigo' => 5214838],
    		['id' => 5485, 'nome' => "Nova Glória", 'uf' => "GO", 'codigo' => 5214861],
    		['id' => 5486, 'nome' => "Nova Iguaçu de Goiás", 'uf' => "GO", 'codigo' => 5214879],
    		['id' => 5487, 'nome' => "Nova Roma", 'uf' => "GO", 'codigo' => 5214903],
    		['id' => 5488, 'nome' => "Nova Veneza", 'uf' => "GO", 'codigo' => 5215009],
    		['id' => 5489, 'nome' => "Novo Brasil", 'uf' => "GO", 'codigo' => 5215207],
    		['id' => 5490, 'nome' => "Novo Gama", 'uf' => "GO", 'codigo' => 5215231],
    		['id' => 5491, 'nome' => "Novo Planalto", 'uf' => "GO", 'codigo' => 5215256],
    		['id' => 5492, 'nome' => "Orizona", 'uf' => "GO", 'codigo' => 5215306],
    		['id' => 5493, 'nome' => "Ouro Verde de Goiás", 'uf' => "GO", 'codigo' => 5215405],
    		['id' => 5494, 'nome' => "Ouvidor", 'uf' => "GO", 'codigo' => 5215504],
    		['id' => 5495, 'nome' => "Padre Bernardo", 'uf' => "GO", 'codigo' => 5215603],
    		['id' => 5496, 'nome' => "Palestina de Goiás", 'uf' => "GO", 'codigo' => 5215652],
    		['id' => 5497, 'nome' => "Palmeiras de Goiás", 'uf' => "GO", 'codigo' => 5215702],
    		['id' => 5498, 'nome' => "Palmelo", 'uf' => "GO", 'codigo' => 5215801],
    		['id' => 5499, 'nome' => "Palminópolis", 'uf' => "GO", 'codigo' => 5215900],
    		['id' => 5500, 'nome' => "Panamá", 'uf' => "GO", 'codigo' => 5216007],
    		['id' => 5501, 'nome' => "Paranaiguara", 'uf' => "GO", 'codigo' => 5216304],
    		['id' => 5502, 'nome' => "Paraúna", 'uf' => "GO", 'codigo' => 5216403],
    		['id' => 5503, 'nome' => "Perolândia", 'uf' => "GO", 'codigo' => 5216452],
    		['id' => 5504, 'nome' => "Petrolina de Goiás", 'uf' => "GO", 'codigo' => 5216809],
    		['id' => 5505, 'nome' => "Pilar de Goiás", 'uf' => "GO", 'codigo' => 5216908],
    		['id' => 5506, 'nome' => "Piracanjuba", 'uf' => "GO", 'codigo' => 5217104],
    		['id' => 5507, 'nome' => "Piranhas", 'uf' => "GO", 'codigo' => 5217203],
    		['id' => 5508, 'nome' => "Pirenópolis", 'uf' => "GO", 'codigo' => 5217302],
    		['id' => 5509, 'nome' => "Pires do Rio", 'uf' => "GO", 'codigo' => 5217401],
    		['id' => 5510, 'nome' => "Planaltina", 'uf' => "GO", 'codigo' => 5217609],
    		['id' => 5511, 'nome' => "Pontalina", 'uf' => "GO", 'codigo' => 5217708],
    		['id' => 5512, 'nome' => "Porangatu", 'uf' => "GO", 'codigo' => 5218003],
    		['id' => 5513, 'nome' => "Porteirão", 'uf' => "GO", 'codigo' => 5218052],
    		['id' => 5514, 'nome' => "Portelândia", 'uf' => "GO", 'codigo' => 5218102],
    		['id' => 5515, 'nome' => "Posse", 'uf' => "GO", 'codigo' => 5218300],
    		['id' => 5516, 'nome' => "Professor Jamil", 'uf' => "GO", 'codigo' => 5218391],
    		['id' => 5517, 'nome' => "Quirinópolis", 'uf' => "GO", 'codigo' => 5218508],
    		['id' => 5518, 'nome' => "Rialma", 'uf' => "GO", 'codigo' => 5218607],
    		['id' => 5519, 'nome' => "Rianápolis", 'uf' => "GO", 'codigo' => 5218706],
    		['id' => 5520, 'nome' => "Rio Quente", 'uf' => "GO", 'codigo' => 5218789],
    		['id' => 5521, 'nome' => "Rio Verde", 'uf' => "GO", 'codigo' => 5218805],
    		['id' => 5522, 'nome' => "Rubiataba", 'uf' => "GO", 'codigo' => 5218904],
    		['id' => 5523, 'nome' => "Sanclerlândia", 'uf' => "GO", 'codigo' => 5219001],
    		['id' => 5524, 'nome' => "Santa Bárbara de Goiás", 'uf' => "GO", 'codigo' => 5219100],
    		['id' => 5525, 'nome' => "Santa Cruz de Goiás", 'uf' => "GO", 'codigo' => 5219209],
    		['id' => 5526, 'nome' => "Santa Fé de Goiás", 'uf' => "GO", 'codigo' => 5219258],
    		['id' => 5527, 'nome' => "Santa Helena de Goiás", 'uf' => "GO", 'codigo' => 5219308],
    		['id' => 5528, 'nome' => "Santa Isabel", 'uf' => "GO", 'codigo' => 5219357],
    		['id' => 5529, 'nome' => "Santa Rita do Araguaia", 'uf' => "GO", 'codigo' => 5219407],
    		['id' => 5530, 'nome' => "Santa Rita do Novo Destino", 'uf' => "GO", 'codigo' => 5219456],
    		['id' => 5531, 'nome' => "Santa Rosa de Goiás", 'uf' => "GO", 'codigo' => 5219506],
    		['id' => 5532, 'nome' => "Santa Tereza de Goiás", 'uf' => "GO", 'codigo' => 5219605],
    		['id' => 5533, 'nome' => "Santa Terezinha de Goiás", 'uf' => "GO", 'codigo' => 5219704],
    		['id' => 5534, 'nome' => "Santo Antônio da Barra", 'uf' => "GO", 'codigo' => 5219712],
    		['id' => 5535, 'nome' => "Santo Antônio de Goiás", 'uf' => "GO", 'codigo' => 5219738],
    		['id' => 5536, 'nome' => "Santo Antônio do Descoberto", 'uf' => "GO", 'codigo' => 5219753],
    		['id' => 5537, 'nome' => "São Domingos", 'uf' => "GO", 'codigo' => 5219803],
    		['id' => 5538, 'nome' => "São Francisco de Goiás", 'uf' => "GO", 'codigo' => 5219902],
    		['id' => 5539, 'nome' => "São João D'Aliança", 'uf' => "GO", 'codigo' => 5220009],
    		['id' => 5540, 'nome' => "São João da Paraúna", 'uf' => "GO", 'codigo' => 5220058],
    		['id' => 5541, 'nome' => "São Luís de Montes Belos", 'uf' => "GO", 'codigo' => 5220108],
    		['id' => 5542, 'nome' => "São Luíz do Norte", 'uf' => "GO", 'codigo' => 5220157],
    		['id' => 5543, 'nome' => "São Miguel do Araguaia", 'uf' => "GO", 'codigo' => 5220207],
    		['id' => 5544, 'nome' => "São Miguel do Passa Quatro", 'uf' => "GO", 'codigo' => 5220264],
    		['id' => 5545, 'nome' => "São Patrício", 'uf' => "GO", 'codigo' => 5220280],
    		['id' => 5546, 'nome' => "São Simão", 'uf' => "GO", 'codigo' => 5220405],
    		['id' => 5547, 'nome' => "Senador Canedo", 'uf' => "GO", 'codigo' => 5220454],
    		['id' => 5548, 'nome' => "Serranópolis", 'uf' => "GO", 'codigo' => 5220504],
    		['id' => 5549, 'nome' => "Silvânia", 'uf' => "GO", 'codigo' => 5220603],
    		['id' => 5550, 'nome' => "Simolândia", 'uf' => "GO", 'codigo' => 5220686],
    		['id' => 5551, 'nome' => "Sítio D'Abadia", 'uf' => "GO", 'codigo' => 5220702],
    		['id' => 5552, 'nome' => "Taquaral de Goiás", 'uf' => "GO", 'codigo' => 5221007],
    		['id' => 5553, 'nome' => "Teresina de Goiás", 'uf' => "GO", 'codigo' => 5221080],
    		['id' => 5554, 'nome' => "Terezópolis de Goiás", 'uf' => "GO", 'codigo' => 5221197],
    		['id' => 5555, 'nome' => "Três Ranchos", 'uf' => "GO", 'codigo' => 5221304],
    		['id' => 5556, 'nome' => "Trindade", 'uf' => "GO", 'codigo' => 5221403],
    		['id' => 5557, 'nome' => "Trombas", 'uf' => "GO", 'codigo' => 5221452],
    		['id' => 5558, 'nome' => "Turvânia", 'uf' => "GO", 'codigo' => 5221502],
    		['id' => 5559, 'nome' => "Turvelândia", 'uf' => "GO", 'codigo' => 5221551],
    		['id' => 5560, 'nome' => "Uirapuru", 'uf' => "GO", 'codigo' => 5221577],
    		['id' => 5561, 'nome' => "Uruaçu", 'uf' => "GO", 'codigo' => 5221601],
    		['id' => 5562, 'nome' => "Uruana", 'uf' => "GO", 'codigo' => 5221700],
    		['id' => 5563, 'nome' => "Urutaí", 'uf' => "GO", 'codigo' => 5221809],
    		['id' => 5564, 'nome' => "Valparaíso de Goiás", 'uf' => "GO", 'codigo' => 5221858],
    		['id' => 5565, 'nome' => "Varjão", 'uf' => "GO", 'codigo' => 5221908],
    		['id' => 5566, 'nome' => "Vianópolis", 'uf' => "GO", 'codigo' => 5222005],
    		['id' => 5567, 'nome' => "Vicentinópolis", 'uf' => "GO", 'codigo' => 5222054],
    		['id' => 5568, 'nome' => "Vila Boa", 'uf' => "GO", 'codigo' => 5222203],
    		['id' => 5569, 'nome' => "Vila Propício", 'uf' => "GO", 'codigo' => 5222302],
    		['id' => 5570, 'nome' => "Brasília", 'uf' => "DF", 'codigo' => 5300108]

    	];
    }
    
}
