<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\DeliveryConfig;

class LojaController extends Controller
{
    public function index(){
        $lojas = DeliveryConfig::orderBy('id', 'desc')
        ->get();
        return view('lojas/index')
        ->with('lojas', $lojas)
        ->with('title', 'Lojas');
    }

    public function alterarStatus($id){
        $delivery = DeliveryConfig::find($id);

        $delivery->status = !$delivery->status;
        $delivery->save();
        session()->flash("mensagem_sucesso", "Status alterado!");

        return redirect()->back();
    }

}
