<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Contador;
use App\Models\Cidade;
use App\Models\Empresa;

class ContadorController extends Controller
{
    public function __construct(){
        $this->middleware(function ($request, $next) {
            $value = session('user_logged');
            if(!$value){
                return redirect("/login");
            }

            if(!$value['super']){
                return redirect('/graficos');
            }
            return $next($request);
        });
    }

    public function index(){

        $data = Contador::paginate(20);
        $count = Contador::count();

        return view('contadores/list')
        ->with('title', 'Contadores')
        ->with('count', $count)
        ->with('data', $data);
    }

    public function filtro(Request $request){

        $data = Contador::
        where('razao_social', 'LIKE', "%$request->nome%")
        ->get();

        $count = Contador::count();

        return view('contadores/list')
        ->with('title', 'Contadores')
        ->with('count', $count)
        ->with('nome', $request->nome)
        ->with('data', $data);
    }

    public function new(){
        $cidades = Cidade::all();   

        return view('contadores/register')
        ->with('title', 'Novo contador')
        ->with('cidades', $cidades);
    }

    public function edit($id){
        $cidades = Cidade::all();   
        $escritorio = Contador::find($id);
        return view('contadores/register')
        ->with('title', 'Editar contador')
        ->with('escritorio', $escritorio)
        ->with('cidades', $cidades);
    }

    public function save(Request $request){
        $this->_validate($request);

        $request->merge([
            'chave_pix' => $request->chave_pix ?? '',
            'conta' => $request->conta ?? '',
            'agencia' => $request->agencia ?? '',
            'banco' => $request->banco ?? '',
            'ie' => $request->ie ?? '',
            'dados_bancarios' => $request->dados_bancarios ? 1 : 0,
            'contador_parceiro' => $request->contador_parceiro ? 1 : 0,
        ]);
        try{
            Contador::create($request->all());
            session()->flash('mensagem_sucesso', "Contador cadastrado");

        }catch(\Exception $e){
            session()->flash('mensagem_erro', $e->getMessage());
        }

        return redirect('/contadores');
    }

    public function update(Request $request){
        $this->_validate($request);

        try{
            $request->merge([
                'chave_pix' => $request->chave_pix ?? '',
                'conta' => $request->conta ?? '',
                'agencia' => $request->agencia ?? '',
                'banco' => $request->banco ?? '',
                'ie' => $request->ie ?? '',
                'dados_bancarios' => $request->dados_bancarios ? 1 : 0,
                'contador_parceiro' => $request->contador_parceiro ? 1 : 0,
            ]);
            $item = Contador::find($request->id);

            $item->fill($request->all())->save();

            session()->flash('mensagem_sucesso', "Contador atualizado");

        }catch(\Exception $e){
            session()->flash('mensagem_erro', $e->getMessage());
        }

        return redirect('/contadores');
    }

    public function delete($id){
        try{
            $contador = Contador::find($id);
            if($contador->delete()){

                session()->flash('mensagem_sucesso', 'Registro removido!');
            }else{

                session()->flash('mensagem_erro', 'Erro!');
            }
            return redirect('/contadores');
        }catch(\Exception $e){
            return view('errors.sql')
            ->with('title', 'Erro ao deletar registro')
            ->with('motivo', $e->getMessage());
        }
    }

    private function _validate(Request $request){
        $rules = [
            'razao_social' => 'required|max:100',
            'nome_fantasia' => 'required|max:80',
            'cnpj' => 'required',
            // 'ie' => 'required',
            'percentual_comissao' => 'required',
            'logradouro' => 'required|max:80',
            'numero' => 'required|max:10',
            'bairro' => 'required|max:50',
            'fone' => 'required|max:20',
            'cep' => 'required',
            'cidade_id' => 'required',
            'email' => 'required|email|max:80'
            
        ];

        $messages = [
            'razao_social.required' => 'O Razão social nome é obrigatório.',
            'razao_social.max' => '100 caracteres maximos permitidos.',
            'nome_fantasia.required' => 'O campo Nome Fantasia é obrigatório.',
            'nome_fantasia.max' => '80 caracteres maximos permitidos.',
            'cnpj.required' => 'O campo CNPJ é obrigatório.',
            'logradouro.required' => 'O campo Logradouro é obrigatório.',
            // 'ie.required' => 'O campo Inscrição Estadual é obrigatório.',
            'logradouro.max' => '80 caracteres maximos permitidos.',
            'numero.required' => 'O campo Numero é obrigatório.',
            'cep.required' => 'O campo CEP é obrigatório.',
            'municipio.required' => 'O campo Municipio é obrigatório.',
            'numero.max' => '10 caracteres maximos permitidos.',
            'bairro.required' => 'O campo Bairro é obrigatório.',
            'bairro.max' => '50 caracteres maximos permitidos.',
            'fone.required' => 'O campo Telefone é obrigatório.',
            'fone.max' => '20 caracteres maximos permitidos.',
            'email.required' => 'O campo email é obrigatório.',
            'email.email' => 'Informe um email valido.',
            'email.max' => '80 caracteres maximos permitidos.',
            'cidade_id.required' => 'O campo cidade é obrigatório.',
            'percentual_comissao.required' => 'O campo % é obrigatório.',

        ];
        $this->validate($request, $rules, $messages);
    }

    public function empresas($id){
        $contador = Contador::find($id);

        $empresas = Empresa::where('contador_id', $id)->get();

        return view('contadores/empresas')
        ->with('title', 'Empresas')
        ->with('empresas', $empresas)
        ->with('contador', $contador);
    }

    public function filtroEmpresa(Request $request){
        $contador = Contador::find($request->contador_id);
        $empresas = Empresa::
        where('nome', 'LIKE', "%$request->nome%")
        ->where('contador_id', $request->contador_id)->get();

        return view('contadores/empresas')
        ->with('empresas', $empresas)
        ->with('title', 'Empresas')
        ->with('nome', $request->nome)
        ->with('contador', $contador);
    }

    public function quickSave(Request $request){
        try{
            $data = $request->data;

            $data['agencia'] = isset($data['agencia']) ? $data['agencia'] : '';
            $data['conta'] = isset($data['conta']) ? $data['conta'] : '';
            $data['banco'] = isset($data['banco']) ? $data['banco'] : '';
            $data['chave_pix'] = isset($data['chave_pix']) ? $data['chave_pix'] : '';
            $data['ie'] = isset($data['ie']) ? $data['ie'] : '';

            $result = Contador::create($data);
            return response()->json($result, 200);


        }catch(\Exception $e){
            return response()->json($e->getMessage(), 401);
        }
    }
}
